/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Ellipse;
import ome.xml.model.Line;
import ome.xml.model.Mask;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Path;
import ome.xml.model.Point;
import ome.xml.model.Polyline;
import ome.xml.model.Rectangle;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.Text;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Union
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Union.class);
    private List<Shape> shapeList = new ArrayList<Shape>();

    public Union() {
    }

    public Union(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Union".equals(tagName)) {
            LOGGER.debug("Expecting node name of Union got {}", (Object)tagName);
        }
        List<Element> Shape_nodeList = Union.getChildrenByTagName(element, "Shape");
        for (Element Shape_element : Shape_nodeList) {
            List<Element> Line_nodeList = Union.getChildrenByTagName(Shape_element, "Line");
            for (Element Line_element : Line_nodeList) {
                Line o = new Line(Shape_element, model);
                o.update(Line_element, model);
                this.addShape(o);
            }
            List<Element> Rectangle_nodeList = Union.getChildrenByTagName(Shape_element, "Rectangle");
            for (Element Rectangle_element : Rectangle_nodeList) {
                Rectangle o = new Rectangle(Shape_element, model);
                o.update(Rectangle_element, model);
                this.addShape(o);
            }
            List<Element> Mask_nodeList = Union.getChildrenByTagName(Shape_element, "Mask");
            for (Element Mask_element : Mask_nodeList) {
                Mask o = new Mask(Shape_element, model);
                o.update(Mask_element, model);
                this.addShape(o);
            }
            List<Element> Ellipse_nodeList = Union.getChildrenByTagName(Shape_element, "Ellipse");
            for (Element Ellipse_element : Ellipse_nodeList) {
                Ellipse o = new Ellipse(Shape_element, model);
                o.update(Ellipse_element, model);
                this.addShape(o);
            }
            List<Element> Point_nodeList = Union.getChildrenByTagName(Shape_element, "Point");
            for (Element Point_element : Point_nodeList) {
                Point o = new Point(Shape_element, model);
                o.update(Point_element, model);
                this.addShape(o);
            }
            List<Element> Polyline_nodeList = Union.getChildrenByTagName(Shape_element, "Polyline");
            for (Element Polyline_element : Polyline_nodeList) {
                Polyline o = new Polyline(Shape_element, model);
                o.update(Polyline_element, model);
                this.addShape(o);
            }
            List<Element> Path_nodeList = Union.getChildrenByTagName(Shape_element, "Path");
            for (Element Path_element : Path_nodeList) {
                Path o = new Path(Shape_element, model);
                o.update(Path_element, model);
                this.addShape(o);
            }
            List<Element> Text_nodeList = Union.getChildrenByTagName(Shape_element, "Text");
            for (Element Text_element : Text_nodeList) {
                Text o = new Text(Shape_element, model);
                o.update(Text_element, model);
                this.addShape(o);
            }
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public int sizeOfShapeList() {
        return this.shapeList.size();
    }

    public List<Shape> copyShapeList() {
        return new ArrayList<Shape>(this.shapeList);
    }

    public Shape getShape(int index) {
        return this.shapeList.get(index);
    }

    public Shape setShape(int index, Shape shape) {
        return this.shapeList.set(index, shape);
    }

    public void addShape(Shape shape) {
        this.shapeList.add(shape);
    }

    public void removeShape(Shape shape) {
        this.shapeList.remove(shape);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Union_element) {
        if (Union_element == null) {
            Union_element = document.createElementNS(NAMESPACE, "Union");
        }
        if (this.shapeList != null) {
            for (Shape shapeList_value : this.shapeList) {
                Union_element.appendChild(shapeList_value.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Union_element);
    }
}

