/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.Annotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLAnnotation
extends Annotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLAnnotation.class);
    private String value;

    public XMLAnnotation() {
    }

    public XMLAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"XMLAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of XMLAnnotation got {}", (Object)tagName);
        }
        if ((Value_nodeList = XMLAnnotation.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(String.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element XMLAnnotation_element) {
        if (XMLAnnotation_element == null) {
            XMLAnnotation_element = document.createElementNS(NAMESPACE, "XMLAnnotation");
        }
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            XMLAnnotation_element.appendChild(value_element);
        }
        return super.asXMLElement(document, XMLAnnotation_element);
    }
}

