/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.BZip2Handle;
import loci.common.GZipHandle;
import loci.common.IRandomAccess;
import loci.common.NIOFileHandle;
import loci.common.URLHandle;
import loci.common.ZipHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location {
    private static final Logger LOGGER = LoggerFactory.getLogger(Location.class);
    private static HashMap<String, Object> idMap = new HashMap();
    private boolean isURL = true;
    private URL url;
    private File file;

    public Location(String pathname) {
        LOGGER.trace("Location({})", (Object)pathname);
        try {
            this.url = new URL(Location.getMappedId(pathname));
        }
        catch (MalformedURLException e) {
            LOGGER.trace("Location is not a URL", (Throwable)e);
            this.isURL = false;
        }
        if (!this.isURL) {
            this.file = new File(Location.getMappedId(pathname));
        }
    }

    public Location(File file) {
        LOGGER.trace("Location({})", (Object)file);
        this.isURL = false;
        this.file = file;
    }

    public Location(String parent, String child) {
        this(parent + File.separator + child);
    }

    public Location(Location parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public static void mapId(String id, String filename) {
        if (id == null) {
            return;
        }
        if (filename == null) {
            idMap.remove(id);
        } else {
            idMap.put(id, filename);
        }
        LOGGER.debug("Location.mapId: {} -> {}", (Object)id, (Object)filename);
    }

    public static void mapFile(String id, IRandomAccess ira) {
        if (id == null) {
            return;
        }
        if (ira == null) {
            idMap.remove(id);
        } else {
            idMap.put(id, ira);
        }
        LOGGER.debug("Location.mapFile: {} -> {}", (Object)id, (Object)ira);
    }

    public static String getMappedId(String id) {
        if (idMap == null) {
            return id;
        }
        String filename = null;
        if (id != null && idMap.get(id) instanceof String) {
            filename = (String)idMap.get(id);
        }
        return filename == null ? id : filename;
    }

    public static IRandomAccess getMappedFile(String id) {
        if (idMap == null) {
            return null;
        }
        IRandomAccess ira = null;
        if (id != null && idMap.get(id) instanceof IRandomAccess) {
            ira = (IRandomAccess)idMap.get(id);
        }
        return ira;
    }

    public static HashMap<String, Object> getIdMap() {
        return idMap;
    }

    public static void setIdMap(HashMap<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null");
        }
        idMap = map;
    }

    public static IRandomAccess getHandle(String id) throws IOException {
        return Location.getHandle(id, false);
    }

    public static IRandomAccess getHandle(String id, boolean writable) throws IOException {
        LOGGER.trace("getHandle(id = {}, writable = {})", (Object)id, (Object)writable);
        IRandomAccess handle = Location.getMappedFile(id);
        if (handle == null) {
            LOGGER.trace("no handle was mapped for this ID");
            String mapId = Location.getMappedId(id);
            handle = id.startsWith("http://") ? new URLHandle(mapId) : (ZipHandle.isZipFile(id) ? new ZipHandle(mapId) : (GZipHandle.isGZipFile(id) ? new GZipHandle(mapId) : (BZip2Handle.isBZip2File(id) ? new BZip2Handle(mapId) : new NIOFileHandle(mapId, writable ? "rw" : "r"))));
        }
        LOGGER.trace("Location.getHandle: {} -> {}", (Object)id, (Object)handle);
        return handle;
    }

    public String[] list(boolean noHiddenFiles) {
        ArrayList<String> files = new ArrayList<String>();
        if (this.isURL) {
            try {
                URLConnection c = this.url.openConnection();
                InputStream is = c.getInputStream();
                boolean foundEnd = false;
                while (!foundEnd) {
                    int ndx;
                    int idx;
                    byte[] b = new byte[is.available()];
                    is.read(b);
                    String s = new String(b);
                    if (s.toLowerCase().indexOf("</html>") != -1) {
                        foundEnd = true;
                    }
                    while (s.indexOf("a href") != -1 && (idx = s.indexOf("\"", ndx = s.indexOf("a href") + 8)) >= 0) {
                        Location check;
                        String f = s.substring(ndx, idx);
                        if (files.size() > 0 && f.startsWith("/")) {
                            return null;
                        }
                        s = s.substring(idx + 1);
                        if (f.startsWith("?") || !(check = new Location(this.getAbsolutePath(), f)).exists() || noHiddenFiles && check.isHidden()) continue;
                        files.add(check.getName());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.trace("Could not retrieve directory listing", (Throwable)e);
                return null;
            }
        } else {
            if (this.file == null) {
                return null;
            }
            String[] f = this.file.list();
            if (f == null) {
                return null;
            }
            for (String name : f) {
                if (noHiddenFiles && new Location(this.file.getAbsolutePath(), name).isHidden()) continue;
                files.add(name);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public boolean canRead() {
        return this.isURL ? this.isDirectory() || this.isFile() : this.file.canRead();
    }

    public boolean canWrite() {
        return this.isURL ? false : this.file.canWrite();
    }

    public boolean createNewFile() throws IOException {
        if (this.isURL) {
            throw new IOException("Unimplemented");
        }
        return this.file.createNewFile();
    }

    public boolean delete() {
        return this.isURL ? false : this.file.delete();
    }

    public void deleteOnExit() {
        if (!this.isURL) {
            this.file.deleteOnExit();
        }
    }

    public boolean equals(Object obj) {
        return this.isURL ? this.url.equals(obj) : this.file.equals(obj);
    }

    public boolean exists() {
        if (this.isURL) {
            try {
                this.url.getContent();
                return true;
            }
            catch (IOException e) {
                LOGGER.trace("Failed to retrieve content from URL", (Throwable)e);
                return false;
            }
        }
        if (this.file.exists()) {
            return true;
        }
        if (Location.getMappedFile(this.file.getPath()) != null) {
            return true;
        }
        String mappedId = Location.getMappedId(this.file.getPath());
        return mappedId != null && new File(mappedId).exists();
    }

    public Location getAbsoluteFile() {
        return new Location(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return this.isURL ? this.url.toExternalForm() : this.file.getAbsolutePath();
    }

    public Location getCanonicalFile() throws IOException {
        return this.isURL ? this.getAbsoluteFile() : new Location(this.file.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.isURL ? this.getAbsolutePath() : this.file.getCanonicalPath();
    }

    public String getName() {
        if (this.isURL) {
            String name = this.url.getFile();
            name = name.substring(name.lastIndexOf("/") + 1);
            return name;
        }
        return this.file.getName();
    }

    public String getParent() {
        if (this.isURL) {
            String absPath = this.getAbsolutePath();
            absPath = absPath.substring(0, absPath.lastIndexOf("/"));
            return absPath;
        }
        return this.file.getParent();
    }

    public Location getParentFile() {
        return new Location(this.getParent());
    }

    public String getPath() {
        return this.isURL ? this.url.getHost() + this.url.getPath() : this.file.getPath();
    }

    public boolean isAbsolute() {
        return this.isURL ? true : this.file.isAbsolute();
    }

    public boolean isDirectory() {
        if (this.isURL) {
            String[] list = this.list();
            return list != null;
        }
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.isURL ? !this.isDirectory() && this.exists() : this.file.isFile();
    }

    public boolean isHidden() {
        return this.isURL ? false : this.file.isHidden();
    }

    public long lastModified() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                LOGGER.trace("Could not determine URL's last modification time", (Throwable)e);
                return 0L;
            }
        }
        return this.file.lastModified();
    }

    public long length() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getContentLength();
            }
            catch (IOException e) {
                LOGGER.trace("Could not determine URL's content length", (Throwable)e);
                return 0L;
            }
        }
        return this.file.length();
    }

    public String[] list() {
        return this.list(false);
    }

    public Location[] listFiles() {
        String[] s = this.list();
        if (s == null) {
            return null;
        }
        Location[] f = new Location[s.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Location(this.getAbsolutePath(), s[i]);
            f[i] = f[i].getAbsoluteFile();
        }
        return f;
    }

    public URL toURL() throws MalformedURLException {
        return this.isURL ? this.url : this.file.toURI().toURL();
    }

    public String toString() {
        return this.isURL ? this.url.toString() : this.file.toString();
    }
}

