/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResponseUtil {
    private static final Log LOG = LogFactory.getLog((String)ResponseUtil.class.getName());
    private static final int EMPTY_GZIPPED_CONTENT_SIZE = 20;

    private ResponseUtil() {
    }

    public static boolean shouldGzippedBodyBeZero(byte[] compressedBytes, HttpServletRequest request) {
        if (compressedBytes.length == 20) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(request.getRequestURL() + " resulted in an empty response."));
            }
            return true;
        }
        return false;
    }

    public static boolean shouldBodyBeZero(HttpServletRequest request, int responseStatus) {
        if (responseStatus == 204) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(request.getRequestURL() + " resulted in a " + 204 + " response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        if (responseStatus == 304) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(request.getRequestURL() + " resulted in a " + 304 + " response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        return false;
    }

    public static void addGzipHeader(HttpServletResponse response) throws ResponseHeadersNotModifiableException {
        response.setHeader("Content-Encoding", "gzip");
        boolean containsEncoding = response.containsHeader("Content-Encoding");
        if (!containsEncoding) {
            throw new ResponseHeadersNotModifiableException("Failure when attempting to set Content-Encoding: gzip");
        }
    }
}

