/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class GridsetRecord
extends Record {
    public static final short sid = 130;
    public short field_1_gridset_flag;

    public GridsetRecord() {
    }

    public GridsetRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 130) {
            throw new RecordFormatException("NOT A Gridset RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_gridset_flag = in.readShort();
    }

    public void setGridset(boolean gridset) {
        this.field_1_gridset_flag = gridset ? (short)1 : 0;
    }

    public boolean getGridset() {
        return this.field_1_gridset_flag == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GRIDSET]\n");
        buffer.append("    .gridset        = ").append(this.getGridset()).append("\n");
        buffer.append("[/GRIDSET]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)130);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_gridset_flag);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 130;
    }

    public Object clone() {
        GridsetRecord rec = new GridsetRecord();
        rec.field_1_gridset_flag = this.field_1_gridset_flag;
        return rec;
    }
}

