/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class PlotAreaRecord
extends Record {
    public static final short sid = 4149;

    public PlotAreaRecord() {
    }

    public PlotAreaRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4149) {
            throw new RecordFormatException("Not a PlotArea record");
        }
    }

    protected void fillFields(RecordInputStream in) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PLOTAREA]\n");
        buffer.append("[/PLOTAREA]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4149);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 4149;
    }

    public Object clone() {
        PlotAreaRecord rec = new PlotAreaRecord();
        return rec;
    }
}

