/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class DodsURLExtractor {
    private HTMLEditorKit.Parser parser;
    private ArrayList urlList;
    private URL baseURL;
    private boolean wantURLS = false;
    private String title;
    private boolean isTitle;
    private StringBuffer textBuffer;
    private boolean wantText = false;
    private boolean debug = false;

    public DodsURLExtractor() {
        ParserGetter kit = new ParserGetter();
        this.parser = kit.getParser();
    }

    public ArrayList extract(String url) throws IOException {
        if (this.debug) {
            System.out.println(" URLextract=" + url);
        }
        this.baseURL = new URL(url);
        InputStream in = this.baseURL.openStream();
        InputStreamReader r = new InputStreamReader(this.filterTag(in));
        CallerBacker callback = new CallerBacker();
        this.urlList = new ArrayList();
        this.wantURLS = true;
        this.wantText = false;
        this.parser.parse(r, callback, false);
        return this.urlList;
    }

    public String getTextContent(String url) throws IOException {
        if (this.debug) {
            System.out.println(" URL.getTextContent=" + url);
        }
        this.baseURL = new URL(url);
        InputStream in = this.baseURL.openStream();
        InputStreamReader r = new InputStreamReader(this.filterTag(in));
        CallerBacker callback = new CallerBacker();
        this.textBuffer = new StringBuffer(3000);
        this.wantURLS = false;
        this.wantText = true;
        this.parser.parse(r, callback, false);
        return this.textBuffer.toString();
    }

    private InputStream filterTag(InputStream in) throws IOException {
        BufferedReader buffIn = new BufferedReader(new InputStreamReader(in));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
        String line = buffIn.readLine();
        while (line != null) {
            String lline = line.toLowerCase();
            if (0 <= lline.indexOf("<meta ")) continue;
            bos.write(line.getBytes());
            line = buffIn.readLine();
        }
        buffIn.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private class ParserGetter
    extends HTMLEditorKit {
        private ParserGetter() {
        }

        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }

    private class CallerBacker
    extends HTMLEditorKit.ParserCallback {
        private CallerBacker() {
        }

        private boolean wantTag(HTML.Tag tag) {
            return tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6;
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
            DodsURLExtractor.this.isTitle = tag == HTML.Tag.TITLE;
            if (DodsURLExtractor.this.wantURLS && tag == HTML.Tag.A) {
                this.extractHREF(attributes);
            }
        }

        public void handleEndTag(HTML.Tag tag, int position) {
            DodsURLExtractor.this.isTitle = false;
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
            DodsURLExtractor.this.isTitle = false;
            if (DodsURLExtractor.this.wantURLS && tag == HTML.Tag.A) {
                this.extractHREF(attributes);
            }
        }

        private void extractHREF(AttributeSet attributes) {
            Enumeration<?> e = attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                Object name = e.nextElement();
                String value = (String)attributes.getAttribute(name);
                try {
                    if (name != HTML.Attribute.HREF) continue;
                    URL u = new URL(DodsURLExtractor.this.baseURL, value);
                    String urlName = u.toString();
                    if (DodsURLExtractor.this.urlList != null) {
                        DodsURLExtractor.this.urlList.add(u.toString());
                    }
                    if (!DodsURLExtractor.this.debug) continue;
                    System.out.println(" extracted URL= <" + urlName + ">");
                }
                catch (MalformedURLException ex) {
                    System.err.println(ex);
                    System.err.println(DodsURLExtractor.this.baseURL);
                    System.err.println(value);
                    ex.printStackTrace();
                }
            }
        }

        public void handleText(char[] text, int position) {
            if (DodsURLExtractor.this.isTitle) {
                DodsURLExtractor.this.title = new String(text);
            }
            if (DodsURLExtractor.this.wantText) {
                DodsURLExtractor.this.textBuffer.append(text);
                DodsURLExtractor.this.textBuffer.append(' ');
            }
        }
    }
}

