/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayObject
extends Array {
    protected Class elementType;
    protected Object[] storage;

    static ArrayObject factory(Class classType, Index index) {
        return ArrayObject.factory(classType, index, null);
    }

    static ArrayObject factory(Class classType, Index index, Object[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(classType, index, storage);
            }
            case 1: {
                return new D1(classType, index, storage);
            }
            case 2: {
                return new D2(classType, index, storage);
            }
            case 3: {
                return new D3(classType, index, storage);
            }
            case 4: {
                return new D4(classType, index, storage);
            }
            case 5: {
                return new D5(classType, index, storage);
            }
            case 6: {
                return new D6(classType, index, storage);
            }
            case 7: {
                return new D7(classType, index, storage);
            }
        }
        return new ArrayObject(classType, index, storage);
    }

    public ArrayObject(Class elementType, int[] shape) {
        super(shape);
        this.elementType = elementType;
        this.storage = new Object[(int)this.indexCalc.getSize()];
    }

    Array createView(Index index) {
        return ArrayObject.factory(this.elementType, index, this.storage);
    }

    ArrayObject(Class elementType, Index ima, Object[] data) {
        super(ima);
        this.elementType = elementType;
        this.storage = data != null ? data : new Object[(int)this.indexCalc.getSize()];
    }

    public Object getStorage() {
        return this.storage;
    }

    void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            iter.setObjectNext(ja[i]);
        }
    }

    void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getObjectNext();
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = value;
    }

    double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    Object getObject(int index) {
        return this.storage[index];
    }

    void setObject(int index, Object value) {
        this.storage[index] = value;
    }

    public static class D7
    extends ArrayObject {
        private Index7D ix;

        public D7(Class classType, int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(classType, new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public Object get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayObject {
        private Index6D ix;

        public D6(Class classType, int len0, int len1, int len2, int len3, int len4, int len5) {
            super(classType, new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public Object get(int i, int j, int k, int l, int m, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayObject {
        private Index5D ix;

        public D5(Class classType, int len0, int len1, int len2, int len3, int len4) {
            super(classType, new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public Object get(int i, int j, int k, int l, int m) {
            return this.storage[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayObject {
        private Index4D ix;

        public D4(Class classType, int len0, int len1, int len2, int len3) {
            super(classType, new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public Object get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayObject {
        private Index3D ix;

        public D3(Class classType, int len0, int len1, int len2) {
            super(classType, new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public Object get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayObject {
        private Index2D ix;

        public D2(Class classType, int len0, int len1) {
            super(classType, new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public Object get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, Object value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayObject {
        private Index1D ix;

        public D1(Class classType, int len0) {
            super(classType, new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public Object get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, Object value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayObject {
        private Index0D ix;

        public D0(Class classType) {
            super(classType, new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Class classType, Index i, Object[] store) {
            super(classType, i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public Object get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(Object value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

