/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.formats.meta.DummyMetadata;
import ome.util.LSID;
import omero.ServerError;
import omero.api.IUpdatePrx;
import omero.api.ServiceFactoryPrx;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Mask;
import omero.model.MaskI;
import omero.model.Pixels;
import omero.model.Roi;
import omero.model.RoiI;
import omero.model.Shape;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayMetadataStore
extends DummyMetadata {
    private static Log log = LogFactory.getLog(OverlayMetadataStore.class);
    private List<Pixels> pixelsList;
    private Map<LSID, Roi> roiMap = new HashMap<LSID, Roi>();
    private Map<String, Roi> authoritativeRoiMap = new HashMap<String, Roi>();
    private IUpdatePrx updateService;

    public void initialize(ServiceFactoryPrx sf, List<Pixels> pixelsList, List<Long> plateIds) throws ServerError {
        this.pixelsList = pixelsList;
        this.updateService = sf.getUpdateService();
    }

    public void complete() throws ServerError {
        this.updateService.saveArray(new ArrayList<Roi>(this.roiMap.values()));
    }

    private Roi getRoi(int roiIndex) {
        LSID lsid = new LSID(Roi.class, new int[]{roiIndex});
        Roi o = this.roiMap.get(lsid);
        if (o == null) {
            o = new RoiI();
            this.roiMap.put(lsid, o);
        }
        return o;
    }

    private Mask getMask(int roiIndex, int shapeIndex) {
        Mask o;
        Roi roi = this.getRoi(roiIndex);
        try {
            o = (Mask)roi.getShape(shapeIndex);
        }
        catch (IndexOutOfBoundsException e) {
            if (roi.sizeOfShapes() != shapeIndex) {
                log.error((Object)String.format("Unable to retrieve a shape where index:%d > length:%d + 1", shapeIndex, roi.sizeOfShapes()));
                return null;
            }
            o = new MaskI();
            o.setTheZ(rtypes.rint((int)0));
            o.setTheT(rtypes.rint((int)0));
            roi.addShape((Shape)o);
        }
        return o;
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        Roi o = this.authoritativeRoiMap.get(roi);
        if (o == null) {
            log.error((Object)String.format("Unable to retrieve ROI with authoritative LSID: %s", roi));
            return;
        }
        try {
            Image image = this.pixelsList.get(imageIndex).getImage();
            image = new ImageI(image.getId(), false);
            o.setImage(image);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error((Object)String.format("Unable to retrieve Image with index: %d", imageIndex));
            return;
        }
    }

    public void setROIID(String id, int ROIIndex) {
        Roi o = this.getRoi(ROIIndex);
        this.authoritativeRoiMap.put(id, o);
    }

    public void setMaskStroke(Integer stroke, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setStrokeColor(rtypes.rint((int)stroke));
        }
    }

    public void setMaskHeight(Double height, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setHeight(rtypes.rdouble((double)height));
        }
    }

    public void setMaskWidth(Double width, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setWidth(rtypes.rdouble((double)width));
        }
    }

    public void setMaskX(Double x, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setX(rtypes.rdouble((double)x));
        }
    }

    public void setMaskY(Double y, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setY(rtypes.rdouble((double)y));
        }
    }

    public void setMaskBinData(byte[] binData, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setBytes(binData);
        }
    }
}

