/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import loci.formats.IFormatReader;
import loci.formats.gui.FormatFileFilter;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.gui.FileQueueChooser;
import ome.formats.importer.gui.FileQueueTable;
import ome.formats.importer.gui.GuiImporter;
import ome.formats.importer.gui.HistoryTable;
import ome.formats.importer.gui.ImportDialog;
import ome.formats.importer.gui.ImportHandler;
import ome.formats.importer.gui.LoggingImportMonitor;
import ome.formats.importer.gui.SPWDialog;
import ome.formats.importer.util.ErrorHandler;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileQueueHandler
extends JPanel
implements ActionListener,
PropertyChangeListener,
IObserver {
    private static final Log log = LogFactory.getLog(FileQueueHandler.class);
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String CLEARDONE = "clear_done";
    public static final String CLEARFAILED = "clear_failed";
    public static final String IMPORT = "import";
    public static final String REFRESH = "refresh";
    private final ImportConfig config;
    private final OMEROWrapper importReader;
    private final OMEROWrapper scanReader;
    private final GuiImporter viewer;
    private final FileQueueChooser fileChooser;
    private final FileQueueTable qTable;
    private final HistoryTable historyTable;
    private final AtomicInteger count = new AtomicInteger(0);
    private final ScheduledExecutorService scanEx;
    private final ScheduledExecutorService importEx;
    private JProgressBar directoryProgressBar;
    private JDialog progressDialog;
    protected boolean cancelScan = false;
    private boolean candidatesFormatException = false;

    FileQueueHandler(ScheduledExecutorService scanEx, ScheduledExecutorService importEx, GuiImporter viewer, ImportConfig config) {
        this.scanEx = scanEx;
        this.importEx = importEx;
        this.config = config;
        this.viewer = viewer;
        this.historyTable = viewer.getHistoryTable();
        this.importReader = new OMEROWrapper(config);
        this.scanReader = new OMEROWrapper(config);
        this.setLayout(new BorderLayout());
        this.fileChooser = new FileQueueChooser(config, this.scanReader);
        this.fileChooser.addActionListener(this);
        this.fileChooser.addPropertyChangeListener(this);
        this.qTable = new FileQueueTable();
        this.qTable.addPropertyChangeListener(this);
        if (this.historyTable != null) {
            this.historyTable.addObserver(this);
            this.addPropertyChangeListener(this.historyTable);
        }
        JSplitPane splitPane = new JSplitPane(1, this.fileChooser, this.qTable);
        splitPane.setResizeWeight(0.1);
        this.add((Component)splitPane, "Center");
    }

    public FileQueueTable getTable() {
        return this.qTable;
    }

    protected OMEROMetadataStoreClient getOMEROMetadataStoreClient() {
        return this.viewer.getLoginHandler().getMetadataStore();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("ApproveSelection")) {
            this.doSelection(true);
        }
    }

    private void addEnabled(boolean enabled) {
        if (enabled) {
            this.viewer.setCursor(Cursor.getDefaultCursor());
        } else {
            this.viewer.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.qTable.addBtn.setEnabled(enabled);
        this.qTable.removeBtn.setEnabled(enabled);
    }

    private void doSelection(boolean enterDirectories) {
        boolean filesOnly = true;
        for (File file : this.fileChooser.getSelectedFiles()) {
            if (!file.isDirectory()) continue;
            filesOnly = false;
        }
        if (enterDirectories && !filesOnly && this.fileChooser.getSelectedFiles().length == 1) {
            this.fileChooser.setCurrentDirectory(this.fileChooser.getSelectedFile());
        } else {
            this.addSelectedFiles();
        }
    }

    private void addSelectedFiles() {
        boolean filesOnly = true;
        File[] _files = this.fileChooser.getSelectedFiles();
        if (_files == null) {
            this.mustSelectFile();
            return;
        }
        Object[] paths = new String[_files.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = _files[i].getAbsolutePath();
        }
        final int which = this.count.incrementAndGet();
        final String msg = Arrays.toString(paths);
        log.info((Object)String.format("Scheduling candidate calculations(%s)=%s", which, msg));
        FileQueueHandler self = this;
        for (File file : this.fileChooser.getSelectedFiles()) {
            if (!file.isDirectory()) continue;
            filesOnly = false;
        }
        this.addEnabled(false);
        if (filesOnly) {
            boolean isSPW = false;
            ArrayList<ImportContainer> containers = new ArrayList<ImportContainer>();
            boolean runCandidates = false;
            for (File file : this.fileChooser.getSelectedFiles()) {
                String fileStr = file.toString();
                String fileExt = fileStr.substring(fileStr.lastIndexOf(46) + 1, fileStr.length());
                if ((fileExt = fileExt.toLowerCase()).equals("flex") || fileExt.equals("xdce") || fileExt.equals("mea") || fileExt.equals("res") || fileExt.equals("htd") || fileExt.equals("pnl")) {
                    isSPW = true;
                } else if (fileExt.equals("txt") || fileExt.equals("xml") || fileExt.equals("log")) {
                    runCandidates = true;
                    break;
                }
                ImportContainer container = new ImportContainer(file, null, null, false, null, null, null, isSPW);
                containers.add(container);
            }
            if (!runCandidates) {
                log.info((Object)String.format("Handling import containers(%s)=%s", which, msg));
                this.handleFiles(containers);
                return;
            }
        }
        Runnable run = new Runnable((String[])paths, self){
            final /* synthetic */ String[] val$paths;
            final /* synthetic */ IObserver val$self;
            {
                this.val$paths = stringArray;
                this.val$self = iObserver;
            }

            public void run() {
                log.info((Object)String.format("Background: calculating candidates(%s)=%s", which, msg));
                ImportCandidates candidates = new ImportCandidates(FileQueueHandler.this.scanReader, this.val$paths, this.val$self);
                final List<ImportContainer> containers = candidates.getContainers();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        log.info((Object)String.format("Handling import containers(%s)=%s", which, msg));
                        FileQueueHandler.this.handleFiles(containers);
                    }
                });
            }
        };
        this.scanEx.execute(run);
    }

    private void handleFiles(List<ImportContainer> allContainers) {
        JDialog dialog;
        FileFilter selectedFilter = this.fileChooser.getFileFilter();
        IFormatReader selectedReader = null;
        if (selectedFilter instanceof FormatFileFilter) {
            log.debug((Object)("Selected file filter: " + selectedFilter));
            selectedReader = ((FormatFileFilter)selectedFilter).getReader();
        }
        List<ImportContainer> containers = new ArrayList<ImportContainer>();
        for (ImportContainer ic : allContainers) {
            String b;
            if (selectedReader == null) {
                containers = allContainers;
                break;
            }
            String a = selectedReader.getFormat();
            if (a.equals(b = ic.getReader()) || b == null) {
                containers.add(ic);
                continue;
            }
            log.debug((Object)String.format("Skipping %s (%s != %s)", ic.getFile().getAbsoluteFile(), a, b));
        }
        Boolean spw = this.spwOrNull(containers);
        if (containers.size() == 0 && !this.candidatesFormatException) {
            final JOptionPane optionPane = new JOptionPane("\nNo importable files found in this selection.", 2);
            final JDialog errorDialog = new JDialog(this.viewer, "No Importable Files Found", true);
            errorDialog.setContentPane(optionPane);
            optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (errorDialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                        errorDialog.dispose();
                    }
                }
            });
            errorDialog.toFront();
            errorDialog.pack();
            errorDialog.setLocationRelativeTo(this.viewer);
            errorDialog.setVisible(true);
        }
        if (this.candidatesFormatException) {
            this.viewer.candidateErrorsCollected(this.viewer);
            this.candidatesFormatException = false;
        }
        if (spw == null) {
            this.addEnabled(true);
            containers.clear();
            return;
        }
        if (this.getOMEROMetadataStoreClient() != null && spw.booleanValue()) {
            this.addEnabled(true);
            dialog = new SPWDialog(this.config, this.viewer, "Screen Import", true, this.getOMEROMetadataStoreClient());
            if (dialog.cancelled || dialog.screen == null) {
                return;
            }
            for (ImportContainer ic : containers) {
                ic.setTarget((IObject)dialog.screen);
                String title = dialog.screen.getName().getValue();
                this.addFileToQueue(ic, title, false, 0);
            }
            FileQueueHandler fileQueueHandler = this;
            this.qTable.centerOnRow(fileQueueHandler.qTable.getQueue().getRowCount() - 1);
            this.qTable.importBtn.requestFocus();
        } else if (this.getOMEROMetadataStoreClient() != null) {
            this.addEnabled(true);
            dialog = new ImportDialog(this.config, this.viewer, "Image Import", true, this.getOMEROMetadataStoreClient());
            if (((ImportDialog)dialog).cancelled || ((ImportDialog)dialog).dataset == null) {
                return;
            }
            Double[] pixelSizes = new Double[]{((ImportDialog)dialog).pixelSizeX, ((ImportDialog)dialog).pixelSizeY, ((ImportDialog)dialog).pixelSizeZ};
            Boolean useFullPath = (Boolean)this.config.useFullPath.get();
            if (!((ImportDialog)dialog).useCustomNamingChkBox.isSelected()) {
                useFullPath = null;
            }
            for (ImportContainer ic : containers) {
                ic.setTarget((IObject)((ImportDialog)dialog).dataset);
                ic.setUserPixels(pixelSizes);
                ic.setArchive(((ImportDialog)dialog).archiveImage.isSelected());
                ic.setProjectID(((ImportDialog)dialog).project.getId().getValue());
                String title = ((ImportDialog)dialog).project.getName().getValue() + " / " + ((ImportDialog)dialog).dataset.getName().getValue();
                this.addFileToQueue(ic, title, useFullPath, (Integer)this.config.numOfDirectories.get());
            }
            FileQueueHandler fileQueueHandler = this;
            this.qTable.centerOnRow(fileQueueHandler.qTable.getQueue().getRowCount() - 1);
            this.qTable.importBtn.requestFocus();
        } else {
            this.addEnabled(true);
            JOptionPane.showMessageDialog(this.viewer, "Due to an error the application is unable to \nretrieve an OMEROMetadataStore and cannot continue.The most likely cause for this error is that youare not logged in. Please try to login again.");
        }
    }

    private void mustSelectFile() {
        JOptionPane.showMessageDialog(this.viewer, "You must select at least one importable file to\nadd to the import queue. Choose an image in the\nleft-hand panel first before continuing.");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(ADD)) {
            this.doSelection(false);
        } else if (prop.equals(REMOVE)) {
            FileQueueHandler fileQueueHandler = this;
            int[] rows = fileQueueHandler.qTable.getQueue().getSelectedRows();
            if (rows.length == 0) {
                JOptionPane.showMessageDialog(this.viewer, "You must select at least one file in the queue to\nremove. Choose an image in the right-hand panel \nfirst before removing.");
                return;
            }
            while (rows.length > 0) {
                FileQueueHandler fileQueueHandler2 = this;
                if (fileQueueHandler2.qTable.getQueue().getValueAt(rows[0], 2) != "added") {
                    FileQueueHandler fileQueueHandler3 = this;
                    if (fileQueueHandler3.qTable.getQueue().getValueAt(rows[0], 2) != "pending") continue;
                }
                this.removeFileFromQueue(rows[0]);
                FileQueueHandler fileQueueHandler4 = this;
                rows = fileQueueHandler4.qTable.getQueue().getSelectedRows();
            }
        } else if (prop.equals(CLEARDONE)) {
            FileQueueHandler fileQueueHandler = this;
            int numRows = fileQueueHandler.qTable.getQueue().getRowCount();
            for (int i = numRows - 1; i >= 0; --i) {
                FileQueueHandler fileQueueHandler5 = this;
                if (fileQueueHandler5.qTable.getQueue().getValueAt(i, 2) != "done") continue;
                this.removeFileFromQueue(i);
            }
            this.qTable.clearDoneBtn.setEnabled(false);
        } else if (prop.equals(CLEARFAILED)) {
            FileQueueHandler fileQueueHandler = this;
            int numRows = fileQueueHandler.qTable.getQueue().getRowCount();
            for (int i = numRows - 1; i >= 0; --i) {
                FileQueueHandler fileQueueHandler6 = this;
                if (fileQueueHandler6.qTable.getQueue().getValueAt(i, 2) != "failed") {
                    FileQueueHandler fileQueueHandler7 = this;
                    if (fileQueueHandler7.qTable.getQueue().getValueAt(i, 2) != "unreadable") continue;
                }
                this.removeFileFromQueue(i);
            }
            this.qTable.clearFailedBtn.setEnabled(false);
        } else if (prop.equals(IMPORT)) {
            if (!this.viewer.getLoggedIn().booleanValue()) {
                JOptionPane.showMessageDialog(this.viewer, "You must be logged in before you can import.");
                return;
            }
            this.qTable.clearDoneBtn.setEnabled(false);
            this.qTable.clearFailedBtn.setEnabled(false);
            try {
                if (!this.qTable.importing) {
                    ImportContainer[] candidates = this.qTable.getImportContainersFromTable();
                    if (candidates != null) {
                        ImportLibrary library = new ImportLibrary(this.getOMEROMetadataStoreClient(), this.importReader);
                        library.addObserver(new LoggingImportMonitor());
                        if (this.getOMEROMetadataStoreClient() != null) {
                            ImportHandler importHandler = new ImportHandler(this.importEx, this.viewer, this.qTable, this.config, library, candidates);
                            importHandler.addObserver(this.viewer);
                            importHandler.addObserver(this.qTable);
                        }
                    }
                    this.qTable.importing = true;
                    FileQueueHandler fileQueueHandler = this;
                    fileQueueHandler.qTable.getQueue().setRowSelectionAllowed(false);
                    this.qTable.removeBtn.setEnabled(false);
                }
                this.qTable.importBtn.setText("Wait...");
                this.qTable.importBtn.setEnabled(false);
                this.viewer.getStatusBar().setStatusIcon("gfx/import_cancelling_16.png", "Cancelling import... please wait.");
                if (this.cancelImportDialog(this.viewer)) {
                    this.qTable.cancel = true;
                    this.qTable.abort = true;
                    this.qTable.importing = false;
                    System.exit(0);
                }
                this.qTable.cancel = true;
                this.qTable.importing = false;
            }
            catch (Exception ex) {
                log.error((Object)"Generic error while updating GUI for import.", (Throwable)ex);
                return;
            }
        } else if (prop.equals("directoryChanged")) {
            this.config.savedDirectory.set(new File(this.fileChooser.getCurrentDirectory().getAbsolutePath()));
        } else if (prop.equals(REFRESH)) {
            this.fileChooser.setVisible(false);
            this.fileChooser.rescanCurrentDirectory();
            this.fileChooser.setVisible(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enableImports(boolean b) {
        this.qTable.addBtn.setEnabled(b);
        this.qTable.removeBtn.setEnabled(b);
        if (b) {
            FileQueueHandler fileQueueHandler = this;
            if (fileQueueHandler.qTable.getTable().getRowCount() > 0) {
                this.qTable.importBtn.setEnabled(true);
                return;
            }
        }
        if (b) return;
        this.qTable.importBtn.setEnabled(false);
    }

    private Boolean spwOrNull(List<ImportContainer> containers) {
        Boolean isSPW = null;
        for (ImportContainer importContainer : containers) {
            if (isSPW != null && importContainer.getIsSPW().booleanValue() != isSPW.booleanValue()) {
                JOptionPane.showMessageDialog(this.viewer, "You have chosen some Screen-based images and some \n non-screen-based images. Please import only one type at a time.");
                log.debug((Object)"Directory import found SPW and non-SPW data:");
                for (ImportContainer ic2 : containers) {
                    log.debug((Object)String.format("  Spw? %5s\t%s", ic2.getIsSPW(), ic2.getFile()));
                }
                return null;
            }
            isSPW = importContainer.getIsSPW();
        }
        return isSPW;
    }

    private boolean cancelImportDialog(Component frame) {
        String s1 = "OK";
        String s2 = "Force Quit Now";
        Object[] options = new Object[]{s1, s2};
        int n = JOptionPane.showOptionDialog(frame, "Click 'OK' to cancel after the current file has\nfinished importing, or click 'Force Quit Now' to\nforce the importer to quit importing immediately.\n\nYou should only force quit the importer if there\nhas been an import problem, as this leaves partial\nfiles in your server dataset.\n\n", "Cancel Import", 0, 3, null, options, s1);
        return n == 1;
    }

    private String getImageName(File file, Boolean useFullPath, int numOfDirectories) {
        String path = file.getAbsolutePath().replace('\\', '/');
        if (useFullPath.booleanValue()) {
            return path;
        }
        if (numOfDirectories == 0) {
            return file.getName();
        }
        String[] directories = this.splitDirectories(path);
        if (numOfDirectories > directories.length - 1) {
            numOfDirectories = directories.length - 1;
        }
        int start = directories.length - numOfDirectories - 1;
        StringBuffer buf = new StringBuffer();
        for (int i = start; i < directories.length - 1; ++i) {
            if (directories[i].length() == 0) continue;
            if (i == start) {
                buf.append(directories[i]);
                continue;
            }
            buf.append("/");
            buf.append(directories[i]);
        }
        buf.append("/");
        buf.append(file.getName());
        return buf.toString();
    }

    private String[] splitDirectories(String path) {
        String[] fields = path.split("/");
        return fields;
    }

    private void removeFileFromQueue(int row) {
        FileQueueHandler fileQueueHandler = this;
        fileQueueHandler.qTable.getTable().removeRow(row);
        FileQueueHandler fileQueueHandler2 = this;
        if (fileQueueHandler2.qTable.getTable().getRowCount() == 0) {
            this.qTable.importBtn.setEnabled(false);
        }
    }

    @Override
    public void update(IObservable observable, ImportEvent event) {
        OMEROMetadataStoreClient store = this.viewer.getLoginHandler().getMetadataStore();
        if (event instanceof ErrorHandler.EXCEPTION_EVENT) {
            this.viewer.getErrorHandler().update(observable, event);
            if (event instanceof ErrorHandler.UNKNOWN_FORMAT && this.fileChooser.getSelectedFiles().length == 1 && this.fileChooser.getSelectedFile().isFile()) {
                JOptionPane.showMessageDialog(this.viewer, "This file's format is not recognized. \nPerhaps the file is damaged?", "Unknown Format", 2);
            }
            if (event instanceof ErrorHandler.FILE_EXCEPTION) {
                this.candidatesFormatException = true;
            }
        }
        if (event instanceof ErrorHandler.MISSING_LIBRARY) {
            JOptionPane.showMessageDialog(this.viewer, "You appear to be missing a required library needed for \nthis file import. See the debug log messages for details.");
        } else if (event instanceof ImportCandidates.SCANNING) {
            this.addEnabled(false);
            ImportCandidates.SCANNING ev = (ImportCandidates.SCANNING)event;
            if (this.scanEx.isShutdown() || this.cancelScan) {
                log.info((Object)"Cancelling scan");
                ev.cancel();
                this.cancelScan = false;
            }
            if (ev.totalFiles < 0) {
                if (this.progressDialog == null) {
                    double[][] layoutTable = new double[][]{{10.0, 180.0, 100.0, 10.0}, {5.0, 20.0, 5.0, 30.0, 5.0}};
                    this.progressDialog = new JDialog((Frame)this.viewer, "Processing Files");
                    this.progressDialog.setSize(300, 90);
                    this.progressDialog.setLocationRelativeTo(this.viewer);
                    TableLayout layout = new TableLayout((double[][])layoutTable);
                    this.progressDialog.setLayout((LayoutManager)layout);
                    this.directoryProgressBar = new JProgressBar();
                    this.directoryProgressBar.setString("Please wait.");
                    this.directoryProgressBar.setStringPainted(true);
                    this.directoryProgressBar.setIndeterminate(true);
                    this.progressDialog.add((Component)this.directoryProgressBar, "1,1,2,1");
                    JButton cancelBtn = new JButton("Cancel");
                    this.progressDialog.setDefaultCloseOperation(0);
                    cancelBtn.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            FileQueueHandler.this.cancelScan = true;
                            FileQueueHandler.this.progressDialog.dispose();
                            FileQueueHandler.this.progressDialog = null;
                            FileQueueHandler.this.addEnabled(true);
                        }
                    });
                    this.progressDialog.add((Component)cancelBtn, "2,3,R,C");
                    this.progressDialog.getRootPane().setDefaultButton(cancelBtn);
                    this.progressDialog.setVisible(true);
                    this.progressDialog.toFront();
                }
            } else {
                if (this.progressDialog != null) {
                    this.updateProgress(ev.totalFiles, ev.numFiles);
                }
                if (ev.totalFiles == ev.numFiles && this.progressDialog != null) {
                    this.progressDialog.dispose();
                    this.progressDialog = null;
                    this.addEnabled(true);
                }
            }
            this.viewer.appendToOutput("Processing files: Scanned " + ev.numFiles + " of " + ev.totalFiles + " total.\n");
            log.debug((Object)ev.toLog());
        } else if (event instanceof ImportEvent.REIMPORT) {
            String objectName = "";
            String projectName = "";
            String fileName = "";
            Long objectID = 0L;
            Long projectID = 0L;
            File file = null;
            Integer finalCount = 0;
            int[] selectedRows = null;
            if (this.historyTable != null) {
                selectedRows = this.historyTable.eTable.getSelectedRows();
            }
            for (int r : selectedRows) {
                Screen object;
                Vector<Object> row;
                block31: {
                    row = new Vector<Object>();
                    objectID = (Long)this.historyTable.table.getValueAt(r, 5);
                    projectID = (Long)this.historyTable.table.getValueAt(r, 6);
                    fileName = (String)this.historyTable.table.getValueAt(r, 0);
                    file = new File((String)this.historyTable.table.getValueAt(r, 4));
                    if (projectID == null || projectID == 0L) {
                        object = null;
                        try {
                            object = store.getTarget(Screen.class, objectID);
                            objectName = object.getName().getValue();
                            break block31;
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to retrieve screen: " + objectID), (Throwable)e);
                            continue;
                        }
                    }
                    object = null;
                    try {
                        object = store.getTarget(Dataset.class, objectID);
                        objectName = ((Dataset)object).getName().getValue();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to retrieve dataset: " + objectID), (Throwable)e);
                        continue;
                    }
                    try {
                        projectName = store.getProject(projectID).getName().getValue();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to retrieve project: " + projectID), (Throwable)e);
                        continue;
                    }
                }
                ImportContainer container = new ImportContainer(file, projectID, (IObject)object, this.cancelScan, null, fileName, null, this.cancelScan);
                finalCount = finalCount + 1;
                Double[] pixelSizes = new Double[]{1.0, 1.0, 1.0};
                row.add(fileName);
                if (projectID == null || projectID == 0L) {
                    row.add(objectName);
                } else {
                    row.add(projectName + "/" + objectName);
                }
                row.add("added");
                row.add(container);
                row.add(file);
                row.add(false);
                row.add(projectID);
                row.add(pixelSizes);
                FileQueueHandler fileQueueHandler = this;
                fileQueueHandler.qTable.getTable().addRow(row);
            }
            if (finalCount == 0) {
                JOptionPane.showMessageDialog(this.viewer, "None of the images in this history\nlist can be reimported.");
            } else if (finalCount == 1) {
                JOptionPane.showMessageDialog(this.viewer, "One of the images in this history list has been\nre-added to the import queue for reimport.");
            } else if (finalCount > 1) {
                JOptionPane.showMessageDialog(this.viewer, finalCount + " images in this history list have been re-added\n" + "to the import queue for reimport.");
            }
            FileQueueHandler fileQueueHandler = this;
            if (fileQueueHandler.qTable.getTable().getRowCount() > 0) {
                this.qTable.importBtn.setEnabled(true);
            }
            this.qTable.importBtn.doClick();
        }
    }

    private void addFileToQueue(ImportContainer container, String pdsString, Boolean useFullPath, int numOfDirectories) {
        String imageName;
        Vector<Object> row = new Vector<Object>();
        if (useFullPath != null) {
            imageName = this.getImageName(container.getFile(), useFullPath, numOfDirectories);
            container.setCustomImageName(imageName);
        } else {
            imageName = container.getFile().getAbsolutePath();
        }
        row.add(imageName);
        row.add(pdsString);
        row.add("added");
        row.add(container);
        FileQueueHandler fileQueueHandler = this;
        fileQueueHandler.qTable.getTable().addRow(row);
        FileQueueHandler fileQueueHandler2 = this;
        if (fileQueueHandler2.qTable.getTable().getRowCount() == 1) {
            this.qTable.importBtn.setEnabled(true);
        }
    }

    private void updateProgress(final int totalFiles, final int numFiles) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileQueueHandler.this.directoryProgressBar.setIndeterminate(false);
                FileQueueHandler.this.directoryProgressBar.setMaximum(totalFiles);
                FileQueueHandler.this.directoryProgressBar.setMinimum(0);
                FileQueueHandler.this.directoryProgressBar.setValue(numFiles);
                FileQueueHandler.this.directoryProgressBar.setString("Scanned " + numFiles + " of " + totalFiles);
            }
        });
    }
}

