/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.About;
import ome.formats.importer.gui.CommentMessenger;
import ome.formats.importer.gui.ErrorHandler;
import ome.formats.importer.gui.FileQueueHandler;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.HistoryDB;
import ome.formats.importer.gui.HistoryHandler;
import ome.formats.importer.gui.HistoryTable;
import ome.formats.importer.gui.LogAppender;
import ome.formats.importer.gui.LoginHandler;
import ome.formats.importer.gui.OptionsDialog;
import ome.formats.importer.gui.StatusBar;
import ome.formats.importer.util.BareBonesBrowserLaunch;
import ome.formats.importer.util.ErrorHandler;
import ome.formats.importer.util.IniFileLoader;
import ome.formats.importer.util.LogAppenderProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;

public class GuiImporter
extends JFrame
implements ActionListener,
WindowListener,
IObserver,
PropertyChangeListener,
WindowStateListener,
WindowFocusListener {
    private static final String show_log_file = "show_log_file_location";
    private static Log log = LogFactory.getLog(GuiImporter.class);
    private static final boolean useSplashScreenAbout = false;
    static boolean USE_QUAQUA = false;
    public static final String TITLE = "OMERO.importer";
    public static final String splash = "gfx/importer_splash.png";
    public static final String ICON = "gfx/icon.png";
    public static final String QUIT_ICON = "gfx/nuvola_exit16.png";
    public static final String LOGIN_ICON = "gfx/nuvola_login16.png";
    public static final String COMMENT_ICON = "gfx/nuvola_sendcomment16.png";
    public static final String HOME_ICON = "gfx/nuvola_home16.png";
    public static final String ABOUT_ICON = "gfx/nuvola_about16.png";
    public static final String HISTORY_ICON = "gfx/nuvola_history16.png";
    public static final String CHOOSER_ICON = "gfx/nuvola_chooser16.png";
    public static final String OUTPUT_ICON = "gfx/nuvola_output16.png";
    public static final String BUG_ICON = "gfx/nuvola_bug16.png";
    public static final String CONFIG_ICON = "gfx/nuvola_configure16.png";
    public static final String ERROR_ICON_ANIM = "gfx/warning_msg16_anim.gif";
    public static final String ERROR_ICON = "gfx/warning_msg16.png";
    public static final String LOGFILE_ICON = "gfx/nuvola_output16.png";
    public static final String FORUM_ICON = "gfx/nuvola_chat16.png";
    private ImportConfig config;
    private ErrorHandler errorHandler;
    private FileQueueHandler fileQueueHandler;
    private StatusBar statusBar;
    private LoginHandler loginHandler;
    private HistoryHandler historyHandler;
    private HistoryTable historyTable;
    private JMenuBar menubar;
    private JMenu fileMenu;
    private JMenuItem options;
    private JMenuItem fileQuit;
    private JMenuItem login;
    private JMenu helpMenu;
    private JMenuItem helpComment;
    private JMenuItem helpForums;
    private JMenuItem helpHome;
    private JMenuItem helpAbout;
    private Boolean loggedIn;
    private JTextPane outputTextPane;
    private JTextPane debugTextPane;
    private JPanel historyPanel;
    private JPanel errorPanel;
    JTabbedPane tPane;
    final int historyTabIndex = 1;
    private boolean errors_pending = false;
    private boolean error_notification = false;
    private ScheduledExecutorService scanEx = Executors.newScheduledThreadPool(1);
    private ScheduledExecutorService importEx = Executors.newScheduledThreadPool(1);
    private Rectangle bounds;

    public GuiImporter(ImportConfig config) {
        this.setConfig(config);
        this.bounds = config.getUIBounds();
        Level level = Level.toLevel((int)config.getDebugLevel());
        LogAppender.setLoggingLevel(level);
        this.historyHandler = new HistoryHandler(this);
        this.setHistoryTable(this.historyHandler.table);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                log.debug((Object)"Running shutdown hook.");
                GuiImporter.this.shutdown();
            }
        });
        this.setTitle(config.getAppTitle());
        this.setIconImage(GuiCommonElements.getImageIcon(ICON).getImage());
        this.setPreferredSize(new Dimension(this.bounds.width, this.bounds.height));
        this.setSize(this.bounds.width, this.bounds.height);
        this.setLocation(this.bounds.x, this.bounds.y);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.pack();
        this.addWindowListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                GuiImporter.this.bounds = GuiImporter.this.getBounds();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                GuiImporter.this.bounds = GuiImporter.this.getBounds();
            }
        });
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.menubar.add(this.fileMenu);
        this.login = new JMenuItem("Login to the server...", GuiCommonElements.getImageIcon(LOGIN_ICON));
        this.login.setActionCommand("login");
        this.login.addActionListener(this);
        this.fileMenu.add(this.login);
        this.options = new JMenuItem("Options...", GuiCommonElements.getImageIcon(CONFIG_ICON));
        this.options.setActionCommand("options");
        this.options.addActionListener(this);
        this.fileMenu.add(this.options);
        this.fileQuit = new JMenuItem("Quit", GuiCommonElements.getImageIcon(QUIT_ICON));
        this.fileQuit.setActionCommand("quit");
        this.fileQuit.addActionListener(this);
        this.fileMenu.add(this.fileQuit);
        this.helpMenu = new JMenu("Help");
        this.menubar.add(this.helpMenu);
        this.helpComment = new JMenuItem("Send a Comment...", GuiCommonElements.getImageIcon(COMMENT_ICON));
        this.helpComment.setActionCommand("comment");
        this.helpComment.addActionListener(this);
        this.helpHome = new JMenuItem("Visit Importer Homepage...", GuiCommonElements.getImageIcon(HOME_ICON));
        this.helpHome.setActionCommand("home");
        this.helpHome.addActionListener(this);
        this.helpForums = new JMenuItem("Visit the OMERO Forums...", GuiCommonElements.getImageIcon(FORUM_ICON));
        this.helpForums.setActionCommand("forums");
        this.helpForums.addActionListener(this);
        this.helpAbout = new JMenuItem("About the Importer...", GuiCommonElements.getImageIcon(ABOUT_ICON));
        this.helpAbout.setActionCommand("about");
        this.helpAbout.addActionListener(this);
        this.helpMenu.add(this.helpComment);
        this.helpMenu.add(this.helpHome);
        this.helpMenu.add(this.helpForums);
        JMenuItem helpShowLog = new JMenuItem("Show log file location...", GuiCommonElements.getImageIcon("gfx/nuvola_output16.png"));
        helpShowLog.setActionCommand(show_log_file);
        helpShowLog.addActionListener(this);
        this.helpMenu.add(helpShowLog);
        this.helpMenu.add(this.helpAbout);
        this.setJMenuBar(this.menubar);
        this.tPane = new JTabbedPane();
        this.tPane.setOpaque(false);
        JPanel filePanel = new JPanel(new BorderLayout());
        this.setStatusBar(new StatusBar());
        this.getStatusBar().setStatusIcon("gfx/server_disconn16.png", "Server disconnected.");
        this.getStatusBar().setProgress(false, 0, "");
        this.getContentPane().add((Component)this.getStatusBar(), "South");
        this.setFileQueueHandler(new FileQueueHandler(this.scanEx, this.importEx, this, config));
        filePanel.add((Component)this.getFileQueueHandler(), "Center");
        this.tPane.addTab("File Chooser", GuiCommonElements.getImageIcon(CHOOSER_ICON), filePanel, "Add and delete images here to the import queue.");
        this.tPane.setMnemonicAt(0, 49);
        this.historyPanel = new JPanel();
        this.historyPanel.setOpaque(false);
        this.historyPanel.setLayout(new BorderLayout());
        this.tPane.addTab("Import History", GuiCommonElements.getImageIcon(HISTORY_ICON), this.historyPanel, "Import history is displayed here.");
        this.tPane.setMnemonicAt(0, 52);
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new BorderLayout());
        this.outputTextPane = new JTextPane();
        this.outputTextPane.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane();
        outputScrollPane.getViewport().add(this.outputTextPane);
        outputScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                try {
                    GuiImporter.this.outputTextPane.setCaretPosition(GuiImporter.this.outputTextPane.getDocument().getLength());
                }
                catch (IllegalArgumentException e1) {
                    log.error((Object)("Error setting cursor:" + e1));
                }
            }
        });
        outputPanel.add((Component)outputScrollPane, "Center");
        this.tPane.addTab("Output Text", GuiCommonElements.getImageIcon("gfx/nuvola_output16.png"), outputPanel, "Standard output text goes here.");
        this.tPane.setMnemonicAt(0, 50);
        JPanel debugPanel = new JPanel();
        debugPanel.setLayout(new BorderLayout());
        this.debugTextPane = new JTextPane();
        this.debugTextPane.setEditable(false);
        JScrollPane debugScrollPane = new JScrollPane();
        debugScrollPane.getViewport().add(this.debugTextPane);
        debugScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                try {
                    GuiImporter.this.debugTextPane.setCaretPosition(GuiImporter.this.debugTextPane.getDocument().getLength());
                }
                catch (IllegalArgumentException e1) {
                    log.error((Object)("Error setting cursor:" + e1));
                }
            }
        });
        debugPanel.add((Component)debugScrollPane, "Center");
        this.tPane.addTab("Debug Text", GuiCommonElements.getImageIcon(BUG_ICON), debugPanel, "Debug messages are displayed here.");
        this.tPane.setMnemonicAt(0, 51);
        this.errorPanel = new JPanel();
        this.errorPanel.setOpaque(false);
        this.errorPanel.setLayout(new BorderLayout());
        this.tPane.addTab("Import Errors", GuiCommonElements.getImageIcon(ERROR_ICON), this.errorPanel, "Import errors are displayed here.");
        this.tPane.setMnemonicAt(0, 53);
        this.tPane.setSelectedIndex(0);
        if (!this.getHistoryTable().db.historyEnabled) {
            this.tPane.setEnabledAt(1, false);
        }
        this.add(this.tPane);
        this.setVisible(false);
        this.historyPanel.add((Component)this.historyHandler, "Center");
        this.tPane.setEnabledAt(1, false);
        this.setLoginHandler(new LoginHandler(this, this.getHistoryTable()));
        LogAppender.getInstance().setTextArea(this.debugTextPane);
        this.appendToOutputLn("> Starting the importer (revision " + GuiImporter.getPrintableKeyword("$LastChangedRevision: 2524 $") + ").");
        this.appendToOutputLn("> Build date: " + GuiImporter.getPrintableKeyword("$LastChangedDate: 2008-06-23 10:29:21 +0100 (Mon, 23 Jun 2008) $"));
        this.appendToOutputLn("> Release date: 2008-06-16 16:18:13 +0100 (Mon, 16 Jun 2008)");
        this.setErrorHandler(new ErrorHandler(this.importEx, config));
        this.getErrorHandler().addObserver(this);
        this.errorPanel.add((Component)this.getErrorHandler(), "Center");
        this.macMenuFix();
    }

    void checkHistoryEnable() {
        this.tPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                if (pane.indexAtLocation(e.getX(), e.getY()) == 1 && !GuiImporter.this.getHistoryTable().db.historyEnabled && !HistoryDB.alertOnce) {
                    JOptionPane.showMessageDialog(null, "For some reason we are not able to connect to the remote\nhistory service (this most likely means the server does\nnot have this feature installed). In the meantime, you will\nstill be able to use the importer, however the history tab's\nfunctionality will not be enabled.", "Warning", 0);
                    HistoryDB.alertOnce = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        log.debug((Object)"Shutdown called");
        this.importEx.shutdown();
        this.scanEx.shutdown();
        this.waitOnExecutor("Import", this.importEx, 60);
        this.waitOnExecutor("Scanning", this.scanEx, 60);
        try {
            this.getLoginHandler().logout();
        }
        catch (Exception e) {
            log.warn((Object)"Exception on metadatastore.logout()", (Throwable)e);
        }
        try {
            this.getConfig().setUIBounds(this.bounds);
        }
        finally {
            this.getConfig().saveAll();
            this.getConfig().saveGui();
        }
    }

    private void waitOnExecutor(String msg, ScheduledExecutorService ex, int secs) {
        try {
            boolean terminated = this.importEx.awaitTermination(secs, TimeUnit.SECONDS);
            if (!terminated) {
                log.error((Object)(msg + " still running!"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception on awaitTermination of " + msg), (Throwable)e);
        }
    }

    private void macMenuFix() {
        try {
            MacOSMenuHandler handler = new MacOSMenuHandler((Frame)this);
            handler.initialize();
            this.addPropertyChangeListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void appendToOutput(String s) {
        try {
            StyledDocument doc = (StyledDocument)this.outputTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 200000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToOutputLn(String s) {
        this.appendToOutput(s + "\n");
    }

    public void appendToDebug(String s) {
        log.debug((Object)s);
        try {
            StyledDocument doc = (StyledDocument)this.debugTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 200000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToDebugLn(String s) {
        this.appendToDebug(s + "\n");
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if ("login".equals(cmd)) {
            if (this.getLoggedIn().booleanValue()) {
                this.logout();
                this.getLoginHandler().logout();
                this.setLoginHandler(null);
                this.showLogoutMessage();
            } else {
                HistoryTable table = null;
                if (this.historyHandler != null) {
                    table = this.historyHandler.table;
                }
                this.setLoginHandler(new LoginHandler(this, table, true, false));
            }
        } else if ("quit".equals(cmd)) {
            String message = null;
            if (this.error_notification) {
                message = "Do you really want to quit?\nDoing so will cancel any running imports.\n\nNOTE: You still have unsent error messages!";
            }
            if (GuiCommonElements.quitConfirmed(this, message)) {
                try {
                    ScreenLogin.registerGroup(this.getLoginHandler().getMetadataStore().mapUserGroups());
                }
                catch (Exception e) {
                    log.warn((Object)"Exception on ScreenLogin.registerGroup()", (Throwable)e);
                }
                System.exit(0);
            }
        } else if ("options".equals(cmd)) {
            OptionsDialog dialog = new OptionsDialog(this.config, this, "Import", true);
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            About.show(this, this.getConfig(), false);
        } else if ("comment".equals(cmd)) {
            new CommentMessenger(this, "OMERO.importer Comment Dialog", this.getConfig(), true, false);
        } else if ("home".equals(cmd)) {
            BareBonesBrowserLaunch.openURL(this.getConfig().getHomeUrl());
        } else if ("forums".equals(cmd)) {
            BareBonesBrowserLaunch.openURL(this.getConfig().getForumUrl());
        } else if (show_log_file.equals(cmd)) {
            File path = new File(this.getConfig().getUserSettingsDirectory());
            try {
                String url = path.toURI().toURL().toString();
                url = url.replaceAll("^file:/", "file:///");
                BareBonesBrowserLaunch.openURL(url);
            }
            catch (MalformedURLException ex) {
                log.error((Object)("Error while transforming URL for: " + path.getAbsolutePath()), (Throwable)ex);
            }
        }
    }

    private void showLogoutMessage() {
        JOptionPane.showMessageDialog(this, "You have been logged out of the importer.\nChoose 'login' from the file menu to continue.", "Warning", 2);
    }

    public static String getPrintableKeyword(String keyword) {
        int begin = keyword.indexOf(" ") + 1;
        int end = keyword.lastIndexOf(" ");
        return keyword.substring(begin, end);
    }

    public void waitCursor(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    public void setImportEnabled(boolean toggle) {
        if (toggle) {
            this.login.setText("Logout of the server...");
        } else {
            this.login.setText("Login to the server...");
        }
    }

    public void onlyAllowExit() {
        this.fileMenu.setEnabled(true);
        this.helpMenu.setEnabled(true);
    }

    public void enableMenus(boolean toggle) {
        this.fileMenu.setEnabled(toggle);
        this.helpMenu.setEnabled(toggle);
    }

    private void logout() {
        this.setImportEnabled(false);
        this.setLoggedIn(false);
        this.tPane.setEnabledAt(1, false);
        this.appendToOutputLn("> Logged out.");
        this.getStatusBar().setStatusIcon("gfx/server_disconn16.png", "Logged out.");
        this.getFileQueueHandler().enableImports(false);
        try {
            ScreenLogin.registerGroup(this.getLoginHandler().getMetadataStore().mapUserGroups());
        }
        catch (Exception e) {
            log.warn((Object)"Exception on ScreenLogin.registerGroup()", (Throwable)e);
        }
    }

    public static Point getSplashLocation() {
        return null;
    }

    public void update(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.LOGGED_OUT) {
            this.logout();
            this.showLogoutMessage();
        }
        if (event instanceof ImportEvent.LOADING_IMAGE) {
            ImportEvent.LOADING_IMAGE ev = (ImportEvent.LOADING_IMAGE)event;
            this.getStatusBar().setProgress(true, -1, "Loading file " + ev.numDone + " of " + ev.total);
            this.appendToOutput("> [" + ev.index + "] Loading image \"" + ev.shortName + "\"...\n");
            this.getStatusBar().setStatusIcon("gfx/import_icon_16.png", "Prepping file \"" + ev.shortName);
        } else if (event instanceof ImportEvent.LOADED_IMAGE) {
            ImportEvent.LOADED_IMAGE ev = (ImportEvent.LOADED_IMAGE)event;
            this.getStatusBar().setProgress(true, -1, "Analyzing file " + ev.numDone + " of " + ev.total);
            this.appendToOutput(" Succesfully loaded.\n");
            this.appendToOutput("> [" + ev.index + "] Importing metadata for " + "image \"" + ev.shortName + "\"... ");
            this.getStatusBar().setStatusIcon("gfx/import_icon_16.png", "Analyzing the metadata for file \"" + ev.shortName);
        } else if (event instanceof ImportEvent.DATASET_STORED) {
            ImportEvent.DATASET_STORED ev = (ImportEvent.DATASET_STORED)event;
            int num = ev.numDone;
            int tot = ev.total;
            int pro = num - 1;
            this.appendToOutputLn("Successfully stored to " + ev.target.getClass().getSimpleName() + " \"" + ev.filename + "\" with id \"" + ev.target.getId().getValue() + "\".");
            this.appendToOutputLn("> [" + ev.series + "] Importing pixel data for " + "image \"" + ev.filename + "\"... ");
            this.getStatusBar().setProgress(true, 0, "Importing file " + num + " of " + tot);
            this.getStatusBar().setProgressValue(pro);
            this.getStatusBar().setStatusIcon("gfx/import_icon_16.png", "Importing the plane data for file \"" + ev.filename);
            this.appendToOutput("> Importing plane: ");
        } else if (event instanceof ImportEvent.DATA_STORED) {
            ImportEvent.DATA_STORED ev = (ImportEvent.DATA_STORED)event;
            this.appendToOutputLn("> Successfully stored with pixels id \"" + ev.pixId + "\".");
            this.appendToOutputLn("> [" + ev.filename + "] Image imported successfully!");
        } else if (event instanceof ErrorHandler.FILE_EXCEPTION) {
            ErrorHandler.FILE_EXCEPTION ev = (ErrorHandler.FILE_EXCEPTION)event;
            if (IOException.class.isAssignableFrom(ev.exception.getClass())) {
                final JOptionPane optionPane = new JOptionPane("The importer cannot retrieve one of your images in a timely manner.\nThe file in question is:\n'" + ev.filename + "'\n\n" + "There are a number of reasons you may see this error:\n" + " - The file has been deleted.\n" + " - There was a networking error retrieving a remotely saved file.\n" + " - An archived file has not been fully retrieved from backup.\n\n" + "The importer should now continue with the remainer of your imports.\n", 0);
                final JDialog dialog = new JDialog((Frame)this, "IO Error");
                dialog.setAlwaysOnTop(true);
                dialog.setContentPane(optionPane);
                dialog.pack();
                dialog.setVisible(true);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                            dialog.dispose();
                        }
                    }
                });
            }
        } else if (event instanceof ErrorHandler.EXCEPTION_EVENT) {
            ErrorHandler.EXCEPTION_EVENT ev = (ErrorHandler.EXCEPTION_EVENT)event;
            log.error((Object)"EXCEPTION_EVENT", (Throwable)ev.exception);
        } else if (event instanceof ErrorHandler.INTERNAL_EXCEPTION) {
            ErrorHandler.INTERNAL_EXCEPTION e = (ErrorHandler.INTERNAL_EXCEPTION)event;
            log.error((Object)"INTERNAL_EXCEPTION", (Throwable)e.exception);
        } else if (event instanceof ImportEvent.ERRORS_PENDING) {
            this.tPane.setIconAt(4, GuiCommonElements.getImageIcon(ERROR_ICON_ANIM));
            this.errors_pending = true;
            this.error_notification = true;
        } else if (event instanceof ImportEvent.ERRORS_COMPLETE) {
            this.tPane.setIconAt(4, GuiCommonElements.getImageIcon(ERROR_ICON));
            this.error_notification = false;
        } else if (event instanceof ImportEvent.ERRORS_COMPLETE) {
            this.tPane.setIconAt(4, GuiCommonElements.getImageIcon(ERROR_ICON));
            this.error_notification = false;
        } else if (event instanceof ImportEvent.ERRORS_FAILED) {
            this.sendingErrorsFailed(this);
        } else if (event instanceof ImportEvent.IMPORT_QUEUE_DONE && this.errors_pending) {
            this.errors_pending = false;
            this.importErrorsCollected(this);
        }
    }

    private void importErrorsCollected(Component frame) {
        final JOptionPane optionPane = new JOptionPane("\nYour import has produced one or more errors, \nvisit the 'Import Errors' tab for details.", 2);
        final JDialog errorDialog = new JDialog(this, "Errors Collected", false);
        errorDialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (errorDialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    errorDialog.dispose();
                }
            }
        });
        errorDialog.toFront();
        errorDialog.pack();
        errorDialog.setLocationRelativeTo(frame);
        errorDialog.setVisible(true);
    }

    public void candidateErrorsCollected(Component frame) {
        this.errors_pending = false;
        final JOptionPane optionPane = new JOptionPane("\nAdding these files to the queue has produced one or more errors and some\n files will not be displayed on the queue. View the 'Import Errors' tab for details.", 2);
        final JDialog errorDialog = new JDialog(this, "Errors Collected", true);
        errorDialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (errorDialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    errorDialog.dispose();
                }
            }
        });
        errorDialog.toFront();
        errorDialog.pack();
        errorDialog.setLocationRelativeTo(frame);
        errorDialog.setVisible(true);
    }

    public void sendingErrorsFailed(Component frame) {
        final JOptionPane optionPane = new JOptionPane("\nDue to an error we were not able to send your error messages.\nto our feedback server. Please try again.", 2);
        final JDialog failedDialog = new JDialog(this, "Feedback Failed!", true);
        failedDialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (failedDialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    failedDialog.dispose();
                }
            }
        });
        failedDialog.toFront();
        failedDialog.pack();
        failedDialog.setLocationRelativeTo(frame);
        failedDialog.setVisible(true);
    }

    private static void LoggingDisabledNotification() {
        JOptionPane.showMessageDialog(null, "The importer was unable to access its local log file\nwhich is normally located in your home directory under\n the sub-directory omero/logs.\n\nThe importer will continue to operate normally, but will\nbe unable to record any information to this file.\n", "Warning", 0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("login".equals(name)) {
            LoginCredentials lc = (LoginCredentials)evt.getNewValue();
            if (lc != null) {
                this.login(lc);
            }
        } else if ("quit".equals(name) || name.equals("quitpplication")) {
            if (GuiCommonElements.quitConfirmed(this, null)) {
                System.exit(0);
            }
        } else if (!"toFront".equals(name) && !"moveFront".equals(name) && name.equals("aboutApplication")) {
            this.setDefaultCloseOperation(0);
            About.show(this, this.getConfig(), false);
        }
    }

    public void login(LoginCredentials lc) {
    }

    public void windowClosing(WindowEvent e) {
        String message = null;
        if (this.error_notification) {
            message = "Do you really want to quit?\nDoing so will cancel any running imports.\n\nNOTE: You still have unsent error messages!";
        }
        if (GuiCommonElements.quitConfirmed(this, null)) {
            try {
                ScreenLogin.registerGroup(this.getLoginHandler().getMetadataStore().mapUserGroups());
            }
            catch (Exception ex) {
                log.warn((Object)"Exception on ScreenLogin.registerGroup()", (Throwable)ex);
            }
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent arg0) {
    }

    public void windowGainedFocus(WindowEvent arg0) {
    }

    public void windowLostFocus(WindowEvent arg0) {
    }

    public void setHistoryTable(HistoryTable historyTable) {
        this.historyTable = historyTable;
    }

    public HistoryTable getHistoryTable() {
        return this.historyTable;
    }

    public void setLoginHandler(LoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public LoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public void setLoggedIn(Boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public Boolean getLoggedIn() {
        return this.loggedIn;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setConfig(ImportConfig config) {
        this.config = config;
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    public void setFileQueueHandler(FileQueueHandler fileQueueHandler) {
        this.fileQueueHandler = fileQueueHandler;
    }

    public FileQueueHandler getFileQueueHandler() {
        return this.fileQueueHandler;
    }

    public static void main(String[] args) {
        try {
            LogAppenderProxy.configure(new File(IniFileLoader.LOGFILE));
        }
        catch (Exception e) {
            GuiImporter.LoggingDisabledNotification();
        }
        ImportConfig config = new ImportConfig(args.length > 0 ? new File(args[0]) : null);
        config.configureDebug(null);
        config.loadAll();
        config.loadGui();
        USE_QUAQUA = config.getUseQuaqua();
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel") && USE_QUAQUA) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        }
        new GuiImporter(config);
    }
}

