/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.IHistoryTableDataSource;

public abstract class HistoryTableAbstractDataSource
implements IObservable,
IHistoryTableDataSource {
    ArrayList<IObserver> observers = new ArrayList();
    private static Calendar CALENDAR = Calendar.getInstance();

    public Date getYesterday() {
        return this.getDayBefore(new Date());
    }

    public Date getDayBefore(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getStartOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getEndOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 23);
            calendar.set(14, 999);
            calendar.set(13, 59);
            calendar.set(12, 59);
            return calendar.getTime();
        }
    }

    public Date getDayAfter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public Date getDaysBefore(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public String stripIllegalSearchCharacters(String queryString) {
        String good = " .-_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < queryString.length(); ++i) {
            if (good.indexOf(queryString.charAt(i)) < 0) continue;
            buf.append(queryString.charAt(i));
        }
        return buf.toString();
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }
}

