/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JOptionPane;
import loci.formats.FormatException;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.gui.FileQueueTable;
import ome.formats.importer.gui.GuiImporter;
import ome.formats.importer.gui.HistoryTableStore;
import ome.formats.importer.util.ErrorHandler;
import omero.ResourceError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportHandler
implements IObservable {
    private static Log log = LogFactory.getLog(ImportHandler.class);
    private static boolean runState = false;
    private final ImportLibrary library;
    private final ImportContainer[] importContainer;
    private final HistoryTableStore db;
    private final GuiImporter viewer;
    private final FileQueueTable qTable;
    private int numOfPendings = 0;
    private int numOfDone = 0;
    final ArrayList<IObserver> observers = new ArrayList();
    private ImportConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportHandler(final ScheduledExecutorService ex, GuiImporter viewer, FileQueueTable qTable, ImportConfig config, ImportLibrary library, ImportContainer[] containers) {
        this.config = config;
        this.library = library;
        this.importContainer = containers;
        this.db = viewer.getHistoryTable() != null ? viewer.getHistoryTable().db : null;
        if (runState) {
            log.error((Object)"ImportHandler running twice");
            throw new RuntimeException("ImportHandler running twice");
        }
        runState = true;
        try {
            this.viewer = viewer;
            this.qTable = qTable;
            library.addObserver(qTable);
            library.addObserver(viewer);
            library.addObserver(viewer.getErrorHandler());
            library.addObserver(new IObserver(){

                public void update(IObservable importLibrary, ImportEvent event) {
                    if (ex.isShutdown()) {
                        log.info((Object)"Cancelling import");
                        throw new RuntimeException("CLIENT SHUTDOWN");
                    }
                }
            });
            Runnable run = new Runnable(){

                public void run() {
                    log.info((Object)"Background: Importing images");
                    ImportHandler.this.importImages();
                }
            };
            ex.execute(run);
        }
        finally {
            runState = false;
        }
    }

    private void importImages() {
        Date date = null;
        this.notifyObservers(new ImportEvent.IMPORT_QUEUE_STARTED());
        long timestampIn = System.currentTimeMillis();
        date = new Date(timestampIn);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String myDate = formatter.format(date);
        this.viewer.appendToOutputLn("> Starting import at: " + myDate + "\n");
        this.viewer.getStatusBar().setStatusIcon("gfx/import_icon_16.png", "Now importing.");
        this.numOfPendings = 0;
        int importKey = 0;
        int importStatus = 0;
        importKey = this.addHistoryPendingImport();
        for (int i = 0; i < this.importContainer.length; ++i) {
            if (!this.qTable.setProgressPending(i)) continue;
            ++this.numOfPendings;
            try {
                if (this.db == null || !this.db.historyEnabled) continue;
                this.db.addItemTableRow((Long)this.library.getExperimenterID(), importKey, (Integer)i, this.importContainer[i].getFile().getAbsolutePath(), this.importContainer[i].getProjectID(), (Long)this.importContainer[i].getTarget().getId().getValue(), "pending", this.importContainer[i].getFile());
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Generic error while inserting history.", (Throwable)e);
                this.viewer.appendToDebug(e.toString());
            }
        }
        if (this.db != null) {
            this.db.notifyObservers(new ImportEvent.QUICKBAR_UPDATE());
        }
        this.viewer.getStatusBar().setProgressMaximum(this.numOfPendings);
        this.numOfDone = 0;
        for (int j = 0; j < this.importContainer.length; ++j) {
            ImportContainer container = this.importContainer[j];
            ImportHandler importHandler = this;
            if (!importHandler.qTable.getTable().getValueAt(j, 2).equals("pending") || this.qTable.cancel) continue;
            ++this.numOfDone;
            String filename = container.getFile().getAbsolutePath();
            this.viewer.appendToOutputLn("> [" + j + "] Importing \"" + filename + "\"");
            try {
                this.library.importImage(this.importContainer[j].getFile(), j, this.numOfDone, this.numOfPendings, this.importContainer[j].getCustomImageName(), null, container.getArchive(), (Boolean)this.config.companionFile.get(), container.getUserPixels(), container.getTarget());
                this.library.clear();
                this.updateHistoryWithDoneImport(importKey, j);
                continue;
            }
            catch (FormatException fe) {
                log.error((Object)"Format exception while importing image.", (Throwable)fe);
                this.qTable.setProgressFailed(j);
                this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                importStatus = importStatus < 0 ? -3 : -1;
                if (fe.getMessage() == "Cannot locate JPEG decoder") {
                    this.viewer.appendToOutputLn("> [" + j + "] Lossless JPEG not supported.");
                    JOptionPane.showMessageDialog(this.viewer, "\nThe importer cannot import the lossless JPEG images used by the file\n" + this.importContainer[j].getFile().getAbsolutePath() + "");
                }
                this.updateHistoryWithFailedImport(importKey, j);
                continue;
            }
            catch (IOException ioe) {
                log.error((Object)"I/O error while importing image.", (Throwable)ioe);
                this.qTable.setProgressUnknown(j);
                this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                importStatus = importStatus < 0 ? -3 : -1;
                this.updateHistoryWithFailedImport(importKey, j);
                continue;
            }
            catch (ResourceError e) {
                log.error((Object)"Resource error while importing image.", (Throwable)e);
                JOptionPane.showMessageDialog(this.viewer, "The server is out of space and imports cannot continue.\n");
                this.qTable.setProgressFailed(j);
                importStatus = importStatus < 0 ? -3 : -2;
                this.qTable.cancel = true;
                this.qTable.abort = true;
                this.qTable.importing = false;
                this.updateHistoryWithFailedImport(importKey, j);
                continue;
            }
            catch (Throwable error) {
                log.error((Object)"Generic error while importing image.", error);
                this.viewer.appendToDebug(ErrorHandler.getStackTrace(error));
                this.qTable.setProgressFailed(j);
                this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                importStatus = importStatus < 0 ? -3 : -2;
                this.updateHistoryWithFailedImport(importKey, j);
            }
        }
        this.viewer.getStatusBar().setProgress(false, 0, "");
        this.viewer.getStatusBar().setStatusIcon("gfx/import_done_16.png", "Import complete.");
        if (importStatus >= 0) {
            this.updateHistoryWithCompleteImport(importKey);
        }
        long timestampOut = System.currentTimeMillis();
        long timestampDiff = timestampOut - timestampIn;
        long timeInSeconds = timestampDiff / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        this.viewer.appendToOutputLn("> Total import time: " + hours + " hour(s), " + minutes + " minute(s), " + seconds + " second(s).");
        this.viewer.appendToOutputLn("> Image import completed!");
        this.notifyObservers(new ImportEvent.IMPORT_QUEUE_DONE());
    }

    private int addHistoryPendingImport() {
        int importKey = 0;
        try {
            if (this.db != null && this.db.historyEnabled) {
                this.db.addBaseTableRow(this.library.getExperimenterID(), "pending");
                importKey = this.db.getLastBaseUid();
                log.debug((Object)("New importKey for history db is: " + importKey));
            }
        }
        catch (Exception e) {
            log.error((Object)("addBaseTableRow exception: experimenterID '" + this.library.getExperimenterID() + "', 'pending'"), (Throwable)e);
        }
        return importKey;
    }

    private void updateHistoryWithFailedImport(int importKey, int index) {
        try {
            if (this.db != null && this.db.historyEnabled) {
                this.db.updateBaseStatus(importKey, "incomplete");
                this.viewer.getHistoryTable().updateOutlookBar();
            }
        }
        catch (Exception e) {
            log.error((Object)("updateBaseStatus exception: importKey '" + importKey + "', 'incomplete'"), (Throwable)e);
        }
        try {
            if (this.db != null && this.db.historyEnabled) {
                this.db.updateItemStatus(importKey, index, "failed");
            }
        }
        catch (Exception e) {
            log.error((Object)("updateItemStatus exception: importKey '" + importKey + "', index '" + index + "', 'failed'"), (Throwable)e);
        }
    }

    private void updateHistoryWithCompleteImport(int importKey) {
        try {
            if (this.db != null && this.db.historyEnabled) {
                this.db.updateBaseStatus(importKey, "complete");
                this.viewer.getHistoryTable().updateOutlookBar();
            }
        }
        catch (Exception e) {
            log.error((Object)("updateBaseStatus exception: importKey '" + importKey + "', 'complete'"), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void updateHistoryWithDoneImport(int importKey, int index) {
        try {
            if (this.db != null && this.db.historyEnabled) {
                this.db.updateItemStatus(importKey, index, "done");
            }
        }
        catch (Exception e) {
            log.error((Object)("updateItemStatus exception: importKey '" + importKey + "', index '" + index + "', 'done'"), (Throwable)e);
            e.printStackTrace();
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }
}

