/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.ErrorFilePart;
import ome.formats.importer.util.ErrorContainer;
import ome.formats.importer.util.FileUploadCounter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUploader
implements IObservable {
    private static Log log = LogFactory.getLog(FileUploader.class);
    private String[] files;
    private String session_id;
    private PostMethod method = null;
    ArrayList<IObserver> observers = new ArrayList();
    private HttpClient client;
    private boolean cancelUpload;

    public FileUploader(HttpClient httpClient) {
        this.client = httpClient;
    }

    public void setSessionId(String sessionId) {
        if (sessionId != null) {
            this.session_id = sessionId;
        } else {
            this.session_id = UUID.randomUUID().toString().replace("-", "");
            log.warn((Object)("FileUploadContainer has not set session_id, autogenerating session id of: " + this.session_id));
        }
    }

    public String getSessionId() {
        return this.session_id;
    }

    public void uploadFiles(String url, int timeout, ErrorContainer upload) {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        this.files = upload.getFiles();
        this.setSessionId(upload.getToken());
        int fileCount = 0;
        for (String f : this.files) {
            if (this.cancelUpload) {
                System.err.println(this.cancelUpload);
                continue;
            }
            final int count = ++fileCount;
            final File file = new File(f);
            try {
                HttpClientParams params = new HttpClientParams();
                params.setConnectionManagerTimeout((long)timeout);
                this.client.setParams(params);
                this.method = new PostMethod(url);
                String format = "";
                format = upload.getFileFormat() != null ? upload.getFileFormat() : "unknown";
                final ErrorFilePart errorFilePart = new ErrorFilePart("Filedata", file);
                Part[] parts = new Part[]{new StringPart("token", upload.getToken()), new StringPart("file_format", format), errorFilePart};
                final long fileLength = file.length();
                MultipartRequestEntity mpre = new MultipartRequestEntity(parts, this.method.getParams());
                FileUploadCounter.ProgressListener listener = new FileUploadCounter.ProgressListener(){
                    private long partsTotal = -1L;

                    public void update(long bytesRead) {
                        if (FileUploader.this.cancelUpload) {
                            errorFilePart.cancel = true;
                        }
                        long partsDone = 0L;
                        if (fileLength != 0L) {
                            partsDone = bytesRead / (fileLength / 10L);
                        }
                        if (this.partsTotal == partsDone) {
                            return;
                        }
                        this.partsTotal = partsDone;
                        FileUploader.this.notifyObservers(new ImportEvent.FILE_UPLOAD_STARTED(file.getName(), count, FileUploader.this.files.length, null, null, null));
                        long uploadedBytes = bytesRead / 2L;
                        if (fileLength == -1L) {
                            FileUploader.this.notifyObservers(new ImportEvent.FILE_UPLOAD_BYTES(file.getName(), count, FileUploader.this.files.length, uploadedBytes, null, null));
                        } else {
                            FileUploader.this.notifyObservers(new ImportEvent.FILE_UPLOAD_BYTES(file.getName(), count, FileUploader.this.files.length, uploadedBytes, fileLength, null));
                        }
                    }
                };
                FileUploadCounter hfre = new FileUploadCounter((RequestEntity)mpre, listener);
                this.method.setRequestEntity((RequestEntity)hfre);
                int status = this.client.executeMethod((HttpMethod)this.method);
                if (status == 200) {
                    this.notifyObservers(new ImportEvent.FILE_UPLOAD_COMPLETE(file.getName(), count, this.files.length, null, null, null));
                    log.info((Object)("Uploaded file '" + file.getName() + "' to QA system"));
                    upload.setStatus(1);
                    continue;
                }
                this.notifyObservers(new ImportEvent.FILE_UPLOAD_COMPLETE(file.getName(), count, this.files.length, null, null, null));
            }
            catch (Exception ex) {
                this.notifyObservers(new ImportEvent.FILE_UPLOAD_ERROR(file.getName(), count, this.files.length, null, null, ex));
            }
        }
        this.notifyObservers(new ImportEvent.FILE_UPLOAD_FINISHED(null, 0, 0, null, null, null));
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    public void cancel() {
        this.cancelUpload = true;
    }

    public static void main(String[] args) {
        String url = "http://mage.openmicroscopy.org.uk/qa/processing/";
        String dvPath = "/Users/TheBrain/test_images_shortrun/dv/";
        String[] files = new String[]{dvPath + "CFPNEAT01_R3D.dv", dvPath + "IAGFP-Noc01_R3D.dv"};
        FileUploader uploader = new FileUploader(new HttpClient());
        ErrorContainer upload = new ErrorContainer();
        upload.setFiles(files);
        uploader.uploadFiles(url, 5000, upload);
    }
}

