/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Map;
import Freeze.NoSuchElementException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

class SubMap
extends AbstractMap
implements SortedMap {
    private final Object _fromKey;
    private final Object _toKey;
    private final Map _map;
    private final Map.Index _index;
    private Set _entrySet;

    SubMap(Map map, Object fromKey, Object toKey) {
        this._fromKey = fromKey;
        this._toKey = toKey;
        this._map = map;
        this._index = null;
        if (fromKey != null && toKey != null && map.comparator().compare(fromKey, toKey) >= 0) {
            throw new IllegalArgumentException();
        }
    }

    SubMap(Map.Index index, Object fromKey, Object toKey) {
        this._fromKey = fromKey;
        this._toKey = toKey;
        this._map = index.parent();
        this._index = index;
        if (fromKey != null && toKey != null && index.comparator().compare(fromKey, toKey) >= 0) {
            throw new IllegalArgumentException();
        }
    }

    private SubMap(SubMap subMap, Object fromKey, Object toKey) {
        this._fromKey = fromKey;
        this._toKey = toKey;
        this._map = subMap._map;
        this._index = subMap._index;
        if (fromKey != null && toKey != null && this.comparator().compare(fromKey, toKey) >= 0) {
            throw new IllegalArgumentException();
        }
    }

    public Comparator comparator() {
        if (this._index != null) {
            return this._index.comparator();
        }
        return this._map.comparator();
    }

    public Object firstKey() {
        return this._index != null ? this._index.firstKey(this._fromKey, this._toKey) : this._map.firstKey(this._fromKey, this._toKey);
    }

    public Object lastKey() {
        return this._index != null ? this._index.lastKey(this._fromKey, this._toKey) : this._map.lastKey(this._fromKey, this._toKey);
    }

    public SortedMap headMap(Object toKey) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, this._fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, this._toKey);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, toKey);
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet(){

                public Iterator iterator() {
                    if (SubMap.this._index == null) {
                        return SubMap.this._map.createIterator(SubMap.this._index, SubMap.this._fromKey, SubMap.this._toKey);
                    }
                    return new IndexIterator();
                }

                public boolean contains(Object o) {
                    if (SubMap.this._index == null) {
                        if (SubMap.this._map.entrySet().contains(o)) {
                            Map.Entry entry = (Map.Entry)o;
                            return SubMap.this.inRange(entry.getKey());
                        }
                        return false;
                    }
                    if (o instanceof IndexEntry) {
                        IndexEntry indexEntry = (IndexEntry)o;
                        return indexEntry.parent() == SubMap.this && SubMap.this._index.containsKey(indexEntry.getKey());
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (SubMap.this._index == null) {
                        if (o instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)o;
                            return SubMap.this.inRange(entry.getKey()) && SubMap.this._map.entrySet().remove(o);
                        }
                        return false;
                    }
                    throw new UnsupportedOperationException();
                }

                public int size() {
                    throw new UnsupportedOperationException();
                }

                public boolean isEmpty() {
                    try {
                        SubMap.this.firstKey();
                        return false;
                    }
                    catch (NoSuchElementException e) {
                        return true;
                    }
                }
            };
        }
        return this._entrySet;
    }

    public boolean constainsKey(Object key) {
        if (!this.inRange(key)) {
            return false;
        }
        if (this._index == null) {
            return this._map.containsKey(key);
        }
        return this._index.containsKey(key);
    }

    public Object get(Object key) {
        if (!this.inRange(key)) {
            return null;
        }
        if (this._index == null) {
            return this._map.get(key);
        }
        if (this._index.containsKey(key)) {
            return new IndexValue(key);
        }
        return null;
    }

    public Object remove(Object key) {
        if (!this.inRange(key)) {
            return null;
        }
        if (this._index == null) {
            return this._map.remove(key);
        }
        throw new UnsupportedOperationException();
    }

    public boolean fastRemove(Object key) {
        if (!this.inRange(key)) {
            return false;
        }
        if (this._index == null) {
            return this._map.fastRemove(key);
        }
        throw new UnsupportedOperationException();
    }

    private boolean inRange(Object key) {
        if (this._fromKey != null && this.comparator().compare(this._fromKey, key) > 0) {
            return false;
        }
        return this._toKey == null || this.comparator().compare(key, this._toKey) < 0;
    }

    private class IndexIterator
    implements Map.EntryIterator {
        Map.EntryIterator _iterator;

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this._iterator.next();
            return new IndexEntry(SubMap.this._index.decodeKey(entry.getIndexBytes(), SubMap.this._map.connection().communicator()));
        }

        public void remove() {
            this._iterator.remove();
        }

        public void close() {
            this._iterator.close();
        }

        public void destroy() {
            this.close();
        }

        private IndexIterator() {
            assert (SubMap.this._index != null);
            this._iterator = SubMap.this._map.createIterator(SubMap.this._index, SubMap.this._fromKey, SubMap.this._toKey);
        }
    }

    private class IndexEntry
    implements Map.Entry {
        private IndexValue _value;

        public Object getKey() {
            return this._value.getKey();
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o instanceof IndexEntry) {
                IndexEntry indexEntry = (IndexEntry)o;
                return indexEntry._value.equals(this._value);
            }
            return false;
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        SubMap parent() {
            return SubMap.this;
        }

        private IndexEntry(Object key) {
            this._value = new IndexValue(key);
        }
    }

    private class IndexValue
    extends AbstractSet {
        private Object _myKey;

        public Iterator iterator() {
            return SubMap.this._index.untypedFind(this._myKey, true);
        }

        public int size() {
            return SubMap.this._index.untypedCount(this._myKey);
        }

        public boolean equals(Object o) {
            if (o instanceof IndexValue) {
                IndexValue indexValue = (IndexValue)o;
                return indexValue._myKey.equals(this._myKey);
            }
            return false;
        }

        public int hashCode() {
            return this._myKey.hashCode();
        }

        private IndexValue(Object key) {
            this._myKey = key;
        }

        private Object getKey() {
            return this._myKey;
        }
    }
}

