/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Properties;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.StringHolder;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.FixedReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.PropertyNames;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReferenceFactory {
    private static String[] _suffixes = new String[]{"EndpointSelection", "ConnectionCached", "PreferSecure", "LocatorCacheTimeout", "Locator", "Router", "CollocationOptimized"};
    private final Instance _instance;
    private final Communicator _communicator;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;
    private WeakHashMap<Reference, WeakReference<Reference>> _references = new WeakHashMap();

    public Reference create(Identity ident, String facet, Reference tmpl, EndpointI[] endpoints) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return this.create(ident, facet, tmpl.getMode(), tmpl.getSecure(), endpoints, null, null);
    }

    public Reference create(Identity ident, String facet, Reference tmpl, String adapterId) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return this.create(ident, facet, tmpl.getMode(), tmpl.getSecure(), null, adapterId, null);
    }

    public Reference create(Identity ident, ConnectionI fixedConnection) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        FixedReference ref = new FixedReference(this._instance, this._communicator, ident, this._instance.getDefaultContext(), "", 0, false, fixedConnection);
        return this.updateCache(ref);
    }

    public Reference copy(Reference r) {
        Identity ident = r.getIdentity();
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return (Reference)r.clone();
    }

    public Reference create(String s, String propertyPrefix) {
        ProxyParseException e;
        if (s == null || s.length() == 0) {
            return null;
        }
        String delim = " \t\n\r";
        int end = 0;
        int beg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
        if (beg == -1) {
            ProxyParseException e2 = new ProxyParseException();
            e2.str = s;
            throw e2;
        }
        String idstr = null;
        end = StringUtil.checkQuote(s, beg);
        if (end == -1) {
            ProxyParseException e3 = new ProxyParseException();
            e3.str = s;
            throw e3;
        }
        if (end == 0) {
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            idstr = s.substring(beg, end);
        } else {
            idstr = s.substring(++beg, end);
            ++end;
        }
        if (beg == end) {
            ProxyParseException e4 = new ProxyParseException();
            e4.str = s;
            throw e4;
        }
        Identity ident = this._instance.stringToIdentity(idstr);
        if (ident.name.length() == 0) {
            if (ident.category.length() > 0) {
                IllegalIdentityException e5 = new IllegalIdentityException();
                e5.id = ident;
                throw e5;
            }
            if (StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e6 = new ProxyParseException();
                e6.str = s;
                throw e6;
            }
            return null;
        }
        String facet = "";
        int mode = 0;
        boolean secure = false;
        String adapter = "";
        block9: while ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", end)) != -1 && s.charAt(beg) != ':' && s.charAt(beg) != '@') {
            char ch;
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            if (beg == end) break;
            String option = s.substring(beg, end);
            if (option.length() != 2 || option.charAt(0) != '-') {
                e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            String argument = null;
            int argumentBeg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
            if (argumentBeg != -1 && (ch = s.charAt(argumentBeg)) != '@' && ch != ':' && ch != '-') {
                beg = argumentBeg;
                end = StringUtil.checkQuote(s, beg);
                if (end == -1) {
                    ProxyParseException e7 = new ProxyParseException();
                    e7.str = s;
                    throw e7;
                }
                if (end == 0) {
                    end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
                    if (end == -1) {
                        end = s.length();
                    }
                    argument = s.substring(beg, end);
                } else {
                    argument = s.substring(++beg, end);
                    ++end;
                }
            }
            switch (option.charAt(1)) {
                case 'f': {
                    if (argument == null) {
                        ProxyParseException e8 = new ProxyParseException();
                        e8.str = s;
                        throw e8;
                    }
                    StringHolder facetH = new StringHolder();
                    if (!StringUtil.unescapeString(argument, 0, argument.length(), facetH)) {
                        ProxyParseException e9 = new ProxyParseException();
                        e9.str = s;
                        throw e9;
                    }
                    facet = facetH.value;
                    continue block9;
                }
                case 't': {
                    if (argument != null) {
                        ProxyParseException e10 = new ProxyParseException();
                        e10.str = s;
                        throw e10;
                    }
                    mode = 0;
                    continue block9;
                }
                case 'o': {
                    if (argument != null) {
                        ProxyParseException e11 = new ProxyParseException();
                        e11.str = s;
                        throw e11;
                    }
                    mode = 1;
                    continue block9;
                }
                case 'O': {
                    if (argument != null) {
                        ProxyParseException e12 = new ProxyParseException();
                        e12.str = s;
                        throw e12;
                    }
                    mode = 2;
                    continue block9;
                }
                case 'd': {
                    if (argument != null) {
                        ProxyParseException e13 = new ProxyParseException();
                        e13.str = s;
                        throw e13;
                    }
                    mode = 3;
                    continue block9;
                }
                case 'D': {
                    if (argument != null) {
                        ProxyParseException e14 = new ProxyParseException();
                        e14.str = s;
                        throw e14;
                    }
                    mode = 4;
                    continue block9;
                }
                case 's': {
                    if (argument != null) {
                        ProxyParseException e15 = new ProxyParseException();
                        e15.str = s;
                        throw e15;
                    }
                    secure = true;
                    continue block9;
                }
            }
            ProxyParseException e16 = new ProxyParseException();
            e16.str = s;
            throw e16;
        }
        if (beg == -1) {
            return this.create(ident, facet, mode, secure, null, null, propertyPrefix);
        }
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        if (s.charAt(beg) == ':') {
            ArrayList<String> unknownEndpoints = new ArrayList<String>();
            end = beg;
            while (end < s.length() && s.charAt(end) == ':') {
                end = beg = end + 1;
                while (true) {
                    if ((end = s.indexOf(58, end)) == -1) {
                        end = s.length();
                        break;
                    }
                    boolean quoted = false;
                    int quote = beg;
                    while ((quote = s.indexOf(34, quote)) != -1 && end >= quote) {
                        ++quote;
                        if ((quote = s.indexOf(34, quote)) == -1) break;
                        if (end < quote) {
                            quoted = true;
                            break;
                        }
                        ++quote;
                    }
                    if (!quoted) break;
                    ++end;
                }
                String es = s.substring(beg, end);
                EndpointI endp = this._instance.endpointFactoryManager().create(es, false);
                if (endp != null) {
                    endpoints.add(endp);
                    continue;
                }
                unknownEndpoints.add(es);
            }
            if (endpoints.size() == 0) {
                EndpointParseException e17 = new EndpointParseException();
                e17.str = (String)unknownEndpoints.get(0);
                throw e17;
            }
            if (unknownEndpoints.size() != 0 && this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Endpoints", 1) > 0) {
                String msg = "Proxy contains unknown endpoints:";
                Iterator iter = unknownEndpoints.iterator();
                while (iter.hasNext()) {
                    msg = msg + " `" + (String)iter.next() + "'";
                }
                this._instance.initializationData().logger.warning(msg);
            }
            EndpointI[] endp = new EndpointI[endpoints.size()];
            endpoints.toArray(endp);
            return this.create(ident, facet, mode, secure, endp, null, propertyPrefix);
        }
        if (s.charAt(beg) == '@') {
            if ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", beg + 1)) == -1) {
                e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            String adapterstr = null;
            end = StringUtil.checkQuote(s, beg);
            if (end == -1) {
                ProxyParseException e18 = new ProxyParseException();
                e18.str = s;
                throw e18;
            }
            if (end == 0) {
                end = StringUtil.findFirstOf(s, " \t\n\r", beg);
                if (end == -1) {
                    end = s.length();
                }
                adapterstr = s.substring(beg, end);
            } else {
                adapterstr = s.substring(++beg, end);
                ++end;
            }
            if (end != s.length() && StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e19 = new ProxyParseException();
                e19.str = s;
                throw e19;
            }
            StringHolder token = new StringHolder();
            if (!StringUtil.unescapeString(adapterstr, 0, adapterstr.length(), token) || token.value.length() == 0) {
                ProxyParseException e20 = new ProxyParseException();
                e20.str = s;
                throw e20;
            }
            adapter = token.value;
            return this.create(ident, facet, mode, secure, null, adapter, propertyPrefix);
        }
        ProxyParseException ex = new ProxyParseException();
        ex.str = s;
        throw ex;
    }

    public Reference create(Identity ident, BasicStream s) {
        String facet;
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        String[] facetPath = s.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new ProxyUnmarshalException();
            }
            facet = facetPath[0];
        } else {
            facet = "";
        }
        byte mode = s.readByte();
        if (mode < 0 || mode > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean secure = s.readBool();
        EndpointI[] endpoints = null;
        String adapterId = null;
        int sz = s.readSize();
        if (sz > 0) {
            endpoints = new EndpointI[sz];
            for (int i = 0; i < sz; ++i) {
                endpoints[i] = this._instance.endpointFactoryManager().read(s);
            }
        } else {
            adapterId = s.readString();
        }
        return this.create(ident, facet, mode, secure, endpoints, adapterId, null);
    }

    public ReferenceFactory setDefaultRouter(RouterPrx defaultRouter) {
        if (this._defaultRouter == null ? defaultRouter == null : this._defaultRouter.equals(defaultRouter)) {
            return this;
        }
        ReferenceFactory factory = new ReferenceFactory(this._instance, this._communicator);
        factory._defaultLocator = this._defaultLocator;
        factory._defaultRouter = defaultRouter;
        return factory;
    }

    public RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public ReferenceFactory setDefaultLocator(LocatorPrx defaultLocator) {
        if (this._defaultLocator == null ? defaultLocator == null : this._defaultLocator.equals(defaultLocator)) {
            return this;
        }
        ReferenceFactory factory = new ReferenceFactory(this._instance, this._communicator);
        factory._defaultRouter = this._defaultRouter;
        factory._defaultLocator = defaultLocator;
        return factory;
    }

    public LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    synchronized void destroy() {
        this._references.clear();
    }

    private synchronized Reference updateCache(Reference ref) {
        WeakReference<Reference> w = this._references.get(ref);
        if (w != null) {
            Reference r = (Reference)w.get();
            if (r != null) {
                ref = r;
            } else {
                this._references.put(ref, new WeakReference<Reference>(ref));
            }
        } else {
            this._references.put(ref, new WeakReference<Reference>(ref));
        }
        return ref;
    }

    private void checkForUnknownProperties(String prefix) {
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            if (prefix.startsWith(PropertyNames.clPropNames[i] + ".")) {
                return;
            }
            ++i;
        }
        ArrayList<String> unknownProps = new ArrayList<String>();
        Map<String, String> props = this._instance.initializationData().properties.getPropertiesForPrefix(prefix + ".");
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String prop = entry.getKey();
            boolean valid = false;
            for (int i2 = 0; i2 < _suffixes.length; ++i2) {
                if (!prop.equals(prefix + "." + _suffixes[i2])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unknownProps.add(prop);
        }
        if (unknownProps.size() != 0) {
            String message = "found unknown properties for proxy '" + prefix + "':";
            Iterator q = unknownProps.iterator();
            while (q.hasNext()) {
                message = message + "\n    " + (String)q.next();
            }
            this._instance.initializationData().logger.warning(message);
        }
    }

    private Reference create(Identity ident, String facet, int mode, boolean secure, EndpointI[] endpoints, String adapterId, String propertyPrefix) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this._defaultLocator);
        RouterInfo routerInfo = this._instance.routerManager().get(this._defaultRouter);
        boolean collocationOptimized = defaultsAndOverrides.defaultCollocationOptimization;
        boolean cacheConnection = true;
        boolean preferSecure = defaultsAndOverrides.defaultPreferSecure;
        EndpointSelectionType endpointSelection = defaultsAndOverrides.defaultEndpointSelection;
        int locatorCacheTimeout = defaultsAndOverrides.defaultLocatorCacheTimeout;
        if (propertyPrefix != null && propertyPrefix.length() > 0) {
            RouterPrx router;
            String property;
            LocatorPrx locator;
            Properties properties = this._instance.initializationData().properties;
            if (properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
                this.checkForUnknownProperties(propertyPrefix);
            }
            if ((locator = LocatorPrxHelper.uncheckedCast(this._communicator.propertyToProxy(property = propertyPrefix + ".Locator"))) != null) {
                locatorInfo = this._instance.locatorManager().get(locator);
            }
            if ((router = RouterPrxHelper.uncheckedCast(this._communicator.propertyToProxy(property = propertyPrefix + ".Router"))) != null) {
                if (propertyPrefix.endsWith(".Router")) {
                    String s = "`" + property + "=" + properties.getProperty(property) + "': cannot set a router on a router; setting ignored";
                    this._instance.initializationData().logger.warning(s);
                } else {
                    routerInfo = this._instance.routerManager().get(router);
                }
            }
            property = propertyPrefix + ".CollocationOptimized";
            collocationOptimized = properties.getPropertyAsIntWithDefault(property, collocationOptimized ? 1 : 0) > 0;
            property = propertyPrefix + ".ConnectionCached";
            cacheConnection = properties.getPropertyAsIntWithDefault(property, cacheConnection ? 1 : 0) > 0;
            property = propertyPrefix + ".PreferSecure";
            preferSecure = properties.getPropertyAsIntWithDefault(property, preferSecure ? 1 : 0) > 0;
            property = propertyPrefix + ".EndpointSelection";
            if (properties.getProperty(property).length() > 0) {
                String type = properties.getProperty(property);
                if (type.equals("Random")) {
                    endpointSelection = EndpointSelectionType.Random;
                } else if (type.equals("Ordered")) {
                    endpointSelection = EndpointSelectionType.Ordered;
                } else {
                    throw new EndpointSelectionTypeParseException(type);
                }
            }
            property = propertyPrefix + ".LocatorCacheTimeout";
            locatorCacheTimeout = properties.getPropertyAsIntWithDefault(property, locatorCacheTimeout);
        }
        return this.updateCache(new RoutableReference(this._instance, this._communicator, ident, this._instance.getDefaultContext(), facet, mode, secure, endpoints, adapterId, locatorInfo, routerInfo, collocationOptimized, cacheConnection, preferSecure, endpointSelection, locatorCacheTimeout));
    }
}

