/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.EndpointI_connectors;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpAcceptor;
import IceInternal.TcpConnector;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TcpEndpointI
extends EndpointI {
    static final short TYPE = 1;
    private Instance _instance;
    private String _host;
    private int _port;
    private int _timeout;
    private String _connectionId = "";
    private boolean _compress;
    private int _hashCode;

    public TcpEndpointI(Instance instance, String ho, int po, int ti, String conId, boolean co) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._timeout = ti;
        this._connectionId = conId;
        this._compress = co;
        this.calcHashValue();
    }

    public TcpEndpointI(Instance instance, String str, boolean oaEndpoint) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._timeout = -1;
        this._compress = false;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block10: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                throw new EndpointParseException("tcp " + str);
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-' && (argument = arr[i++]).charAt(0) == '\"' && argument.charAt(argument.length() - 1) == '\"') {
                argument = argument.substring(1, argument.length() - 1);
            }
            switch (option.charAt(1)) {
                case 'h': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    this._host = argument;
                    continue block10;
                }
                case 'p': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    try {
                        this._port = Integer.parseInt(argument);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    if (this._port >= 0 && this._port <= 65535) continue block10;
                    throw new EndpointParseException("tcp " + str);
                }
                case 't': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    try {
                        this._timeout = Integer.parseInt(argument);
                        continue block10;
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("tcp " + str);
                    }
                }
                case 'z': {
                    if (argument != null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    this._compress = true;
                    continue block10;
                }
            }
            throw new EndpointParseException("tcp " + str);
        }
        if (this._host == null) {
            this._host = this._instance.defaultsAndOverrides().defaultHost;
        } else if (this._host.equals("*")) {
            if (oaEndpoint) {
                this._host = null;
            } else {
                throw new EndpointParseException("tcp " + str);
            }
        }
        if (this._host == null) {
            this._host = "";
        }
        this.calcHashValue();
    }

    public TcpEndpointI(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._timeout = s.readInt();
        this._compress = s.readBool();
        s.endReadEncaps();
        this.calcHashValue();
    }

    @Override
    public void streamWrite(BasicStream s) {
        s.writeShort((short)1);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    @Override
    public String _toString() {
        String s = "tcp";
        if (this._host != null && this._host.length() > 0) {
            boolean addQuote;
            s = s + " -h ";
            boolean bl = addQuote = this._host.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._host;
            if (addQuote) {
                s = s + "\"";
            }
        }
        s = s + " -p " + this._port;
        if (this._timeout != -1) {
            s = s + " -t " + this._timeout;
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    @Override
    public short type() {
        return 1;
    }

    @Override
    public int timeout() {
        return this._timeout;
    }

    @Override
    public EndpointI timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, timeout, this._connectionId, this._compress);
    }

    @Override
    public EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._connectionId)) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._timeout, connectionId, this._compress);
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._timeout, this._connectionId, compress);
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public boolean secure() {
        return false;
    }

    @Override
    public boolean unknown() {
        return false;
    }

    @Override
    public Transceiver transceiver(EndpointIHolder endpoint) {
        endpoint.value = this;
        return null;
    }

    @Override
    public List<Connector> connectors() {
        return this.connectors(Network.getAddresses(this._host, this._port, this._instance.protocolSupport()));
    }

    @Override
    public void connectors_async(EndpointI_connectors callback) {
        this._instance.endpointHostResolver().resolve(this._host, this._port, this, callback);
    }

    @Override
    public Acceptor acceptor(EndpointIHolder endpoint, String adapterName) {
        TcpAcceptor p = new TcpAcceptor(this._instance, this._host, this._port);
        endpoint.value = new TcpEndpointI(this._instance, this._host, p.effectivePort(), this._timeout, this._connectionId, this._compress);
        return p;
    }

    @Override
    public List<EndpointI> expand() {
        ArrayList<EndpointI> endps = new ArrayList<EndpointI>();
        ArrayList<String> hosts = Network.getHostsForEndpointExpand(this._host, this._instance.protocolSupport());
        if (hosts == null || hosts.isEmpty()) {
            endps.add(this);
        } else {
            Iterator p = hosts.iterator();
            while (p.hasNext()) {
                endps.add(new TcpEndpointI(this._instance, (String)p.next(), this._port, this._timeout, this._connectionId, this._compress));
            }
        }
        return endps;
    }

    @Override
    public boolean equivalent(EndpointI endpoint) {
        TcpEndpointI tcpEndpointI = null;
        try {
            tcpEndpointI = (TcpEndpointI)endpoint;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return tcpEndpointI._host.equals(this._host) && tcpEndpointI._port == this._port;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return this.compareTo((EndpointI)obj) == 0;
        }
        catch (ClassCastException ee) {
            assert (false);
            return false;
        }
    }

    @Override
    public int compareTo(EndpointI obj) {
        TcpEndpointI p = null;
        try {
            p = (TcpEndpointI)obj;
        }
        catch (ClassCastException ex) {
            return this.type() < obj.type() ? -1 : 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        return this._host.compareTo(p._host);
    }

    @Override
    public List<Connector> connectors(List<InetSocketAddress> addresses) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        Iterator<InetSocketAddress> p = addresses.iterator();
        while (p.hasNext()) {
            connectors.add(new TcpConnector(this._instance, p.next(), this._timeout, this._connectionId));
        }
        return connectors;
    }

    private void calcHashValue() {
        this._hashCode = this._host.hashCode();
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + this._timeout;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }
}

