/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BadMagicException;
import Ice.CommunicatorDestroyedException;
import Ice.DatagramLimitException;
import Ice.IllegalMessageSizeException;
import Ice.MemoryLimitException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.Protocol;
import IceInternal.Selector;
import IceInternal.SocketStatus;
import IceInternal.ThreadPoolWorkItem;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class ThreadPool {
    private static final boolean TRACE_REGISTRATION = false;
    private static final boolean TRACE_INTERRUPT = false;
    private static final boolean TRACE_SHUTDOWN = false;
    private static final boolean TRACE_SELECT = false;
    private static final boolean TRACE_EXCEPTION = false;
    private static final boolean TRACE_THREAD = false;
    private static final boolean TRACE_STACK_TRACE = false;
    private Instance _instance;
    private boolean _destroyed;
    private final String _prefix;
    private final String _programNamePrefix;
    private final Selector _selector;
    private LinkedList<ThreadPoolWorkItem> _workItems = new LinkedList();
    private LinkedList<EventHandler> _finished = new LinkedList();
    private int _timeout;
    private final int _size;
    private final int _sizeMax;
    private final int _sizeWarn;
    private final boolean _serialize;
    private List<EventHandlerThread> _threads;
    private int _threadIndex;
    private int _running;
    private int _inUse;
    private double _load;
    private boolean _promote;
    private final boolean _warnUdp;

    public ThreadPool(Instance instance, String prefix, int timeout) {
        int sizeWarn;
        int sizeMax;
        this._instance = instance;
        this._destroyed = false;
        this._prefix = prefix;
        this._timeout = timeout;
        this._selector = new Selector(instance, timeout);
        this._threadIndex = 0;
        this._running = 0;
        this._inUse = 0;
        this._load = 1.0;
        this._promote = true;
        this._serialize = this._instance.initializationData().properties.getPropertyAsInt(this._prefix + ".Serialize") > 0;
        this._warnUdp = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        String programName = this._instance.initializationData().properties.getProperty("Ice.ProgramName");
        this._programNamePrefix = programName.length() > 0 ? programName + "-" : "";
        int size = this._instance.initializationData().properties.getPropertyAsIntWithDefault(this._prefix + ".Size", 1);
        if (size < 1) {
            String s = this._prefix + ".Size < 1; Size adjusted to 1";
            this._instance.initializationData().logger.warning(s);
            size = 1;
        }
        if ((sizeMax = this._instance.initializationData().properties.getPropertyAsIntWithDefault(this._prefix + ".SizeMax", size)) < size) {
            String s = this._prefix + ".SizeMax < " + this._prefix + ".Size; SizeMax adjusted to Size (" + size + ")";
            this._instance.initializationData().logger.warning(s);
            sizeMax = size;
        }
        if ((sizeWarn = this._instance.initializationData().properties.getPropertyAsIntWithDefault(this._prefix + ".SizeWarn", sizeMax * 80 / 100)) > sizeMax) {
            String s = this._prefix + ".SizeWarn > " + this._prefix + ".SizeMax; adjusted SizeWarn to SizeMax (" + sizeMax + ")";
            this._instance.initializationData().logger.warning(s);
            sizeWarn = sizeMax;
        }
        this._size = size;
        this._sizeMax = sizeMax;
        this._sizeWarn = sizeWarn;
        try {
            this._threads = new ArrayList<EventHandlerThread>();
            for (int i = 0; i < this._size; ++i) {
                EventHandlerThread thread = new EventHandlerThread(this._programNamePrefix + this._prefix + "-" + this._threadIndex++);
                this._threads.add(thread);
                thread.start();
                ++this._running;
            }
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String s = "cannot create thread for `" + this._prefix + "':\n" + sw.toString();
            this._instance.initializationData().logger.error(s);
            this.destroy();
            this.joinWithAllThreads();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._destroyed);
    }

    public synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._selector.setInterrupt();
    }

    public synchronized void _register(EventHandler handler) {
        assert (!this._destroyed);
        if (!handler._registered) {
            if (!handler._serializing) {
                this._selector.add(handler, SocketStatus.NeedRead);
            }
            handler._registered = true;
        }
    }

    public synchronized void unregister(EventHandler handler) {
        assert (!this._destroyed);
        if (handler._registered) {
            if (!handler._serializing) {
                this._selector.remove(handler);
            }
            handler._registered = false;
        }
    }

    public synchronized void finish(EventHandler handler) {
        assert (!this._destroyed);
        if (handler._registered) {
            if (!handler._serializing) {
                this._selector.remove(handler);
            }
            handler._registered = false;
        }
        this._finished.add(handler);
        this._selector.setInterrupt();
    }

    public synchronized void execute(ThreadPoolWorkItem workItem) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._workItems.add(workItem);
        this._selector.setInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promoteFollower(EventHandler handler) {
        if (this._sizeMax > 1) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this._serialize && handler != null) {
                    handler._serializing = true;
                    if (handler._registered) {
                        this._selector.remove(handler);
                    }
                }
                assert (!this._promote);
                this._promote = true;
                this.notify();
                if (!this._destroyed) {
                    assert (this._inUse >= 0);
                    ++this._inUse;
                    if (this._inUse == this._sizeWarn) {
                        String s = "thread pool `" + this._prefix + "' is running low on threads\n" + "Size=" + this._size + ", " + "SizeMax=" + this._sizeMax + ", " + "SizeWarn=" + this._sizeWarn;
                        this._instance.initializationData().logger.warning(s);
                    }
                    assert (this._inUse <= this._running);
                    if (this._inUse < this._sizeMax && this._inUse == this._running) {
                        try {
                            EventHandlerThread thread = new EventHandlerThread(this._programNamePrefix + this._prefix + "-" + this._threadIndex++);
                            this._threads.add(thread);
                            thread.start();
                            ++this._running;
                        }
                        catch (RuntimeException ex) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            ex.printStackTrace(pw);
                            pw.flush();
                            String s = "cannot create thread for `" + this._prefix + "':\n" + sw.toString();
                            this._instance.initializationData().logger.error(s);
                        }
                    }
                }
            }
        }
    }

    public void joinWithAllThreads() {
        block2: for (EventHandlerThread thread : this._threads) {
            while (true) {
                try {
                    thread.join();
                    continue block2;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        this._selector.destroy();
    }

    public String prefix() {
        return this._prefix;
    }

    /*
     * Exception decompiling
     */
    private boolean run(BasicStream stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean read(EventHandler handler) {
        int pos;
        BasicStream stream = handler._stream;
        if (stream.pos() >= 14) {
            if (!handler.read(stream)) {
                return false;
            }
            assert (stream.pos() == stream.size());
            return true;
        }
        if (stream.size() == 0) {
            stream.resize(14, true);
            stream.pos(0);
        }
        if (stream.pos() != stream.size()) {
            if (!handler.read(stream)) {
                return false;
            }
            assert (stream.pos() == stream.size());
        }
        if ((pos = stream.pos()) < 14) {
            throw new IllegalMessageSizeException();
        }
        stream.pos(0);
        byte[] m = new byte[]{stream.readByte(), stream.readByte(), stream.readByte(), stream.readByte()};
        if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
            BadMagicException ex = new BadMagicException();
            ex.badMagic = m;
            throw ex;
        }
        int pMajor = stream.readByte();
        int pMinor = stream.readByte();
        if (pMajor != 1 || pMinor > 0) {
            UnsupportedProtocolException e = new UnsupportedProtocolException();
            e.badMajor = pMajor < 0 ? pMajor + 255 : pMajor;
            e.badMinor = pMinor < 0 ? pMinor + 255 : pMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        int eMajor = stream.readByte();
        int eMinor = stream.readByte();
        if (eMajor != 1 || eMinor > 0) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = eMajor < 0 ? eMajor + 255 : eMajor;
            e.badMinor = eMinor < 0 ? eMinor + 255 : eMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        stream.readByte();
        stream.readByte();
        int size = stream.readInt();
        if (size < 14) {
            throw new IllegalMessageSizeException();
        }
        if (size > this._instance.messageSizeMax()) {
            throw new MemoryLimitException();
        }
        if (size > stream.size()) {
            stream.resize(size, true);
        }
        stream.pos(pos);
        if (stream.pos() != stream.size()) {
            if (handler.datagram()) {
                if (this._warnUdp) {
                    this._instance.initializationData().logger.warning("DatagramLimitException: maximum size of " + stream.pos() + " exceeded");
                }
                throw new DatagramLimitException();
            }
            if (!handler.read(stream)) {
                return false;
            }
            assert (stream.pos() == stream.size());
        }
        return true;
    }

    private void trace(String msg) {
        System.err.println(this._prefix + ": " + msg);
    }

    private String keyToString(SelectionKey key) {
        String ops = "[";
        if (key.isAcceptable()) {
            ops = ops + " OP_ACCEPT";
        }
        if (key.isReadable()) {
            ops = ops + " OP_READ";
        }
        if (key.isConnectable()) {
            ops = ops + " OP_CONNECT";
        }
        if (key.isWritable()) {
            ops = ops + " OP_WRITE";
        }
        ops = ops + " ]";
        return key.channel() + " " + ops;
    }

    private final class EventHandlerThread
    extends Thread {
        EventHandlerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean promote;
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.start();
            }
            BasicStream stream = new BasicStream(ThreadPool.this._instance);
            try {
                promote = ThreadPool.this.run(stream);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception in `" + ThreadPool.this._prefix + "' thread " + this.getName() + ":\n" + sw.toString();
                ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
                promote = true;
            }
            if (promote && ThreadPool.this._sizeMax > 1) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    assert (!ThreadPool.this._promote);
                    ThreadPool.this._promote = true;
                    ThreadPool.this.notify();
                }
            }
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.stop();
            }
        }
    }
}

