/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Logger;
import Ice.PluginInitializationException;
import IceInternal.Acceptor;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.Instance;
import IceSSL.TransceiverI;
import IceUtilInternal.Assert;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

final class AcceptorI
implements Acceptor {
    private Instance _instance;
    private String _adapterName;
    private Logger _logger;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    public ServerSocketChannel fd() {
        return this._fd;
    }

    public void close() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "stopping to accept ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        assert (this._fd != null);
        Network.closeSocketNoThrow(this._fd);
        this._fd = null;
    }

    public void listen() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "accepting ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
    }

    public Transceiver accept() {
        if (!this._instance.initialized()) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plug-in is not initialized";
            throw ex;
        }
        SocketChannel fd = Network.doAccept(this._fd);
        SSLEngine engine = null;
        try {
            Network.setBlock(fd, false);
            Network.setTcpBufSize(fd, this._instance.communicator().getProperties(), this._logger);
            engine = this._instance.createSSLEngine(true);
        }
        catch (RuntimeException ex) {
            Network.closeSocketNoThrow(fd);
            throw ex;
        }
        if (this._instance.networkTraceLevel() >= 1) {
            this._logger.trace(this._instance.networkTraceCategory(), "accepting ssl connection\n" + Network.fdToString(fd));
        }
        return new TransceiverI(this._instance, engine, fd, "", true, true, this._adapterName);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    AcceptorI(Instance instance, String adapterName, String host, int port) {
        this._instance = instance;
        this._adapterName = adapterName;
        this._logger = instance.communicator().getLogger();
        this._backlog = instance.communicator().getProperties().getPropertyAsIntWithDefault("Ice.TCP.Backlog", 511);
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, this._instance.communicator().getProperties(), this._logger);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.getAddressForServer(host, port, this._instance.protocolSupport());
            if (this._instance.networkTraceLevel() >= 2) {
                String s = "attempting to bind to ssl socket " + this.toString();
                this._logger.trace(this._instance.networkTraceCategory(), s);
            }
            this._addr = Network.doBind(this._fd, this._addr, this._backlog);
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

