/*
 * Decompiled with CFR 0.152.
 */
package ome.model.screen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ScreenAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.Plate;
import ome.model.screen.Reagent;
import ome.model.screen.ScreenPlateLink;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="screen_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screen_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screen_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screen_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="screen_owner_filter_PLATELINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screen_group_filter_PLATELINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screen_event_filter_PLATELINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screen_perms_filter_PLATELINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="screen_owner_filter_REAGENT", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screen_group_filter_REAGENT", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screen_event_filter_REAGENT", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screen_perms_filter_REAGENT", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="screen_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screen_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screen_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screen_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="screen_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screen_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screen_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screen_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="screen", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_screen", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_screen"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Screen
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "screen_owner_filter";
    public static final String GROUP_FILTER = "screen_group_filter";
    public static final String EVENT_FILTER = "screen_event_filter";
    public static final String PERMS_FILTER = "screen_perms_filter";
    public static final String ID = "ome.model.screen.Screen_id";
    protected Long id;
    public static final String VERSION = "ome.model.screen.Screen_version";
    protected Integer version = 0;
    protected String type = null;
    protected String protocolIdentifier = null;
    protected String protocolDescription = null;
    protected String reagentSetIdentifier = null;
    protected String reagentSetDescription = null;
    protected Set<ScreenPlateLink> plateLinks = new HashSet<ScreenPlateLink>();
    public static final String OWNER_FILTER_PLATELINKS = "screen_owner_filter_PLATELINKS";
    public static final String GROUP_FILTER_PLATELINKS = "screen_group_filter_PLATELINKS";
    public static final String EVENT_FILTER_PLATELINKS = "screen_event_filter_PLATELINKS";
    public static final String PERMS_FILTER_PLATELINKS = "screen_perms_filter_PLATELINKS";
    private Map<Long, Long> plateLinksCountPerOwner = null;
    protected Set<Reagent> reagent = new HashSet<Reagent>();
    public static final String OWNER_FILTER_REAGENT = "screen_owner_filter_REAGENT";
    public static final String GROUP_FILTER_REAGENT = "screen_group_filter_REAGENT";
    public static final String EVENT_FILTER_REAGENT = "screen_event_filter_REAGENT";
    public static final String PERMS_FILTER_REAGENT = "screen_perms_filter_REAGENT";
    protected Set<ScreenAnnotationLink> annotationLinks = new HashSet<ScreenAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "screen_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "screen_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "screen_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "screen_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String TYPE = "ome.model.screen.Screen_type";
    public static final String PROTOCOLIDENTIFIER = "ome.model.screen.Screen_protocolIdentifier";
    public static final String PROTOCOLDESCRIPTION = "ome.model.screen.Screen_protocolDescription";
    public static final String REAGENTSETIDENTIFIER = "ome.model.screen.Screen_reagentSetIdentifier";
    public static final String REAGENTSETDESCRIPTION = "ome.model.screen.Screen_reagentSetDescription";
    public static final String PLATELINKSCOUNTPEROWNER = "ome.model.screen.Screen_plateLinksCountPerOwner";
    public static final String PLATELINKS = "ome.model.screen.Screen_plateLinks";
    public static final String REAGENT = "ome.model.screen.Screen_reagent";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.screen.Screen_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Screen_annotationLinks";
    public static final String NAME = "ome.model.screen.Screen_name";
    public static final String DESCRIPTION = "ome.model.screen.Screen_description";
    public static final String DETAILS = "ome.model.screen.Screen_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Screen() {
        this(null, true);
    }

    protected Screen(Long id) {
        this(id, true);
    }

    public Screen(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Screen(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_screen")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="type", updatable=true)
    public String getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(String type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="protocolIdentifier", updatable=true)
    public String getProtocolIdentifier() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.protocolIdentifier;
    }

    public void setProtocolIdentifier(String protocolIdentifier) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.protocolIdentifier = protocolIdentifier;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="protocolDescription", updatable=true)
    public String getProtocolDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.protocolDescription;
    }

    public void setProtocolDescription(String protocolDescription) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.protocolDescription = protocolDescription;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="reagentSetIdentifier", updatable=true)
    public String getReagentSetIdentifier() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagentSetIdentifier;
    }

    public void setReagentSetIdentifier(String reagentSetIdentifier) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.reagentSetIdentifier = reagentSetIdentifier;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="reagentSetDescription", updatable=true)
    public String getReagentSetDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagentSetDescription;
    }

    public void setReagentSetDescription(String reagentSetDescription) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.reagentSetDescription = reagentSetDescription;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="screen_owner_filter_PLATELINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screen_group_filter_PLATELINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screen_event_filter_PLATELINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screen_perms_filter_PLATELINKS", condition=":permsStr = permissions")})
    protected Set<ScreenPlateLink> getPlateLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.plateLinks;
    }

    protected void setPlateLinks(Set<ScreenPlateLink> plateLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.plateLinks = plateLinks;
    }

    public int sizeOfPlateLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.plateLinks == null ? -1 : this.plateLinks.size();
    }

    public Iterator<ScreenPlateLink> iteratePlateLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            return new EmptyIterator<ScreenPlateLink>();
        }
        return this.getPlateLinks().iterator();
    }

    public Collection<ScreenPlateLink> unmodifiablePlateLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getPlateLinks());
    }

    public <E> List<E> collectPlateLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ScreenPlateLink> it = this.iteratePlateLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addScreenPlateLink(ScreenPlateLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addScreenPlateLinkSet(Collection<ScreenPlateLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().addAll(targets);
        for (ScreenPlateLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeScreenPlateLink(ScreenPlateLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().remove(target);
        target.setParent(null);
    }

    public void removeScreenPlateLinkSet(Collection<ScreenPlateLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().removeAll(targets);
        for (ScreenPlateLink target : targets) {
            target.setParent(null);
        }
    }

    public ScreenPlateLink linkPlate(Plate addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ScreenPlateLink link = new ScreenPlateLink();
        link.link(this, addition);
        this.addScreenPlateLink(link, true);
        return link;
    }

    public void addScreenPlateLink(ScreenPlateLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addScreenPlateLink(link, false);
        }
    }

    public Iterator<Plate> linkedPlateIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            return new EmptyIterator<Plate>();
        }
        final Iterator<ScreenPlateLink> it = this.getPlateLinks().iterator();
        return new Iterator<Plate>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Plate next() {
                if (it == null) {
                    throw new NoSuchElementException("plateLinks is null; no elements.");
                }
                ScreenPlateLink link = (ScreenPlateLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ScreenPlateLink> findScreenPlateLink(Plate target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ScreenPlateLink> it = this.iteratePlateLinks();
        HashSet<ScreenPlateLink> result = new HashSet<ScreenPlateLink>();
        while (it.hasNext()) {
            ScreenPlateLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Plate> linkedPlateList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Plate> it = this.linkedPlateIterator();
        ArrayList<Plate> list = new ArrayList<Plate>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedPlate(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Plate> it = this.linkedPlateIterator();
        while (it.hasNext()) {
            Plate obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkPlate(Plate removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ScreenPlateLink> toRemove = this.findScreenPlateLink(removal);
        Iterator<ScreenPlateLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenPlateLink(it.next(), true);
        }
    }

    public void removeScreenPlateLink(ScreenPlateLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlateLinks() == null) {
            this.throwNullCollectionException("PlateLinks");
        }
        this.getPlateLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeScreenPlateLink(link, false);
        }
    }

    public void clearPlateLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ScreenPlateLink> list = new ArrayList<ScreenPlateLink>(this.getPlateLinks());
        for (ScreenPlateLink link : list) {
            this.removeScreenPlateLink(link, true);
        }
    }

    protected void setPlateLinksCountPerOwner(Map<Long, Long> map) {
        this.plateLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Screen_plateLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Screen_plateLinks_by_owner", joinColumns={@JoinColumn(name="Screen_id")})
    public Map<Long, Long> getPlateLinksCountPerOwner() {
        return this.plateLinksCountPerOwner;
    }

    @OneToMany(mappedBy="screen", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="screen_owner_filter_REAGENT", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screen_group_filter_REAGENT", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screen_event_filter_REAGENT", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screen_perms_filter_REAGENT", condition=":permsStr = permissions")})
    protected Set<Reagent> getReagent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagent;
    }

    protected void setReagent(Set<Reagent> reagent) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.reagent = reagent;
    }

    public int sizeOfReagent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagent == null ? -1 : this.reagent.size();
    }

    public Iterator<Reagent> iterateReagent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            return new EmptyIterator<Reagent>();
        }
        return this.getReagent().iterator();
    }

    public Collection<Reagent> unmodifiableReagent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getReagent());
    }

    public <E> List<E> collectReagent(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Reagent> it = this.iterateReagent();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addReagent(Reagent target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            this.throwNullCollectionException("Reagent");
        }
        this.getReagent().add(target);
        if (target != null) {
            target.setScreen(this);
        }
    }

    public void addReagentSet(Collection<Reagent> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            this.throwNullCollectionException("Reagent");
        }
        this.getReagent().addAll(targets);
        for (Reagent target : targets) {
            if (target == null) continue;
            target.setScreen(this);
        }
    }

    public void removeReagent(Reagent target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            this.throwNullCollectionException("Reagent");
        }
        this.getReagent().remove(target);
        target.setScreen(null);
    }

    public void removeReagentSet(Collection<Reagent> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            this.throwNullCollectionException("Reagent");
        }
        this.getReagent().removeAll(targets);
        for (Reagent target : targets) {
            target.setScreen(null);
        }
    }

    public void clearReagent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagent() == null) {
            this.throwNullCollectionException("Reagent");
        }
        this.getReagent().clear();
        Iterator<Reagent> it = this.iterateReagent();
        while (it.hasNext()) {
            Reagent target = it.next();
            target.setScreen(null);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="screen_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screen_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screen_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screen_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ScreenAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ScreenAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ScreenAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ScreenAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ScreenAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ScreenAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addScreenAnnotationLink(ScreenAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addScreenAnnotationLinkSet(Collection<ScreenAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ScreenAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeScreenAnnotationLink(ScreenAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeScreenAnnotationLinkSet(Collection<ScreenAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ScreenAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ScreenAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ScreenAnnotationLink link = new ScreenAnnotationLink();
        link.link(this, addition);
        this.addScreenAnnotationLink(link, true);
        return link;
    }

    public void addScreenAnnotationLink(ScreenAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ScreenAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ScreenAnnotationLink link = (ScreenAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ScreenAnnotationLink> findScreenAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ScreenAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ScreenAnnotationLink> result = new HashSet<ScreenAnnotationLink>();
        while (it.hasNext()) {
            ScreenAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ScreenAnnotationLink> toRemove = this.findScreenAnnotationLink(removal);
        Iterator<ScreenAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenAnnotationLink(it.next(), true);
        }
    }

    public void removeScreenAnnotationLink(ScreenAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ScreenAnnotationLink> list = new ArrayList<ScreenAnnotationLink>(this.getAnnotationLinks());
        for (ScreenAnnotationLink link : list) {
            this.removeScreenAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Screen_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Screen_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Screen_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Screen newInstance() {
        return new Screen();
    }

    public Screen proxy() {
        return new Screen(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.type = (String)__filter.filter(TYPE, this.type);
            this.protocolIdentifier = (String)__filter.filter(PROTOCOLIDENTIFIER, this.protocolIdentifier);
            this.protocolDescription = (String)__filter.filter(PROTOCOLDESCRIPTION, this.protocolDescription);
            this.reagentSetIdentifier = (String)__filter.filter(REAGENTSETIDENTIFIER, this.reagentSetIdentifier);
            this.reagentSetDescription = (String)__filter.filter(REAGENTSETDESCRIPTION, this.reagentSetDescription);
            this.plateLinksCountPerOwner = __filter.filter(PLATELINKSCOUNTPEROWNER, this.plateLinksCountPerOwner);
            this.plateLinks = (Set)__filter.filter(PLATELINKS, this.plateLinks);
            this.reagent = (Set)__filter.filter(REAGENT, this.reagent);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(PROTOCOLIDENTIFIER)) {
            return this.getProtocolIdentifier();
        }
        if (field.equals(PROTOCOLDESCRIPTION)) {
            return this.getProtocolDescription();
        }
        if (field.equals(REAGENTSETIDENTIFIER)) {
            return this.getReagentSetIdentifier();
        }
        if (field.equals(REAGENTSETDESCRIPTION)) {
            return this.getReagentSetDescription();
        }
        if (field.equals(PLATELINKSCOUNTPEROWNER)) {
            return this.getPlateLinksCountPerOwner();
        }
        if (field.equals(PLATELINKS)) {
            return this.getPlateLinks();
        }
        if (field.equals(REAGENT)) {
            return this.getReagent();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(TYPE)) {
            this.setType((String)value);
        } else if (field.equals(PROTOCOLIDENTIFIER)) {
            this.setProtocolIdentifier((String)value);
        } else if (field.equals(PROTOCOLDESCRIPTION)) {
            this.setProtocolDescription((String)value);
        } else if (field.equals(REAGENTSETIDENTIFIER)) {
            this.setReagentSetIdentifier((String)value);
        } else if (field.equals(REAGENTSETDESCRIPTION)) {
            this.setReagentSetDescription((String)value);
        } else if (field.equals(PLATELINKSCOUNTPEROWNER)) {
            this.setPlateLinksCountPerOwner((Map)value);
        } else if (field.equals(PLATELINKS)) {
            this.setPlateLinks((Set)value);
        } else if (field.equals(REAGENT)) {
            this.setReagent((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.type = null;
        this.protocolIdentifier = null;
        this.protocolDescription = null;
        this.reagentSetIdentifier = null;
        this.reagentSetDescription = null;
        this.plateLinksCountPerOwner = null;
        this.plateLinks = null;
        this.reagent = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(TYPE);
        raw.add(PROTOCOLIDENTIFIER);
        raw.add(PROTOCOLDESCRIPTION);
        raw.add(REAGENTSETIDENTIFIER);
        raw.add(REAGENTSETDESCRIPTION);
        raw.add(PLATELINKSCOUNTPEROWNER);
        raw.add(PLATELINKS);
        raw.add(REAGENT);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKscreen_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreen_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKscreen_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreen_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreen_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

