/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RDouble;
import omero.RInt;
import omero.RString;
import omero.model.AcquisitionMode;
import omero.model.Channel;
import omero.model.ChannelI;
import omero.model.ContrastMethod;
import omero.model.Illumination;
import omero.model.LogicalChannel;
import omero.model.StatsInfo;
import omero.rtypes;
import pojos.DataObject;

public class ChannelData
extends DataObject {
    public static final String ANNOTATIONS = "ome.model.core.Channel_annotationLinks";
    private int index;
    private AcquisitionMode mode;
    private Illumination illumination;
    private ContrastMethod contrastMethod;

    public ChannelData(int index) {
        this.setDirty(false);
        this.setValue(new ChannelI());
        this.index = index;
    }

    public ChannelData(int index, Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.index = index;
        this.setValue(channel);
        this.setDirty(false);
    }

    public int getIndex() {
        return this.index;
    }

    public String getChannelLabeling() {
        String value = this.getName();
        if (value != null && value.trim().length() != 0) {
            return value;
        }
        value = this.getFluor();
        if (value != null && value.trim().length() != 0) {
            return value;
        }
        int v = this.getEmissionWavelength();
        if (v > 0) {
            return "" + v;
        }
        return "" + this.index;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setName(rtypes.rstring(name));
    }

    public String getName() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return null;
        }
        RString n = lc.getName();
        if (n != null) {
            return n.getValue();
        }
        return null;
    }

    public int getEmissionWavelength() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return this.index;
        }
        RInt value = lc.getEmissionWave();
        if (value != null) {
            return value.getValue();
        }
        return -1;
    }

    public int getExcitationWavelength() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return this.getEmissionWavelength();
        }
        RInt value = lc.getExcitationWave();
        if (value != null) {
            return value.getValue();
        }
        return -1;
    }

    public double getPinholeSize() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return -1.0;
        }
        RDouble value = lc.getPinHoleSize();
        if (value != null) {
            return value.getValue();
        }
        return -1.0;
    }

    public double getNDFilter() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return -1.0;
        }
        RDouble value = lc.getNdFilter();
        if (value != null) {
            return value.getValue();
        }
        return -1.0;
    }

    public String getFluor() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return null;
        }
        RString value = lc.getFluor();
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public int getPockelCell() {
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return -1;
        }
        RInt value = lc.getPockelCellSetting();
        if (value != null) {
            return value.getValue();
        }
        return -1;
    }

    public String getIllumination() {
        if (this.illumination != null) {
            return this.illumination.getValue().getValue();
        }
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return null;
        }
        Illumination value = lc.getIllumination();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getContrastMethod() {
        if (this.contrastMethod != null) {
            return this.contrastMethod.getValue().getValue();
        }
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return null;
        }
        ContrastMethod value = lc.getContrastMethod();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getMode() {
        if (this.mode != null) {
            return this.mode.getValue().getValue();
        }
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return null;
        }
        AcquisitionMode value = lc.getMode();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public double getGlobalMin() {
        StatsInfo stats = this.asChannel().getStatsInfo();
        if (stats == null) {
            return 0.0;
        }
        RDouble object = stats.getGlobalMin();
        if (object != null) {
            return object.getValue();
        }
        return 0.0;
    }

    public double getGlobalMax() {
        StatsInfo stats = this.asChannel().getStatsInfo();
        if (stats == null) {
            return 1.0;
        }
        RDouble object = stats.getGlobalMax();
        if (object != null) {
            return object.getValue();
        }
        return 1.0;
    }

    public void setPinholeSize(double value) {
        if (value < 0.0) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setPinHoleSize(rtypes.rdouble(value));
    }

    public void setNDFilter(double value) {
        if (value < 0.0) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setNdFilter(rtypes.rdouble(value));
    }

    public void setFluor(String value) {
        if (value == null) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setFluor(rtypes.rstring(value));
    }

    public void setEmissionWavelength(int value) {
        if (value < 0) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setEmissionWave(rtypes.rint(value));
    }

    public void setExcitationWavelength(int value) {
        if (value < 0) {
            return;
        }
        this.setDirty(true);
        this.asChannel().getLogicalChannel().setExcitationWave(rtypes.rint(value));
    }

    public void setPockelCell(int value) {
        if (value < 0) {
            return;
        }
        LogicalChannel lc = this.asChannel().getLogicalChannel();
        if (lc == null) {
            return;
        }
        this.setDirty(true);
        lc.setPockelCellSetting(rtypes.rint(value));
    }

    public void setIllumination(Illumination illumination) {
        this.setDirty(true);
        this.illumination = illumination;
    }

    public void setMode(AcquisitionMode mode) {
        this.setDirty(true);
        this.mode = mode;
    }

    public void setContrastMethod(ContrastMethod contrastMethod) {
        this.setDirty(true);
        this.contrastMethod = contrastMethod;
    }

    public AcquisitionMode getModeAsEnum() {
        return this.mode;
    }

    public Illumination getIlluminationAsEnum() {
        return this.illumination;
    }

    public ContrastMethod getContrastMethodAsEnum() {
        return this.contrastMethod;
    }
}

