/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.awt.Color;
import java.awt.Font;
import omero.RInt;
import omero.RString;
import omero.model.Shape;
import omero.rtypes;
import pojos.DataObject;

public class ShapeSettingsData
extends DataObject {
    public static final String LINE_CAP_BUTT = "Butt";
    public static final String LINE_CAP_ROUND = "Round";
    public static final String LINE_CAP_SQUARE = "Square";
    public static final Color DEFAULT_FILL_COLOUR = new Color(0, 0, 0, 64);
    public static final Color DEFAULT_FILL_COLOUR_ALPHA = new Color(0, 0, 0, 32);
    public static final Color DEFAULT_STROKE_COLOUR = new Color(196, 196, 196, 196);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_FONT_STYLE = "normal";
    public static final String DEFAULT_FONT_WEIGHT = "normal";
    public static final String DEFAULT_FONT_FAMILY = "Courier";
    public static final double DEFAULT_STROKE_WIDTH = 1.0;
    public static final String FONT_ITALIC = "italic";
    public static final String FONT_BOLD = "bold";

    ShapeSettingsData(Shape shape) {
        this.setValue(shape);
    }

    public String getFillRule() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getFillRule();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setFillRule(String fillRule) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFillRule(rtypes.rstring(fillRule));
        this.setDirty(true);
    }

    public Color getFillColor() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getFillColor();
        if (value == null) {
            return DEFAULT_FILL_COLOUR;
        }
        return new Color(value.getValue(), true);
    }

    public void setFillColor(Color fillColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFillColor(rtypes.rint(fillColour.getRGB()));
        this.setDirty(true);
    }

    public Color getStrokeColor() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeColor();
        if (value == null) {
            return DEFAULT_STROKE_COLOUR;
        }
        return new Color(value.getValue(), true);
    }

    public void setStrokeColor(Color strokeColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeColor(rtypes.rint(strokeColour.getRGB()));
        this.setDirty(true);
    }

    public double getStrokeWidth() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeWidth();
        if (value == null) {
            return 1.0;
        }
        return value.getValue();
    }

    public void setStrokeWidth(double strokeWidth) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeWidth(rtypes.rint((int)strokeWidth));
        this.setDirty(true);
    }

    public double[] getStrokeDashArray() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeDashArray();
        if (value == null) {
            return null;
        }
        String v = value.getValue();
        String[] values = v.split("\\s*,\\s*");
        double[] dashes = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dashes[i] = new Double(values[i]);
        }
        return dashes;
    }

    public void setStrokeDashArray(double[] dashArray) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String values = "";
        for (int i = 0; i < dashArray.length - 1; ++i) {
            values = values + dashArray[i] + ",";
        }
        values = values + dashArray[dashArray.length - 1];
        shape.setStrokeDashArray(rtypes.rstring(values));
        this.setDirty(true);
    }

    public int getLineCap() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeLineCap();
        if (value == null) {
            return 0;
        }
        String v = value.getValue();
        if (LINE_CAP_BUTT.equals(v)) {
            return 0;
        }
        if (LINE_CAP_ROUND.equals(v)) {
            return 1;
        }
        if (LINE_CAP_SQUARE.equals(v)) {
            return 2;
        }
        return 0;
    }

    public void setLineCap(int lineCap) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        switch (lineCap) {
            case 0: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            case 1: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            case 2: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            default: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
            }
        }
        this.setDirty(true);
    }

    public Font getFont() {
        int style = 0;
        if (this.getFontWeight() == FONT_BOLD) {
            style |= 1;
        }
        if (this.getFontWeight() == FONT_ITALIC) {
            style |= 2;
        }
        return new Font(this.getFontFamily(), style, this.getFontSize());
    }

    public String getFontFamily() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (shape.getFontFamily() != null) {
            return shape.getFontFamily().getValue();
        }
        return DEFAULT_FONT_FAMILY;
    }

    public void setFontFamily(String fontFamily) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontFamily(rtypes.rstring(fontFamily));
        this.setDirty(true);
    }

    public int getFontSize() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (shape.getFontSize() != null) {
            return shape.getFontSize().getValue();
        }
        return 12;
    }

    public void setFontSize(int fontSize) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontSize(rtypes.rint(fontSize));
        this.setDirty(true);
    }

    public String getFontStyle() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (shape.getFontStyle() != null) {
            return shape.getFontStyle().getValue();
        }
        return "normal";
    }

    public void setFontStyle(String fontStyle) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontStyle(rtypes.rstring(fontStyle));
        this.setDirty(true);
    }

    public String getFontWeight() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (shape.getFontWeight() != null) {
            return shape.getFontWeight().getValue();
        }
        return "normal";
    }

    public void setFontWeight(String fontWeight) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontWeight(rtypes.rstring(fontWeight));
        this.setDirty(true);
    }

    public String getMarkerStart() {
        return "";
    }

    public String getMarkerEnd() {
        return "";
    }

    public String getText() {
        return "";
    }

    public boolean isFontItalic() {
        return this.getFontStyle() == FONT_ITALIC;
    }

    public boolean isFontBold() {
        return this.getFontWeight() == FONT_BOLD;
    }
}

