/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Ice.ObjectPrx;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.formats.Index;
import ome.formats.OMEXMLModelComparator;
import ome.formats.SortDatasetsByName;
import ome.formats.SortProjectsByName;
import ome.formats.enums.EnumerationProvider;
import ome.formats.enums.IQueryEnumProvider;
import ome.formats.importer.util.ClientKeepAlive;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.model.ChannelProcessor;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.InstanceProvider;
import ome.formats.model.InstrumentProcessor;
import ome.formats.model.ModelProcessor;
import ome.formats.model.PixelsProcessor;
import ome.formats.model.PlaneInfoProcessor;
import ome.formats.model.ReferenceProcessor;
import ome.formats.model.ShapeProcessor;
import ome.formats.model.TargetProcessor;
import ome.formats.model.WellProcessor;
import ome.util.LSID;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.ServerError;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.ITypesPrx;
import omero.api.IUpdatePrx;
import omero.api.MetadataStorePrx;
import omero.api.MetadataStorePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.client;
import omero.grid.InteractiveProcessorPrx;
import omero.metadatastore.IObjectContainer;
import omero.model.Annotation;
import omero.model.Arc;
import omero.model.ArcType;
import omero.model.BooleanAnnotation;
import omero.model.Channel;
import omero.model.CommentAnnotation;
import omero.model.ContrastMethod;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.Detector;
import omero.model.DetectorSettings;
import omero.model.Dichroic;
import omero.model.DoubleAnnotation;
import omero.model.Ellipse;
import omero.model.Experiment;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.Filament;
import omero.model.FilamentType;
import omero.model.FileAnnotation;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.Format;
import omero.model.IObject;
import omero.model.Illumination;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.ImagingEnvironment;
import omero.model.Immersion;
import omero.model.ImmersionI;
import omero.model.Instrument;
import omero.model.Label;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LightEmittingDiode;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.Line;
import omero.model.ListAnnotation;
import omero.model.LogicalChannel;
import omero.model.LongAnnotation;
import omero.model.Mask;
import omero.model.Medium;
import omero.model.MicrobeamManipulation;
import omero.model.MicrobeamManipulationType;
import omero.model.Microscope;
import omero.model.OTF;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.OriginalFile;
import omero.model.Path;
import omero.model.Permissions;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.PlaneInfo;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.Point;
import omero.model.Polyline;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.Reagent;
import omero.model.Rect;
import omero.model.Roi;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.StageLabel;
import omero.model.TagAnnotation;
import omero.model.TermAnnotation;
import omero.model.TimestampAnnotation;
import omero.model.TransmittanceRange;
import omero.model.TransmittanceRangeI;
import omero.model.Well;
import omero.model.WellSample;
import omero.model.XmlAnnotation;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import omero.util.TempFileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEROMetadataStoreClient
implements MetadataStore,
IMinMaxStore,
IObjectContainerStore {
    private Log log = LogFactory.getLog(OMEROMetadataStoreClient.class);
    private MetadataStorePrx delegate;
    private Map<LSID, IObjectContainer> containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
    private Map<LSID, List<LSID>> referenceCache = new HashMap<LSID, List<LSID>>();
    private Map<Class<? extends IObject>, Map<String, IObjectContainer>> authoritativeContainerCache = new HashMap<Class<? extends IObject>, Map<String, IObjectContainer>>();
    private Map<String, String[]> referenceStringCache;
    private List<ModelProcessor> modelProcessors = new ArrayList<ModelProcessor>();
    private IFormatReader reader;
    private List<Pixels> pixelsList;
    private boolean encryptedConnection = false;
    private client c;
    private ServiceFactoryPrx serviceFactory;
    private IUpdatePrx iUpdate;
    private IQueryPrx iQuery;
    private IAdminPrx iAdmin;
    private RawFileStorePrx rawFileStore;
    private RawPixelsStorePrx rawPixelStore;
    private IRepositoryInfoPrx iRepoInfo;
    private IContainerPrx iContainer;
    private IRenderingSettingsPrx iSettings;
    private ThumbnailStorePrx thumbnailStore;
    private EnumerationProvider enumProvider;
    private InstanceProvider instanceProvider;
    private Long currentPixId;
    private List<Annotation> userSpecifiedAnnotations;
    private String userSpecifiedImageName;
    private String userSpecifiedImageDescription;
    private String userSpecifiedPlateName;
    private String userSpecifiedPlateDescription;
    private IObject userSpecifiedTarget;
    private Double[] userSpecifiedPhysicalPixelSizes;
    private double[][][] imageChannelGlobalMinMax;
    private ScheduledThreadPoolExecutor executor;
    public static final String OMERO_EMISSION_FILTER_SUFFIX = ":OMERO_EMISSION_FILTER";
    public static final String OMERO_EXCITATION_FILTER_SUFFIX = ":OMERO_EXCITATION_FILTER";
    private static final String NS_COMPANION = "openmicroscopy.org/omero/import/companionFile";
    private static final String ORIGINAL_METADATA_KEY = "ORIGINAL_METADATA_TXT";
    private static final int DEFAULT_INSIGHT_THUMBNAIL_LONGEST_SIDE = 96;
    private ClientKeepAlive keepAlive = new ClientKeepAlive();
    private Map<Integer, Image> existingMetadata;

    public ClientKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    private void initializeServices() throws ServerError {
        this.iAdmin = this.serviceFactory.getAdminService();
        this.iQuery = this.serviceFactory.getQueryService();
        this.iUpdate = this.serviceFactory.getUpdateService();
        this.rawFileStore = this.serviceFactory.createRawFileStore();
        this.rawPixelStore = this.serviceFactory.createRawPixelsStore();
        this.thumbnailStore = this.serviceFactory.createThumbnailStore();
        this.iRepoInfo = this.serviceFactory.getRepositoryInfoService();
        this.iContainer = this.serviceFactory.getContainerService();
        this.iSettings = this.serviceFactory.getRenderingSettingsService();
        this.delegate = MetadataStorePrxHelper.checkedCast((ObjectPrx)this.serviceFactory.getByName("omero.api.MetadataStore"));
        this.enumProvider = new IQueryEnumProvider(this.iQuery);
        this.instanceProvider = new BlitzInstanceProvider(this.enumProvider);
        this.modelProcessors.add(new PixelsProcessor());
        this.modelProcessors.add(new ChannelProcessor());
        this.modelProcessors.add(new InstrumentProcessor());
        this.modelProcessors.add(new PlaneInfoProcessor());
        this.modelProcessors.add(new WellProcessor());
        this.modelProcessors.add(new ShapeProcessor());
        this.modelProcessors.add(new TargetProcessor());
        this.modelProcessors.add(new ReferenceProcessor());
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.scheduleWithFixedDelay(this.keepAlive, 60L, 60L, TimeUnit.SECONDS);
        }
        this.keepAlive.setClient(this);
    }

    public IQueryPrx getIQuery() {
        return this.iQuery;
    }

    public void setEncryptedConnection(boolean encryptedConnection) {
        this.encryptedConnection = encryptedConnection;
    }

    public boolean isEncryptedConnection() {
        return this.encryptedConnection;
    }

    public void initialize(ServiceFactoryPrx serviceFactory) throws ServerError {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("No factory.");
        }
        this.serviceFactory = serviceFactory;
        this.initializeServices();
    }

    public void initialize(client c) throws ServerError {
        this.c = c;
        c.setAgent("OMERO.importer");
        this.serviceFactory = c.getSession();
        this.initializeServices();
    }

    public void initialize(String username, String password, String server, int port) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(username, password, server, port, false);
    }

    public void initialize(String username, String password, String server, int port, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.secure(server, port);
        this.c.createSession(username, password);
        if (!isSecure) {
            this.unsecure();
        }
        this.initializeServices();
    }

    public void initialize(String username, String password, String server, int port, long group, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.secure(server, port);
        this.serviceFactory = this.c.createSession(username, password);
        if (!isSecure) {
            this.unsecure();
        }
        this.iAdmin = this.serviceFactory.getAdminService();
        this.iQuery = this.serviceFactory.getQueryService();
        this.setCurrentGroup(group);
        this.initializeServices();
    }

    public void initialize(String server, int port, String sessionKey) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(server, port, sessionKey, false);
    }

    public void initialize(String server, int port, String sessionKey, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.secure(server, port);
        this.serviceFactory = this.c.joinSession(sessionKey);
        if (!isSecure) {
            this.unsecure();
        }
        this.initializeServices();
    }

    private void secure(String server, int port) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.log.info((Object)String.format("Attempting initial SSL connection to %s:%d", server, port));
        this.c = new client(server, port);
        this.c.setAgent("OMERO.importer");
    }

    private void unsecure() throws ServerError, CannotCreateSessionException, PermissionDeniedException {
        this.log.info((Object)"Insecure connection requested, falling back");
        client tmp = this.c.createClient(false);
        this.c.closeSession();
        this.c = tmp;
        this.serviceFactory = this.c.getSession();
    }

    public ServiceFactoryPrx getServiceFactory() {
        return this.serviceFactory;
    }

    public void ping() {
        try {
            this.serviceFactory.keepAllAlive(new ServiceInterfacePrx[]{this.iQuery, this.iAdmin, this.rawFileStore, this.rawPixelStore, this.thumbnailStore, this.iRepoInfo, this.iContainer, this.iUpdate, this.iSettings, this.delegate});
            this.log.debug((Object)"KeepAlive ping.");
        }
        catch (Exception e) {
            this.log.debug((Object)"KeepAlive failed.");
            throw new RuntimeException(e);
        }
    }

    public void setEnumerationProvider(EnumerationProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public EnumerationProvider getEnumerationProvider() {
        return this.enumProvider;
    }

    public void setInstanceProvider(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    public InstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public RInt toRType(Integer value) {
        return value == null ? null : rtypes.rint((int)value);
    }

    public RInt toRType(NonNegativeInteger value) {
        return value == null ? null : rtypes.rint((int)((Integer)value.getValue()));
    }

    public RLong toRType(NonNegativeLong value) {
        return value == null ? null : rtypes.rlong((long)((Long)value.getValue()));
    }

    public RDouble toRType(PercentFraction value) {
        return value == null ? null : rtypes.rdouble((double)((Float)value.getValue()).floatValue());
    }

    public RLong toRType(Long value) {
        return value == null ? null : rtypes.rlong((long)value);
    }

    public RString toRType(String value) {
        return value == null ? null : rtypes.rstring((String)value);
    }

    public RBool toRType(Boolean value) {
        return value == null ? null : rtypes.rbool((boolean)value);
    }

    public RDouble toRType(Double value) {
        return value == null ? null : rtypes.rdouble((double)value);
    }

    public RDouble toRType(Float value) {
        return value == null ? null : rtypes.rdouble((double)Double.parseDouble(value.toString()));
    }

    public RTime toRType(Timestamp value) {
        return value == null ? null : rtypes.rtime((Date)value);
    }

    public RString toRType(NamingConvention value) {
        return value == null ? null : rtypes.rstring((String)value.getValue());
    }

    private Timestamp timestampFromXmlString(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
            return new Timestamp(sdf.parse(value).getTime());
        }
        catch (ParseException e) {
            this.log.error((Object)String.format("Parsing timestamp '%s' failed!", value), (Throwable)e);
            return null;
        }
    }

    private void closeQuietly(StatefulServiceInterfacePrx prx) {
        if (prx != null) {
            try {
                prx.close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Exception closing " + prx));
                this.log.debug((Object)e);
            }
        }
    }

    public void logout() {
        this.closeQuietly((StatefulServiceInterfacePrx)this.rawFileStore);
        this.rawFileStore = null;
        this.closeQuietly((StatefulServiceInterfacePrx)this.rawPixelStore);
        this.rawPixelStore = null;
        this.closeQuietly((StatefulServiceInterfacePrx)this.thumbnailStore);
        this.thumbnailStore = null;
        this.closeQuietly((StatefulServiceInterfacePrx)this.delegate);
        this.delegate = null;
        if (this.c != null) {
            this.log.debug((Object)"closing client session.");
            this.c.closeSession();
            this.c = null;
            this.log.debug((Object)"client closed.");
        }
        if (this.executor != null) {
            this.log.debug((Object)"Logout called, shutting keep alive down.");
            this.executor.shutdown();
            this.executor = null;
            this.log.debug((Object)"keepalive shut down.");
        }
    }

    public void prepare(Map<Integer, Image> existingMetadata) {
        this.existingMetadata = existingMetadata;
    }

    private void prepare() {
        if (this.existingMetadata == null) {
            return;
        }
        for (Map.Entry<Integer, Image> entry : this.existingMetadata.entrySet()) {
            Image image = entry.getValue();
            Integer series = entry.getKey();
            image.setAcquisitionDate(null);
            Pixels pixels = image.getPrimaryPixels();
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.IMAGE_INDEX, series);
            IObjectContainer container = this.getIObjectContainer(Image.class, indexes);
            container.sourceObject = image;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Prepared(%d) == %s,%s", series, container.sourceObject, container.LSID));
            }
            container = this.getIObjectContainer(Pixels.class, indexes);
            container.sourceObject = pixels;
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)String.format("Prepared(%d) == %s,%s", series, container.sourceObject, container.LSID));
        }
    }

    public void createRoot() {
        try {
            this.log.debug((Object)"Creating root!");
            this.authoritativeContainerCache = new HashMap<Class<? extends IObject>, Map<String, IObjectContainer>>();
            this.containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
            this.referenceCache = new HashMap<LSID, List<LSID>>();
            this.referenceStringCache = null;
            this.imageChannelGlobalMinMax = null;
            this.userSpecifiedAnnotations = null;
            this.userSpecifiedImageName = null;
            this.userSpecifiedImageDescription = null;
            this.userSpecifiedTarget = null;
            this.userSpecifiedPhysicalPixelSizes = null;
            this.delegate.createRoot();
            this.prepare();
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
        finally {
            this.existingMetadata = null;
        }
    }

    public Object getRoot() {
        return this.pixelsList;
    }

    private IObject getEnumeration(Class<? extends IObject> klass, String value) {
        return this.enumProvider.getEnumeration(klass, value, false);
    }

    private void checkDuplicateLSID(Class<? extends IObject> klass, String lsid) {
        if (this.log.isTraceEnabled()) {
            List<IObjectContainer> containers = this.getIObjectContainers(klass);
            for (IObjectContainer container : containers) {
                if (!container.LSID.equals(lsid)) continue;
                this.log.trace((Object)String.format("Duplicate LSID %s exists in %s,%s", lsid, container.sourceObject, container.LSID));
                return;
            }
        }
    }

    @Override
    public IFormatReader getReader() {
        return this.reader;
    }

    private Format getImageFormat() {
        ImageReader imageReader = (ImageReader)this.reader;
        String value = imageReader.getReader().getClass().toString();
        value = value.replace("class loci.formats.in.", "");
        value = value.replace("Reader", "");
        return (Format)this.getEnumeration(Format.class, value);
    }

    @Override
    public void setReader(IFormatReader reader) {
        this.reader = reader;
    }

    @Override
    public List<Annotation> getUserSpecifiedAnnotations() {
        return this.userSpecifiedAnnotations;
    }

    @Override
    public void setUserSpecifiedAnnotations(List<Annotation> annotations) {
        this.userSpecifiedAnnotations = annotations;
    }

    @Override
    public String getUserSpecifiedPlateName() {
        return this.userSpecifiedPlateName;
    }

    @Override
    public void setUserSpecifiedPlateName(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using user specified plate name: " + name));
        }
        this.userSpecifiedPlateName = name;
    }

    @Override
    public String getUserSpecifiedPlateDescription() {
        return this.userSpecifiedPlateDescription;
    }

    @Override
    public void setUserSpecifiedPlateDescription(String description) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using user specified plate description: " + description));
        }
        this.userSpecifiedPlateDescription = description;
    }

    @Override
    public String getUserSpecifiedImageName() {
        return this.userSpecifiedImageName;
    }

    @Override
    public void setUserSpecifiedImageName(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using user specified image name: " + name));
        }
        this.userSpecifiedImageName = name;
    }

    @Override
    public String getUserSpecifiedImageDescription() {
        return this.userSpecifiedImageDescription;
    }

    @Override
    public void setUserSpecifiedImageDescription(String description) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using user specified image description: " + description));
        }
        this.userSpecifiedImageDescription = description;
    }

    @Override
    public IObject getUserSpecifiedTarget() {
        return this.userSpecifiedTarget;
    }

    @Override
    public void setUserSpecifiedTarget(IObject target) {
        this.userSpecifiedTarget = target;
    }

    @Override
    public Double[] getUserSpecifiedPhysicalPixelSizes() {
        return this.userSpecifiedPhysicalPixelSizes;
    }

    @Override
    public void setUserSpecifiedPhysicalPixelSizes(Double physicalSizeX, Double physicalSizeY, Double physicalSizeZ) {
        this.userSpecifiedPhysicalPixelSizes = new Double[]{physicalSizeX, physicalSizeY, physicalSizeZ};
    }

    public List<ModelProcessor> getModelProcessors() {
        return this.modelProcessors;
    }

    public void setModelProcessors(List<ModelProcessor> modelProcessors) {
        this.modelProcessors = modelProcessors;
    }

    public void removeModelProcessor(ModelProcessor processor) {
        this.modelProcessors.remove(processor);
    }

    public boolean addModelProcessor(ModelProcessor processor) {
        return this.modelProcessors.add(processor);
    }

    @Override
    public Map<LSID, IObjectContainer> getContainerCache() {
        return this.containerCache;
    }

    @Override
    public Map<LSID, List<LSID>> getReferenceCache() {
        return this.referenceCache;
    }

    @Override
    public Map<Class<? extends IObject>, Map<String, IObjectContainer>> getAuthoritativeContainerCache() {
        return this.authoritativeContainerCache;
    }

    private void addAuthoritativeContainer(Class<? extends IObject> klass, String lsid, IObjectContainer container) {
        Map<String, IObjectContainer> lsidContainerMap = this.authoritativeContainerCache.get(klass);
        if (lsidContainerMap == null) {
            lsidContainerMap = new HashMap<String, IObjectContainer>();
            this.authoritativeContainerCache.put(klass, lsidContainerMap);
        }
        lsidContainerMap.put(lsid, container);
    }

    @Override
    public void addReference(LSID source, LSID target) {
        List<Object> targets = null;
        if (this.referenceCache.containsKey(source)) {
            targets = this.referenceCache.get(source);
        } else {
            targets = new ArrayList();
            this.referenceCache.put(source, targets);
        }
        if (!targets.contains(target)) {
            targets.add(target);
        }
    }

    @Override
    public Map<String, String[]> getReferenceStringCache() {
        return this.referenceStringCache;
    }

    @Override
    public void setReferenceStringCache(Map<String, String[]> referenceStringCache) {
        this.referenceStringCache = referenceStringCache;
    }

    private <T extends IObject> T getSourceObject(Class<T> klass, LinkedHashMap<Index, Integer> indexes) {
        return (T)this.getIObjectContainer(klass, indexes).sourceObject;
    }

    @Override
    public IObject getSourceObject(LSID LSID2) {
        IObjectContainer o = this.containerCache.get(LSID2);
        if (o == null) {
            return null;
        }
        return o.sourceObject;
    }

    @Override
    public <T extends IObject> List<T> getSourceObjects(Class<T> klass) {
        List<IObjectContainer> containers = this.getIObjectContainers(klass);
        ArrayList<IObject> toReturn = new ArrayList<IObject>(containers.size());
        for (IObjectContainer container : containers) {
            toReturn.add(container.sourceObject);
        }
        return toReturn;
    }

    @Override
    public boolean hasReference(LSID source, LSID target) {
        return this.referenceCache.containsKey(source) && this.referenceCache.get(source).contains(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createSeriesMetadataFile(String suffix) {
        Hashtable globalMetadata = this.reader.getGlobalMetadata();
        Hashtable seriesMetadata = this.reader.getSeriesMetadata();
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            String s;
            File metadataFile = TempFileManager.createTempFile((String)ORIGINAL_METADATA_KEY, (String)suffix);
            stream = new FileOutputStream(metadataFile);
            writer = new OutputStreamWriter(stream);
            metadataFile.deleteOnExit();
            writer.write("[GlobalMetadata]\n");
            for (Object key : globalMetadata.keySet()) {
                s = key.toString() + "=" + globalMetadata.get(key).toString() + "\n";
                writer.write(s);
            }
            writer.write("[SeriesMetadata]\n");
            for (Object key : seriesMetadata.keySet()) {
                s = key.toString() + "=" + seriesMetadata.get(key).toString() + "\n";
                writer.write(s);
            }
            File file = metadataFile;
            return file;
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to create series metadata file.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to close writer or stream.", (Throwable)e);
            }
        }
    }

    public List<File> setArchiveScreeningDomain(boolean archive) {
        ArrayList<File> metadataFiles = new ArrayList<File>();
        String[] usedFiles = this.reader.getUsedFiles();
        List<String> companionFiles = this.getFilteredCompanionFiles();
        ImageReader imageReader = (ImageReader)this.reader;
        String formatString = imageReader.getReader().getClass().toString();
        formatString = formatString.replace("class loci.formats.in.", "");
        formatString = formatString.replace("Reader", "");
        LSID plateKey = new LSID(Plate.class, new int[]{0});
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            LinkedHashMap<Index, Integer> imageIndexes = new LinkedHashMap<Index, Integer>();
            imageIndexes.put(Index.IMAGE_INDEX, series);
            Image image = this.getSourceObject(Image.class, imageIndexes);
            image.setArchived(this.toRType(archive));
        }
        int originalFileIndex = 0;
        for (String usedFilename : usedFiles) {
            boolean isCompanionFile;
            File usedFile = new File(usedFilename);
            boolean bl = isCompanionFile = companionFiles == null ? false : companionFiles.contains(usedFilename);
            if (!archive && !isCompanionFile) continue;
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.ORIGINAL_FILE_INDEX, originalFileIndex);
            if (isCompanionFile) {
                String format = "Companion/" + formatString;
                this.createOriginalFileFromFile(usedFile, indexes, format);
                this.addCompanionFileAnnotationTo(plateKey, indexes, originalFileIndex);
                ++originalFileIndex;
                continue;
            }
            this.createOriginalFileFromFile(usedFile, indexes, formatString);
            LSID originalFileKey = new LSID(OriginalFile.class, new int[]{originalFileIndex++});
            this.addReference(plateKey, originalFileKey);
        }
        return metadataFiles;
    }

    public List<File> setArchive(boolean archive, boolean useMetadataFile) {
        ArrayList<File> metadataFiles = new ArrayList<File>();
        int originalFileIndex = this.countCachedContainers(OriginalFile.class, null);
        HashMap<String, Integer> pathIndexMap = new HashMap<String, Integer>();
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            String[] usedFiles = this.reader.getSeriesUsedFiles();
            List<String> companionFiles = this.getFilteredSeriesCompanionFiles();
            ImageReader imageReader = (ImageReader)this.reader;
            String formatString = imageReader.getReader().getClass().toString();
            formatString = formatString.replace("class loci.formats.in.", "");
            formatString = formatString.replace("Reader", "");
            LSID pixelsKey = new LSID(Pixels.class, new int[]{series});
            LSID imageKey = new LSID(Image.class, new int[]{series});
            LinkedHashMap<Index, Integer> imageIndexes = new LinkedHashMap<Index, Integer>();
            imageIndexes.put(Index.IMAGE_INDEX, series);
            Image image = this.getSourceObject(Image.class, imageIndexes);
            image.setArchived(this.toRType(archive));
            if (useMetadataFile) {
                String uuid = UUID.randomUUID().toString();
                File metadataFile = this.createSeriesMetadataFile(uuid);
                metadataFiles.add(metadataFile);
                LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                indexes.put(Index.ORIGINAL_FILE_INDEX, originalFileIndex);
                String format = "text/plain";
                OriginalFile originalFile = this.createOriginalFileFromFile(metadataFile, indexes, format);
                this.log.debug((Object)"originalFile created");
                originalFile.setPath(this.toRType(String.format("%s%s/", "/openmicroscopy.org/omero/image_files/", uuid)));
                originalFile.setName(this.toRType("original_metadata.txt"));
                this.log.debug((Object)"originalFile path created");
                indexes = new LinkedHashMap();
                indexes.put(Index.IMAGE_INDEX, series);
                indexes.put(Index.ORIGINAL_FILE_INDEX, originalFileIndex);
                this.addCompanionFileAnnotationTo(imageKey, indexes, originalFileIndex);
                ++originalFileIndex;
            }
            for (int i = 0; i < usedFiles.length; ++i) {
                boolean isCompanionFile;
                String usedFilename = usedFiles[i];
                File usedFile = new File(usedFilename);
                String absolutePath = usedFile.getAbsolutePath();
                boolean bl = isCompanionFile = companionFiles == null ? false : companionFiles.contains(usedFilename);
                if (!archive && !isCompanionFile) continue;
                LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                indexes.put(Index.ORIGINAL_FILE_INDEX, originalFileIndex);
                int usedFileIndex = originalFileIndex++;
                if (pathIndexMap.containsKey(absolutePath)) {
                    usedFileIndex = (Integer)pathIndexMap.get(absolutePath);
                } else if (isCompanionFile) {
                    String format = "Companion/" + formatString;
                    this.createOriginalFileFromFile(usedFile, indexes, format);
                    pathIndexMap.put(absolutePath, usedFileIndex);
                } else {
                    this.createOriginalFileFromFile(usedFile, indexes, formatString);
                    pathIndexMap.put(absolutePath, usedFileIndex);
                    ++originalFileIndex;
                }
                if (isCompanionFile) {
                    indexes = new LinkedHashMap();
                    indexes.put(Index.IMAGE_INDEX, series);
                    indexes.put(Index.ORIGINAL_FILE_INDEX, usedFileIndex);
                    this.addCompanionFileAnnotationTo(imageKey, indexes, usedFileIndex);
                }
                if (!archive) continue;
                LSID originalFileKey = new LSID(OriginalFile.class, new int[]{usedFileIndex});
                this.addReference(pixelsKey, originalFileKey);
            }
        }
        return metadataFiles;
    }

    private List<String> filterFilenames(String[] files) {
        if (files == null) {
            return null;
        }
        ArrayList<String> filteredFiles = new ArrayList<String>();
        for (String file : files) {
            if (file.endsWith(".tif") || file.endsWith(".tiff")) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    public List<String> getFilteredCompanionFiles() {
        return this.filterFilenames(this.reader.getUsedFiles(true));
    }

    public List<String> getFilteredSeriesCompanionFiles() {
        return this.filterFilenames(this.reader.getSeriesUsedFiles(true));
    }

    private void addCompanionFileAnnotationTo(LSID target, LinkedHashMap<Index, Integer> indexes, int originalFileIndex) {
        FileAnnotation a = this.getSourceObject(FileAnnotation.class, indexes);
        a.setNs(rtypes.rstring((String)NS_COMPANION));
        Collection<Integer> indexValues = indexes.values();
        Integer[] integerValues = indexValues.toArray(new Integer[indexValues.size()]);
        int[] values = new int[integerValues.length];
        for (int i = 0; i < integerValues.length; ++i) {
            values[i] = integerValues[i];
        }
        LSID annotationKey = new LSID(FileAnnotation.class, values);
        LSID originalFileKey = new LSID(OriginalFile.class, new int[]{originalFileIndex});
        this.addReference(target, annotationKey);
        this.addReference(annotationKey, originalFileKey);
    }

    private OriginalFile byUUID(String path, Map<String, OriginalFile> originalFileMap) {
        for (Map.Entry<String, OriginalFile> entry : originalFileMap.entrySet()) {
            try {
                String[] tokens;
                if (!path.contains(ORIGINAL_METADATA_KEY) || (tokens = entry.getKey().split("/")).length <= 1 || !path.endsWith(tokens[tokens.length - 2])) continue;
                return entry.getValue();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.log.error((Object)("byUUID error, path: " + path + ", entry.key: " + entry.getKey()), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFilesToFileStore(List<File> files, Map<String, OriginalFile> originalFileMap) {
        byte[] buf = new byte[0x100000];
        for (File file : files) {
            String path = file.getAbsolutePath();
            OriginalFile originalFile = originalFileMap.get(path);
            if (originalFile == null) {
                originalFile = this.byUUID(path, originalFileMap);
            }
            if (originalFile == null) {
                this.log.warn((Object)("Cannot lookup original file with path: " + file.getAbsolutePath()));
                continue;
            }
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                this.rawFileStore.setFileId(originalFile.getId().getValue());
                int rlen = 0;
                int offset = 0;
                while (stream.available() != 0) {
                    rlen = stream.read(buf);
                    this.rawFileStore.write(buf, (long)offset, rlen);
                    offset += rlen;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"I/O or server error populating file store.", (Throwable)e);
                break;
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"I/O error closing stream.", (Throwable)e);
                }
            }
        }
    }

    public void setCurrentGroup(long groupID) throws ServerError {
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.iAdmin.getEventContext().userId);
        if (currentDefaultGroup.getId().getValue() == groupID) {
            return;
        }
        Experimenter exp = this.iAdmin.getExperimenter(this.iAdmin.getEventContext().userId);
        List<ExperimenterGroup> groups = this.getUserGroups();
        Iterator<ExperimenterGroup> i = groups.iterator();
        ExperimenterGroup group = null;
        boolean in = false;
        while (i.hasNext()) {
            group = i.next();
            if (group.getId().getValue() != groupID) continue;
            in = true;
            break;
        }
        if (!in) {
            this.log.error((Object)"Can't modify the current group.\n\n");
        } else {
            this.iAdmin.setDefaultGroup(exp, this.iAdmin.getGroup(groupID));
            this.serviceFactory.setSecurityContext((IObject)new ExperimenterGroupI(groupID, false));
        }
    }

    List<ExperimenterGroup> getUserGroups() throws ServerError {
        ArrayList<ExperimenterGroup> myGroups = new ArrayList<ExperimenterGroup>();
        ParametersI p = new ParametersI();
        p.addId(this.iAdmin.getEventContext().userId);
        List groups = this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent p where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", (Parameters)p);
        for (ExperimenterGroup group : groups) {
            myGroups.add(group);
        }
        return myGroups;
    }

    public Map<Long, String> mapUserGroups() throws ServerError {
        String dn;
        ArrayList<String> systemGroups = new ArrayList<String>();
        systemGroups.add("system");
        systemGroups.add("user");
        systemGroups.add("guest");
        LinkedHashMap<Long, String> names = new LinkedHashMap<Long, String>();
        List<ExperimenterGroup> groups = this.getUserGroups();
        if (groups == null || groups.size() == 0) {
            return null;
        }
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.iAdmin.getEventContext().userId);
        Iterator<ExperimenterGroup> i = groups.iterator();
        ExperimenterGroup group = null;
        while (i.hasNext()) {
            group = i.next();
            String n = group.getName() == null ? null : group.getName().getValue();
            if (systemGroups.contains(n) || group.getId().getValue() == currentDefaultGroup.getId().getValue()) continue;
            names.put(group.getId().getValue(), group.getName().getValue());
        }
        String string = dn = currentDefaultGroup.getName() == null ? null : currentDefaultGroup.getName().getValue();
        if (!systemGroups.contains(dn)) {
            names.put(currentDefaultGroup.getId().getValue(), currentDefaultGroup.getName().getValue());
        }
        if (names.size() == 0) {
            names = null;
        }
        return names;
    }

    public String getDefaultGroupName() throws ServerError {
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.iAdmin.getEventContext().userId);
        String dn = currentDefaultGroup.getName() == null ? "" : currentDefaultGroup.getName().getValue();
        return dn;
    }

    public int getDefaultGroupLevel() throws ServerError {
        int groupLevel = 0;
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.iAdmin.getEventContext().userId);
        Permissions perm = currentDefaultGroup.getDetails().getPermissions();
        groupLevel = perm.isGroupRead() ? (perm.isGroupWrite() ? 2 : 1) : (perm.isWorldRead() ? (perm.isWorldWrite() ? 0 : 0) : 3);
        return groupLevel;
    }

    public long getRepositorySpace() {
        try {
            return this.iRepoInfo.getFreeSpaceInKilobytes();
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcess() {
        for (ModelProcessor processor : this.modelProcessors) {
            processor.process(this);
        }
    }

    public List<Pixels> saveToDB() {
        try {
            Collection<IObjectContainer> containers = this.containerCache.values();
            IObjectContainer[] containerArray = containers.toArray(new IObjectContainer[containers.size()]);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Starting containers....");
                for (LSID lSID : this.containerCache.keySet()) {
                    String s = String.format("%s == %s,%s", lSID, this.containerCache.get((Object)lSID).sourceObject, this.containerCache.get((Object)lSID).LSID);
                    this.log.debug((Object)s);
                }
                this.log.debug((Object)"Starting references....");
                for (String string : this.referenceStringCache.keySet()) {
                    for (String value : this.referenceStringCache.get(string)) {
                        String s = String.format("%s == %s", string, value);
                        this.log.debug((Object)s);
                    }
                }
                this.log.debug((Object)("containerCache contains " + this.containerCache.size() + " entries."));
                this.log.debug((Object)("referenceCache contains " + this.countCachedReferences(null, null) + " entries."));
            }
            this.delegate.updateObjects(containerArray);
            this.delegate.updateReferences(this.referenceStringCache);
            this.pixelsList = this.delegate.saveToDB();
            if (this.log.isDebugEnabled()) {
                for (Pixels pixels : this.pixelsList) {
                    long pixelsId = pixels.getId().getValue();
                    this.log.debug((Object)("Saved Pixels with ID: " + pixelsId));
                }
            }
            return this.pixelsList;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<InteractiveProcessorPrx> launchProcessing() {
        try {
            return this.delegate.postProcess();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to launch post-processing", (Throwable)e);
            return null;
        }
    }

    public <T extends IObject> T getTarget(Class<T> klass, long id) {
        try {
            return (T)this.iQuery.get(klass.getName(), id);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Project getProject(long projectId) {
        try {
            return (Project)this.iQuery.get("Project", projectId);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Dataset addDataset(String datasetName, String datasetDescription, Project project) {
        DatasetI dataset = new DatasetI();
        if (datasetName.length() != 0) {
            dataset.setName(this.toRType(datasetName));
        }
        if (datasetDescription.length() != 0) {
            dataset.setDescription(this.toRType(datasetDescription));
        }
        ProjectI p = new ProjectI(project.getId().getValue(), false);
        dataset.linkProject((Project)p);
        try {
            return (Dataset)this.iUpdate.saveAndReturnObject((IObject)dataset);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public long getExperimenterID() {
        try {
            return this.iAdmin.getEventContext().userId;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    private OriginalFile createOriginalFileFromFile(File file, LinkedHashMap<Index, Integer> indexes, String formatString) {
        OriginalFile o = this.getSourceObject(OriginalFile.class, indexes);
        o.setName(this.toRType(file.getName()));
        o.setSize(this.toRType(file.length()));
        o.setMimetype(this.toRType(formatString));
        o.setPath(this.toRType(file.getParent() + File.separator));
        o.setSha1(this.toRType("Pending"));
        return o;
    }

    public List<Screen> getScreens() {
        try {
            List objects = this.iContainer.loadContainerHierarchy(Screen.class.getName(), null, (Parameters)new ParametersI().exp(rtypes.rlong((long)this.getExperimenterID())));
            ArrayList<Screen> screens = new ArrayList<Screen>(objects.size());
            for (IObject object : objects) {
                screens.add((Screen)object);
            }
            return screens;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<Project> getProjects() {
        try {
            List objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), null, (Parameters)new ParametersI().exp(rtypes.rlong((long)this.getExperimenterID())));
            ArrayList<Project> projects = new ArrayList<Project>(objects.size());
            for (IObject object : objects) {
                projects.add((Project)object);
            }
            Collections.sort(projects, new SortProjectsByName());
            return projects;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<Dataset> getDatasets(Project p) {
        try {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(p.getId().getValue());
            List objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), ids, null);
            if (objects.size() > 0) {
                Project project = (Project)objects.get(0);
                List datasets = project.linkedDatasetList();
                Collections.sort(datasets, new SortDatasetsByName());
                return datasets;
            }
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Project addProject(String projectName, String projectDescription) {
        ProjectI project = new ProjectI();
        if (projectName.length() != 0) {
            project.setName(this.toRType(projectName));
        }
        if (projectDescription.length() != 0) {
            project.setDescription(this.toRType(projectDescription));
        }
        try {
            return (Project)this.iUpdate.saveAndReturnObject((IObject)project);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Screen addScreen(String screenName, String screenDescription) {
        ScreenI screen = new ScreenI();
        if (screenName.length() != 0) {
            screen.setName(this.toRType(screenName));
        }
        if (screenDescription.length() != 0) {
            screen.setDescription(this.toRType(screenDescription));
        }
        try {
            return (Screen)this.iUpdate.saveAndReturnObject((IObject)screen);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void preparePixelsStore(List<Long> pixelsIds) {
        try {
            this.rawPixelStore.prepare(pixelsIds);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void setRegion(Long pixId, byte[] arrayBuf, int size, long offset) throws ServerError {
        if (this.currentPixId != pixId) {
            this.rawPixelStore.setPixelsId(pixId.longValue(), true);
            this.currentPixId = pixId;
        }
        this.rawPixelStore.setRegion(size, offset, arrayBuf);
    }

    public void setPlane(Long pixId, byte[] arrayBuf, int z, int c, int t) throws ServerError {
        if (this.currentPixId != pixId) {
            this.rawPixelStore.setPixelsId(pixId.longValue(), true);
            this.currentPixId = pixId;
        }
        this.rawPixelStore.setPlane(arrayBuf, z, c, t);
    }

    public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
        double[] globalMinMax;
        Object channelGlobalMinMax;
        Pixels pixels = (Pixels)this.getSourceObject(new LSID(Pixels.class, new int[]{series}));
        if (this.imageChannelGlobalMinMax == null) {
            int imageCount = this.countCachedContainers(Image.class, new int[0]);
            this.imageChannelGlobalMinMax = new double[imageCount][][];
        }
        if ((channelGlobalMinMax = this.imageChannelGlobalMinMax[series]) == null) {
            double[][] dArrayArray = new double[pixels.getSizeC().getValue()][];
            channelGlobalMinMax = dArrayArray;
            this.imageChannelGlobalMinMax[series] = dArrayArray;
        }
        if ((globalMinMax = channelGlobalMinMax[channel]) == null) {
            globalMinMax = new double[2];
            this.imageChannelGlobalMinMax[series][channel] = globalMinMax;
        }
        globalMinMax[0] = minimum;
        globalMinMax[1] = maximum;
    }

    public void updatePixels(List<Pixels> pixelsList) {
        try {
            ArrayList<Pixels> objectList = new ArrayList<Pixels>(pixelsList.size());
            for (Pixels pixels : pixelsList) {
                pixels.unloadCollections();
                pixels.unloadDetails();
                ImageI unloadedImage = new ImageI(pixels.getImage().getId(), false);
                pixels.setImage((Image)unloadedImage);
                objectList.add(pixels);
            }
            this.iUpdate.saveArray(objectList);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    public void populateMinMax() {
        try {
            this.delegate.populateMinMax(this.imageChannelGlobalMinMax);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void resetDefaultsAndGenerateThumbnails(List<Long> plateIds, List<Long> pixelsIds) {
        try {
            if (plateIds.size() > 0) {
                this.iSettings.resetDefaultsInSet("Plate", plateIds);
            } else {
                this.iSettings.resetDefaultsInSet("Pixels", pixelsIds);
            }
            this.thumbnailStore.createThumbnailsByLongestSideSet(rtypes.rint((int)96), pixelsIds);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    private void checkImmersions() {
        String[] immersionAddStrings = new String[]{"Air", "Glycerol", "Multi", "WaterDipping", "Other"};
        List<String> immersionAdds = Arrays.asList(immersionAddStrings);
        String[] immersionDeleteStrings = new String[]{"Gly", "Hl", "Oel", "Wasser", "Wl"};
        List<String> immersionDeletes = Arrays.asList(immersionDeleteStrings);
        try {
            ITypesPrx types = this.serviceFactory.getTypesService();
            List immersionList = types.allEnumerations("omero.model.Immersion");
            ArrayList<String> immersionStrings = new ArrayList<String>();
            for (IObject immersion : immersionList) {
                Immersion immersion2 = (Immersion)immersion;
                immersionStrings.add(immersion2.getValue().getValue());
                this.log.info((Object)("Found immersion: " + immersion2.getValue().getValue()));
            }
            for (String i : immersionAdds) {
                if (immersionStrings.contains(i)) continue;
                ImmersionI immersion = new ImmersionI();
                immersion.setValue(rtypes.rstring((String)i));
                this.log.info((Object)("Adding missing immersion: " + i));
            }
            for (String i : immersionDeletes) {
                int index = immersionStrings.indexOf(i);
                if (index == -1) continue;
                this.log.info((Object)("Deleting bad immersion: " + i));
            }
        }
        catch (ServerError e) {
            this.log.error((Object)"checkImmersions() failure", (Throwable)e);
        }
    }

    @Override
    public IObjectContainer getIObjectContainer(Class<? extends IObject> klass, LinkedHashMap<Index, Integer> indexes) {
        Collection<Integer> indexValues = indexes.values();
        int[] indexesArray = new int[indexValues.size()];
        int i = 0;
        for (Integer index : indexValues) {
            indexesArray[i] = index;
            ++i;
        }
        LSID lsid = new LSID(klass, indexesArray);
        HashMap<String, Integer> asString = new HashMap<String, Integer>();
        for (Map.Entry<Index, Integer> v : indexes.entrySet()) {
            asString.put(v.getKey().toString(), v.getValue());
        }
        if (!this.containerCache.containsKey(lsid)) {
            IObjectContainer c = new IObjectContainer();
            c.indexes = asString;
            c.LSID = lsid.toString();
            c.sourceObject = this.getSourceObjectInstance(klass);
            this.containerCache.put(lsid, c);
        }
        return this.containerCache.get(lsid);
    }

    @Override
    public void removeIObjectContainer(LSID lsid) {
        this.containerCache.remove(lsid);
    }

    @Override
    public List<IObjectContainer> getIObjectContainers(Class<? extends IObject> klass) {
        Set<LSID> keys = this.containerCache.keySet();
        ArrayList<IObjectContainer> toReturn = new ArrayList<IObjectContainer>();
        for (LSID key : keys) {
            Class keyClass = key.getJavaClass();
            if (keyClass == null || !keyClass.equals(klass)) continue;
            toReturn.add(this.containerCache.get(key));
        }
        return toReturn;
    }

    private <T extends IObject> T getSourceObjectInstance(Class<T> klass) {
        return this.instanceProvider.getInstance(klass);
    }

    @Override
    public int countCachedContainers(Class<? extends IObject> klass, int ... indexes) {
        if (klass == null) {
            return new HashSet<IObjectContainer>(this.containerCache.values()).size();
        }
        int count = 0;
        for (LSID lsid : this.containerCache.keySet()) {
            Class lsidClass = lsid.getJavaClass();
            if (lsidClass == null || !lsidClass.equals(klass)) continue;
            if (indexes == null) {
                ++count;
                continue;
            }
            int[] lsidIndexes = lsid.getIndexes();
            int n = Math.min(indexes.length, lsidIndexes.length);
            boolean match = true;
            for (int i = 0; i < n; ++i) {
                if (lsidIndexes[i] == indexes[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countCachedReferences(Class<? extends IObject> source, Class<? extends IObject> target) {
        if (source == null && target == null) {
            int count = 0;
            for (LSID key : this.referenceCache.keySet()) {
                count += this.referenceCache.get(key).size();
            }
            return count;
        }
        int count = 0;
        if (target == null) {
            for (LSID lsid : this.referenceCache.keySet()) {
                Class containerClass = lsid.getJavaClass();
                if (!containerClass.equals(source)) continue;
                ++count;
            }
            return count;
        }
        if (source == null) {
            for (LSID sourceLSID : this.referenceCache.keySet()) {
                for (LSID targetLSID : this.referenceCache.get(sourceLSID)) {
                    Class containerClass = targetLSID.getJavaClass();
                    if (!containerClass.equals(target)) continue;
                    ++count;
                }
            }
            return count;
        }
        for (LSID sourceLSID : this.referenceCache.keySet()) {
            Class sourceClass = sourceLSID.getJavaClass();
            if (!sourceClass.equals(source)) continue;
            for (LSID targetLSID : this.referenceCache.get(sourceLSID)) {
                Class targetClass = targetLSID.getJavaClass();
                if (!targetClass.equals(target)) continue;
                ++count;
            }
        }
        return count;
    }

    private Arc getArc(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Arc.class, indexes);
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Arc.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Arc.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Arc.class, id, o);
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setPower(this.toRType(power));
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setArcType(ome.xml.model.enums.ArcType type, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setType((ArcType)this.getEnumeration(ArcType.class, type.toString()));
    }

    private BooleanAnnotation getBooleanAnnotation(int booleanAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.BOOLEAN_ANNOTATION_INDEX, booleanAnnotationIndex);
        return this.getSourceObject(BooleanAnnotation.class, indexes);
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        this.checkDuplicateLSID(BooleanAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.BOOLEAN_ANNOTATION_INDEX, booleanAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(BooleanAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(BooleanAnnotation.class, id, o);
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getBooleanAnnotation(booleanAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getBooleanAnnotation(booleanAnnotationIndex);
        o.setBoolValue(this.toRType(value));
    }

    public Channel getChannel(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        Channel c = this.getSourceObject(Channel.class, indexes);
        c.setLogicalChannel(this.getSourceObject(LogicalChannel.class, indexes));
        return this.getSourceObject(Channel.class, indexes);
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        this.checkDuplicateLSID(Channel.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        IObjectContainer o = this.getIObjectContainer(Channel.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Channel.class, id, o);
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setMode((omero.model.AcquisitionMode)this.getEnumeration(omero.model.AcquisitionMode.class, acquisitionMode.toString()));
    }

    public void setChannelColor(Integer color, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        Color c = new Color(color >>> 8 | color << 24);
        o.setRed(this.toRType(c.getRed()));
        o.setGreen(this.toRType(c.getGreen()));
        o.setBlue(this.toRType(c.getBlue()));
        o.setAlpha(this.toRType(c.getAlpha()));
    }

    public void setChannelContrastMethod(ome.xml.model.enums.ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setContrastMethod((ContrastMethod)this.getEnumeration(ContrastMethod.class, contrastMethod.toString()));
    }

    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setEmissionWave(this.toRType((NonNegativeInteger)emissionWavelength));
    }

    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setExcitationWave(this.toRType((NonNegativeInteger)excitationWavelength));
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        LSID key = new LSID(LogicalChannel.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(filterSet));
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setFluor(this.toRType(fluor));
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setIllumination((Illumination)this.getEnumeration(Illumination.class, illuminationType.toString()));
    }

    public void setChannelNDFilter(Double ndfilter, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setNdFilter(this.toRType(ndfilter));
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setName(this.toRType(name));
    }

    public void setChannelOTFRef(String otf, int imageIndex, int channelIndex) {
        LSID key = new LSID(Channel.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(otf));
    }

    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setPinHoleSize(this.toRType(pinholeSize));
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setPockelCellSetting(this.toRType(pockelCellSetting));
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setSamplesPerPixel(this.toRType((NonNegativeInteger)samplesPerPixel));
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        LSID key = new LSID(Channel.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(annotation));
    }

    private LightSettings getChannelLightSourceSettings(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        return this.getSourceObject(LightSettings.class, indexes);
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        this.getChannelLightSourceSettings(imageIndex, channelIndex);
        LSID key = new LSID(LightSettings.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(id));
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        LightSettings o = this.getChannelLightSourceSettings(imageIndex, channelIndex);
        o.setAttenuation(this.toRType(attenuation));
    }

    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        LightSettings o = this.getChannelLightSourceSettings(imageIndex, channelIndex);
        o.setWavelength(this.toRType((NonNegativeInteger)wavelength));
    }

    public void setDatasetID(String id, int datasetIndex) {
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
    }

    public void setDatasetDescription(String description, int datasetIndex) {
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
    }

    public void setDatasetGroupRef(String group, int datasetIndex) {
    }

    public void setDatasetName(String name, int datasetIndex) {
    }

    public void setDatasetProjectRef(String project, int datasetIndex, int projectRefIndex) {
    }

    public Detector getDetector(int instrumentIndex, int detectorIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DETECTOR_INDEX, detectorIndex);
        return this.getSourceObject(Detector.class, indexes);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        this.checkDuplicateLSID(Detector.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DETECTOR_INDEX, detectorIndex);
        IObjectContainer o = this.getIObjectContainer(Detector.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Detector.class, id, o);
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setAmplificationGain(this.toRType(amplificationGain));
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setGain(this.toRType(gain));
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setModel(this.toRType(model));
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setType((omero.model.DetectorType)this.getEnumeration(omero.model.DetectorType.class, type.toString()));
    }

    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setVoltage(this.toRType(voltage));
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setZoom(this.toRType(zoom));
    }

    private DetectorSettings getDetectorSettings(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        return this.getSourceObject(DetectorSettings.class, indexes);
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        this.getDetectorSettings(imageIndex, channelIndex);
        LSID key = new LSID(DetectorSettings.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(id));
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setBinning((omero.model.Binning)this.getEnumeration(omero.model.Binning.class, binning.toString()));
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setGain(this.toRType(gain));
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setReadOutRate(this.toRType(readOutRate));
    }

    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setVoltage(this.toRType(voltage));
    }

    private Dichroic getDichroic(int instrumentIndex, int dichroicIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DICHROIC_INDEX, dichroicIndex);
        return this.getSourceObject(Dichroic.class, indexes);
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        this.checkDuplicateLSID(Dichroic.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DICHROIC_INDEX, dichroicIndex);
        IObjectContainer o = this.getIObjectContainer(Dichroic.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Dichroic.class, id, o);
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setModel(this.toRType(model));
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
    }

    private DoubleAnnotation getDoubleAnnotation(int doubleAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.DOUBLE_ANNOTATION_INDEX, doubleAnnotationIndex);
        return this.getSourceObject(DoubleAnnotation.class, indexes);
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        this.checkDuplicateLSID(DoubleAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.DOUBLE_ANNOTATION_INDEX, doubleAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(DoubleAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(DoubleAnnotation.class, id, o);
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getDoubleAnnotation(doubleAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getDoubleAnnotation(doubleAnnotationIndex);
        o.setDoubleValue(this.toRType(value));
    }

    private Ellipse getEllipse(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Ellipse.class, indexes);
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Ellipse.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Ellipse.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Ellipse.class, id, o);
    }

    public void setEllipseDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setEllipseFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setEllipseLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setEllipseName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setRx(this.toRType(radiusX));
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setRy(this.toRType(radiusY));
    }

    public void setEllipseStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setStrokeWidth(this.toRType(strokeWidth.intValue()));
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setEllipseTransform(String transform, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setCx(this.toRType(x));
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setCy(this.toRType(y));
    }

    private Experiment getExperiment(int experimentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        return this.getSourceObject(Experiment.class, indexes);
    }

    public void setExperimentID(String id, int experimentIndex) {
        this.checkDuplicateLSID(Experiment.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        IObjectContainer o = this.getIObjectContainer(Experiment.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Experiment.class, id, o);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setDescription(this.toRType(description));
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setType((omero.model.ExperimentType)this.getEnumeration(omero.model.ExperimentType.class, type.toString()));
    }

    public void setExperimenterID(String id, int experimenterIndex) {
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
    }

    public void setExperimenterDisplayName(String displayName, int experimenterIndex) {
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
    }

    public void setExperimenterGroupRef(String group, int experimenterIndex, int groupRefIndex) {
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
    }

    public Filament getFilament(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Filament.class, indexes);
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Filament.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Filament.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Filament.class, id, o);
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setPower(this.toRType(power));
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setFilamentType(ome.xml.model.enums.FilamentType type, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setType((FilamentType)this.getEnumeration(FilamentType.class, type.toString()));
    }

    private FileAnnotation getFileAnnotation(int fileAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FILE_ANNOTATION_INDEX, fileAnnotationIndex);
        return this.getSourceObject(FileAnnotation.class, indexes);
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        this.checkDuplicateLSID(FileAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FILE_ANNOTATION_INDEX, fileAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(FileAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(FileAnnotation.class, id, o);
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        FileAnnotation o = this.getFileAnnotation(fileAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setFileAnnotationBinaryFileFileName(String fileName, int fileAnnotationIndex) {
    }

    public void setFileAnnotationBinaryFileMIMEType(String mimetype, int fileAnnotationIndex) {
    }

    public void setFileAnnotationBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
    }

    private Filter getFilter(int instrumentIndex, int filterIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_INDEX, filterIndex);
        return this.getSourceObject(Filter.class, indexes);
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        this.checkDuplicateLSID(Filter.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_INDEX, filterIndex);
        IObjectContainer o = this.getIObjectContainer(Filter.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Filter.class, id, o);
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setFilterWheel(this.toRType(filterWheel));
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setType((omero.model.FilterType)this.getEnumeration(omero.model.FilterType.class, type.toString()));
    }

    public FilterSet getFilterSet(int instrumentIndex, int filterSetIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_SET_INDEX, filterSetIndex);
        return this.getSourceObject(FilterSet.class, indexes);
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        this.checkDuplicateLSID(FilterSet.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_SET_INDEX, filterSetIndex);
        IObjectContainer o = this.getIObjectContainer(FilterSet.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(FilterSet.class, id, o);
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(dichroic));
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        emissionFilter = emissionFilter + OMERO_EMISSION_FILTER_SUFFIX;
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(emissionFilter));
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        excitationFilter = excitationFilter + OMERO_EXCITATION_FILTER_SUFFIX;
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(excitationFilter));
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
    }

    public void setGroupID(String id, int groupIndex) {
    }

    public void setGroupContact(String contact, int groupIndex) {
    }

    public void setGroupDescription(String description, int groupIndex) {
    }

    public void setGroupLeader(String leader, int groupIndex) {
    }

    public void setGroupName(String name, int groupIndex) {
    }

    private Image getImage(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        Image o = this.getSourceObject(Image.class, indexes);
        o.setFormat(this.getImageFormat());
        return o;
    }

    public void setImageID(String id, int imageIndex) {
        this.checkDuplicateLSID(Image.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        IObjectContainer o = this.getIObjectContainer(Image.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Image.class, id, o);
    }

    public void setImageAcquiredDate(String acquiredDate, int imageIndex) {
        if (acquiredDate == null) {
            return;
        }
        Image o = this.getImage(imageIndex);
        o.setAcquisitionDate(this.toRType(this.timestampFromXmlString(acquiredDate)));
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setImageDatasetRef(String dataset, int imageIndex, int datasetRefIndex) {
    }

    public void setImageDescription(String description, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setDescription(this.toRType(description));
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(experiment));
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
    }

    public void setImageGroupRef(String group, int imageIndex) {
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(instrument));
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(microbeamManipulation));
    }

    public void setImageName(String name, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setName(this.toRType(name));
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(roi));
    }

    public ObjectiveSettings getImageObjectiveSettings(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(ObjectiveSettings.class, indexes);
    }

    public void setImageObjectiveSettingsID(String id, int imageIndex) {
        this.getImageObjectiveSettings(imageIndex);
        LSID key = new LSID(ObjectiveSettings.class, new int[]{imageIndex});
        this.addReference(key, new LSID(id));
    }

    public void setImageObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        ObjectiveSettings o = this.getImageObjectiveSettings(imageIndex);
        o.setCorrectionCollar(this.toRType(correctionCollar));
    }

    public void setImageObjectiveSettingsMedium(ome.xml.model.enums.Medium medium, int imageIndex) {
        ObjectiveSettings o = this.getImageObjectiveSettings(imageIndex);
        o.setMedium((Medium)this.getEnumeration(Medium.class, medium.toString()));
    }

    public void setImageObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        ObjectiveSettings o = this.getImageObjectiveSettings(imageIndex);
        o.setRefractiveIndex(this.toRType(refractiveIndex));
    }

    public ImagingEnvironment getImagingEnvironment(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(ImagingEnvironment.class, indexes);
    }

    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setAirPressure(this.toRType(airPressure));
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2percent, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setCo2percent(this.toRType(co2percent));
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setHumidity(this.toRType(humidity));
    }

    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setTemperature(this.toRType(temperature));
    }

    private Instrument getInstrument(int instrumentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        return this.getSourceObject(Instrument.class, indexes);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        this.checkDuplicateLSID(Instrument.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        IObjectContainer o = this.getIObjectContainer(Instrument.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Instrument.class, id, o);
    }

    public Laser getLaser(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Laser.class, indexes);
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Laser.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Laser.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Laser.class, id, o);
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setFrequencyMultiplication(this.toRType((NonNegativeInteger)frequencyMultiplication));
    }

    public void setLaserLaserMedium(ome.xml.model.enums.LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setLaserMedium((LaserMedium)this.getEnumeration(LaserMedium.class, laserMedium.toString()));
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPockelCell(this.toRType(pockelCell));
    }

    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPower(this.toRType(power));
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPulse((omero.model.Pulse)this.getEnumeration(omero.model.Pulse.class, pulse.toString()));
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        LSID key = new LSID(Laser.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(pump));
    }

    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setRepetitionRate(this.toRType(repetitionRate));
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setTuneable(this.toRType(tuneable));
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setType((omero.model.LaserType)this.getEnumeration(omero.model.LaserType.class, type.toString()));
    }

    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setWavelength(this.toRType((NonNegativeInteger)wavelength));
    }

    public LightEmittingDiode getLightEmittingDiode(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(LightEmittingDiode.class, indexes);
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(LightEmittingDiode.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(LightEmittingDiode.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(LightEmittingDiode.class, id, o);
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setPower(this.toRType(power));
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(dichroic));
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        emissionFilter = emissionFilter + OMERO_EMISSION_FILTER_SUFFIX;
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(emissionFilter));
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        excitationFilter = excitationFilter + OMERO_EXCITATION_FILTER_SUFFIX;
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(excitationFilter));
    }

    public Line getLine(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Line.class, indexes);
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Line.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Line.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Line.class, id, o);
    }

    public void setLineDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setLineFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setLineLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setLineName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setLineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeWidth(this.toRType(stroke));
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeWidth(this.toRType(strokeWidth.intValue()));
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setLineTransform(String transform, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setX1(this.toRType(x1));
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setX2(this.toRType(x2));
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setY1(this.toRType(y1));
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setY2(this.toRType(y2));
    }

    public ListAnnotation getListAnnotation(int listAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LIST_ANNOTATION_INDEX, listAnnotationIndex);
        return this.getSourceObject(ListAnnotation.class, indexes);
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        this.checkDuplicateLSID(ListAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LIST_ANNOTATION_INDEX, listAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(ListAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(ListAnnotation.class, id, o);
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(Annotation.class, new int[]{listAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        ListAnnotation o = this.getListAnnotation(listAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public LongAnnotation getLongAnnotation(int longAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LONG_ANNOTATION_INDEX, longAnnotationIndex);
        return this.getSourceObject(LongAnnotation.class, indexes);
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        this.checkDuplicateLSID(LongAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LONG_ANNOTATION_INDEX, longAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(LongAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(LongAnnotation.class, id, o);
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        LongAnnotation o = this.getLongAnnotation(longAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        LongAnnotation o = this.getLongAnnotation(longAnnotationIndex);
        o.setLongValue(this.toRType(value));
    }

    public Mask getMask(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Mask.class, indexes);
    }

    public void setMaskBinData(byte[] binData, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setBytes(binData);
        }
    }

    public void setMaskDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setMaskFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Mask.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Mask.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Mask.class, id, o);
    }

    public void setMaskLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setMaskName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setMaskStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setMaskTransform(String transform, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setHeight(this.toRType(height));
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setWidth(this.toRType(width));
    }

    public MicrobeamManipulation getMicrobeamManipulation(int experimentIndex, int microbeamManipulationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        return this.getSourceObject(MicrobeamManipulation.class, indexes);
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        this.checkDuplicateLSID(MicrobeamManipulation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        IObjectContainer o = this.getIObjectContainer(MicrobeamManipulation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(MicrobeamManipulation.class, id, o);
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        LSID key = new LSID(MicrobeamManipulation.class, new int[]{experimentIndex, microbeamManipulationIndex});
        this.addReference(key, new LSID(roi));
    }

    public void setMicrobeamManipulationType(ome.xml.model.enums.MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        MicrobeamManipulation o = this.getMicrobeamManipulation(experimentIndex, microbeamManipulationIndex);
        o.setType((MicrobeamManipulationType)this.getEnumeration(MicrobeamManipulationType.class, type.toString()));
    }

    public LightSettings getMicrobeamManipulationLightSourceSettings(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        indexes.put(Index.LIGHT_SOURCE_SETTINGS_INDEX, lightSourceSettingsIndex);
        return this.getSourceObject(LightSettings.class, indexes);
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        LSID key = new LSID(LightSettings.class, new int[]{experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex});
        this.addReference(key, new LSID(id));
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LightSettings o = this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        o.setAttenuation(this.toRType(attenuation));
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LightSettings o = this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        o.setWavelength(this.toRType((NonNegativeInteger)wavelength));
    }

    private Microscope getMicroscope(int instrumentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        return this.getSourceObject(Microscope.class, indexes);
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setModel(this.toRType(model));
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setType((omero.model.MicroscopeType)this.getEnumeration(omero.model.MicroscopeType.class, type.toString()));
    }

    public OTF getOTF(int instrumentIndex, int OTFIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OTF_INDEX, OTFIndex);
        return this.getSourceObject(OTF.class, indexes);
    }

    private OriginalFile getOriginalFile(int instrumentIndex, int OTFIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OTF_INDEX, OTFIndex);
        return this.getSourceObject(OriginalFile.class, indexes);
    }

    public void setOTFID(String id, int instrumentIndex, int OTFIndex) {
        this.checkDuplicateLSID(OTF.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OTF_INDEX, OTFIndex);
        IObjectContainer o = this.getIObjectContainer(OTF.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(OTF.class, id, o);
    }

    public void setOTFBinaryFileFileName(String fileName, int instrumentIndex, int OTFIndex) {
        OriginalFile o = this.getOriginalFile(instrumentIndex, OTFIndex);
        o.setName(this.toRType(fileName));
    }

    public void setOTFBinaryFileMIMEType(String mimetype, int instrumentIndex, int OTFIndex) {
        OriginalFile o = this.getOriginalFile(instrumentIndex, OTFIndex);
        o.setMimetype(this.toRType(mimetype));
    }

    public void setOTFBinaryFileSize(NonNegativeLong size, int instrumentIndex, int OTFIndex) {
        OriginalFile o = this.getOriginalFile(instrumentIndex, OTFIndex);
        o.setSize(this.toRType(size));
    }

    public void setOTFFilterSetRef(String filterSet, int instrumentIndex, int OTFIndex) {
        LSID key = new LSID(OTF.class, new int[]{instrumentIndex, OTFIndex});
        this.addReference(key, new LSID(filterSet));
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int OTFIndex) {
        OTF o = this.getOTF(instrumentIndex, OTFIndex);
        o.setOpticalAxisAveraged(this.toRType(opticalAxisAveraged));
    }

    public void setOTFSizeX(PositiveInteger sizeX, int instrumentIndex, int OTFIndex) {
        OTF o = this.getOTF(instrumentIndex, OTFIndex);
        o.setSizeX(this.toRType((NonNegativeInteger)sizeX));
    }

    public void setOTFSizeY(PositiveInteger sizeY, int instrumentIndex, int OTFIndex) {
        OTF o = this.getOTF(instrumentIndex, OTFIndex);
        o.setSizeY(this.toRType((NonNegativeInteger)sizeY));
    }

    public void setOTFType(PixelType type, int instrumentIndex, int OTFIndex) {
        OTF o = this.getOTF(instrumentIndex, OTFIndex);
        o.setPixelsType((PixelsType)this.getEnumeration(PixelsType.class, type.toString()));
    }

    private ObjectiveSettings getOTFObjectiveSettings(int instrumentIndex, int OTFIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OTF_INDEX, OTFIndex);
        return this.getSourceObject(ObjectiveSettings.class, indexes);
    }

    public void setOTFObjectiveSettingsID(String id, int instrumentIndex, int OTFIndex) {
        this.getOTFObjectiveSettings(instrumentIndex, OTFIndex);
        LSID key = new LSID(OTF.class, new int[]{instrumentIndex, OTFIndex});
        this.addReference(key, new LSID(id));
    }

    public void setOTFObjectiveSettingsCorrectionCollar(Double correctionCollar, int instrumentIndex, int OTFIndex) {
        ObjectiveSettings o = this.getOTFObjectiveSettings(instrumentIndex, OTFIndex);
        o.setCorrectionCollar(this.toRType(correctionCollar));
    }

    public void setOTFObjectiveSettingsMedium(ome.xml.model.enums.Medium medium, int instrumentIndex, int OTFIndex) {
        ObjectiveSettings o = this.getOTFObjectiveSettings(instrumentIndex, OTFIndex);
        o.setMedium((Medium)this.getEnumeration(Medium.class, medium.toString()));
    }

    public void setOTFObjectiveSettingsRefractiveIndex(Double refractiveIndex, int instrumentIndex, int OTFIndex) {
        ObjectiveSettings o = this.getOTFObjectiveSettings(instrumentIndex, OTFIndex);
        o.setRefractiveIndex(this.toRType(refractiveIndex));
    }

    public Objective getObjective(int instrumentIndex, int objectiveIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OBJECTIVE_INDEX, objectiveIndex);
        return this.getSourceObject(Objective.class, indexes);
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCalibratedMagnification(this.toRType(calibratedMagnification));
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCorrection((omero.model.Correction)this.getEnumeration(omero.model.Correction.class, correction.toString()));
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        this.checkDuplicateLSID(Objective.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OBJECTIVE_INDEX, objectiveIndex);
        IObjectContainer o = this.getIObjectContainer(Objective.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Objective.class, id, o);
    }

    public void setObjectiveImmersion(ome.xml.model.enums.Immersion immersion, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setImmersion((Immersion)this.getEnumeration(Immersion.class, immersion.toString()));
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setIris(this.toRType(iris));
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setLensNA(this.toRType(lensNA));
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setModel(this.toRType(model));
    }

    public void setObjectiveNominalMagnification(PositiveInteger nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setNominalMagnification(this.toRType((NonNegativeInteger)nominalMagnification));
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setWorkingDistance(this.toRType(workingDistance));
    }

    private Path getPath(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Path.class, indexes);
    }

    public void setPathDefinition(String definition, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setD(this.toRType(definition));
    }

    public void setPathDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setPathFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setPathFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setPathID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Path.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Path.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Path.class, id, o);
    }

    public void setPathLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setPathName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setPathStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setPathStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPathStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setPathTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPathTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPathTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPathTransform(String transform, int ROIIndex, int shapeIndex) {
        Path o = this.getPath(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    private Pixels getPixels(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        Pixels p = this.getSourceObject(Pixels.class, indexes);
        p.setSha1(rtypes.rstring((String)"Foo"));
        return p;
    }

    public void setPixelsID(String id, int imageIndex) {
        this.checkDuplicateLSID(Pixels.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        IObjectContainer o = this.getIObjectContainer(Pixels.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Pixels.class, id, o);
    }

    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        LSID key = new LSID(Pixels.class, new int[]{imageIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setDimensionOrder((omero.model.DimensionOrder)this.getEnumeration(omero.model.DimensionOrder.class, "XYZCT"));
    }

    public void setPixelsPhysicalSizeX(Double physicalSizeX, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeX(this.toRType(physicalSizeX));
    }

    public void setPixelsPhysicalSizeY(Double physicalSizeY, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeY(this.toRType(physicalSizeY));
    }

    public void setPixelsPhysicalSizeZ(Double physicalSizeZ, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeZ(this.toRType(physicalSizeZ));
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeC(this.toRType((NonNegativeInteger)sizeC));
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeT(this.toRType((NonNegativeInteger)sizeT));
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeX(this.toRType((NonNegativeInteger)sizeX));
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeY(this.toRType((NonNegativeInteger)sizeY));
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeZ(this.toRType((NonNegativeInteger)sizeZ));
    }

    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setTimeIncrement(this.toRType(timeIncrement));
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPixelsType((PixelsType)this.getEnumeration(PixelsType.class, type.toString()));
    }

    private PlaneInfo getPlane(int imageIndex, int planeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.PLANE_INDEX, planeIndex);
        return this.getSourceObject(PlaneInfo.class, indexes);
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        LSID key = new LSID(PlaneInfo.class, new int[]{imageIndex, planeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setDeltaT(this.toRType(deltaT));
    }

    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setExposureTime(this.toRType(exposureTime));
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
    }

    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionX(this.toRType(positionX));
    }

    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionY(this.toRType(positionY));
    }

    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionZ(this.toRType(positionZ));
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    private PlateAcquisition getPlateAcquisition(int plateIndex, int plateAcquisitionIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.PLATE_ACQUISITION_INDEX, plateAcquisitionIndex);
        return this.getSourceObject(PlateAcquisition.class, indexes);
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        LSID key = new LSID(PlateAcquisition.class, new int[]{plateIndex, plateAcquisitionIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setDescription(this.toRType(description));
    }

    public void setPlateAcquisitionEndTime(String endTime, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setEndTime(this.toRType(this.timestampFromXmlString(endTime)));
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        this.checkDuplicateLSID(PlateAcquisition.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.PLATE_ACQUISITION_INDEX, plateAcquisitionIndex);
        IObjectContainer o = this.getIObjectContainer(PlateAcquisition.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(PlateAcquisition.class, id, o);
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setMaximumFieldCount(this.toRType((NonNegativeInteger)maximumFieldCount));
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setName(this.toRType(name));
    }

    public void setPlateAcquisitionStartTime(String startTime, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setStartTime(this.toRType(this.timestampFromXmlString(startTime)));
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        LSID key = new LSID(PlateAcquisition.class, new int[]{plateIndex, plateAcquisitionIndex});
        this.addReference(key, new LSID(wellSample));
    }

    private Plate getPlate(int plateIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        return this.getSourceObject(Plate.class, indexes);
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        LSID key = new LSID(Plate.class, new int[]{plateIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setColumnNamingConvention(this.toRType(columnNamingConvention));
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setCols(this.toRType((NonNegativeInteger)columns));
    }

    public void setPlateDescription(String description, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setDescription(this.toRType(description));
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setPlateID(String id, int plateIndex) {
        this.checkDuplicateLSID(Plate.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        IObjectContainer o = this.getIObjectContainer(Plate.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Plate.class, id, o);
    }

    public void setPlateName(String name, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setName(this.toRType(name));
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setRowNamingConvention(this.toRType(rowNamingConvention));
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setRows(this.toRType((NonNegativeInteger)rows));
    }

    public void setPlateScreenRef(String screen, int plateIndex, int screenRefIndex) {
        LSID key = new LSID(Plate.class, new int[]{plateIndex});
        this.addReference(key, new LSID(screen));
    }

    public void setPlateStatus(String status, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setStatus(this.toRType(status));
    }

    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setWellOriginX(this.toRType(wellOriginX));
    }

    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setWellOriginY(this.toRType(wellOriginY));
    }

    private Point getPoint(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Point.class, indexes);
    }

    public void setPointDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setPointFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Point.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Point.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Point.class, id, o);
    }

    public void setPointLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setPointName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setPointStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPointTransform(String transform, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setCx(this.toRType(x));
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setCy(this.toRType(y));
    }

    private Polyline getPolyline(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Polyline.class, indexes);
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Polyline.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Polyline.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Polyline.class, id, o);
    }

    public void setPolylineClosed(Boolean closed, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setPolylineLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setPoints(this.toRType(points));
    }

    public void setPolylineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPolylineTransform(String transform, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setProjectID(String id, int projectIndex) {
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
    }

    public void setProjectDescription(String description, int projectIndex) {
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
    }

    public void setProjectGroupRef(String group, int projectIndex) {
    }

    public void setProjectName(String name, int projectIndex) {
    }

    private Roi getROI(int ROIIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        return this.getSourceObject(Roi.class, indexes);
    }

    public void setROIID(String id, int ROIIndex) {
        this.checkDuplicateLSID(Roi.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        IObjectContainer o = this.getIObjectContainer(Roi.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Roi.class, id, o);
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
    }

    public void setROIDescription(String description, int ROIIndex) {
        Roi o = this.getROI(ROIIndex);
        o.setDescription(this.toRType(description));
    }

    public void setROIName(String name, int ROIIndex) {
    }

    public void setROINamespace(String namespace, int ROIIndex) {
    }

    private Reagent getReagent(int screenIndex, int reagentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        indexes.put(Index.REAGENT_INDEX, reagentIndex);
        return this.getSourceObject(Reagent.class, indexes);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        this.checkDuplicateLSID(Reagent.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        indexes.put(Index.REAGENT_INDEX, reagentIndex);
        IObjectContainer o = this.getIObjectContainer(Reagent.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Reagent.class, id, o);
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        LSID key = new LSID(Reagent.class, new int[]{screenIndex, reagentIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setDescription(this.toRType(description));
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setName(this.toRType(name));
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setReagentIdentifier(this.toRType(reagentIdentifier));
    }

    private Rect getRectangle(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Rect.class, indexes);
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Rect.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Rect.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Rect.class, id, o);
    }

    public void setRectangleDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setHeight(this.toRType(height));
    }

    public void setRectangleLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setRectangleTransform(String transform, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setWidth(this.toRType(width));
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        Rect o = this.getRectangle(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setRoot(Object root) {
    }

    private Screen getScreen(int screenIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        return this.getSourceObject(Screen.class, indexes);
    }

    public void setScreenID(String id, int screenIndex) {
        this.checkDuplicateLSID(Screen.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        IObjectContainer o = this.getIObjectContainer(Screen.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Screen.class, id, o);
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        LSID key = new LSID(Screen.class, new int[]{screenIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setScreenDescription(String description, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setDescription(this.toRType(description));
    }

    public void setScreenName(String name, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setName(this.toRType(name));
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        LSID key = new LSID(Screen.class, new int[]{screenIndex});
        this.addReference(key, new LSID(plate));
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolDescription(this.toRType(protocolDescription));
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolIdentifier(this.toRType(protocolIdentifier));
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setReagentSetDescription(this.toRType(reagentSetDescription));
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setReagentSetIdentifier(this.toRType(reagentSetIdentifier));
    }

    public void setScreenType(String type, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setType(this.toRType(type));
    }

    private StageLabel getStageLabel(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(StageLabel.class, indexes);
    }

    public void setStageLabelName(String name, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setName(this.toRType(name));
    }

    public void setStageLabelX(Double x, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionX(this.toRType(x));
    }

    public void setStageLabelY(Double y, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionY(this.toRType(y));
    }

    public void setStageLabelZ(Double z, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionZ(this.toRType(z));
    }

    private CommentAnnotation getCommentAnnotation(int commentAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.COMMENT_ANNOTATION_INDEX, commentAnnotationIndex);
        return this.getSourceObject(CommentAnnotation.class, indexes);
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        this.checkDuplicateLSID(CommentAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.COMMENT_ANNOTATION_INDEX, commentAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(CommentAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(CommentAnnotation.class, id, o);
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        CommentAnnotation o = this.getCommentAnnotation(commentAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        CommentAnnotation o = this.getCommentAnnotation(commentAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    private Label getText(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Label.class, indexes);
    }

    public void setTextID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Label.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Label.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Label.class, id, o);
    }

    public void setTextDescription(String description, int ROIIndex, int shapeIndex) {
    }

    public void setTextFill(Integer fill, int ROIIndex, int shapeIndex) {
    }

    public void setTextFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setFontSize(this.toRType(fontSize));
    }

    public void setTextLabel(String label, int ROIIndex, int shapeIndex) {
    }

    public void setTextName(String name, int ROIIndex, int shapeIndex) {
    }

    public void setTextStroke(Integer stroke, int ROIIndex, int shapeIndex) {
    }

    public void setTextStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setTextStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
    }

    public void setTextTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setTextTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setTextTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setTextTransform(String transform, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setTextValue(String value, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(value));
    }

    public void setTextX(Double x, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setTextY(Double y, int ROIIndex, int shapeIndex) {
        Label o = this.getText(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
    }

    private TimestampAnnotation getTimestampAnnotation(int timestampAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TIMESTAMP_ANNOTATION_INDEX, timestampAnnotationIndex);
        return this.getSourceObject(TimestampAnnotation.class, indexes);
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        this.checkDuplicateLSID(TimestampAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TIMESTAMP_ANNOTATION_INDEX, timestampAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TimestampAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TimestampAnnotation.class, id, o);
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getTimestampAnnotation(timestampAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTimestampAnnotationValue(String value, int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getTimestampAnnotation(timestampAnnotationIndex);
        o.setTimeValue(this.toRType(this.timestampFromXmlString(value)));
    }

    private TransmittanceRange getTransmittanceRange(int instrumentIndex, int filterIndex) {
        Filter filter = this.getFilter(instrumentIndex, filterIndex);
        TransmittanceRange tm = filter.getTransmittanceRange();
        if (tm == null) {
            tm = new TransmittanceRangeI();
            filter.setTransmittanceRange(tm);
        }
        return tm;
    }

    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutIn(this.toRType((NonNegativeInteger)cutIn));
    }

    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutInTolerance(this.toRType(cutInTolerance));
    }

    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutOut(this.toRType((NonNegativeInteger)cutOut));
    }

    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutOutTolerance(this.toRType(cutOutTolerance));
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setTransmittance(this.toRType(transmittance));
    }

    public void setUUID(String uuid) {
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
    }

    public void setUUIDValue(String fileName, int imageIndex, int tiffDataIndex) {
    }

    private Well getWell(int plateIndex, int wellIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        return this.getSourceObject(Well.class, indexes);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        this.checkDuplicateLSID(Well.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        IObjectContainer o = this.getIObjectContainer(Well.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Well.class, id, o);
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        LSID key = new LSID(Well.class, new int[]{plateIndex, wellIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setWellColor(Integer color, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        Color c = new Color(color);
        o.setRed(this.toRType(c.getRed()));
        o.setGreen(this.toRType(c.getGreen()));
        o.setBlue(this.toRType(c.getBlue()));
        o.setAlpha(this.toRType(c.getAlpha()));
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setColumn(this.toRType(column));
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalDescription(this.toRType(externalDescription));
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        LSID key = new LSID(Well.class, new int[]{plateIndex, wellIndex});
        this.addReference(key, new LSID(reagent));
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setRow(this.toRType(row));
    }

    public void setWellStatus(String status, int plateIndex, int wellIndex) {
    }

    private WellSample getWellSample(int plateIndex, int wellIndex, int wellSampleIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        indexes.put(Index.WELL_SAMPLE_INDEX, wellSampleIndex);
        WellSample ws = this.getSourceObject(WellSample.class, indexes);
        return ws;
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.checkDuplicateLSID(WellSample.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        indexes.put(Index.WELL_SAMPLE_INDEX, wellSampleIndex);
        IObjectContainer o = this.getIObjectContainer(WellSample.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(WellSample.class, id, o);
    }

    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        LSID key = new LSID(WellSample.class, new int[]{plateIndex, wellIndex, wellSampleIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        LSID key = new LSID(WellSample.class, new int[]{plateIndex, wellIndex, wellSampleIndex});
        this.addReference(key, new LSID(image));
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
    }

    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosX(this.toRType(positionX));
    }

    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosY(this.toRType(positionY));
    }

    public void setWellSampleTimepoint(String timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (timepoint == null) {
            return;
        }
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setTimepoint(this.toRType(this.timestampFromXmlString(timepoint)));
    }

    private XmlAnnotation getXMLAnnotation(int XMLAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.XML_ANNOTATION_INDEX, XMLAnnotationIndex);
        return this.getSourceObject(XmlAnnotation.class, indexes);
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        this.checkDuplicateLSID(XmlAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.XML_ANNOTATION_INDEX, XMLAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(XmlAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(XmlAnnotation.class, id, o);
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        XmlAnnotation o = this.getXMLAnnotation(XMLAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        XmlAnnotation o = this.getXMLAnnotation(XMLAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(BooleanAnnotation.class, new int[]{booleanAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(CommentAnnotation.class, new int[]{commentAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(DoubleAnnotation.class, new int[]{doubleAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(FileAnnotation.class, new int[]{fileAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(LongAnnotation.class, new int[]{longAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
    }

    private TagAnnotation getTagAnnotation(int tagAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TAG_ANNOTATION_INDEX, tagAnnotationIndex);
        return this.getSourceObject(TagAnnotation.class, indexes);
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TagAnnotation.class, new int[]{tagAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        this.checkDuplicateLSID(TagAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TAG_ANNOTATION_INDEX, tagAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TagAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TagAnnotation.class, id, o);
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        TagAnnotation o = this.getTagAnnotation(tagAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        TagAnnotation o = this.getTagAnnotation(tagAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    private TermAnnotation getTermAnnotation(int termAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TERM_ANNOTATION_INDEX, termAnnotationIndex);
        return this.getSourceObject(TermAnnotation.class, indexes);
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TermAnnotation.class, new int[]{termAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        this.checkDuplicateLSID(TermAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TERM_ANNOTATION_INDEX, termAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TermAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TermAnnotation.class, id, o);
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        TermAnnotation o = this.getTermAnnotation(termAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        TermAnnotation o = this.getTermAnnotation(termAnnotationIndex);
        o.setTermValue(this.toRType(value));
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TimestampAnnotation.class, new int[]{timestampAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(XmlAnnotation.class, new int[]{XMLAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
    }
}

