/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.in.LeicaReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.ZipReader;
import loci.formats.meta.MetadataStore;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.Plane2D;
import omero.model.Channel;
import omero.model.Pixels;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEROWrapper
extends MinMaxCalculator {
    private static final Log log = LogFactory.getLog(OMEROWrapper.class);
    private ChannelSeparator separator;
    private ChannelFiller filler;
    public Boolean minMaxSet = null;
    private ImageReader iReader;
    private ImportConfig config;

    public OMEROWrapper(ImportConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("An ImportConfig must be instantitated \n in order to properly configure all readers.");
        }
        this.config = config;
        try {
            String readersPath = (String)config.readersPath.get();
            ClassList readers = ImageReader.getDefaultReaderClasses();
            readers.removeClass(ZipReader.class);
            if (readersPath != null) {
                Class<?> k = ((Object)((Object)this)).getClass();
                if (new File(readersPath).exists()) {
                    k = null;
                }
                readers = new ClassList(readersPath, IFormatReader.class, k);
            }
            this.iReader = new ImageReader(readers);
            this.filler = new ChannelFiller((IFormatReader)this.iReader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load readers.txt.");
        }
        this.separator = new ChannelSeparator((IFormatReader)this.filler);
        this.reader = this.separator;
        this.iReader.setMetadataFiltered(true);
        this.filler.setMetadataFiltered(true);
        this.separator.setMetadataFiltered(true);
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    public Plane2D openPlane2D(String id, int planeNumber, byte[] buf) throws FormatException, IOException {
        return this.openPlane2D(id, planeNumber, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public Plane2D openPlane2D(String id, int planeNumber, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        ByteBuffer plane;
        if (this.iReader.isRGB() || this.isLeicaReader()) {
            byte[] bytePlane = this.openBytes(planeNumber, x, y, w, h);
            plane = ByteBuffer.wrap(bytePlane);
        } else {
            plane = ByteBuffer.wrap(this.openBytes(planeNumber, buf, x, y, w, h));
        }
        return new Plane2D(plane, this.getPixelType(), this.isLittleEndian(), this.getSizeX(), this.getSizeY());
    }

    public boolean isLeicaReader() {
        return this.iReader.getReader() instanceof LeicaReader;
    }

    public boolean isMinMaxSet() throws FormatException, IOException {
        if (this.minMaxSet == null) {
            MetadataStore store = this.reader.getMetadataStore();
            int series = this.reader.getSeries();
            List pixels = (List)store.getRoot();
            if (pixels == null) {
                this.minMaxSet = true;
                return this.minMaxSet;
            }
            Pixels p = (Pixels)pixels.get(series);
            Channel c = p.getChannel(p.getSizeC().getValue() - 1);
            this.minMaxSet = c.getStatsInfo() == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.minMaxSet;
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(b, ndx);
        }
    }

    public void close() throws IOException {
        this.minMaxSet = null;
        super.close(false);
    }

    public ImageReader getImageReader() {
        return this.iReader;
    }

    public boolean isSPWReader() {
        String[] domains = this.reader.getDomains();
        return Arrays.asList(domains).contains("High-Content Screening (HCS)");
    }

    public MetadataOptions getMetadataOptions() {
        return this.iReader.getMetadataOptions();
    }

    public void setMetadataOptions(MetadataOptions options) {
        this.iReader.setMetadataOptions(options);
    }

    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.iReader.getSupportedMetadataLevels();
    }
}

