/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import omero.metadatastore.IObjectContainer;
import omero.model.Ellipse;
import omero.model.IObject;
import omero.model.Label;
import omero.model.Line;
import omero.model.Mask;
import omero.model.Path;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Rect;
import omero.model.Roi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShapeProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(ShapeProcessor.class);
    private static final List<Class<? extends IObject>> SHAPE_TYPES = new ArrayList<Class<? extends IObject>>();

    public void process(IObjectContainerStore store) throws ModelException {
        for (Class<? extends IObject> klass : SHAPE_TYPES) {
            List<IObjectContainer> containers = store.getIObjectContainers(klass);
            for (IObjectContainer container : containers) {
                Integer roiIndex = (Integer)container.indexes.get(Index.ROI_INDEX.getValue());
                LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                indexes.put(Index.ROI_INDEX, roiIndex);
                store.getIObjectContainer(Roi.class, indexes);
            }
        }
    }

    static {
        SHAPE_TYPES.add(Line.class);
        SHAPE_TYPES.add(Rect.class);
        SHAPE_TYPES.add(Mask.class);
        SHAPE_TYPES.add(Ellipse.class);
        SHAPE_TYPES.add(Point.class);
        SHAPE_TYPES.add(Polyline.class);
        SHAPE_TYPES.add(Path.class);
        SHAPE_TYPES.add(Label.class);
        SHAPE_TYPES.add(Polygon.class);
    }
}

