/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.List;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Plate;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TargetProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(TargetProcessor.class);

    public void process(IObjectContainerStore store) throws ModelException {
        IObject target = store.getUserSpecifiedTarget();
        if (target == null) {
            return;
        }
        List<IObjectContainer> containers = null;
        if (target instanceof Dataset) {
            containers = store.getIObjectContainers(Image.class);
        } else if (target instanceof Screen) {
            containers = store.getIObjectContainers(Plate.class);
        } else {
            throw new ModelException("Unable to handle target: " + target);
        }
        for (IObjectContainer container : containers) {
            LSID targetLSID = new LSID(container.LSID);
            LSID referenceLSID = new LSID(String.format("%s:%d", target.getClass().getName(), target.getId().getValue()));
            store.addReference(targetLSID, referenceLSID);
        }
    }
}

