/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.ObjectAdapter;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.AbstractRepositoryI;
import ome.services.scripts.ScriptRepoHelper;
import ome.services.util.Executor;
import ome.util.SqlAction;
import omero.ServerError;
import omero.ValidationException;
import omero.model.OriginalFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRepositoryI
extends AbstractRepositoryI {
    private static final Log log = LogFactory.getLog(ScriptRepositoryI.class);
    private final ScriptRepoHelper helper;

    public ScriptRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, SqlAction sql, String sessionUuid, ScriptRepoHelper helper) {
        super(oa, reg, ex, sql, sessionUuid, helper.getScriptDir());
        this.helper = helper;
    }

    public String generateRepoUuid() {
        return this.helper.getUuid();
    }

    public String getFilePath(OriginalFile file, Current __current) throws ServerError {
        String repo = this.getFileRepo(file);
        String uuid = this.getRepoUuid();
        if (repo == null || !repo.equals(uuid)) {
            throw new ValidationException(null, null, repo + " does not belong to this repository: " + uuid);
        }
        return file.getPath() == null ? null : file.getPath().getValue();
    }
}

