// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public enum EventType
{
    Create,
    Modify,
    Delete,
    All;

    public static final int _Create = 0;
    public static final int _Modify = 1;
    public static final int _Delete = 2;
    public static final int _All = 3;

    public static EventType
    convert(int val)
    {
        assert val >= 0 && val < 4;
        return values()[val];
    }

    public static EventType
    convert(String val)
    {
        try
        {
            return valueOf(val);
        }
        catch(java.lang.IllegalArgumentException ex)
        {
            return null;
        }
    }

    public int
    value()
    {
        return ordinal();
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeByte((byte)value());
    }

    public static EventType
    __read(IceInternal.BasicStream __is)
    {
        int __v = __is.readByte(4);
        return EventType.convert(__v);
    }
}
