/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierNodeHandle
extends AbstractHandle {
    private static final Color HANDLE_FILL_COLOR = Color.BLACK;
    private static final Color HANDLE_STROKE_COLOR = Color.WHITE;
    protected int index;
    private CompositeEdit edit;
    private BezierPath.Node oldNode;
    private Figure transformOwner;

    public BezierNodeHandle(BezierFigure owner, int index) {
        this(owner, index, owner);
    }

    public BezierNodeHandle(BezierFigure owner, int index, Figure transformOwner) {
        super(owner);
        this.index = index;
        this.transformOwner = transformOwner;
        transformOwner.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    @Override
    public void draw(Graphics2D g) {
        BezierFigure f = this.getOwner();
        int size = f.getNodeCount();
        boolean isClosed = f.isClosed();
        if (size > this.index) {
            BezierPath.Node v = f.getNode(this.index);
            if (v.mask == 0 || this.index == 0 && v.mask == 1 && !isClosed || this.index == size - 1 && v.mask == 2 && !isClosed) {
                this.drawRectangle(g, HANDLE_FILL_COLOR, HANDLE_STROKE_COLOR);
            } else if (v.mask == 1 || v.mask == 2 || this.index == 0 && !isClosed || this.index == size - 1 && !isClosed) {
                this.drawDiamond(g, HANDLE_FILL_COLOR, HANDLE_STROKE_COLOR);
            } else {
                this.drawCircle(g, HANDLE_FILL_COLOR, HANDLE_STROKE_COLOR);
            }
        }
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    protected Point getLocation() {
        if (this.getOwner().getNodeCount() > this.index) {
            Point2D.Double p = this.getOwner().getPoint(this.index, 0);
            if (AttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).transform(p, p);
            }
            return this.view.drawingToView(p);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getOwner().getNodeCount() > this.index ? this.getOwner().getNode(this.index) : null;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return r;
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        BezierFigure figure = this.getOwner();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double location = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
        this.oldNode = figure.getNode(this.index);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getOwner();
        figure.willChange();
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        if (AttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
            try {
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        BezierPath.Node n = figure.getNode(this.index);
        this.fireAreaInvalidated(n);
        n.moveTo(p);
        this.fireAreaInvalidated(n);
        figure.setNode(this.index, n);
        figure.changed();
    }

    private void fireAreaInvalidated(BezierPath.Node v) {
        Rectangle2D.Double dr = new Rectangle2D.Double(v.x[0], v.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            dr.add(v.x[i], v.y[i]);
        }
        Rectangle vr = this.view.drawingToView(dr);
        vr.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(vr);
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        BezierFigure f = this.getOwner();
        if ((modifiersEx & 0x3C0) != 0 && (modifiersEx & 0x800) == 0) {
            f.willChange();
            BezierPath.Node v = f.getNode(this.index);
            v.mask = this.index > 0 && this.index < f.getNodeCount() || f.isClosed() ? (v.mask + 3) % 4 : (this.index == 0 ? ((v.mask & 2) == 0 ? 2 : 0) : ((v.mask & 1) == 0 ? 1 : 0));
            f.setNode(this.index, v);
            f.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    @Override
    public void trackDoubleClick(Point p, int modifiersEx) {
        final BezierFigure f = this.getOwner();
        if (f.getNodeCount() > 2 && (modifiersEx & 0x380) == 0) {
            Rectangle invalidatedArea = this.getDrawingArea();
            f.willChange();
            final BezierPath.Node removedNode = f.removeNode(this.index);
            f.changed();
            this.fireHandleRequestRemove(invalidatedArea);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("bezierPath.joinSegment");
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    BezierNodeHandle.this.view.removeFromSelection(f);
                    f.willChange();
                    f.removeNode(BezierNodeHandle.this.index);
                    f.changed();
                    BezierNodeHandle.this.view.addToSelection(f);
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    BezierNodeHandle.this.view.removeFromSelection(f);
                    f.willChange();
                    f.addNode(BezierNodeHandle.this.index, removedNode);
                    f.changed();
                    BezierNodeHandle.this.view.addToSelection(f);
                }
            });
        }
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        int i;
        BezierFigure f = this.getOwner();
        LinkedList<Handle> list = new LinkedList<Handle>();
        BezierPath.Node v = f.getNode(this.index);
        if ((v.mask & 1) != 0 && (this.index != 0 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 1, this.getTransformOwner()));
        }
        if ((v.mask & 2) != 0 && (this.index < f.getNodeCount() - 1 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 2, this.getTransformOwner()));
        }
        if (this.index > 0 || f.isClosed()) {
            i = this.index == 0 ? f.getNodeCount() - 1 : this.index - 1;
            v = f.getNode(i);
            if ((v.mask & 2) != 0) {
                list.add(new BezierControlPointHandle(f, i, 2, this.getTransformOwner()));
            }
        }
        if (this.index < f.getNodeCount() - 1 || f.isClosed()) {
            i = this.index == f.getNodeCount() - 1 ? 0 : this.index + 1;
            v = f.getNode(i);
            if ((v.mask & 1) != 0) {
                list.add(new BezierControlPointHandle(f, i, 1, this.getTransformOwner()));
            }
        }
        return list;
    }

    @Override
    public String getToolTipText(Point p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        return node == null ? null : labels.getFormatted("bezierNodeHandle.tip", labels.getFormatted(node.getMask() == 0 ? "bezierNode.linearNode" : (node.getMask() == 3 ? "bezierNode.cubicNode" : "bezierNode.quadraticNode"), new Object[0]));
    }
}

