/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedDecoratedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopRectangleConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.io.Base64;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageFigure
extends AbstractAttributedDecoratedFigure
implements ImageHolderFigure {
    private Rectangle2D.Double rectangle;
    private byte[] imageData;
    private BufferedImage bufferedImage;

    public ImageFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public ImageFigure(double x, double y, double width, double height) {
        this.rectangle = new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    protected void drawFigure(Graphics2D g) {
        if (AttributeKeys.FILL_COLOR.get(this) != null) {
            g.setColor(AttributeKeys.FILL_COLOR.get(this));
            this.drawFill(g);
        }
        this.drawImage(g);
        if (AttributeKeys.STROKE_COLOR.get(this) != null && AttributeKeys.STROKE_WIDTH.get(this) > 0.0) {
            g.setStroke(AttributeKeys.getStroke(this));
            g.setColor(AttributeKeys.STROKE_COLOR.get(this));
            this.drawStroke(g);
        }
        if (AttributeKeys.TEXT_COLOR.get(this) != null) {
            if (AttributeKeys.TEXT_SHADOW_COLOR.get(this) != null && AttributeKeys.TEXT_SHADOW_OFFSET.get(this) != null) {
                Dimension2DDouble d = AttributeKeys.TEXT_SHADOW_OFFSET.get(this);
                g.translate(d.width, d.height);
                g.setColor(AttributeKeys.TEXT_SHADOW_COLOR.get(this));
                this.drawText(g);
                g.translate(-d.width, -d.height);
            }
            g.setColor(AttributeKeys.TEXT_COLOR.get(this));
            this.drawText(g);
        }
    }

    @Override
    protected void drawFill(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        Geom.grow(r, grow, grow);
        g.fill(r);
    }

    protected void drawImage(Graphics2D g) {
        BufferedImage image = this.getBufferedImage();
        if (image != null) {
            g.drawImage(image, (int)this.rectangle.x, (int)this.rectangle.y, (int)this.rectangle.width, (int)this.rectangle.height, null);
        } else {
            g.setStroke(new BasicStroke());
            g.setColor(Color.red);
            g.draw(this.rectangle);
            g.draw(new Line2D.Double(this.rectangle.x, this.rectangle.y, this.rectangle.x + this.rectangle.width, this.rectangle.y + this.rectangle.height));
            g.draw(new Line2D.Double(this.rectangle.x + this.rectangle.width, this.rectangle.y, this.rectangle.x, this.rectangle.y + this.rectangle.height));
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        Geom.grow(r, grow, grow);
        g.draw(r);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.rectangle.clone();
        return bounds;
    }

    @Override
    public Rectangle2D.Double getFigureDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(r, grow, grow);
        return r;
    }

    @Override
    public boolean figureContains(Point2D.Double p) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(r, grow, grow);
        return r.contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.rectangle.x = Math.min(anchor.x, lead.x);
        this.rectangle.y = Math.min(anchor.y, lead.y);
        this.rectangle.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.rectangle.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.rectangle.setRect((Rectangle2D.Double)geometry);
    }

    @Override
    public Object getTransformRestoreData() {
        return (Rectangle2D.Double)this.rectangle.clone();
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        return actions;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public ImageFigure clone() {
        ImageFigure that = (ImageFigure)super.clone();
        that.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return that;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        if (in.getElementCount("imageData") > 0) {
            in.openElement("imageData");
            String base64Data = in.getText();
            if (base64Data != null) {
                this.setImageData(Base64.decode(base64Data));
            }
            in.closeElement();
        }
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        if (this.getImageData() != null) {
            out.openElement("imageData");
            out.addText(Base64.encodeBytes(this.getImageData()));
            out.closeElement();
        }
    }

    public void setImage(byte[] imageData, BufferedImage bufferedImage) {
        this.willChange();
        this.imageData = imageData;
        this.bufferedImage = bufferedImage;
        this.changed();
    }

    public void setImageData(byte[] imageData) {
        this.willChange();
        this.imageData = imageData;
        this.bufferedImage = null;
        this.changed();
    }

    @Override
    public void setBufferedImage(BufferedImage image) {
        this.willChange();
        this.imageData = null;
        this.bufferedImage = image;
        this.changed();
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null && this.imageData != null) {
            try {
                this.bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageData));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.imageData = null;
            }
        }
        return this.bufferedImage;
    }

    public byte[] getImageData() {
        if (this.bufferedImage != null && this.imageData == null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.bufferedImage, "PNG", bout);
                bout.close();
                this.imageData = bout.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.bufferedImage = null;
            }
        }
        return this.imageData;
    }

    @Override
    public void loadImage(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.loadImage(in);
        }
        catch (Throwable t) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            IOException e = new IOException(labels.getFormatted("failedToLoadImage", file.getName()));
            e.initCause(t);
            throw e;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    @Override
    public void loadImage(InputStream in) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((bytesRead = in.read(buf)) > 0) {
            baos.write(buf, 0, bytesRead);
        }
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
        if (img == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            throw new IOException(labels.getFormatted("failedToLoadImage", in.toString()));
        }
        this.imageData = baos.toByteArray();
        this.bufferedImage = img;
    }
}

