/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddyapplication.text;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.jhotdraw.samples.teddyapplication.text.NumberedParagraphView;

public class NumberedViewFactory
implements ViewFactory {
    private boolean isLineNumbersVisible;

    public void setLineNumbersVisible(boolean newValue) {
        boolean oldValue = this.isLineNumbersVisible;
        this.isLineNumbersVisible = newValue;
    }

    public boolean isLineNumbersVisible() {
        return this.isLineNumbersVisible;
    }

    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new LabelView(elem);
            }
            if (kind.equals("paragraph")) {
                return new NumberedParagraphView(elem, this);
            }
            if (kind.equals("section")) {
                return new BoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }
}

