/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.HashMap;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;
import ome.xml.model.primitives.PositiveInteger;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected boolean[][] initialized;
    protected boolean interleaved;
    protected int series;
    protected MetadataRetrieve metadataRetrieve = new DummyMetadata();
    private HashMap<Integer, Integer> planeIndices = new HashMap();
    protected RandomAccessOutputStream out;

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void changeOutputFile(String id) throws FormatException, IOException {
        this.setId(id);
    }

    public void saveBytes(int no, byte[] buf) throws FormatException, IOException {
        int width = (Integer)this.metadataRetrieve.getPixelsSizeX(this.getSeries()).getValue();
        int height = (Integer)this.metadataRetrieve.getPixelsSizeY(this.getSeries()).getValue();
        this.saveBytes(no, buf, 0, 0, width, height);
    }

    public void savePlane(int no, Object plane) throws FormatException, IOException {
        int width = (Integer)this.metadataRetrieve.getPixelsSizeX(this.getSeries()).getValue();
        int height = (Integer)this.metadataRetrieve.getPixelsSizeY(this.getSeries()).getValue();
        this.savePlane(no, plane, 0, 0, width, height);
    }

    public void savePlane(int no, Object plane, int x, int y, int w, int h) throws FormatException, IOException {
        if (!(plane instanceof byte[])) {
            throw new IllegalArgumentException("Object to save must be a byte[]");
        }
        this.saveBytes(no, (byte[])plane, x, y, w, h);
    }

    public void setSeries(int series) throws FormatException {
        if (series < 0) {
            throw new FormatException("Series must be > 0.");
        }
        if (series >= this.metadataRetrieve.getImageCount()) {
            throw new FormatException("Series is '" + series + "' but MetadataRetrieve only defines " + this.metadataRetrieve.getImageCount() + " series.");
        }
        this.series = series;
    }

    public int getSeries() {
        return this.series;
    }

    public void setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public boolean canDoStacks() {
        return false;
    }

    public void setMetadataRetrieve(MetadataRetrieve retrieve) {
        FormatTools.assertId(this.currentId, false, 1);
        if (retrieve == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataRetrieve = retrieve;
    }

    public MetadataRetrieve getMetadataRetrieve() {
        return this.metadataRetrieve;
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    public void setCompression(String compress) throws FormatException {
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compress)) continue;
            this.compression = compress;
            return;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    public String getCompression() {
        return this.compression;
    }

    public int[] getPixelTypes() {
        return this.getPixelTypes(this.getCompression());
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.saveBytes(bytes, 0, last, last);
    }

    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.setSeries(series);
        Integer planeIndex = this.planeIndices.get(series);
        if (planeIndex == null) {
            planeIndex = 0;
        }
        this.saveBytes(planeIndex, bytes);
        Integer n = planeIndex;
        Integer n2 = planeIndex = Integer.valueOf(planeIndex + 1);
        this.planeIndices.put(series, planeIndex);
    }

    public void savePlane(Object plane, boolean last) throws FormatException, IOException {
        this.savePlane(plane, 0, last, last);
    }

    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (!(plane instanceof byte[])) {
            throw new IllegalArgumentException("Object to save must be a byte[]");
        }
        this.saveBytes((byte[])plane, series, lastInSeries, last);
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        this.close();
        this.currentId = id;
        this.out = new RandomAccessOutputStream(this.currentId);
        MetadataRetrieve r = this.getMetadataRetrieve();
        this.initialized = new boolean[r.getImageCount()][];
        int oldSeries = this.series;
        for (int i = 0; i < r.getImageCount(); ++i) {
            this.setSeries(i);
            this.initialized[i] = new boolean[this.getPlaneCount()];
        }
        this.setSeries(oldSeries);
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = null;
    }

    protected void checkParams(int no, byte[] buf, int x, int y, int w, int h) throws FormatException {
        int minSize;
        MetadataRetrieve r = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(r, this.series);
        if (buf == null) {
            throw new FormatException("Buffer cannot be null.");
        }
        int z = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)r.getPixelsSizeT(this.series).getValue();
        int c = r.getChannelCount(this.series);
        int planes = z * c * t;
        if (no < 0) {
            throw new FormatException("Plane index must be >= 0");
        }
        if (no >= planes) {
            throw new FormatException("Plane index must be < " + planes);
        }
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)r.getPixelsSizeY(this.series).getValue();
        if (x < 0) {
            throw new FormatException("X coordinate must be >= 0");
        }
        if (y < 0) {
            throw new FormatException("Y coordinate must be >= 0");
        }
        if (x >= sizeX) {
            throw new FormatException("X coordinate must be < " + sizeX);
        }
        if (y >= sizeY) {
            throw new FormatException("Y coordinate must be < " + sizeY);
        }
        if (w <= 0) {
            throw new FormatException("Width must be > 0");
        }
        if (h <= 0) {
            throw new FormatException("Height must be > 0");
        }
        if (x + w > sizeX) {
            throw new FormatException("(w + x) must be <= " + sizeX);
        }
        if (y + h > sizeY) {
            throw new FormatException("(h + y) must be <= " + sizeY);
        }
        int pixelType = FormatTools.pixelTypeFromString(r.getPixelsType(this.series).toString());
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        PositiveInteger samples = r.getChannelSamplesPerPixel(this.series, 0);
        if (samples == null) {
            samples = new PositiveInteger(Integer.valueOf(1));
        }
        if (buf.length < (minSize = bpp * w * h * (Integer)samples.getValue())) {
            throw new FormatException("Buffer is too small; expected " + minSize + " bytes, got " + buf.length + " bytes.");
        }
        if (!DataTools.containsValue((int[])this.getPixelTypes(this.compression), (int)pixelType)) {
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(pixelType) + "'.");
        }
    }

    protected void seekToPlaneOffset(long baseOffset, int x, int y) throws IOException {
        this.out.seek(baseOffset);
        MetadataRetrieve r = this.getMetadataRetrieve();
        int samples = this.getSamplesPerPixel();
        int pixelType = FormatTools.pixelTypeFromString(r.getPixelsType(this.series).toString());
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        if (this.interleaved) {
            bpp *= samples;
        }
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        this.out.skipBytes(bpp * (y * sizeX + x));
    }

    protected boolean isFullPlane(int x, int y, int w, int h) {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)r.getPixelsSizeY(this.series).getValue();
        return x == 0 && y == 0 && w == sizeX && h == sizeY;
    }

    protected int getSamplesPerPixel() {
        MetadataRetrieve r = this.getMetadataRetrieve();
        PositiveInteger samples = r.getChannelSamplesPerPixel(this.series, 0);
        if (samples == null) {
            LOGGER.warn("SamplesPerPixel #0 is null. It is assumed to be 1.");
        }
        return samples == null ? 1 : (Integer)samples.getValue();
    }

    protected int getPlaneCount() {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int z = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)r.getPixelsSizeT(this.series).getValue();
        int c = (Integer)r.getPixelsSizeC(this.series).getValue();
        return z * (c /= ((Integer)r.getChannelSamplesPerPixel(this.series, 0).getValue()).intValue()) * t;
    }
}

