/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import loci.common.DataTools;

public final class ImageTools {
    private ImageTools() {
    }

    public static byte[][] make24Bits(Object pixels, int w, int h, boolean interleaved, boolean reverse) {
        return ImageTools.make24Bits(pixels, w, h, interleaved, reverse, null, null);
    }

    public static byte[][] make24Bits(Object pixels, int w, int h, boolean interleaved, boolean reverse, Double min, Double max) {
        int[] pix = ImageTools.make24Bits(pixels, w, h, interleaved, min, max);
        byte[][] rtn = new byte[3][pix.length];
        for (int i = 0; i < pix.length; ++i) {
            byte r = (byte)(pix[i] >> 16 & 0xFF);
            rtn[1][i] = (byte)(pix[i] >> 8 & 0xFF);
            byte b = (byte)(pix[i] & 0xFF);
            rtn[0][i] = reverse ? b : r;
            rtn[2][i] = reverse ? r : b;
        }
        return rtn;
    }

    public static int[] make24Bits(Object pixels, int w, int h, boolean interleaved) {
        return ImageTools.make24Bits(pixels, w, h, interleaved, null, null);
    }

    public static int[] make24Bits(Object pixels, int w, int h, boolean interleaved, Double min, Double max) {
        int i;
        Object[] s;
        double mult;
        double range;
        int[] rtn = new int[w * h];
        byte[] b = null;
        if (min == null) {
            min = new Double(0.0);
        }
        double newRange = 256.0;
        if (pixels instanceof byte[]) {
            b = (byte[])pixels;
        } else if (pixels instanceof short[]) {
            if (max == null) {
                max = new Double(65535.0);
            }
            range = max - min + 1.0;
            mult = newRange / range;
            s = (short[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                b[i] = (byte)(Math.abs((double)s[i] * mult) - min);
            }
        } else if (pixels instanceof int[]) {
            if (max == null) {
                max = new Double(4.294967295E9);
            }
            range = max - min + 1.0;
            mult = newRange / range;
            s = (int[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                b[i] = (byte)(Math.abs((double)s[i] * mult) - min);
            }
        } else if (pixels instanceof float[]) {
            if (max == null) {
                max = new Double(3.4028234663852886E38);
            }
            range = max - min + 1.0;
            mult = newRange / range;
            s = (float[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                b[i] = (byte)((double)s[i] * mult - min);
            }
        } else if (pixels instanceof double[]) {
            if (max == null) {
                max = new Double(Double.MAX_VALUE);
            }
            range = max - min + 1.0;
            mult = newRange / range;
            s = (double[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                b[i] = (byte)(s[i] * mult - min);
            }
        }
        int c = b.length / rtn.length;
        for (int i2 = 0; i2 < rtn.length; ++i2) {
            int j;
            byte[] a = new byte[4];
            int maxC = Math.min(c, a.length);
            for (j = maxC - 1; j >= 0; --j) {
                a[j] = b[interleaved ? i2 * c + j : i2 + j * w * h];
            }
            if (c == 1) {
                for (j = 1; j < a.length; ++j) {
                    a[j] = a[0];
                }
            }
            byte tmp = a[0];
            a[0] = a[2];
            a[2] = tmp;
            rtn[i2] = DataTools.bytesToInt((byte[])a, (boolean)true);
        }
        return rtn;
    }

    public static byte[] splitChannels(byte[] array, int index, int c, int bytes, boolean reverse, boolean interleaved) {
        return ImageTools.splitChannels(array, null, index, c, bytes, reverse, interleaved);
    }

    public static byte[] splitChannels(byte[] array, byte[] rtn, int index, int c, int bytes, boolean reverse, boolean interleaved) {
        if (c == 1) {
            return array;
        }
        if (rtn == null) {
            rtn = new byte[array.length / c];
        }
        if (reverse) {
            index = c - index - 1;
        }
        if (!interleaved) {
            System.arraycopy(array, rtn.length * index, rtn, 0, rtn.length);
        } else {
            int next = 0;
            for (int i = 0; i < array.length; i += c * bytes) {
                for (int k = 0; k < bytes; ++k) {
                    if (next < rtn.length) {
                        rtn[next] = array[i + index * bytes + k];
                    }
                    ++next;
                }
            }
        }
        return rtn;
    }

    public static byte[] padImage(byte[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        byte[] padded = new byte[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static short[] padImage(short[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        short[] padded = new short[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static int[] padImage(int[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        int[] padded = new int[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static float[] padImage(float[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        float[] padded = new float[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static double[] padImage(double[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        double[] padded = new double[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static byte[] autoscale(byte[] b, int min, int max, int bpp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        byte[] out = new byte[b.length / bpp];
        for (int i = 0; i < b.length; i += bpp) {
            int s = DataTools.bytesToInt((byte[])b, (int)i, (int)bpp, (boolean)little);
            if (s >= max) {
                s = 255;
            } else if (s <= min) {
                s = 0;
            } else {
                int diff = max - min;
                float dist = (s - min) / diff;
                s = (int)dist * 256;
            }
            out[i / bpp] = (byte)s;
        }
        return out;
    }

    public static Double[] scanData(byte[] plane, int bits, boolean littleEndian) {
        int j;
        int max = 0;
        int min = Integer.MAX_VALUE;
        if (bits <= 8) {
            for (j = 0; j < plane.length; ++j) {
                if (plane[j] < min) {
                    min = plane[j];
                }
                if (plane[j] <= max) continue;
                max = plane[j];
            }
        } else if (bits == 16) {
            for (j = 0; j < plane.length; j += 2) {
                int s = DataTools.bytesToShort((byte[])plane, (int)j, (int)2, (boolean)littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s <= max) continue;
                max = s;
            }
        } else if (bits == 32) {
            for (j = 0; j < plane.length; j += 4) {
                int s = DataTools.bytesToInt((byte[])plane, (int)j, (int)4, (boolean)littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s <= max) continue;
                max = s;
            }
        }
        Double[] rtn = new Double[]{new Double(min), new Double(max)};
        return rtn;
    }

    public static byte[] getSubimage(byte[] src, byte[] dest, int originalWidth, int originalHeight, int x, int y, int w, int h, int bpp, int channels, boolean interleaved) {
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                for (int cc = 0; cc < channels; ++cc) {
                    int oldNdx = -1;
                    int newNdx = -1;
                    if (interleaved) {
                        oldNdx = yy * originalWidth * bpp * channels + xx * bpp * channels + cc * bpp;
                        newNdx = (yy - y) * w * bpp * channels + (xx - x) * bpp * channels + cc * bpp;
                    } else {
                        oldNdx = bpp * (cc * originalWidth * originalHeight + yy * originalWidth + xx);
                        newNdx = bpp * (cc * w * h + (yy - y) * w + (xx - x));
                    }
                    System.arraycopy(src, oldNdx, dest, newNdx, bpp);
                }
            }
        }
        return dest;
    }

    public static byte[][] indexedToRGB(byte[][] lut, byte[] b) {
        byte[][] rtn = new byte[lut.length][b.length];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                rtn[j][i] = lut[j][b[i] & 0xFF];
            }
        }
        return rtn;
    }

    public static short[][] indexedToRGB(short[][] lut, byte[] b, boolean le) {
        short[][] rtn = new short[lut.length][b.length / 2];
        for (int i = 0; i < b.length / 2; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                int index = DataTools.bytesToInt((byte[])b, (int)(i * 2), (int)2, (boolean)le);
                rtn[j][i] = lut[j][index];
            }
        }
        return rtn;
    }

    public static byte[] interpolate(short[] s, byte[] buf, int[] bayerPattern, int width, int height, boolean littleEndian) {
        if (width == 1 && height == 1) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)s[0];
            }
            return buf;
        }
        int plane = width * height;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                short v;
                int ncomps;
                int sum;
                boolean needBlue;
                boolean evenCol = col % 2 == 0;
                int index = row % 2 * 2 + col % 2;
                boolean needGreen = bayerPattern[index] != 1;
                boolean needRed = bayerPattern[index] != 0;
                boolean bl = needBlue = bayerPattern[index] != 2;
                if (needGreen) {
                    sum = 0;
                    ncomps = 0;
                    if (row > 0) {
                        sum += s[plane + (row - 1) * width + col];
                        ++ncomps;
                    }
                    if (row < height - 1) {
                        sum += s[plane + (row + 1) * width + col];
                        ++ncomps;
                    }
                    if (col > 0) {
                        sum += s[plane + row * width + col - 1];
                        ++ncomps;
                    }
                    if (col < width - 1) {
                        sum += s[plane + row * width + col + 1];
                        ++ncomps;
                    }
                    v = (short)(sum / ncomps);
                    DataTools.unpackBytes((long)v, (byte[])buf, (int)(row * width * 6 + col * 6 + 2), (int)2, (boolean)littleEndian);
                } else {
                    DataTools.unpackBytes((long)s[plane + row * width + col], (byte[])buf, (int)(row * width * 6 + col * 6 + 2), (int)2, (boolean)littleEndian);
                }
                if (needRed) {
                    sum = 0;
                    ncomps = 0;
                    if (!needBlue) {
                        if (row > 0) {
                            if (col > 0) {
                                sum += s[(row - 1) * width + col - 1];
                                ++ncomps;
                            }
                            if (col < width - 1) {
                                sum += s[(row - 1) * width + col + 1];
                                ++ncomps;
                            }
                        }
                        if (row < height - 1) {
                            if (col > 0) {
                                sum += s[(row + 1) * width + col - 1];
                                ++ncomps;
                            }
                            if (col < width - 1) {
                                sum += s[(row + 1) * width + col + 1];
                                ++ncomps;
                            }
                        }
                    } else if (evenCol && bayerPattern[index + 1] == 0 || !evenCol && bayerPattern[index - 1] == 0) {
                        if (col > 0) {
                            sum += s[row * width + col - 1];
                            ++ncomps;
                        }
                        if (col < width - 1) {
                            sum += s[row * width + col + 1];
                            ++ncomps;
                        }
                    } else {
                        if (row > 0) {
                            sum += s[(row - 1) * width + col];
                            ++ncomps;
                        }
                        if (row < height - 1) {
                            sum += s[(row + 1) * width + col];
                            ++ncomps;
                        }
                    }
                    v = (short)(sum / ncomps);
                    DataTools.unpackBytes((long)v, (byte[])buf, (int)(row * width * 6 + col * 6), (int)2, (boolean)littleEndian);
                } else {
                    DataTools.unpackBytes((long)s[row * width + col], (byte[])buf, (int)(row * width * 6 + col * 6), (int)2, (boolean)littleEndian);
                }
                if (needBlue) {
                    sum = 0;
                    ncomps = 0;
                    if (!needRed) {
                        if (row > 0) {
                            if (col > 0) {
                                sum += s[(2 * height + row - 1) * width + col - 1];
                                ++ncomps;
                            }
                            if (col < width - 1) {
                                sum += s[(2 * height + row - 1) * width + col + 1];
                                ++ncomps;
                            }
                        }
                        if (row < height - 1) {
                            if (col > 0) {
                                sum += s[(2 * height + row + 1) * width + col - 1];
                                ++ncomps;
                            }
                            if (col < width - 1) {
                                sum += s[(2 * height + row + 1) * width + col + 1];
                                ++ncomps;
                            }
                        }
                    } else if (evenCol && bayerPattern[index + 1] == 2 || !evenCol && bayerPattern[index - 1] == 2) {
                        if (col > 0) {
                            sum += s[(2 * height + row) * width + col - 1];
                            ++ncomps;
                        }
                        if (col < width - 1) {
                            sum += s[(2 * height + row) * width + col + 1];
                            ++ncomps;
                        }
                    } else {
                        if (row > 0) {
                            sum += s[(2 * height + row - 1) * width + col];
                            ++ncomps;
                        }
                        if (row < height - 1) {
                            sum += s[(2 * height + row + 1) * width + col];
                            ++ncomps;
                        }
                    }
                    v = (short)(sum / ncomps);
                    DataTools.unpackBytes((long)v, (byte[])buf, (int)(row * width * 6 + col * 6 + 4), (int)2, (boolean)littleEndian);
                    continue;
                }
                DataTools.unpackBytes((long)s[2 * plane + row * width + col], (byte[])buf, (int)(row * width * 6 + col * 6 + 4), (int)2, (boolean)littleEndian);
            }
        }
        return buf;
    }

    public static void bgrToRgb(byte[] buf, boolean interleaved, int bpp, int c) {
        if (c < 3) {
            return;
        }
        if (interleaved) {
            for (int i = 0; i < buf.length; i += bpp * c) {
                for (int b = 0; b < bpp; ++b) {
                    byte tmp = buf[i + b];
                    buf[i + b] = buf[i + bpp * 2];
                    buf[i + bpp * 2] = tmp;
                }
            }
        } else {
            byte[] channel = new byte[buf.length / (bpp * c)];
            System.arraycopy(buf, 0, channel, 0, channel.length);
            System.arraycopy(buf, channel.length * 2, buf, 0, channel.length);
            System.arraycopy(channel, 0, buf, channel.length * 2, channel.length);
        }
    }
}

