/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.services.OMEXMLService;
import ome.xml.model.BinData;
import ome.xml.model.OME;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataTools.class);
    private static OMEXMLService omexmlService = MetadataTools.createOMEXMLService();

    private MetadataTools() {
    }

    public static void populatePixels(MetadataStore store, IFormatReader r) {
        MetadataTools.populatePixels(store, r, false, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane) {
        MetadataTools.populatePixels(store, r, doPlane, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane, boolean doImageName) {
        if (store == null || r == null) {
            return;
        }
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            r.setSeries(i);
            store.setImageID(MetadataTools.createLSID("Image", i), i);
            if (doImageName) {
                store.setImageName(r.getCurrentFile(), i);
            }
            String pixelsID = MetadataTools.createLSID("Pixels", i);
            store.setPixelsID(pixelsID, i);
            store.setPixelsSizeX(new PositiveInteger(Integer.valueOf(r.getSizeX())), i);
            store.setPixelsSizeY(new PositiveInteger(Integer.valueOf(r.getSizeY())), i);
            store.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(r.getSizeZ())), i);
            store.setPixelsSizeC(new PositiveInteger(Integer.valueOf(r.getSizeC())), i);
            store.setPixelsSizeT(new PositiveInteger(Integer.valueOf(r.getSizeT())), i);
            store.setPixelsBinDataBigEndian(new Boolean(!r.isLittleEndian()), i, 0);
            try {
                OMEXMLService service = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
                if (service.isOMEXMLRoot(store.getRoot())) {
                    MetadataStore baseStore = r.getMetadataStore();
                    if (service.isOMEXMLMetadata(baseStore)) {
                        ((OMEXMLMetadataImpl)baseStore).resolveReferences();
                    }
                    OME root = (OME)store.getRoot();
                    BinData bin = root.getImage(i).getPixels().getBinData(0);
                    bin.setLength(new NonNegativeLong(Long.valueOf(0L)));
                    store.setRoot(root);
                }
            }
            catch (DependencyException exc) {
                LOGGER.debug("Failed to set BinData.Length", (Throwable)exc);
            }
            try {
                store.setPixelsType(PixelType.fromString((String)FormatTools.getPixelTypeString(r.getPixelType())), i);
                store.setPixelsDimensionOrder(DimensionOrder.fromString((String)r.getDimensionOrder()), i);
            }
            catch (EnumerationException e) {
                LOGGER.debug("Failed to create enumeration", (Throwable)e);
            }
            if (r.getSizeC() > 0) {
                Integer sampleCount = new Integer(r.getRGBChannelCount());
                for (int c = 0; c < r.getEffectiveSizeC(); ++c) {
                    store.setChannelID(MetadataTools.createLSID("Channel", i, c), i, c);
                    store.setChannelSamplesPerPixel(new PositiveInteger(sampleCount), i, c);
                }
            }
            if (!doPlane) continue;
            for (int q = 0; q < r.getImageCount(); ++q) {
                int[] coords = r.getZCTCoords(q);
                store.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf(coords[0])), i, q);
                store.setPlaneTheC(new NonNegativeInteger(Integer.valueOf(coords[1])), i, q);
                store.setPlaneTheT(new NonNegativeInteger(Integer.valueOf(coords[2])), i, q);
            }
        }
        r.setSeries(oldSeries);
    }

    public static String createLSID(String type, int ... indices) {
        StringBuffer lsid = new StringBuffer(type);
        for (int index : indices) {
            lsid.append(":");
            lsid.append(index);
        }
        return lsid.toString();
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src) throws FormatException {
        MetadataTools.verifyMinimumPopulated(src, 0);
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src, int n) throws FormatException {
        if (src == null) {
            throw new FormatException("Metadata object is null; call IFormatWriter.setMetadataRetrieve() first");
        }
        if (src instanceof MetadataStore && ((MetadataStore)((Object)src)).getRoot() == null) {
            throw new FormatException("Metadata object has null root; call IMetadata.createRoot() first");
        }
        if (src.getImageID(n) == null) {
            throw new FormatException("Image ID #" + n + " is null");
        }
        if (src.getPixelsID(n) == null) {
            throw new FormatException("Pixels ID #" + n + " is null");
        }
        for (int i = 0; i < src.getChannelCount(n); ++i) {
            if (src.getChannelID(n, i) != null) continue;
            throw new FormatException("Channel ID #" + i + " in Image #" + n + " is null");
        }
        if (src.getPixelsBinDataBigEndian(n, 0) == null) {
            throw new FormatException("BigEndian #" + n + " is null");
        }
        if (src.getPixelsDimensionOrder(n) == null) {
            throw new FormatException("DimensionOrder #" + n + " is null");
        }
        if (src.getPixelsType(n) == null) {
            throw new FormatException("PixelType #" + n + " is null");
        }
        if (src.getPixelsSizeC(n) == null) {
            throw new FormatException("SizeC #" + n + " is null");
        }
        if (src.getPixelsSizeT(n) == null) {
            throw new FormatException("SizeT #" + n + " is null");
        }
        if (src.getPixelsSizeX(n) == null) {
            throw new FormatException("SizeX #" + n + " is null");
        }
        if (src.getPixelsSizeY(n) == null) {
            throw new FormatException("SizeY #" + n + " is null");
        }
        if (src.getPixelsSizeZ(n) == null) {
            throw new FormatException("SizeZ #" + n + " is null");
        }
    }

    public static void setDefaultCreationDate(MetadataStore store, String id, int series) {
        Location file = new Location(id).getAbsoluteFile();
        long time = System.currentTimeMillis();
        if (file.exists()) {
            time = file.lastModified();
        }
        store.setImageAcquiredDate(DateTools.convertDate((long)time, (int)0), series);
    }

    public static String makeSaneDimensionOrder(String dimensionOrder) {
        String[] axes;
        String order = dimensionOrder.toUpperCase();
        order = order.replaceAll("[^XYZCT]", "");
        for (String axis : axes = new String[]{"X", "Y", "C", "Z", "T"}) {
            if (order.indexOf(axis) == -1) {
                order = order + axis;
            }
            while (order.indexOf(axis) != order.lastIndexOf(axis)) {
                order = order.replaceFirst(axis, "");
            }
        }
        return order;
    }

    public static String[] keys(Hashtable<String, Object> meta) {
        Object[] keys = new String[meta.size()];
        meta.keySet().toArray(keys);
        Arrays.sort(keys);
        return keys;
    }

    public static void merge(Map<String, Object> src, Map<String, Object> dest, String prefix) {
        for (String key : src.keySet()) {
            dest.put(prefix + key, src.get(key));
        }
    }

    private static OMEXMLService createOMEXMLService() {
        try {
            return (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
        }
        catch (DependencyException exc) {
            return null;
        }
    }

    public static MetadataRetrieve asRetrieve(MetadataStore meta) {
        if (omexmlService == null) {
            return null;
        }
        return omexmlService.asRetrieve(meta);
    }

    public static String getLatestVersion() {
        if (omexmlService == null) {
            return null;
        }
        return omexmlService.getLatestVersion();
    }

    public static IMetadata createOMEXMLMetadata() {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.createOMEXMLMetadata();
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static IMetadata createOMEXMLMetadata(String xml) {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.createOMEXMLMetadata(xml);
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static IMetadata createOMEXMLMetadata(String xml, String version) {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.createOMEXMLMetadata(xml);
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static Object createOMEXMLRoot(String xml) {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.createOMEXMLMetadata(xml);
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static boolean isOMEXMLMetadata(Object o) {
        if (omexmlService == null) {
            return false;
        }
        return omexmlService.isOMEXMLMetadata(o);
    }

    public static boolean isOMEXMLRoot(Object o) {
        if (omexmlService == null) {
            return false;
        }
        return omexmlService.isOMEXMLRoot(o);
    }

    public static String getOMEXMLVersion(Object o) {
        if (omexmlService == null) {
            return null;
        }
        return omexmlService.getOMEXMLVersion(o);
    }

    public static IMetadata getOMEMetadata(MetadataRetrieve src) {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.getOMEMetadata(src);
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static String getOMEXML(MetadataRetrieve src) {
        if (omexmlService == null) {
            return null;
        }
        try {
            return omexmlService.getOMEXML(src);
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static boolean validateOMEXML(String xml) {
        if (omexmlService == null) {
            return false;
        }
        return omexmlService.validateOMEXML(xml);
    }

    public static boolean validateOMEXML(String xml, boolean pixelsHack) {
        if (omexmlService == null) {
            return false;
        }
        return omexmlService.validateOMEXML(xml, pixelsHack);
    }
}

