/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.MissingLibraryException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.gui.AWTImageTools;
import loci.formats.services.JAIIIOService;

public class JPEG2000Codec
extends BaseCodec {
    private JAIIIOService service;

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        this.initialize();
        JPEG2000CodecOptions j2kOptions = JPEG2000CodecOptions.getDefaultOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = null;
        int next = 0;
        int plane = j2kOptions.width * j2kOptions.height;
        if (j2kOptions.bitsPerSample == 8) {
            byte[][] b = new byte[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < j2kOptions.channels; ++c) {
                        b[c][q] = data[next++];
                    }
                }
            } else {
                for (int c = 0; c < j2kOptions.channels; ++c) {
                    System.arraycopy(data, c * plane, b[c], 0, plane);
                }
            }
            DataBufferByte buffer = new DataBufferByte(b, plane);
            img = AWTImageTools.constructImage(b.length, 0, j2kOptions.width, j2kOptions.height, false, true, buffer);
        } else if (j2kOptions.bitsPerSample == 16) {
            short[][] s = new short[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < j2kOptions.channels; ++c) {
                        s[c][q] = DataTools.bytesToShort((byte[])data, (int)next, (int)2, (boolean)j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            } else {
                for (int c = 0; c < j2kOptions.channels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = DataTools.bytesToShort((byte[])data, (int)next, (int)2, (boolean)j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            }
            DataBufferUShort buffer = new DataBufferUShort(s, plane);
            img = AWTImageTools.constructImage(s.length, 1, j2kOptions.width, j2kOptions.height, false, true, buffer);
        }
        try {
            this.service.writeImage(out, img, j2kOptions.lossless, j2kOptions.codeBlockSize, j2kOptions.quality);
        }
        catch (IOException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        catch (ServiceException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        return out.toByteArray();
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        this.initialize();
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] single = null;
        BufferedImage b = null;
        long fp = in.getFilePointer();
        byte[] buf = null;
        buf = options.maxBytes == 0 ? new byte[(int)(in.length() - fp)] : new byte[(int)((long)options.maxBytes - fp)];
        in.read(buf);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            b = this.service.readImage(bis);
            single = AWTImageTools.getPixelBytes(b, options.littleEndian);
            bis.close();
            b = null;
        }
        catch (IOException e) {
            throw new FormatException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        catch (ServiceException e) {
            throw new FormatException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        if (single.length == 1) {
            return single[0];
        }
        byte[] rtn = new byte[single.length * single[0].length];
        if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < single[0].length; ++i) {
                for (int j = 0; j < single.length; ++j) {
                    rtn[next++] = single[j][i];
                }
            }
        } else {
            for (int i = 0; i < single.length; ++i) {
                System.arraycopy(single[i], 0, rtn, i * single[0].length, single[i].length);
            }
        }
        single = null;
        return rtn;
    }

    private void initialize() throws FormatException {
        if (this.service != null) {
            return;
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = (JAIIIOService)factory.getInstance(JAIIIOService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("The JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/ome/formats-library.html", de);
        }
    }
}

