/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MSRLECodec;
import loci.formats.codec.MSVideoCodec;
import loci.formats.meta.MetadataStore;

public class AVIReader
extends FormatReader {
    public static final String AVI_MAGIC_STRING = "RIFF";
    private static final int MSRLE = 1;
    private static final int MS_VIDEO = 1296126531;
    private static final int JPEG = 1196444237;
    private Vector<Long> offsets;
    private Vector<Long> lengths;
    private String listString;
    private String type = "error";
    private String fcc = "error";
    private int size = -1;
    private long pos;
    private int bytesPerPlane;
    private int bmpColorsUsed;
    private int bmpWidth;
    private int bmpCompression;
    private int bmpScanLineSize;
    private short bmpBitsPerPixel;
    private byte[][] lut = null;
    private byte[] lastImage;
    private int lastImageNo;

    public AVIReader() {
        super("Audio Video Interleave", "avi");
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 12;
        if (!FormatTools.validStream(stream, 12, false)) {
            return false;
        }
        String type = stream.readString(4);
        stream.skipBytes(4);
        String format = stream.readString(4);
        return type.equals(AVI_MAGIC_STRING) && format.equals("AVI ");
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.isRGB() ? (byte[][])null : this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.getSizeX()) {
            effectiveWidth = this.getSizeX();
        }
        long fileOff = this.offsets.get(no);
        this.in.seek(fileOff);
        if (this.bmpCompression != 0) {
            byte[] b = this.uncompress(no, buf);
            int rowLen = FormatTools.getPlaneSize(this, w, 1);
            int inputRowLen = FormatTools.getPlaneSize(this, this.getSizeX(), 1);
            for (int row = 0; row < h; ++row) {
                System.arraycopy(b, (row + y) * inputRowLen, buf, row * rowLen, rowLen);
            }
            b = null;
            return buf;
        }
        if (this.bmpBitsPerPixel < 8) {
            int rawSize = FormatTools.getPlaneSize(this, effectiveWidth, this.getSizeY());
            byte[] b = new byte[rawSize /= 8 / this.bmpBitsPerPixel];
            int len = rawSize / this.getSizeY();
            this.in.read(b);
            BitBuffer bb = new BitBuffer(b);
            bb.skipBits(this.bmpBitsPerPixel * len * (this.getSizeY() - h - y));
            for (int row = h; row >= y; --row) {
                bb.skipBits(this.bmpBitsPerPixel * x);
                for (int col = 0; col < len; ++col) {
                    buf[(row - y) * len + col] = (byte)bb.getBits(this.bmpBitsPerPixel);
                }
                bb.skipBits(this.bmpBitsPerPixel * (this.getSizeX() - w - x));
            }
            return buf;
        }
        int pad = this.bmpScanLineSize / this.getRGBChannelCount() - this.getSizeX() * bytes;
        int scanline = w * bytes * (this.isInterleaved() ? this.getRGBChannelCount() : 1);
        this.in.skipBytes((this.getSizeX() + pad) * bytes * (this.getSizeY() - h - y));
        if (this.getSizeX() == w && pad == 0) {
            for (int row = 0; row < this.getSizeY(); ++row) {
                this.in.read(buf, (this.getSizeY() - row - 1) * scanline, scanline);
            }
            if (this.bmpBitsPerPixel == 24) {
                for (int i = 0; i < buf.length / this.getRGBChannelCount(); ++i) {
                    byte r = buf[i * this.getRGBChannelCount() + 2];
                    buf[i * this.getRGBChannelCount() + 2] = buf[i * this.getRGBChannelCount()];
                    buf[i * this.getRGBChannelCount()] = r;
                }
            }
        } else {
            int skip = FormatTools.getPlaneSize(this, this.getSizeX() - w - x + pad, 1);
            for (int i = h - 1; i >= 0; --i) {
                this.in.skipBytes(x * (this.bmpBitsPerPixel / 8));
                this.in.read(buf, (i - y) * scanline, scanline);
                if (this.bmpBitsPerPixel == 24) {
                    for (int j = 0; j < w; ++j) {
                        byte r = buf[i * scanline + j * 3 + 2];
                        buf[i * scanline + j * 3 + 2] = buf[i * scanline + j * 3];
                        buf[i * scanline + j * 3] = r;
                    }
                }
                this.in.skipBytes(skip);
            }
        }
        if (this.bmpBitsPerPixel == 16 && this.isRGB()) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 2, this.getRGBChannelCount());
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.listString = null;
            this.offsets = null;
            this.lengths = null;
            this.type = null;
            this.fcc = null;
            this.size = -1;
            this.pos = 0L;
            this.bytesPerPlane = 0;
            this.bmpScanLineSize = 0;
            this.bmpCompression = 0;
            this.bmpWidth = 0;
            this.bmpColorsUsed = 0;
            this.bmpBitsPerPixel = 0;
            this.lut = null;
            this.lastImage = null;
            this.lastImageNo = -1;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        LOGGER.info("Verifying AVI format");
        this.offsets = new Vector();
        this.lengths = new Vector();
        this.lastImageNo = -1;
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            this.readChunk();
        }
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = this.offsets.size();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount();
        this.core[0].littleEndian = true;
        boolean bl = this.core[0].interleaved = this.bmpBitsPerPixel != 16;
        if (this.bmpCompression == 1196444237) {
            long fileOff = this.offsets.get(0);
            this.in.seek(fileOff);
            int nBytes = this.uncompress(0, null).length / (this.getSizeX() * this.getSizeY());
            if (this.bmpBitsPerPixel == 16) {
                nBytes /= 2;
            }
            this.core[0].sizeC = nBytes;
            this.core[0].rgb = this.getSizeC() > 1;
        } else if (this.bmpBitsPerPixel == 32) {
            this.core[0].sizeC = 4;
            this.core[0].rgb = true;
        } else if (this.bytesPerPlane == 0 || this.bmpBitsPerPixel == 24) {
            this.core[0].rgb = this.bmpBitsPerPixel > 8 || this.bmpCompression != 0 && this.lut == null;
            this.core[0].sizeC = this.isRGB() ? 3 : 1;
        } else {
            this.core[0].sizeC = this.bytesPerPlane / (this.getSizeX() * this.getSizeY() * (this.bmpBitsPerPixel / 8));
            this.core[0].rgb = this.getSizeC() > 1;
        }
        this.core[0].dimensionOrder = this.isRGB() ? "XYCTZ" : "XYTCZ";
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        boolean bl2 = this.core[0].indexed = this.lut != null && !this.isRGB();
        if (this.bmpBitsPerPixel <= 8) {
            this.core[0].pixelType = 1;
            this.core[0].bitsPerPixel = this.bmpBitsPerPixel;
        } else if (this.bmpBitsPerPixel == 16) {
            this.core[0].pixelType = 3;
        } else if (this.bmpBitsPerPixel == 24 || this.bmpBitsPerPixel == 32) {
            this.core[0].pixelType = 1;
        } else {
            throw new FormatException("Unknown matching for pixel bit width of: " + this.bmpBitsPerPixel);
        }
        if (this.bmpCompression != 0) {
            this.core[0].pixelType = 1;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    private byte[] uncompress(int no, byte[] buf) throws FormatException, IOException {
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.previousImage = this.lastImageNo == no - 1 ? this.lastImage : null;
        options.bitsPerSample = this.bmpBitsPerPixel;
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        if (this.bmpCompression == 1) {
            byte[] b = new byte[(int)this.lengths.get(no).longValue()];
            this.in.read(b);
            MSRLECodec codec = new MSRLECodec();
            buf = codec.decompress(b, options);
            this.lastImage = buf;
            this.lastImageNo = no;
        } else if (this.bmpCompression == 1296126531) {
            MSVideoCodec codec = new MSVideoCodec();
            buf = codec.decompress(this.in, options);
            this.lastImage = buf;
            this.lastImageNo = no;
        } else if (this.bmpCompression == 1196444237) {
            JPEGCodec codec = new JPEGCodec();
            buf = codec.decompress(this.in, options);
        } else {
            throw new FormatException("Unsupported compression : " + this.bmpCompression);
        }
        return buf;
    }

    private void readChunkHeader() throws IOException {
        this.readTypeAndSize();
        this.fcc = this.in.readString(4);
    }

    private void readTypeAndSize() throws IOException {
        this.type = this.in.readString(4);
        this.size = this.in.readInt();
    }

    private void readChunk() throws FormatException, IOException {
        this.readChunkHeader();
        if (this.type.equals(AVI_MAGIC_STRING)) {
            if (!this.fcc.startsWith("AVI")) {
                throw new FormatException("Sorry, AVI RIFF format not found.");
            }
        } else {
            if (this.in.getFilePointer() == 12L) {
                throw new FormatException("Not an AVI file");
            }
            return;
        }
        long spos = this.pos = this.in.getFilePointer();
        LOGGER.info("Searching for image data");
        while (this.in.length() - this.in.getFilePointer() > 4L) {
            this.listString = this.in.readString(4);
            this.in.seek(this.pos);
            if (this.listString.equals(" JUN")) {
                this.in.skipBytes(1);
                ++this.pos;
            }
            if (this.listString.equals("JUNK")) {
                this.readTypeAndSize();
                if (this.type.equals("JUNK")) {
                    this.in.skipBytes(this.size);
                }
            } else if (this.listString.equals("LIST")) {
                spos = this.in.getFilePointer();
                this.readChunkHeader();
                this.in.seek(spos);
                if (this.fcc.equals("hdrl")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("hdrl")) {
                        this.readTypeAndSize();
                        if (this.type.equals("avih")) {
                            spos = this.in.getFilePointer();
                            this.addGlobalMeta("Microseconds per frame", this.in.readInt());
                            this.addGlobalMeta("Max. bytes per second", this.in.readInt());
                            this.in.skipBytes(8);
                            this.addGlobalMeta("Total frames", this.in.readInt());
                            this.addGlobalMeta("Initial frames", this.in.readInt());
                            this.in.skipBytes(8);
                            this.core[0].sizeX = this.in.readInt();
                            this.addGlobalMeta("Frame height", this.in.readInt());
                            this.addGlobalMeta("Scale factor", this.in.readInt());
                            this.addGlobalMeta("Frame rate", this.in.readInt());
                            this.addGlobalMeta("Start time", this.in.readInt());
                            this.addGlobalMeta("Length", this.in.readInt());
                            this.addGlobalMeta("Frame width", this.getSizeX());
                            if (spos + (long)this.size <= this.in.length()) {
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                    }
                } else if (this.fcc.equals("strl")) {
                    long startPos = this.in.getFilePointer();
                    long streamSize = this.size;
                    this.readChunkHeader();
                    if (this.type.equals("LIST")) {
                        if (this.fcc.equals("strl")) {
                            this.readTypeAndSize();
                            if (this.type.equals("strh")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(40);
                                this.addGlobalMeta("Stream quality", this.in.readInt());
                                this.bytesPerPlane = this.in.readInt();
                                this.addGlobalMeta("Stream sample size", this.bytesPerPlane);
                                if (spos + (long)this.size <= this.in.length()) {
                                    this.in.seek(spos + (long)this.size);
                                }
                            }
                            this.readTypeAndSize();
                            if (this.type.equals("strf")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(4);
                                this.bmpWidth = this.in.readInt();
                                this.core[0].sizeY = this.in.readInt();
                                this.in.skipBytes(2);
                                this.bmpBitsPerPixel = this.in.readShort();
                                this.bmpCompression = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Horizontal resolution", this.in.readInt());
                                this.addGlobalMeta("Vertical resolution", this.in.readInt());
                                this.bmpColorsUsed = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Bitmap compression value", this.bmpCompression);
                                this.addGlobalMeta("Number of colors used", this.bmpColorsUsed);
                                this.addGlobalMeta("Bits per pixel", this.bmpBitsPerPixel);
                                int npad = this.bmpWidth % 4;
                                if (npad > 0) {
                                    npad = 4 - npad;
                                }
                                this.bmpScanLineSize = (this.bmpWidth + npad) * (this.bmpBitsPerPixel / 8);
                                int bmpActualColorsUsed = 0;
                                if (this.bmpColorsUsed != 0) {
                                    bmpActualColorsUsed = this.bmpColorsUsed;
                                } else if (this.bmpBitsPerPixel < 16) {
                                    this.bmpColorsUsed = bmpActualColorsUsed = 1 << this.bmpBitsPerPixel;
                                }
                                if (this.bmpCompression != 1 && this.bmpCompression != 0 && this.bmpCompression != 1296126531 && this.bmpCompression != 1196444237) {
                                    throw new FormatException("Unsupported compression type " + this.bmpCompression);
                                }
                                if (this.bmpBitsPerPixel != 4 && this.bmpBitsPerPixel != 8 && this.bmpBitsPerPixel != 24 && this.bmpBitsPerPixel != 16 && this.bmpBitsPerPixel != 32) {
                                    throw new FormatException(this.bmpBitsPerPixel + " bits per pixel not supported");
                                }
                                if (bmpActualColorsUsed != 0) {
                                    this.lut = new byte[3][this.bmpColorsUsed];
                                    for (int i = 0; i < this.bmpColorsUsed; ++i) {
                                        this.lut[2][i] = this.in.readByte();
                                        this.lut[1][i] = this.in.readByte();
                                        this.lut[0][i] = this.in.readByte();
                                        this.in.skipBytes(1);
                                    }
                                }
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                        spos = this.in.getFilePointer();
                        this.readTypeAndSize();
                        if (this.type.equals("strd")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.readTypeAndSize();
                        if (this.type.equals("strn")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                    }
                    if (startPos + streamSize + 8L <= this.in.length()) {
                        this.in.seek(startPos + 8L + streamSize);
                    }
                } else if (this.fcc.equals("movi")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("movi")) {
                        spos = this.in.getFilePointer();
                        if (spos >= this.in.length() - 12L) break;
                        this.readChunkHeader();
                        if (!this.type.equals("LIST") || !this.fcc.equals("rec ") && !this.fcc.equals("movi")) {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        boolean end = false;
                        while (!end) {
                            this.readTypeAndSize();
                            String oldType = this.type;
                            if (this.type.startsWith("ix")) {
                                this.in.skipBytes(this.size);
                                this.readTypeAndSize();
                            }
                            String check = this.type.substring(2);
                            boolean foundPixels = false;
                            while (check.equals("db") || check.equals("dc") || check.equals("wb")) {
                                foundPixels = true;
                                if (check.startsWith("d") && (this.size > 0 || this.bmpCompression != 0)) {
                                    this.offsets.add(new Long(this.in.getFilePointer()));
                                    this.lengths.add(new Long(this.size));
                                    this.in.skipBytes(this.size);
                                }
                                if ((spos = this.in.getFilePointer()) + 8L >= this.in.length()) {
                                    return;
                                }
                                this.readTypeAndSize();
                                if (this.type.equals("JUNK")) {
                                    this.in.skipBytes(this.size);
                                    spos = this.in.getFilePointer();
                                    this.readTypeAndSize();
                                }
                                if (!(check = this.type.substring(2)).equals("0d")) continue;
                                this.in.seek(spos + 1L);
                                this.readTypeAndSize();
                                check = this.type.substring(2);
                            }
                            this.in.seek(spos);
                            if (oldType.startsWith("ix") || foundPixels) continue;
                            end = true;
                        }
                    }
                } else if (this.size + 8 >= 0) {
                    this.in.skipBytes(8 + this.size);
                }
            } else {
                this.readTypeAndSize();
                if (this.in.getFilePointer() + 8L < this.in.length() && !this.type.equals("idx1")) {
                    this.readTypeAndSize();
                } else if (!this.type.equals("idx1")) break;
                if (this.in.getFilePointer() + (long)this.size + 4L <= this.in.length()) {
                    this.in.skipBytes(this.size);
                }
                if (this.type.equals("idx1")) break;
            }
            this.pos = this.in.getFilePointer();
        }
    }
}

