/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class FEIReader
extends FormatReader {
    public static final String FEI_MAGIC_STRING = "XL";
    private static final int INVALID_PIXELS = 112;
    private int headerSize;

    public FEIReader() {
        super("FEI/Philips", "img");
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readString(2).startsWith(FEI_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek((long)this.headerSize);
        byte[] segment = new byte[this.getSizeX() / 2];
        int halfRow = this.getSizeX() / 2;
        for (int q = 0; q < 4; ++q) {
            for (int row = q; row < h; row += 4) {
                for (int s = 0; s < 2; ++s) {
                    this.in.read(segment);
                    this.in.skipBytes(56);
                    for (int col = s; col < w; col += 2) {
                        buf[row * w + col] = segment[col / 2];
                    }
                }
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.headerSize = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        LOGGER.info("Reading file header");
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(44);
            float magnification = this.in.readFloat();
            float kV = this.in.readFloat() / 1000.0f;
            float wd = this.in.readFloat();
            this.in.skipBytes(12);
            float spot = this.in.readFloat();
            this.addGlobalMeta("Magnification", magnification);
            this.addGlobalMeta("kV", kV);
            this.addGlobalMeta("Working distance", wd);
            this.addGlobalMeta("Spot", spot);
        }
        this.in.seek(514L);
        this.core[0].sizeX = this.in.readShort() - 112;
        this.core[0].sizeY = this.in.readShort();
        this.in.skipBytes(4);
        this.headerSize = this.in.readShort();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].littleEndian = true;
        this.core[0].pixelType = 1;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYCZT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

