/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class GatanDM2Reader
extends FormatReader {
    private static final int HEADER_SIZE = 24;
    private static final int DM2_MAGIC_BYTES = 0x3D0000;

    public GatanDM2Reader() {
        super("Gatan DM2", "dm2");
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 0x3D0000;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(24L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        id = new Location(id).getAbsolutePath();
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        int magicBytes = this.in.readInt();
        if (magicBytes != 0x3D0000) {
            throw new FormatException("Invalid DM2 file");
        }
        this.in.skipBytes(8);
        long footerOffset = this.in.readInt() + 16;
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        int bpp = (int)((footerOffset - 24L) / (long)(this.getSizeX() * this.getSizeY()));
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeZ = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].littleEndian = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        String date = null;
        String time = null;
        String name = null;
        this.in.skipBytes(FormatTools.getPlaneSize(this) + 39);
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        while (this.in.getFilePointer() < this.in.length() && (level != MetadataLevel.MINIMUM || date == null || time == null || name == null)) {
            short strlen = this.in.readShort();
            if (strlen == 0) {
                this.in.skipBytes(35);
                strlen = this.in.readShort();
            }
            if ((long)strlen + this.in.getFilePointer() >= this.in.length()) break;
            String label = this.in.readString((int)strlen);
            StringBuffer value = new StringBuffer();
            int block = this.in.readInt();
            if (block == 5) {
                this.in.skipBytes(33);
                while (this.in.readShort() == 0) {
                    this.in.skipBytes(33);
                }
                this.in.seek(this.in.getFilePointer() - 2L);
                continue;
            }
            int len = this.in.readInt();
            if ((long)len + this.in.getFilePointer() >= this.in.length()) break;
            String type = this.in.readString(len);
            this.in.skipBytes(4);
            int count = this.in.readInt();
            if (type.equals("TEXT")) {
                value.append(this.in.readString(count));
            } else if (type.equals("long")) {
                count /= 8;
                for (int i = 0; i < count; ++i) {
                    value.append(this.in.readLong());
                    if (i >= count - 1) continue;
                    value.append(", ");
                }
                this.in.skipBytes(4);
            } else if (type.equals("bool")) {
                for (int i = 0; i < count; ++i) {
                    value.append(this.in.read() == 1);
                    if (i >= count - 1) continue;
                    value.append(", ");
                }
            } else if (type.equals("shor")) {
                count /= 2;
                for (int i = 0; i < count; ++i) {
                    value.append(this.in.readShort());
                    if (i >= count - 1) continue;
                    value.append(", ");
                }
            } else {
                this.in.skipBytes(count);
            }
            this.in.skipBytes(16);
            this.addGlobalMeta(label, value.toString());
            if (label.equals("Acquisition Date")) {
                date = value.toString();
                if (date == null || date.indexOf("/") == -1) continue;
                String year = date.substring(date.lastIndexOf("/") + 1);
                if (year.length() < 2) {
                    year = "0" + year;
                }
                date = date.substring(0, date.lastIndexOf("/") + 1) + year;
                continue;
            }
            if (label.equals("Acquisition Time")) {
                time = value.toString();
                continue;
            }
            if (label.equals("Binning")) {
                store.setDetectorSettingsBinning(this.getBinning(value + "x" + value), 0, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorSettingsID(detectorID, 0, 0);
                continue;
            }
            if (label.equals("Name")) {
                name = value.toString();
                continue;
            }
            if (!label.equals("Operator")) continue;
            String[] experimenterName = value.toString().split(" ");
            store.setExperimenterFirstName(experimenterName[0], 0);
            if (experimenterName.length > 1) {
                store.setExperimenterLastName(experimenterName[1], 0);
            }
            store.setExperimenterDisplayName(value.toString(), 0);
            String expID = MetadataTools.createLSID("Experimenter", 0);
            store.setExperimenterID(expID, 0);
            store.setImageExperimenterRef(expID, 0);
        }
        if (date != null && time != null) {
            String[] format = new String[]{"M/d/yy h:mm:ss a", "d/M/yy h:mm:ss a", "M/d/yy H:mm:ss", "d/M/yy H:mm:ss"};
            date = date + " " + time;
            store.setImageAcquiredDate(DateTools.formatDate((String)date, (String[])format), 0);
        }
        if (name != null) {
            store.setImageName(name, 0);
        }
    }
}

