/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.handlers.CorrectionEnumHandler;
import ome.xml.model.enums.handlers.DetectorTypeEnumHandler;
import ome.xml.model.enums.handlers.ImmersionEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeicaHandler
extends DefaultHandler {
    private Stack<String> nameStack = new Stack();
    private String elementName;
    private String collection;
    private int count = 0;
    private int numChannels;
    private int extras = 1;
    private Vector<String> lutNames;
    private Vector<Double> xPos;
    private Vector<Double> yPos;
    private Vector<Double> zPos;
    private double physicalSizeX;
    private double physicalSizeY;
    private int numDatasets = -1;
    private Hashtable globalMetadata;
    private MetadataStore store;
    private int nextChannel = 0;
    private Double zoom;
    private Double pinhole;
    private Vector<Integer> detectorIndices;
    private String filterWheelName;
    private int nextFilter = 0;
    private int nextROI = 0;
    private ROI roi;
    private boolean alternateCenter = false;
    private boolean linkedInstruments = false;
    private int detectorChannel = 0;
    private Vector<CoreMetadata> core;
    private boolean canParse = true;
    private long firstStamp = 0L;
    private Hashtable<Integer, String> bytesPerAxis;
    private Vector<MultiBand> multiBands = new Vector();
    private Vector<Detector> detectors = new Vector();
    private Vector<Laser> lasers = new Vector();
    private Hashtable<String, Channel> channels = new Hashtable();
    private MetadataLevel level;
    private int laserCount = 0;

    public LeicaHandler(MetadataStore store, MetadataLevel level) {
        this.globalMetadata = new Hashtable();
        this.lutNames = new Vector();
        this.store = store;
        this.core = new Vector();
        this.detectorIndices = new Vector();
        this.xPos = new Vector();
        this.yPos = new Vector();
        this.zPos = new Vector();
        this.bytesPerAxis = new Hashtable();
        this.level = level;
    }

    public Vector<CoreMetadata> getCoreMetadata() {
        return this.core;
    }

    public Hashtable getGlobalMetadata() {
        return this.globalMetadata;
    }

    public Vector<String> getLutNames() {
        return this.lutNames;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!this.nameStack.empty() && this.nameStack.peek().equals(qName)) {
            this.nameStack.pop();
        }
        if (qName.equals("ImageDescription")) {
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            if (this.numChannels == 0) {
                this.numChannels = 1;
            }
            coreMeta.sizeC = this.numChannels;
            if (this.extras > 1) {
                if (coreMeta.sizeZ == 1) {
                    coreMeta.sizeZ = this.extras;
                } else {
                    coreMeta.sizeT = coreMeta.sizeT == 0 ? this.extras : (coreMeta.sizeT *= this.extras);
                }
            }
            if (coreMeta.sizeX == 0 && coreMeta.sizeY == 0) {
                if (this.numDatasets > 0) {
                    --this.numDatasets;
                }
            } else {
                String[] axes;
                if (coreMeta.sizeX == 0) {
                    coreMeta.sizeX = 1;
                }
                if (coreMeta.sizeZ == 0) {
                    coreMeta.sizeZ = 1;
                }
                if (coreMeta.sizeT == 0) {
                    coreMeta.sizeT = 1;
                }
                coreMeta.orderCertain = true;
                coreMeta.metadataComplete = true;
                coreMeta.littleEndian = true;
                coreMeta.interleaved = coreMeta.rgb;
                coreMeta.imageCount = coreMeta.sizeZ * coreMeta.sizeT;
                if (!coreMeta.rgb) {
                    coreMeta.imageCount *= coreMeta.sizeC;
                }
                coreMeta.indexed = !coreMeta.rgb;
                coreMeta.falseColor = true;
                Object[] bytes = this.bytesPerAxis.keySet().toArray(new Integer[0]);
                Arrays.sort(bytes);
                coreMeta.dimensionOrder = "XY";
                for (Object nBytes : bytes) {
                    String axis = this.bytesPerAxis.get(nBytes);
                    if (coreMeta.dimensionOrder.indexOf(axis) != -1) continue;
                    coreMeta.dimensionOrder = coreMeta.dimensionOrder + axis;
                }
                for (String axis : axes = new String[]{"Z", "C", "T"}) {
                    if (coreMeta.dimensionOrder.indexOf(axis) != -1) continue;
                    coreMeta.dimensionOrder = coreMeta.dimensionOrder + axis;
                }
                this.core.setElementAt(coreMeta, this.numDatasets);
            }
            if (this.level != MetadataLevel.MINIMUM) {
                int c;
                int nChannels = coreMeta.rgb ? 0 : this.numChannels;
                for (c = 0; c < nChannels; ++c) {
                    this.store.setChannelPinholeSize(this.pinhole, this.numDatasets, c);
                }
                for (int i = 0; i < this.xPos.size(); ++i) {
                    int pos = i + 1;
                    this.globalMetadata.put("X position for position #" + pos, this.xPos.get(i));
                    this.globalMetadata.put("Y position for position #" + pos, this.yPos.get(i));
                    this.globalMetadata.put("Z position for position #" + pos, this.zPos.get(i));
                    for (int image = 0; image < coreMeta.imageCount; ++image) {
                        this.store.setPlanePositionX(this.xPos.get(i), this.numDatasets, image);
                        this.store.setPlanePositionY(this.yPos.get(i), this.numDatasets, image);
                        this.store.setPlanePositionZ(this.zPos.get(i), this.numDatasets, image);
                    }
                }
                for (c = 0; c < nChannels; ++c) {
                    int index;
                    int n = index = c < this.detectorIndices.size() ? this.detectorIndices.get(c) : this.detectorIndices.size() - 1;
                    if (index < 0 || index >= nChannels || index >= 0) break;
                    String id = MetadataTools.createLSID("Detector", this.numDatasets, index);
                    this.store.setDetectorSettingsID(id, this.numDatasets, c);
                }
                Object[] keys = this.channels.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (int c2 = 0; c2 < keys.length; ++c2) {
                    Channel ch = this.channels.get(keys[c2]);
                    this.store.setDetectorSettingsID(ch.detector, this.numDatasets, c2);
                    this.store.setChannelExcitationWavelength(ch.exWave, this.numDatasets, c2);
                    this.store.setChannelName(ch.name, this.numDatasets, c2);
                    this.store.setDetectorSettingsGain(ch.gain, this.numDatasets, c2);
                }
            }
            this.channels.clear();
            this.xPos.clear();
            this.yPos.clear();
            this.zPos.clear();
            this.detectorIndices.clear();
        } else if (qName.equals("Element") && this.level != MetadataLevel.MINIMUM) {
            this.multiBands.clear();
            this.nextROI = 0;
            if (this.numDatasets >= 0) {
                int c;
                int nChannels = this.core.get((int)this.numDatasets).rgb ? 1 : this.numChannels;
                for (c = 0; c < this.detectorIndices.size(); ++c) {
                    int index = this.detectorIndices.get(c);
                    if (c >= nChannels || index >= nChannels || index >= 0) break;
                    String id = MetadataTools.createLSID("Detector", this.numDatasets, index);
                    this.store.setDetectorSettingsID(id, this.numDatasets, index);
                }
                for (c = 0; c < nChannels; ++c) {
                    this.store.setChannelPinholeSize(this.pinhole, this.numDatasets, c);
                }
            }
        } else if (qName.equals("Image")) {
            this.nextChannel = 0;
        } else if (qName.equals("LDM_Block_Sequential_Master")) {
            this.canParse = true;
        } else if (qName.equals("Annotation") && this.level != MetadataLevel.MINIMUM) {
            this.roi.storeROI(this.store, this.numDatasets, this.nextROI++);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!(attributes.getLength() <= 0 || qName.equals("Element") || qName.equals("Attachment") || qName.equals("LMSDataContainerHeader"))) {
            this.nameStack.push(qName);
        }
        int oldSeriesCount = this.numDatasets;
        Hashtable h = this.getSeriesHashtable(this.numDatasets);
        if (qName.equals("LDM_Block_Sequential_Master")) {
            this.canParse = false;
        } else if (qName.startsWith("LDM")) {
            this.linkedInstruments = true;
        }
        if (!this.canParse) {
            return;
        }
        StringBuffer key = new StringBuffer();
        for (String k : this.nameStack) {
            key.append(k);
            key.append("|");
        }
        String suffix = attributes.getValue("Identifier");
        String value = attributes.getValue("Variant");
        if (suffix == null) {
            suffix = attributes.getValue("Description");
        }
        if (this.level != MetadataLevel.MINIMUM) {
            if (suffix != null && value != null) {
                this.storeKeyValue(h, key.toString() + suffix, value);
            } else {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    this.storeKeyValue(h, key.toString() + name, attributes.getValue(i));
                }
            }
        }
        if (qName.equals("Element")) {
            this.elementName = attributes.getValue("Name");
        } else if (qName.equals("Collection")) {
            this.collection = this.elementName;
        } else if (qName.equals("Image")) {
            if (!this.linkedInstruments && this.level != MetadataLevel.MINIMUM) {
                String id;
                int c = 0;
                for (Detector d : this.detectors) {
                    id = MetadataTools.createLSID("Detector", this.numDatasets, this.detectorChannel);
                    this.store.setDetectorID(id, this.numDatasets, this.detectorChannel);
                    try {
                        DetectorTypeEnumHandler handler = new DetectorTypeEnumHandler();
                        this.store.setDetectorType((DetectorType)handler.getEnumeration(d.type), this.numDatasets, this.detectorChannel);
                    }
                    catch (EnumerationException e) {
                        // empty catch block
                    }
                    this.store.setDetectorModel(d.model, this.numDatasets, this.detectorChannel);
                    this.store.setDetectorZoom(d.zoom, this.numDatasets, this.detectorChannel);
                    this.store.setDetectorOffset(d.offset, this.numDatasets, this.detectorChannel);
                    this.store.setDetectorVoltage(d.voltage, this.numDatasets, this.detectorChannel);
                    if (c < this.numChannels && d.active) {
                        this.store.setDetectorSettingsOffset(d.offset, this.numDatasets, c);
                        this.store.setDetectorSettingsID(id, this.numDatasets, c);
                        ++c;
                    }
                    ++this.detectorChannel;
                }
                int filter = 0;
                for (int i = 0; i < this.nextFilter; ++i) {
                    while (filter < this.detectors.size() && !this.detectors.get((int)filter).active) {
                        ++filter;
                    }
                    if (filter >= this.detectors.size() || filter >= this.nextFilter) break;
                    id = MetadataTools.createLSID("Filter", this.numDatasets, filter);
                    if (i < this.numChannels && this.detectors.get((int)filter).active) {
                        String lsid = MetadataTools.createLSID("Channel", this.numDatasets, i);
                        this.store.setChannelID(lsid, this.numDatasets, i);
                        this.store.setLightPathEmissionFilterRef(id, this.numDatasets, i, 0);
                    }
                    ++filter;
                }
            }
            this.core.add(new CoreMetadata());
            ++this.numDatasets;
            this.laserCount = 0;
            this.linkedInstruments = false;
            this.detectorChannel = 0;
            this.detectors.clear();
            this.lasers.clear();
            this.nextFilter = 0;
            String name = this.elementName;
            if (this.collection != null) {
                name = this.collection + "/" + name;
            }
            this.store.setImageName(name, this.numDatasets);
            h = this.getSeriesHashtable(this.numDatasets);
            this.storeKeyValue(h, "Image name", name);
            this.storeSeriesHashtable(this.numDatasets, h);
            String instrumentID = MetadataTools.createLSID("Instrument", this.numDatasets);
            this.store.setInstrumentID(instrumentID, this.numDatasets);
            this.store.setImageInstrumentRef(instrumentID, this.numDatasets);
            this.numChannels = 0;
            this.extras = 1;
        } else if (qName.equals("Attachment") && this.level != MetadataLevel.MINIMUM) {
            if ("ContextDescription".equals(attributes.getValue("Name"))) {
                this.store.setImageDescription(attributes.getValue("Content"), this.numDatasets);
            }
        } else if (qName.equals("ChannelDescription")) {
            int bytes;
            ++this.count;
            ++this.numChannels;
            this.lutNames.add(attributes.getValue("LUTName"));
            String bytesInc = attributes.getValue("BytesInc");
            int n = bytes = bytesInc == null ? 0 : Integer.parseInt(bytesInc);
            if (bytes > 0) {
                this.bytesPerAxis.put(new Integer(bytes), "C");
            }
        } else if (qName.equals("DimensionDescription")) {
            int len = Integer.parseInt(attributes.getValue("NumberOfElements"));
            int id = Integer.parseInt(attributes.getValue("DimID"));
            double physicalLen = Double.parseDouble(attributes.getValue("Length"));
            String unit = attributes.getValue("Unit");
            int nBytes = Integer.parseInt(attributes.getValue("BytesInc"));
            physicalLen /= (double)len;
            if (unit.equals("Ks")) {
                physicalLen /= 1000.0;
            } else if (unit.equals("m")) {
                physicalLen *= 1000000.0;
            }
            Double physicalSize = new Double(physicalLen);
            CoreMetadata coreMeta = this.core.get(this.core.size() - 1);
            switch (id) {
                case 1: {
                    coreMeta.sizeX = len;
                    boolean bl = coreMeta.rgb = nBytes % 3 == 0;
                    if (coreMeta.rgb) {
                        nBytes /= 3;
                    }
                    switch (nBytes) {
                        case 1: {
                            coreMeta.pixelType = 1;
                            break;
                        }
                        case 2: {
                            coreMeta.pixelType = 3;
                            break;
                        }
                        case 4: {
                            coreMeta.pixelType = 6;
                        }
                    }
                    this.physicalSizeX = physicalSize;
                    this.store.setPixelsPhysicalSizeX(physicalSize, this.numDatasets);
                    break;
                }
                case 2: {
                    if (coreMeta.sizeY != 0) {
                        if (coreMeta.sizeZ == 1) {
                            coreMeta.sizeZ = len;
                            this.bytesPerAxis.put(new Integer(nBytes), "Z");
                            break;
                        }
                        if (coreMeta.sizeT != 1) break;
                        coreMeta.sizeT = len;
                        this.bytesPerAxis.put(new Integer(nBytes), "T");
                        break;
                    }
                    coreMeta.sizeY = len;
                    this.physicalSizeY = physicalSize;
                    this.store.setPixelsPhysicalSizeY(physicalSize, this.numDatasets);
                    break;
                }
                case 3: {
                    if (coreMeta.sizeY == 0) {
                        coreMeta.sizeY = len;
                        coreMeta.sizeZ = 1;
                        this.physicalSizeY = physicalSize;
                        this.store.setPixelsPhysicalSizeY(physicalSize, this.numDatasets);
                        this.bytesPerAxis.put(new Integer(nBytes), "Y");
                        break;
                    }
                    coreMeta.sizeZ = len;
                    this.bytesPerAxis.put(new Integer(nBytes), "Z");
                    break;
                }
                case 4: {
                    if (coreMeta.sizeY == 0) {
                        coreMeta.sizeY = len;
                        coreMeta.sizeT = 1;
                        this.physicalSizeY = physicalSize;
                        this.store.setPixelsPhysicalSizeY(physicalSize, this.numDatasets);
                        this.bytesPerAxis.put(new Integer(nBytes), "Y");
                        break;
                    }
                    coreMeta.sizeT = len;
                    this.bytesPerAxis.put(new Integer(nBytes), "T");
                    break;
                }
                default: {
                    this.extras *= len;
                }
            }
            ++this.count;
        } else if (qName.equals("ScannerSettingRecord") && this.level != MetadataLevel.MINIMUM) {
            String id = attributes.getValue("Identifier");
            if (id == null) {
                id = "";
            }
            if (id.equals("SystemType")) {
                this.store.setMicroscopeModel(value, this.numDatasets);
                this.store.setMicroscopeType(MicroscopeType.OTHER, this.numDatasets);
            } else if (id.equals("dblPinhole")) {
                this.pinhole = new Double(Double.parseDouble(value) * 1000000.0);
            } else if (id.equals("dblZoom")) {
                this.zoom = new Double(value);
            } else if (id.equals("dblStepSize")) {
                double zStep = Double.parseDouble(value) * 1000000.0;
                this.store.setPixelsPhysicalSizeZ(zStep, this.numDatasets);
            } else if (id.equals("nDelayTime_s")) {
                this.store.setPixelsTimeIncrement(new Double(value), this.numDatasets);
            } else if (id.equals("CameraName")) {
                this.store.setDetectorModel(value, this.numDatasets, 0);
            } else if (id.indexOf("WFC") == 1) {
                int c = 0;
                try {
                    c = Integer.parseInt(id.replaceAll("\\D", ""));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                Channel channel = this.channels.get(this.numDatasets + "-" + c);
                if (channel == null) {
                    channel = new Channel();
                }
                if (id.endsWith("ExposureTime") && c < this.numChannels) {
                    try {
                        this.store.setPlaneExposureTime(new Double(value), this.numDatasets, c);
                    }
                    catch (IndexOutOfBoundsException e) {}
                } else if (id.endsWith("Gain")) {
                    String detectorID;
                    channel.gain = new Double(value);
                    channel.detector = detectorID = MetadataTools.createLSID("Detector", this.numDatasets, 0);
                    this.store.setDetectorID(detectorID, this.numDatasets, 0);
                    this.store.setDetectorType(DetectorType.CCD, this.numDatasets, 0);
                } else if (id.endsWith("WaveLength")) {
                    Integer exWave = new Integer(value);
                    if (exWave > 0) {
                        channel.exWave = new PositiveInteger(exWave);
                    }
                } else if (id.endsWith("UesrDefName") && !value.equals("None")) {
                    channel.name = value;
                }
                this.channels.put(this.numDatasets + "-" + c, channel);
            }
        } else if (qName.equals("FilterSettingRecord") && this.level != MetadataLevel.MINIMUM) {
            String object = attributes.getValue("ObjectName");
            String attribute = attributes.getValue("Attribute");
            String objectClass = attributes.getValue("ClassName");
            String variant = attributes.getValue("Variant");
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            if (attribute.equals("NumericalAperture")) {
                this.store.setObjectiveLensNA(new Double(variant), this.numDatasets, 0);
            } else if (attribute.equals("OrderNumber")) {
                this.store.setObjectiveSerialNumber(variant, this.numDatasets, 0);
            } else if (objectClass.equals("CDetectionUnit")) {
                if (attribute.equals("State")) {
                    Detector d = new Detector();
                    String data = attributes.getValue("data");
                    if (data == null) {
                        data = attributes.getValue("Data");
                    }
                    d.channel = data == null ? 0 : Integer.parseInt(data);
                    d.type = "PMT";
                    d.model = object;
                    d.active = variant.equals("Active");
                    d.zoom = this.zoom;
                    this.detectors.add(d);
                } else if (attribute.equals("HighVoltage")) {
                    Detector d = this.detectors.get(this.detectors.size() - 1);
                    d.voltage = new Double(variant);
                } else if (attribute.equals("VideoOffset")) {
                    Detector d = this.detectors.get(this.detectors.size() - 1);
                    d.offset = new Double(variant);
                }
            } else if (attribute.equals("Objective")) {
                StringTokenizer tokens = new StringTokenizer(variant, " ");
                boolean foundMag = false;
                StringBuffer model = new StringBuffer();
                while (!foundMag) {
                    String token = tokens.nextToken();
                    int x = token.indexOf("x");
                    if (x != -1) {
                        foundMag = true;
                        int mag = (int)Double.parseDouble(token.substring(0, x));
                        String na = token.substring(x + 1);
                        this.store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(mag)), this.numDatasets, 0);
                        this.store.setObjectiveLensNA(new Double(na), this.numDatasets, 0);
                        continue;
                    }
                    model.append(token);
                    model.append(" ");
                }
                String immersion = "Other";
                if (tokens.hasMoreTokens() && ((immersion = tokens.nextToken()) == null || immersion.trim().equals(""))) {
                    immersion = "Other";
                }
                try {
                    ImmersionEnumHandler handler = new ImmersionEnumHandler();
                    this.store.setObjectiveImmersion((Immersion)handler.getEnumeration(immersion), this.numDatasets, 0);
                }
                catch (EnumerationException e) {
                    // empty catch block
                }
                String correction = "Other";
                if (tokens.hasMoreTokens() && ((correction = tokens.nextToken()) == null || correction.trim().equals(""))) {
                    correction = "Other";
                }
                try {
                    CorrectionEnumHandler handler = new CorrectionEnumHandler();
                    this.store.setObjectiveCorrection((Correction)handler.getEnumeration(correction), this.numDatasets, 0);
                }
                catch (EnumerationException e) {
                    // empty catch block
                }
                this.store.setObjectiveModel(model.toString().trim(), this.numDatasets, 0);
            } else if (attribute.equals("RefractionIndex")) {
                String id = MetadataTools.createLSID("Objective", this.numDatasets, 0);
                this.store.setObjectiveID(id, this.numDatasets, 0);
                this.store.setImageObjectiveSettingsID(id, this.numDatasets);
                this.store.setImageObjectiveSettingsRefractiveIndex(new Double(variant), this.numDatasets);
            } else if (attribute.equals("XPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount;
                Double posX = new Double(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    this.store.setPlanePositionX(posX, this.numDatasets, image);
                }
                if (this.numChannels == 0) {
                    this.xPos.add(posX);
                }
            } else if (attribute.equals("YPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount;
                Double posY = new Double(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    this.store.setPlanePositionY(posY, this.numDatasets, image);
                }
                if (this.numChannels == 0) {
                    this.yPos.add(posY);
                }
            } else if (attribute.equals("ZPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount;
                Double posZ = new Double(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    this.store.setPlanePositionZ(posZ, this.numDatasets, image);
                }
                if (this.numChannels == 0) {
                    this.zPos.add(posZ);
                }
            } else if (objectClass.equals("CSpectrophotometerUnit")) {
                Integer v = null;
                try {
                    v = new Integer((int)Double.parseDouble(variant));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (attributes.getValue("Description").endsWith("(left)")) {
                    String id = MetadataTools.createLSID("Filter", this.numDatasets, this.nextFilter);
                    this.store.setFilterID(id, this.numDatasets, this.nextFilter);
                    this.store.setFilterModel(object, this.numDatasets, this.nextFilter);
                    if (v != null) {
                        this.store.setTransmittanceRangeCutIn(new PositiveInteger(v), this.numDatasets, this.nextFilter);
                    }
                } else if (attributes.getValue("Description").endsWith("(right)") && v != null) {
                    this.store.setTransmittanceRangeCutOut(new PositiveInteger(v), this.numDatasets, this.nextFilter);
                    ++this.nextFilter;
                }
            }
        } else if (qName.equals("Detector") && this.level != MetadataLevel.MINIMUM) {
            String v = attributes.getValue("Gain");
            Double gain = v == null ? null : new Double(v);
            v = attributes.getValue("Offset");
            Double offset = v == null ? null : new Double(v);
            boolean active = "1".equals(attributes.getValue("IsActive"));
            if (active) {
                MultiBand m = null;
                Detector detector = null;
                Laser laser = this.lasers.size() == 0 ? null : this.lasers.get(this.lasers.size() - 1);
                String c = attributes.getValue("Channel");
                int channel = c == null ? 0 : Integer.parseInt(c);
                for (MultiBand mb : this.multiBands) {
                    if (mb.channel != channel) continue;
                    m = mb;
                    break;
                }
                for (Detector d : this.detectors) {
                    if (d.channel != channel) continue;
                    detector = d;
                    break;
                }
                String id = MetadataTools.createLSID("Detector", this.numDatasets, this.nextChannel);
                if (m != null) {
                    String channelID = MetadataTools.createLSID("Channel", this.numDatasets, this.nextChannel);
                    this.store.setChannelID(channelID, this.numDatasets, this.nextChannel);
                    this.store.setChannelName(m.dyeName, this.numDatasets, this.nextChannel);
                    String filter = MetadataTools.createLSID("Filter", this.numDatasets, this.nextFilter);
                    this.store.setFilterID(filter, this.numDatasets, this.nextFilter);
                    this.store.setTransmittanceRangeCutIn(new PositiveInteger(Integer.valueOf(m.cutIn)), this.numDatasets, this.nextFilter);
                    this.store.setTransmittanceRangeCutOut(new PositiveInteger(Integer.valueOf(m.cutOut)), this.numDatasets, this.nextFilter);
                    this.store.setLightPathEmissionFilterRef(filter, this.numDatasets, this.nextChannel, 0);
                    ++this.nextFilter;
                    this.store.setDetectorID(id, this.numDatasets, this.nextChannel);
                    this.store.setDetectorType(DetectorType.PMT, this.numDatasets, this.nextChannel);
                    this.store.setDetectorSettingsGain(gain, this.numDatasets, this.nextChannel);
                    this.store.setDetectorSettingsOffset(offset, this.numDatasets, this.nextChannel);
                    this.store.setDetectorSettingsID(id, this.numDatasets, this.nextChannel);
                }
                this.store.setDetectorID(id, this.numDatasets, this.nextChannel);
                if (detector != null) {
                    this.store.setDetectorSettingsGain(gain, this.numDatasets, this.nextChannel);
                    this.store.setDetectorSettingsOffset(offset, this.numDatasets, this.nextChannel);
                    this.store.setDetectorSettingsID(id, this.numDatasets, this.nextChannel);
                    try {
                        DetectorTypeEnumHandler handler = new DetectorTypeEnumHandler();
                        this.store.setDetectorType((DetectorType)handler.getEnumeration(detector.type), this.numDatasets, this.nextChannel);
                    }
                    catch (EnumerationException e) {
                        // empty catch block
                    }
                    this.store.setDetectorModel(detector.model, this.numDatasets, this.nextChannel);
                    this.store.setDetectorZoom(detector.zoom, this.numDatasets, this.nextChannel);
                    this.store.setDetectorOffset(detector.offset, this.numDatasets, this.nextChannel);
                    this.store.setDetectorVoltage(detector.voltage, this.numDatasets, this.nextChannel);
                }
                if (laser != null && laser.intensity < 100.0) {
                    this.store.setChannelLightSourceSettingsID(laser.id, this.numDatasets, this.nextChannel);
                    this.store.setChannelLightSourceSettingsAttenuation(new PercentFraction(Float.valueOf((float)laser.intensity / 100.0f)), this.numDatasets, this.nextChannel);
                    this.store.setChannelExcitationWavelength(new PositiveInteger(laser.wavelength), this.numDatasets, this.nextChannel);
                }
                ++this.nextChannel;
            }
        } else if (qName.equals("LaserLineSetting") && this.level != MetadataLevel.MINIMUM) {
            Laser l = new Laser();
            String lineIndex = attributes.getValue("LineIndex");
            String qual = attributes.getValue("Qualifier");
            l.index = lineIndex == null ? 0 : Integer.parseInt(lineIndex);
            int qualifier = qual == null ? 0 : Integer.parseInt(qual);
            l.index += 2 - qualifier / 10;
            if (l.index < 0) {
                l.index = 0;
            }
            l.id = MetadataTools.createLSID("LightSource", this.numDatasets, l.index);
            l.wavelength = new Integer(attributes.getValue("LaserLine"));
            while (l.index > this.laserCount) {
                String lsid = MetadataTools.createLSID("LightSource", this.numDatasets, this.laserCount);
                this.store.setLaserID(lsid, this.numDatasets, this.laserCount);
                ++this.laserCount;
            }
            this.store.setLaserID(l.id, this.numDatasets, l.index);
            ++this.laserCount;
            if (l.wavelength > 0) {
                this.store.setLaserWavelength(new PositiveInteger(l.wavelength), this.numDatasets, l.index);
            }
            this.store.setLaserType(LaserType.OTHER, this.numDatasets, l.index);
            this.store.setLaserLaserMedium(LaserMedium.OTHER, this.numDatasets, l.index);
            String intensity = attributes.getValue("IntensityDev");
            double d = l.intensity = intensity == null ? 0.0 : Double.parseDouble(intensity);
            if (l.intensity > 0.0) {
                l.intensity = 100.0 - l.intensity;
                this.lasers.add(l);
            }
        } else if (qName.equals("TimeStamp") && this.numDatasets >= 0) {
            String stampHigh = attributes.getValue("HighInteger");
            String stampLow = attributes.getValue("LowInteger");
            long high = stampHigh == null ? 0L : Long.parseLong(stampHigh);
            long low = stampLow == null ? 0L : Long.parseLong(stampLow);
            long ms = DateTools.getMillisFromTicks((long)high, (long)low);
            if (this.count == 0) {
                String date = DateTools.convertDate((long)ms, (int)1);
                if (DateTools.getTime((String)date, (String)"yyyy-MM-dd'T'HH:mm:ss") < System.currentTimeMillis()) {
                    this.store.setImageAcquiredDate(date, this.numDatasets);
                }
                this.firstStamp = ms;
                this.store.setPlaneDeltaT(0.0, this.numDatasets, this.count);
            } else if (this.level != MetadataLevel.MINIMUM) {
                CoreMetadata coreMeta = this.core.get(this.numDatasets);
                int nImages = coreMeta.sizeZ * coreMeta.sizeT * coreMeta.sizeC;
                if (this.count < nImages) {
                    this.store.setPlaneDeltaT((double)(ms -= this.firstStamp) / 1000.0, this.numDatasets, this.count);
                }
            }
            ++this.count;
        } else if (qName.equals("RelTimeStamp") && this.level != MetadataLevel.MINIMUM) {
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            int nImages = coreMeta.sizeZ * coreMeta.sizeT * coreMeta.sizeC;
            if (this.count < nImages) {
                Double time = new Double(attributes.getValue("Time"));
                this.store.setPlaneDeltaT(time, this.numDatasets, this.count++);
            }
        } else if (qName.equals("Annotation") && this.level != MetadataLevel.MINIMUM) {
            String color;
            this.roi = new ROI();
            String type = attributes.getValue("type");
            if (type != null) {
                this.roi.type = Integer.parseInt(type);
            }
            if ((color = attributes.getValue("color")) != null) {
                this.roi.color = Integer.parseInt(color);
            }
            this.roi.name = attributes.getValue("name");
            this.roi.fontName = attributes.getValue("fontName");
            this.roi.fontSize = attributes.getValue("fontSize");
            this.roi.transX = this.parseDouble(attributes.getValue("transTransX"));
            this.roi.transY = this.parseDouble(attributes.getValue("transTransY"));
            this.roi.scaleX = this.parseDouble(attributes.getValue("transScalingX"));
            this.roi.scaleY = this.parseDouble(attributes.getValue("transScalingY"));
            this.roi.rotation = this.parseDouble(attributes.getValue("transRotation"));
            String linewidth = attributes.getValue("linewidth");
            if (linewidth != null) {
                this.roi.linewidth = Integer.parseInt(linewidth);
            }
            this.roi.text = attributes.getValue("text");
        } else if (qName.equals("Vertex") && this.level != MetadataLevel.MINIMUM) {
            String x = attributes.getValue("x");
            String y = attributes.getValue("y");
            if (x != null) {
                x = x.replaceAll(",", ".");
                this.roi.x.add(new Double(x));
            }
            if (y != null) {
                y = y.replaceAll(",", ".");
                this.roi.y.add(new Double(y));
            }
        } else if (qName.equals("ROI")) {
            this.alternateCenter = true;
        } else if (qName.equals("MultiBand") && this.level != MetadataLevel.MINIMUM) {
            MultiBand m = new MultiBand();
            m.dyeName = attributes.getValue("DyeName");
            m.channel = Integer.parseInt(attributes.getValue("Channel"));
            m.cutIn = (int)Math.round(Double.parseDouble(attributes.getValue("LeftWorld")));
            m.cutOut = (int)Math.round(Double.parseDouble(attributes.getValue("RightWorld")));
            this.multiBands.add(m);
        } else if (qName.equals("ChannelInfo")) {
            int index = Integer.parseInt(attributes.getValue("Index"));
            this.channels.remove(this.numDatasets + "-" + index);
        } else {
            this.count = 0;
        }
        if (this.numDatasets == oldSeriesCount) {
            this.storeSeriesHashtable(this.numDatasets, h);
        }
    }

    private Hashtable getSeriesHashtable(int series) {
        if (series < 0 || series >= this.core.size()) {
            return new Hashtable();
        }
        return this.core.get((int)series).seriesMetadata;
    }

    private void storeSeriesHashtable(int series, Hashtable h) {
        Object[] keys;
        if (series < 0) {
            return;
        }
        for (Object key : keys = h.keySet().toArray(new Object[h.size()])) {
            Object value = h.get(key);
            if (!(value instanceof Vector)) continue;
            Vector v = (Vector)value;
            for (int o = 0; o < v.size(); ++o) {
                h.put(key + " " + (o + 1), v.get(o));
            }
            h.remove(key);
        }
        CoreMetadata coreMeta = this.core.get(series);
        coreMeta.seriesMetadata = h;
        this.core.setElementAt(coreMeta, series);
    }

    private double parseDouble(String number) {
        if (number != null) {
            number = number.replaceAll(",", ".");
            return Double.parseDouble(number);
        }
        return 0.0;
    }

    private void storeKeyValue(Hashtable h, String key, String value) {
        if (h.get(key) == null) {
            h.put(key, value);
        } else {
            Object oldValue = h.get(key);
            if (oldValue instanceof Vector) {
                Vector values = (Vector)oldValue;
                values.add(value);
                h.put(key, values);
            } else {
                Vector<Object> values = new Vector<Object>();
                values.add(oldValue);
                values.add(value);
                h.put(key, values);
            }
        }
    }

    class Channel {
        public String detector;
        public Double gain;
        public PositiveInteger exWave;
        public String name;

        Channel() {
        }
    }

    class Laser {
        public Integer wavelength;
        public double intensity;
        public String id;
        public int index;

        Laser() {
        }
    }

    class Detector {
        public int channel;
        public Double zoom;
        public String type;
        public String model;
        public boolean active;
        public Double voltage;
        public Double offset;

        Detector() {
        }
    }

    class MultiBand {
        public int channel;
        public int cutIn;
        public int cutOut;
        public String dyeName;

        MultiBand() {
        }
    }

    class ROI {
        public static final int TEXT = 512;
        public static final int SCALE_BAR = 8192;
        public static final int POLYGON = 32;
        public static final int RECTANGLE = 16;
        public static final int LINE = 256;
        public static final int ARROW = 2;
        public int type;
        public Vector<Double> x = new Vector();
        public Vector<Double> y = new Vector();
        public double transX;
        public double transY;
        public double scaleX;
        public double scaleY;
        public double rotation;
        public int color;
        public int linewidth;
        public String text;
        public String fontName;
        public String fontSize;
        public String name;
        private boolean normalized = false;

        ROI() {
        }

        public void storeROI(MetadataStore store, int series, int roi) {
            if (LeicaHandler.this.level == MetadataLevel.NO_OVERLAYS || LeicaHandler.this.level == MetadataLevel.MINIMUM) {
                return;
            }
            store.setROIID(MetadataTools.createLSID("ROI", roi), roi);
            store.setTextID(MetadataTools.createLSID("Shape", roi, 0), roi, 0);
            if (this.text == null) {
                this.text = "";
            }
            store.setTextValue(this.text, roi, 0);
            if (this.fontSize != null) {
                store.setTextFontSize(new NonNegativeInteger(Integer.valueOf((int)Double.parseDouble(this.fontSize))), roi, 0);
            }
            store.setTextStrokeWidth(new Double(this.linewidth), roi, 0);
            if (!this.normalized) {
                this.normalize();
            }
            double cornerX = this.x.get(0);
            double cornerY = this.y.get(0);
            store.setTextX(cornerX, roi, 0);
            store.setTextY(cornerY, roi, 0);
            int centerX = ((CoreMetadata)((LeicaHandler)LeicaHandler.this).core.get((int)series)).sizeX / 2 - 1;
            int centerY = ((CoreMetadata)((LeicaHandler)LeicaHandler.this).core.get((int)series)).sizeY / 2 - 1;
            double roiX = (double)centerX + this.transX;
            double roiY = (double)centerY + this.transY;
            if (LeicaHandler.this.alternateCenter) {
                roiX = this.transX - 2.0 * cornerX;
                roiY = this.transY - 2.0 * cornerY;
            }
            String shapeID = MetadataTools.createLSID("Shape", roi, 1);
            switch (this.type) {
                case 32: {
                    StringBuffer points = new StringBuffer();
                    for (int i = 0; i < this.x.size(); ++i) {
                        points.append(this.x.get(i) + roiX);
                        points.append(",");
                        points.append(this.y.get(i) + roiY);
                        if (i >= this.x.size() - 1) continue;
                        points.append(" ");
                    }
                    store.setPolylineID(shapeID, roi, 1);
                    store.setPolylinePoints(points.toString(), roi, 1);
                    store.setPolylineClosed(Boolean.TRUE, roi, 1);
                    break;
                }
                case 16: 
                case 512: {
                    store.setRectangleID(shapeID, roi, 1);
                    store.setRectangleX(roiX - Math.abs(cornerX), roi, 1);
                    store.setRectangleY(roiY - Math.abs(cornerY), roi, 1);
                    double width = 2.0 * Math.abs(cornerX);
                    double height = 2.0 * Math.abs(cornerY);
                    store.setRectangleWidth(width, roi, 1);
                    store.setRectangleHeight(height, roi, 1);
                    break;
                }
                case 2: 
                case 256: 
                case 8192: {
                    store.setLineID(shapeID, roi, 1);
                    store.setLineX1(roiX + this.x.get(0), roi, 1);
                    store.setLineY1(roiY + this.y.get(0), roi, 1);
                    store.setLineX2(roiX + this.x.get(1), roi, 1);
                    store.setLineY2(roiY + this.y.get(1), roi, 1);
                }
            }
        }

        private void normalize() {
            double coordinate;
            int i;
            if (this.normalized) {
                return;
            }
            this.transX *= 1000000.0;
            this.transY *= 1000000.0;
            this.transX *= 1.0 / LeicaHandler.this.physicalSizeX;
            this.transY *= 1.0 / LeicaHandler.this.physicalSizeY;
            for (i = 0; i < this.x.size(); ++i) {
                coordinate = this.x.get(i) * 1000000.0;
                this.x.setElementAt(coordinate *= 1.0 / LeicaHandler.this.physicalSizeX, i);
            }
            for (i = 0; i < this.y.size(); ++i) {
                coordinate = this.y.get(i) * 1000000.0;
                this.y.setElementAt(coordinate *= 1.0 / LeicaHandler.this.physicalSizeY, i);
            }
            this.normalized = true;
        }
    }
}

