/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeicaReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaReader.class);
    public static final String[] LEI_SUFFIX = new String[]{"lei"};
    private static final int LEICA_MAGIC_TAG = 33923;
    private static final String DATE_FORMAT = "yyyy:MM:dd,HH:mm:ss:SSS";
    private static final Integer SERIES = new Integer(10);
    private static final Integer IMAGES = new Integer(15);
    private static final Integer DIMDESCR = new Integer(20);
    private static final Integer FILTERSET = new Integer(30);
    private static final Integer TIMEINFO = new Integer(40);
    private static final Integer SCANNERSET = new Integer(50);
    private static final Integer EXPERIMENT = new Integer(60);
    private static final Integer LUTDESC = new Integer(70);
    private static final Integer CHANDESC = new Integer(80);
    private static final Integer SEQUENTIALSET = new Integer(90);
    private static final Integer SEQ_SCANNERSET = new Integer(200);
    private static final Integer SEQ_FILTERSET = new Integer(700);
    private static final int SEQ_SCANNERSET_END = 300;
    private static final int SEQ_FILTERSET_END = 800;
    private static final Hashtable<String, Integer> CHANNEL_PRIORITIES = LeicaReader.createChannelPriorities();
    private static Hashtable<Integer, String> dimensionNames = LeicaReader.makeDimensionTable();
    protected IFDList ifds;
    protected IFDList headerIFDs;
    protected MinimalTiffReader tiff;
    protected Vector[] files;
    private int numSeries;
    private String leiFilename;
    private int fileLength;
    private boolean[] valid;
    private String[][] timestamps;
    private Vector<String> seriesNames;
    private Vector<String> seriesDescriptions;
    private int lastPlane = 0;
    private int nameLength = 0;
    private double[][] physicalSizes;
    private double[] pinhole;
    private double[] exposureTime;
    private int nextDetector = 0;
    private int nextChannel = 0;
    private Vector<Integer> activeChannelIndices = new Vector();
    private boolean sequential = false;
    private Vector[] channelNames;
    private Vector[] emWaves;
    private Vector[] exWaves;
    private boolean[][] cutInPopulated;
    private boolean[][] cutOutPopulated;
    private boolean[][] filterRefPopulated;
    private Double detectorOffset;
    private Double detectorVoltage;

    private static Hashtable<String, Integer> createChannelPriorities() {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    public LeicaReader() {
        super("Leica", new String[]{"lei", "tif", "tiff", "raw"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (LeicaReader.checkSuffix(name, LEI_SUFFIX)) {
            return true;
        }
        if (!LeicaReader.checkSuffix(name, TiffReader.TIFF_SUFFIXES) && !LeicaReader.checkSuffix(name, "raw")) {
            return false;
        }
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        return lei.exists();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(new Integer(33923));
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int index = Math.min(this.lastPlane, this.files[this.series].size() - 1);
            this.tiff.setId((String)this.files[this.series].get(index));
            return this.tiff.get8BitLookupTable();
        }
        catch (FormatException e) {
            LOGGER.debug("Failed to retrieve lookup table", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to retrieve lookup table", (Throwable)e);
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int index = Math.min(this.lastPlane, this.files[this.series].size() - 1);
            this.tiff.setId((String)this.files[this.series].get(index));
            return this.tiff.get16BitLookupTable();
        }
        catch (FormatException e) {
            LOGGER.debug("Failed to retrieve lookup table", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to retrieve lookup table", (Throwable)e);
        }
        return null;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        int fileIndex = no < this.files[this.series].size() ? no : 0;
        int planeIndex = no < this.files[this.series].size() ? 0 : no;
        String filename = (String)this.files[this.series].get(fileIndex);
        if (new Location(filename).exists()) {
            if (LeicaReader.checkSuffix(filename, TiffReader.TIFF_SUFFIXES)) {
                this.tiff.setId(filename);
                return this.tiff.openBytes(planeIndex, buf, x, y, w, h);
            }
            RandomAccessInputStream s = new RandomAccessInputStream(filename);
            s.seek((long)(planeIndex * FormatTools.getPlaneSize(this)));
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        if (this.leiFilename != null) {
            v.add(this.leiFilename);
        }
        if (!noPixels && this.files != null) {
            for (Object file : this.files[this.getSeries()]) {
                if (file == null || !new Location((String)file).exists()) continue;
                v.add((String)file);
            }
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.leiFilename = null;
            this.files = null;
            this.headerIFDs = null;
            this.ifds = null;
            this.tiff = null;
            this.seriesNames = null;
            this.numSeries = 0;
            this.lastPlane = 0;
            this.physicalSizes = null;
            this.seriesDescriptions = null;
            this.exposureTime = null;
            this.pinhole = null;
            this.nextDetector = 0;
            this.nextChannel = 0;
            this.sequential = false;
            this.activeChannelIndices.clear();
            this.channelNames = null;
            this.emWaves = null;
            this.exWaves = null;
            this.cutInPopulated = null;
            this.cutOutPopulated = null;
            this.filterRefPopulated = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int i2;
        int i3;
        this.close();
        String leiFile = this.findLEIFile(id);
        if (leiFile == null || leiFile.trim().length() == 0 || new Location(leiFile).isDirectory()) {
            if (LeicaReader.checkSuffix(id, TiffReader.TIFF_SUFFIXES)) {
                super.initFile(id);
                TiffReader r = new TiffReader();
                r.setMetadataStore(this.getMetadataStore());
                r.setId(id);
                this.core = r.getCoreMetadata();
                this.metadataStore = r.getMetadataStore();
                Hashtable<String, Object> globalMetadata = r.getGlobalMetadata();
                for (String key : globalMetadata.keySet()) {
                    this.addGlobalMeta(key.toString(), globalMetadata.get(key));
                }
                r.close();
                this.files = new Vector[]{new Vector()};
                this.files[0].add(id);
                this.tiff = new MinimalTiffReader();
                return;
            }
            throw new FormatException("LEI file not found.");
        }
        super.initFile(leiFile);
        this.leiFilename = new File(leiFile).exists() ? new Location(leiFile).getAbsolutePath() : id;
        this.in = new RandomAccessInputStream(leiFile);
        MetadataLevel metadataLevel = this.metadataOptions.getMetadataLevel();
        this.seriesNames = new Vector();
        byte[] fourBytes = new byte[4];
        this.in.read(fourBytes);
        this.core[0].littleEndian = fourBytes[0] == 73 && fourBytes[1] == 73 && fourBytes[2] == 73 && fourBytes[3] == 73;
        boolean realLittleEndian = this.isLittleEndian();
        this.in.order(this.isLittleEndian());
        LOGGER.info("Reading metadata blocks");
        this.in.skipBytes(8);
        int addr = this.in.readInt();
        this.headerIFDs = new IFDList();
        while (addr != 0) {
            IFD ifd = new IFD();
            this.headerIFDs.add(ifd);
            this.in.seek((long)(addr + 4));
            int tag = this.in.readInt();
            while (tag != 0) {
                int offset = this.in.readInt();
                long pos = this.in.getFilePointer();
                this.in.seek((long)(offset + 12));
                int size = this.in.readInt();
                ifd.putIFDValue(tag, this.in.getFilePointer());
                this.in.seek(pos);
                tag = this.in.readInt();
            }
            addr = this.in.readInt();
        }
        this.numSeries = this.headerIFDs.size();
        this.core = new CoreMetadata[this.numSeries];
        for (i3 = 0; i3 < this.numSeries; ++i3) {
            this.core[i3] = new CoreMetadata();
        }
        this.files = new Vector[this.numSeries];
        this.channelNames = new Vector[this.getSeriesCount()];
        this.emWaves = new Vector[this.getSeriesCount()];
        this.exWaves = new Vector[this.getSeriesCount()];
        this.cutInPopulated = new boolean[this.getSeriesCount()][];
        this.cutOutPopulated = new boolean[this.getSeriesCount()][];
        this.filterRefPopulated = new boolean[this.getSeriesCount()][];
        for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
            this.channelNames[i3] = new Vector();
            this.emWaves[i3] = new Vector();
            this.exWaves[i3] = new Vector();
        }
        LOGGER.info("Parsing metadata blocks");
        this.core[0].littleEndian = !this.isLittleEndian();
        boolean seriesIndex = false;
        int invalidCount = 0;
        this.valid = new boolean[this.numSeries];
        this.timestamps = new String[this.headerIFDs.size()][];
        for (int i4 = 0; i4 < this.headerIFDs.size(); ++i4) {
            IFD ifd = (IFD)this.headerIFDs.get(i4);
            this.valid[i4] = true;
            if (ifd.get(SERIES) != null) {
                long offset = (Long)ifd.get(SERIES);
                this.in.seek(offset + 8L);
                this.nameLength = this.in.readInt() * 2;
            }
            this.in.seek(((Long)ifd.get(IMAGES)).longValue());
            this.parseFilenames(i4);
            if (this.valid[i4]) continue;
            ++invalidCount;
        }
        this.numSeries -= invalidCount;
        int[] count = new int[this.getSeriesCount()];
        for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
            count[i5] = this.core[i5].imageCount;
        }
        Vector[] tempFiles = this.files;
        IFDList tempIFDs = this.headerIFDs;
        this.core = new CoreMetadata[this.numSeries];
        this.files = new Vector[this.numSeries];
        this.headerIFDs = new IFDList();
        int index = 0;
        for (i2 = 0; i2 < this.numSeries; ++i2) {
            this.core[i2] = new CoreMetadata();
            while (!this.valid[index]) {
                ++index;
            }
            this.core[i2].imageCount = count[index];
            this.files[i2] = tempFiles[index];
            Object[] sorted = this.files[i2].toArray();
            Arrays.sort(sorted);
            this.files[i2].clear();
            this.files[i2].addAll(Arrays.asList(sorted));
            this.headerIFDs.add(tempIFDs.get(index));
            ++index;
        }
        this.tiff = new MinimalTiffReader();
        LOGGER.info("Populating metadata");
        if (this.headerIFDs == null) {
            this.headerIFDs = this.ifds;
        }
        this.seriesDescriptions = new Vector();
        this.physicalSizes = new double[this.headerIFDs.size()][5];
        this.pinhole = new double[this.headerIFDs.size()];
        this.exposureTime = new double[this.headerIFDs.size()];
        for (i2 = 0; i2 < this.headerIFDs.size(); ++i2) {
            IFD ifd = (IFD)this.headerIFDs.get(i2);
            this.core[i2].littleEndian = this.isLittleEndian();
            this.setSeries(i2);
            Object[] keys = ifd.keySet().toArray(new Integer[ifd.size()]);
            Arrays.sort(keys);
            for (Object key : keys) {
                long offset = (Long)ifd.get(key);
                this.in.seek(offset);
                if (((Integer)key).equals(SERIES)) {
                    this.parseSeriesTag();
                    continue;
                }
                if (((Integer)key).equals(IMAGES)) {
                    this.parseImageTag(i2);
                    continue;
                }
                if (((Integer)key).equals(DIMDESCR)) {
                    this.parseDimensionTag(i2);
                    continue;
                }
                if (((Integer)key).equals(TIMEINFO) && metadataLevel != MetadataLevel.MINIMUM) {
                    this.parseTimeTag(i2);
                    continue;
                }
                if (((Integer)key).equals(EXPERIMENT) && metadataLevel != MetadataLevel.MINIMUM) {
                    this.parseExperimentTag();
                    continue;
                }
                if (((Integer)key).equals(LUTDESC)) {
                    this.parseLUT(i2);
                    continue;
                }
                if (!((Integer)key).equals(CHANDESC) || metadataLevel == MetadataLevel.MINIMUM) continue;
                this.parseChannelTag();
            }
            this.core[i2].orderCertain = true;
            this.core[i2].littleEndian = this.isLittleEndian();
            this.core[i2].falseColor = true;
            this.core[i2].metadataComplete = true;
            this.core[i2].interleaved = false;
            String filename = (String)this.files[i2].get(0);
            this.tiff.setId(filename);
            this.core[i2].sizeX = this.tiff.getSizeX();
            this.core[i2].sizeY = this.tiff.getSizeY();
        }
        for (i2 = 0; i2 < this.numSeries; ++i2) {
            this.setSeries(i2);
            if (this.getSizeZ() == 0) {
                this.core[i2].sizeZ = 1;
            }
            if (this.getSizeT() == 0) {
                this.core[i2].sizeT = 1;
            }
            if (this.getSizeC() == 0) {
                this.core[i2].sizeC = 1;
            }
            if (this.getImageCount() == 0) {
                this.core[i2].imageCount = 1;
            }
            if (this.getImageCount() == 1 && this.getSizeZ() * this.getSizeT() > 1) {
                this.core[i2].sizeZ = 1;
                this.core[i2].sizeT = 1;
            }
            if (this.getSizeY() == 1 || this.getSizeY() == this.getSizeZ() || this.getSizeY() == this.getSizeT()) {
                if (this.getSizeZ() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeT()) {
                    this.core[i2].sizeY = this.getSizeZ();
                    this.core[i2].sizeZ = 1;
                } else if (this.getSizeT() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeZ()) {
                    this.core[i2].sizeY = this.getSizeT();
                    this.core[i2].sizeT = 1;
                }
            }
            if (this.isRGB()) {
                this.core[i2].indexed = false;
            }
            this.core[i2].dimensionOrder = MetadataTools.makeSaneDimensionOrder(this.getDimensionOrder());
            this.core[i2].littleEndian = realLittleEndian;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.numSeries; ++i) {
            store.setImageName(this.seriesNames.get(i), i);
        }
        if (metadataLevel == MetadataLevel.MINIMUM) {
            return;
        }
        for (i = 0; i < this.numSeries; ++i) {
            IFD ifd = (IFD)this.headerIFDs.get(i);
            long firstPlane = 0L;
            if (i < this.timestamps.length && this.timestamps[i] != null && this.timestamps[i].length > 0) {
                firstPlane = DateTools.getTime((String)this.timestamps[i][0], (String)DATE_FORMAT);
                store.setImageAcquiredDate(DateTools.formatDate((String)this.timestamps[i][0], (String)DATE_FORMAT), i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            store.setImageDescription(this.seriesDescriptions.get(i), i);
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            this.nextDetector = 0;
            this.nextChannel = 0;
            this.cutInPopulated[i] = new boolean[this.core[i].sizeC];
            this.cutOutPopulated[i] = new boolean[this.core[i].sizeC];
            this.filterRefPopulated[i] = new boolean[this.core[i].sizeC];
            Object[] keys = ifd.keySet().toArray(new Integer[ifd.size()]);
            Arrays.sort(keys);
            int nextInstrumentBlock = 1;
            this.sequential = DataTools.indexOf((Object[])keys, (Object)SEQ_SCANNERSET) != -1;
            for (Object key : keys) {
                if (!((Integer)key).equals(FILTERSET) && !((Integer)key).equals(SCANNERSET) && !((Integer)key).equals(SEQ_SCANNERSET) && !((Integer)key).equals(SEQ_FILTERSET) && ((Integer)key <= SEQ_SCANNERSET || (Integer)key >= 300) && ((Integer)key <= SEQ_FILTERSET || (Integer)key >= 800) || this.sequential && (((Integer)key).equals(FILTERSET) || ((Integer)key).equals(SCANNERSET))) continue;
                long offset = (Long)ifd.get(key);
                this.in.seek(offset);
                this.setSeries(i);
                this.parseInstrumentData(store, nextInstrumentBlock++);
            }
            this.activeChannelIndices.clear();
            store.setImageInstrumentRef(instrumentID, i);
            store.setPixelsPhysicalSizeX(this.physicalSizes[i][0], i);
            store.setPixelsPhysicalSizeY(this.physicalSizes[i][1], i);
            store.setPixelsPhysicalSizeZ(this.physicalSizes[i][2], i);
            if ((int)this.physicalSizes[i][4] > 0) {
                store.setPixelsTimeIncrement(this.physicalSizes[i][4], i);
            }
            for (int j = 0; j < this.core[i].imageCount; ++j) {
                if (this.timestamps[i] == null || j >= this.timestamps[i].length) continue;
                long time = DateTools.getTime((String)this.timestamps[i][j], (String)DATE_FORMAT);
                double elapsedTime = (double)(time - firstPlane) / 1000.0;
                store.setPlaneDeltaT(elapsedTime, i, j);
                store.setPlaneExposureTime(this.exposureTime[i], i, j);
            }
        }
        this.setSeries(0);
    }

    private String findLEIFile(String baseFile) throws FormatException, IOException {
        if (LeicaReader.checkSuffix(baseFile, LEI_SUFFIX)) {
            return baseFile;
        }
        if (LeicaReader.checkSuffix(baseFile, TiffReader.TIFF_SUFFIXES) && this.isGroupFiles()) {
            if (this.ifds == null) {
                super.initFile(baseFile);
            }
            this.in = new RandomAccessInputStream(baseFile);
            TiffParser tp = new TiffParser(this.in);
            this.in.order(tp.checkHeader().booleanValue());
            this.in.seek(0L);
            LOGGER.info("Finding companion file name");
            this.ifds = tp.getIFDs();
            if (this.ifds == null) {
                throw new FormatException("No IFDs found");
            }
            String descr = ((IFD)this.ifds.get(0)).getComment();
            descr = descr.replaceAll("\\[.*.\\]\n", "");
            String lei = baseFile.substring(0, baseFile.lastIndexOf(File.separator) + 1);
            StringTokenizer lines = new StringTokenizer(descr, "\n");
            String line = null;
            String key = null;
            String value = null;
            while (lines.hasMoreTokens()) {
                line = lines.nextToken();
                if (line.indexOf("=") == -1) continue;
                key = line.substring(0, line.indexOf("=")).trim();
                value = line.substring(line.indexOf("=") + 1).trim();
                this.addGlobalMeta(key, value);
                if (!key.startsWith("Series Name")) continue;
                lei = lei + value;
            }
            Location l = new Location(lei).getAbsoluteFile();
            if (l.exists()) {
                return lei;
            }
            l = l.getParentFile();
            String[] list = l.list();
            for (int i = 0; i < list.length; ++i) {
                if (!LeicaReader.checkSuffix(list[i], LEI_SUFFIX)) continue;
                return new Location(l.getAbsolutePath(), list[i]).getAbsolutePath();
            }
        } else if (LeicaReader.checkSuffix(baseFile, "raw") && this.isGroupFiles()) {
            Location lei;
            String prefix = baseFile;
            if (prefix.indexOf(".") != -1) {
                prefix = prefix.substring(0, prefix.lastIndexOf("."));
            }
            if (!(lei = new Location(prefix + ".lei")).exists()) {
                lei = new Location(prefix + ".LEI");
                while (!lei.exists() && prefix.indexOf("_") != -1) {
                    lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                    if (lei.exists()) continue;
                    lei = new Location(prefix + ".LEI");
                }
            }
            if (lei.exists()) {
                return lei.getAbsolutePath();
            }
        }
        return null;
    }

    private void parseFilenames(int seriesIndex) throws IOException {
        int maxPlanes = 0;
        Vector<String> f = new Vector<String>();
        int tempImages = this.in.readInt();
        if ((long)tempImages * (long)this.nameLength > this.in.length()) {
            this.in.order(!this.isLittleEndian());
            tempImages = this.in.readInt();
            this.in.order(this.isLittleEndian());
        }
        this.core[seriesIndex].sizeX = this.in.readInt();
        this.core[seriesIndex].sizeY = this.in.readInt();
        this.in.skipBytes(4);
        int samplesPerPixel = this.in.readInt();
        this.core[seriesIndex].rgb = samplesPerPixel > 1;
        this.core[seriesIndex].sizeC = samplesPerPixel;
        File dirFile = new File(this.currentId).getAbsoluteFile();
        String[] listing = null;
        String dirPrefix = "";
        if (dirFile.exists()) {
            listing = dirFile.getParentFile().list();
            dirPrefix = dirFile.getParent();
            if (!dirPrefix.endsWith(File.separator)) {
                dirPrefix = dirPrefix + File.separator;
            }
        } else {
            listing = Location.getIdMap().keySet().toArray(new String[0]);
        }
        Vector<String> list = new Vector<String>();
        for (int k = 0; k < listing.length; ++k) {
            if (!LeicaReader.checkSuffix(listing[k], TiffReader.TIFF_SUFFIXES)) continue;
            list.add(listing[k]);
        }
        boolean tiffsExist = false;
        String prefix = "";
        for (int j = 0; j < tempImages; ++j) {
            prefix = this.getString(this.nameLength);
            f.add(dirPrefix + prefix);
            Location test = new Location((String)f.get(f.size() - 1)).getAbsoluteFile();
            LOGGER.debug("Expected to find TIFF file {}", (Object)test.getAbsolutePath());
            if (!test.exists()) {
                LOGGER.debug("  file does not exist");
            }
            if (test.exists()) {
                list.remove(prefix);
            }
            if (tiffsExist) continue;
            tiffsExist = test.exists();
        }
        if (!tiffsExist) {
            LOGGER.info("Handling renamed TIFF files");
            listing = list.toArray(new String[list.size()]);
            Vector<String> filePatterns = new Vector<String>();
            for (String q : listing) {
                Location l = new Location(dirPrefix, q).getAbsoluteFile();
                FilePattern pattern = new FilePattern(l);
                if (!pattern.isValid()) continue;
                AxisGuesser guess = new AxisGuesser(pattern, "XYZCT", 1, 1, 1, false);
                String fp = pattern.getPattern();
                if (guess.getAxisCountS() >= 1) {
                    String pre = pattern.getPrefix(guess.getAxisCountS());
                    Vector<String> fileList = new Vector<String>();
                    for (int n = 0; n < listing.length; ++n) {
                        Location p = new Location(dirPrefix, listing[n]);
                        if (!p.getAbsolutePath().startsWith(pre)) continue;
                        fileList.add(listing[n]);
                    }
                    fp = FilePattern.findPattern(l.getAbsolutePath(), dirPrefix, fileList.toArray(new String[fileList.size()]));
                }
                if (fp == null || filePatterns.contains(fp)) continue;
                filePatterns.add(fp);
            }
            for (String q : filePatterns) {
                String[] pattern = new FilePattern(q).getFiles();
                if (pattern.length != tempImages) continue;
                boolean validPattern = true;
                for (int n = 0; n < seriesIndex; ++n) {
                    if (this.files[n] == null || !this.files[n].contains(pattern[0])) continue;
                    validPattern = false;
                    break;
                }
                if (!validPattern) continue;
                this.files[seriesIndex] = new Vector();
                this.files[seriesIndex].addAll(Arrays.asList(pattern));
            }
        } else {
            this.files[seriesIndex] = f;
        }
        if (this.files[seriesIndex] == null) {
            this.valid[seriesIndex] = false;
        } else {
            this.core[seriesIndex].imageCount = this.files[seriesIndex].size();
            maxPlanes = Math.max(maxPlanes, this.core[seriesIndex].imageCount);
        }
    }

    private void parseSeriesTag() throws IOException {
        this.addSeriesMeta("Version", this.in.readInt());
        this.addSeriesMeta("Number of Series", this.in.readInt());
        this.fileLength = this.in.readInt();
        this.addSeriesMeta("Length of filename", this.fileLength);
        int extLen = this.in.readInt();
        if (extLen > this.fileLength) {
            this.in.seek(8L);
            this.core[0].littleEndian = !this.isLittleEndian();
            this.in.order(this.isLittleEndian());
            this.fileLength = this.in.readInt();
            extLen = this.in.readInt();
        }
        this.addSeriesMeta("Length of file extension", extLen);
        this.addSeriesMeta("Image file extension", this.getString(extLen));
    }

    private void parseImageTag(int seriesIndex) throws IOException {
        this.core[seriesIndex].imageCount = this.in.readInt();
        this.core[seriesIndex].sizeX = this.in.readInt();
        this.core[seriesIndex].sizeY = this.in.readInt();
        this.addSeriesMeta("Number of images", this.getImageCount());
        this.addSeriesMeta("Image width", this.getSizeX());
        this.addSeriesMeta("Image height", this.getSizeY());
        this.addSeriesMeta("Bits per Sample", this.in.readInt());
        this.addSeriesMeta("Samples per pixel", this.in.readInt());
        String name = this.getString(this.fileLength * 2);
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        String[] tokens = name.split("_");
        StringBuffer buf = new StringBuffer();
        for (int p = 1; p < tokens.length; ++p) {
            String lcase = tokens[p].toLowerCase();
            if (lcase.startsWith("ch0") || lcase.startsWith("c0") || lcase.startsWith("z0") || lcase.startsWith("t0")) continue;
            if (buf.length() > 0) {
                buf.append("_");
            }
            buf.append(tokens[p]);
        }
        this.seriesNames.add(buf.toString());
    }

    private void parseDimensionTag(int seriesIndex) throws FormatException, IOException {
        int resolution;
        this.addSeriesMeta("Voxel Version", this.in.readInt());
        this.core[seriesIndex].rgb = this.in.readInt() == 20;
        this.addSeriesMeta("VoxelType", this.isRGB() ? "RGB" : "gray");
        int bpp = this.in.readInt();
        this.addSeriesMeta("Bytes per pixel", bpp);
        if (bpp % 3 == 0) {
            this.core[seriesIndex].sizeC = 3;
            this.core[seriesIndex].rgb = true;
            bpp /= 3;
        }
        this.core[seriesIndex].pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        this.core[seriesIndex].dimensionOrder = "XY";
        this.core[seriesIndex].bitsPerPixel = resolution = this.in.readInt();
        this.addSeriesMeta("Real world resolution", resolution);
        this.addSeriesMeta("Maximum voxel intensity", this.getString(true));
        this.addSeriesMeta("Minimum voxel intensity", this.getString(true));
        int len = this.in.readInt();
        this.in.skipBytes(len * 2 + 4);
        len = this.in.readInt();
        for (int j = 0; j < len; ++j) {
            int dimId = this.in.readInt();
            String dimType = dimensionNames.get(new Integer(dimId));
            if (dimType == null) {
                dimType = "";
            }
            int size = this.in.readInt();
            int distance = this.in.readInt();
            int strlen = this.in.readInt() * 2;
            String[] sizeData = this.getString(strlen).split(" ");
            String physicalSize = sizeData[0];
            String unit = "";
            if (sizeData.length > 1) {
                unit = sizeData[1];
            }
            double physical = Double.parseDouble(physicalSize) / (double)size;
            if (unit.equals("m")) {
                physical *= 1000000.0;
            }
            if (dimType.equals("x")) {
                this.core[seriesIndex].sizeX = size;
                this.physicalSizes[seriesIndex][0] = physical;
            } else if (dimType.equals("y")) {
                this.core[seriesIndex].sizeY = size;
                this.physicalSizes[seriesIndex][1] = physical;
            } else if (dimType.equals("channel")) {
                if (this.getSizeC() == 0) {
                    this.core[seriesIndex].sizeC = 1;
                }
                this.core[seriesIndex].sizeC *= size;
                if (this.getDimensionOrder().indexOf("C") == -1) {
                    this.core[seriesIndex].dimensionOrder = this.core[seriesIndex].dimensionOrder + "C";
                }
                this.physicalSizes[seriesIndex][3] = physical;
            } else if (dimType.equals("z")) {
                this.core[seriesIndex].sizeZ = size;
                this.physicalSizes[seriesIndex][2] = physical;
            } else {
                this.core[seriesIndex].sizeT = size;
                if (this.getDimensionOrder().indexOf("T") == -1) {
                    this.core[seriesIndex].dimensionOrder = this.core[seriesIndex].dimensionOrder + "T";
                }
                this.physicalSizes[seriesIndex][4] = physical;
            }
            String dimPrefix = "Dim" + j;
            this.addSeriesMeta(dimPrefix + " type", dimType);
            this.addSeriesMeta(dimPrefix + " size", size);
            this.addSeriesMeta(dimPrefix + " distance between sub-dimensions", distance);
            this.addSeriesMeta(dimPrefix + " physical length", physicalSize + " " + unit);
            this.addSeriesMeta(dimPrefix + " physical origin", this.getString(true));
        }
        this.addSeriesMeta("Series name", this.getString(false));
        String description = this.getString(false);
        this.seriesDescriptions.add(description);
        this.addSeriesMeta("Series description", description);
    }

    private void parseTimeTag(int seriesIndex) throws IOException {
        int nDims = this.in.readInt();
        this.addSeriesMeta("Number of time-stamped dimensions", nDims);
        this.addSeriesMeta("Time-stamped dimension", this.in.readInt());
        for (int j = 0; j < nDims; ++j) {
            String dimPrefix = "Dimension " + j;
            this.addSeriesMeta(dimPrefix + " ID", this.in.readInt());
            this.addSeriesMeta(dimPrefix + " size", this.in.readInt());
            this.addSeriesMeta(dimPrefix + " distance", this.in.readInt());
        }
        int numStamps = this.in.readInt();
        this.addSeriesMeta("Number of time-stamps", numStamps);
        this.timestamps[seriesIndex] = new String[numStamps];
        for (int j = 0; j < numStamps; ++j) {
            this.timestamps[seriesIndex][j] = this.getString(64);
            this.addSeriesMeta("Timestamp " + j, this.timestamps[seriesIndex][j]);
        }
        if (this.in.getFilePointer() < this.in.length()) {
            int numTMs = this.in.readInt();
            this.addSeriesMeta("Number of time-markers", numTMs);
            for (int j = 0; j < numTMs && this.in.getFilePointer() + 4L < this.in.length(); ++j) {
                int numDims = this.in.readInt();
                String time = "Time-marker " + j + " Dimension ";
                for (int k = 0; k < numDims && this.in.getFilePointer() + 4L < this.in.length(); ++k) {
                    this.addSeriesMeta(time + k + " coordinate", this.in.readInt());
                }
                if (this.in.getFilePointer() >= this.in.length()) break;
                this.addSeriesMeta("Time-marker " + j, this.getString(64));
            }
        }
    }

    private void parseExperimentTag() throws IOException {
        this.in.skipBytes(8);
        String description = this.getString(true);
        this.addSeriesMeta("Image Description", description);
        this.addSeriesMeta("Main file extension", this.getString(true));
        this.addSeriesMeta("Image format identifier", this.getString(true));
        this.addSeriesMeta("Single image extension", this.getString(true));
    }

    private void parseLUT(int seriesIndex) throws IOException {
        int nChannels = this.in.readInt();
        if (nChannels > 0) {
            this.core[seriesIndex].indexed = true;
        }
        this.addSeriesMeta("Number of LUT channels", nChannels);
        this.addSeriesMeta("ID of colored dimension", this.in.readInt());
        for (int j = 0; j < nChannels; ++j) {
            String p = "LUT Channel " + j;
            this.addSeriesMeta(p + " version", this.in.readInt());
            this.addSeriesMeta(p + " inverted?", this.in.read() == 1);
            this.addSeriesMeta(p + " description", this.getString(false));
            this.addSeriesMeta(p + " filename", this.getString(false));
            String lut = this.getString(false);
            this.addSeriesMeta(p + " name", lut);
            this.in.skipBytes(8);
        }
    }

    private void parseChannelTag() throws IOException {
        int nBands = this.in.readInt();
        for (int band = 0; band < nBands; ++band) {
            String p = "Band #" + (band + 1) + " ";
            this.addSeriesMeta(p + "Lower wavelength", this.in.readDouble());
            this.in.skipBytes(4);
            this.addSeriesMeta(p + "Higher wavelength", this.in.readDouble());
            this.in.skipBytes(4);
            this.addSeriesMeta(p + "Gain", this.in.readDouble());
            this.addSeriesMeta(p + "Offset", this.in.readDouble());
        }
    }

    private void parseInstrumentData(MetadataStore store, int blockNum) throws FormatException, IOException {
        int series = this.getSeries();
        this.in.skipBytes(4);
        int cbElements = this.in.readInt();
        this.in.skipBytes(8);
        int nElements = this.in.readInt();
        this.in.skipBytes(4);
        long initialOffset = this.in.getFilePointer();
        long elementOffset = 0L;
        LOGGER.trace("Element LOOP; series {} at offset", (Object)series, (Object)initialOffset);
        for (int j = 0; j < nElements; ++j) {
            String data;
            String contentID;
            block78: {
                elementOffset = initialOffset + (long)(j * cbElements);
                LOGGER.trace("Seeking to: {}", (Object)elementOffset);
                this.in.seek(elementOffset);
                contentID = this.getString(128);
                LOGGER.trace("contentID: {}", (Object)contentID);
                String description = this.getString(64);
                LOGGER.trace("description: {}", (Object)description);
                data = this.getString(64);
                short dataType = this.in.readShort();
                LOGGER.trace("dataType: {}", (Object)dataType);
                this.in.skipBytes(6);
                switch (dataType) {
                    case 2: {
                        data = String.valueOf(this.in.readShort());
                        break;
                    }
                    case 3: {
                        data = String.valueOf(this.in.readInt());
                        break;
                    }
                    case 4: {
                        data = String.valueOf(this.in.readFloat());
                        break;
                    }
                    case 5: {
                        data = String.valueOf(this.in.readDouble());
                        break;
                    }
                    case 7: 
                    case 11: {
                        data = this.in.read() == 0 ? "false" : "true";
                        break;
                    }
                    case 17: {
                        data = this.in.readString(1);
                    }
                }
                LOGGER.trace("data: {}", (Object)data);
                if (data.trim().length() == 0) {
                    LOGGER.trace("Zero length dat string, continuing...");
                    continue;
                }
                Object[] tokens = contentID.split("\\|");
                LOGGER.trace("Parsing tokens: {}", tokens);
                if (((String)tokens[0]).startsWith("CDetectionUnit")) {
                    if (((String)tokens[1]).startsWith("PMT")) {
                        try {
                            if (((String)tokens[2]).equals("VideoOffset")) {
                                this.detectorOffset = new Double(data);
                                break block78;
                            }
                            if (((String)tokens[2]).equals("HighVoltage")) {
                                this.detectorVoltage = new Double(data);
                                ++this.nextDetector;
                                break block78;
                            }
                            if (!((String)tokens[2]).equals("State") || !data.equals("Active")) break block78;
                            store.setDetectorOffset(this.detectorOffset, series, this.nextDetector);
                            store.setDetectorVoltage(this.detectorVoltage, series, this.nextDetector);
                            store.setDetectorType(this.getDetectorType("PMT"), series, this.nextDetector);
                            String index = ((String)tokens[1]).substring(((String)tokens[1]).indexOf(" ") + 1);
                            int channelIndex = -1;
                            try {
                                channelIndex = Integer.parseInt(index) - 1;
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (channelIndex >= 0) {
                                this.activeChannelIndices.add(new Integer(channelIndex));
                            }
                            String detectorID = MetadataTools.createLSID("Detector", series, this.nextDetector);
                            store.setDetectorID(detectorID, series, this.nextDetector);
                            if (this.nextDetector == 0) {
                                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                                    store.setDetectorSettingsID(detectorID, series, c);
                                }
                            }
                            if (this.nextChannel < this.getEffectiveSizeC()) {
                                store.setDetectorSettingsID(detectorID, series, this.nextChannel++);
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Failed to parse detector metadata", (Throwable)e);
                        }
                    }
                } else if (((String)tokens[0]).startsWith("CTurret")) {
                    int objective = Integer.parseInt((String)tokens[3]);
                    if (((String)tokens[2]).equals("NumericalAperture")) {
                        store.setObjectiveLensNA(new Double(data), series, objective);
                    } else if (((String)tokens[2]).equals("Objective")) {
                        String[] objectiveData = data.split(" ");
                        StringBuffer model = new StringBuffer();
                        String mag = null;
                        String na = null;
                        String immersion = null;
                        String correction = null;
                        for (int i = 0; i < objectiveData.length; ++i) {
                            if (objectiveData[i].indexOf("x") != -1 && mag == null && na == null) {
                                int xIndex = objectiveData[i].indexOf("x");
                                mag = objectiveData[i].substring(0, xIndex).trim();
                                na = objectiveData[i].substring(xIndex + 1).trim();
                                continue;
                            }
                            if (mag == null && na == null) {
                                model.append(objectiveData[i]);
                                model.append(" ");
                                continue;
                            }
                            if (correction == null) {
                                correction = objectiveData[i];
                                continue;
                            }
                            if (immersion != null) continue;
                            immersion = objectiveData[i];
                        }
                        if (immersion != null) {
                            immersion = immersion.trim();
                        }
                        if (correction != null) {
                            correction = correction.trim();
                        }
                        Correction realCorrection = this.getCorrection(correction);
                        Correction testCorrection = this.getCorrection(immersion);
                        Immersion realImmersion = this.getImmersion(immersion);
                        Immersion testImmersion = this.getImmersion(correction);
                        if (testCorrection != Correction.OTHER && realCorrection == Correction.OTHER || testImmersion != Immersion.OTHER && realImmersion == Immersion.OTHER) {
                            String tmp = correction;
                            correction = immersion;
                            immersion = tmp;
                        }
                        store.setObjectiveImmersion(this.getImmersion(immersion), series, objective);
                        store.setObjectiveCorrection(this.getCorrection(correction), series, objective);
                        store.setObjectiveModel(model.toString().trim(), series, objective);
                        store.setObjectiveLensNA(new Double(na), series, objective);
                        store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf((int)Double.parseDouble(mag))), series, objective);
                    } else if (((String)tokens[2]).equals("OrderNumber")) {
                        store.setObjectiveSerialNumber(data, series, objective);
                    } else if (((String)tokens[2]).equals("RefractionIndex")) {
                        store.setImageObjectiveSettingsRefractiveIndex(new Double(data), series);
                    }
                    String objectiveID = MetadataTools.createLSID("Objective", series, objective);
                    store.setObjectiveID(objectiveID, series, objective);
                    if (objective == 0) {
                        store.setImageObjectiveSettingsID(objectiveID, series);
                    }
                } else if (((String)tokens[0]).startsWith("CSpectrophotometerUnit")) {
                    int ndx = ((String)tokens[1]).lastIndexOf(" ");
                    int channel = Integer.parseInt(((String)tokens[1]).substring(ndx + 1)) - 1;
                    if (((String)tokens[2]).equals("Wavelength")) {
                        Integer wavelength = new Integer((int)Double.parseDouble(data));
                        store.setFilterModel((String)tokens[1], series, channel);
                        String filterID = MetadataTools.createLSID("Filter", series, channel);
                        store.setFilterID(filterID, series, channel);
                        int index = this.activeChannelIndices.indexOf(new Integer(channel));
                        if (index >= 0 && index < this.core[series].sizeC) {
                            if (!this.filterRefPopulated[series][index]) {
                                store.setLightPathEmissionFilterRef(filterID, series, index, 0);
                                this.filterRefPopulated[series][index] = true;
                            }
                            if (((String)tokens[3]).equals("0") && !this.cutInPopulated[series][index]) {
                                store.setTransmittanceRangeCutIn(new PositiveInteger(wavelength), series, channel);
                                this.cutInPopulated[series][index] = true;
                            } else if (((String)tokens[3]).equals("1") && !this.cutOutPopulated[series][index]) {
                                store.setTransmittanceRangeCutOut(new PositiveInteger(wavelength), series, channel);
                                this.cutOutPopulated[series][index] = true;
                            }
                        }
                    } else if (((String)tokens[2]).equals("Stain") && this.activeChannelIndices.contains(new Integer(channel))) {
                        String prevValue;
                        int nNames = this.channelNames[series].size();
                        String string = prevValue = nNames == 0 ? "" : (String)this.channelNames[series].get(nNames - 1);
                        if (!prevValue.equals(data)) {
                            this.channelNames[series].add(data);
                        }
                    }
                } else if (((String)tokens[0]).startsWith("CXYZStage")) {
                    if (((String)tokens[2]).equals("XPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setPlanePositionX(new Double(data), series, q);
                            if (q != 0) continue;
                            this.addGlobalMeta("X position for position #" + (series + 1), data);
                        }
                    } else if (((String)tokens[2]).equals("YPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setPlanePositionY(new Double(data), series, q);
                            if (q != 0) continue;
                            this.addGlobalMeta("Y position for position #" + (series + 1), data);
                        }
                    } else if (((String)tokens[2]).equals("ZPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setPlanePositionZ(new Double(data), series, q);
                            if (q != 0) continue;
                            this.addGlobalMeta("Z position for position #" + (series + 1), data);
                        }
                    }
                } else if (((String)tokens[0]).equals("CScanActuator") && ((String)tokens[1]).equals("Z Scan Actuator") && ((String)tokens[2]).equals("Position")) {
                    double pos = Double.parseDouble(data) * 1000000.0;
                    for (int q = 0; q < this.core[series].imageCount; ++q) {
                        store.setPlanePositionZ(pos, series, q);
                    }
                }
            }
            if (contentID.equals("dblVoxelX")) {
                this.physicalSizes[series][0] = Double.parseDouble(data);
            } else if (contentID.equals("dblVoxelY")) {
                this.physicalSizes[series][1] = Double.parseDouble(data);
            } else if (contentID.equals("dblStepSize")) {
                this.physicalSizes[series][2] = Double.parseDouble(data);
            } else if (contentID.equals("dblPinhole")) {
                this.pinhole[series] = Double.parseDouble(data) * 1000000.0;
            } else if (contentID.startsWith("nDelayTime")) {
                this.exposureTime[series] = Double.parseDouble(data);
                if (contentID.endsWith("_ms")) {
                    int n = series;
                    this.exposureTime[n] = this.exposureTime[n] / 1000.0;
                }
            }
            this.addSeriesMeta("Block " + blockNum + " " + contentID, data);
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            for (int channel = 0; channel < this.getEffectiveSizeC(); ++channel) {
                Integer wave;
                String name;
                if (channel < this.channelNames[i].size() && (name = (String)this.channelNames[i].get(channel)) != null && !name.trim().equals("") && !name.equals("None")) {
                    store.setChannelName(name, i, channel);
                }
                if (channel < this.emWaves[i].size()) {
                    wave = new Integer(this.emWaves[i].get(channel).toString());
                    store.setChannelEmissionWavelength(new PositiveInteger(wave), i, channel);
                }
                if (channel < this.exWaves[i].size()) {
                    wave = new Integer(this.exWaves[i].get(channel).toString());
                    store.setChannelExcitationWavelength(new PositiveInteger(wave), i, channel);
                }
                if (i >= this.pinhole.length) continue;
                store.setChannelPinholeSize(new Double(this.pinhole[i]), i, channel);
            }
        }
        this.setSeries(0);
    }

    private boolean usedFile(String s) {
        if (this.files == null) {
            return false;
        }
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] == null) continue;
            for (int j = 0; j < this.files[i].size(); ++j) {
                if (!((String)this.files[i].get(j)).endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private String getString(int len) throws IOException {
        return DataTools.stripString((String)this.in.readString(len));
    }

    private String getString(boolean doubleLength) throws IOException {
        int len = this.in.readInt();
        if (doubleLength) {
            len *= 2;
        }
        return this.getString(len);
    }

    private static Hashtable<Integer, String> makeDimensionTable() {
        Hashtable<Integer, String> table = new Hashtable<Integer, String>();
        table.put(new Integer(0), "undefined");
        table.put(new Integer(120), "x");
        table.put(new Integer(121), "y");
        table.put(new Integer(122), "z");
        table.put(new Integer(116), "t");
        table.put(new Integer(6815843), "channel");
        table.put(new Integer(6357100), "wave length");
        table.put(new Integer(7602290), "rotation");
        table.put(new Integer(0x770078), "x-wide for the motorized xy-stage");
        table.put(new Integer(0x770079), "y-wide for the motorized xy-stage");
        table.put(new Integer(0x77007A), "z-wide for the z-stage-drive");
        table.put(new Integer(4259957), "user1 - unspecified");
        table.put(new Integer(4325493), "user2 - unspecified");
        table.put(new Integer(4391029), "user3 - unspecified");
        table.put(new Integer(6357095), "graylevel");
        table.put(new Integer(6422631), "graylevel1");
        table.put(new Integer(6488167), "graylevel2");
        table.put(new Integer(6553703), "graylevel3");
        table.put(new Integer(7864398), "logical x");
        table.put(new Integer(7929934), "logical y");
        table.put(new Integer(7995470), "logical z");
        table.put(new Integer(7602254), "logical t");
        table.put(new Integer(7077966), "logical lambda");
        table.put(new Integer(7471182), "logical rotation");
        table.put(new Integer(5767246), "logical x-wide");
        table.put(new Integer(5832782), "logical y-wide");
        table.put(new Integer(5898318), "logical z-wide");
        return table;
    }
}

