/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveInteger;

public class PerkinElmerReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] ANO_SUFFIX = new String[]{"ano"};
    public static final String[] REC_SUFFIX = new String[]{"rec"};
    public static final String[] TIM_SUFFIX = new String[]{"tim"};
    public static final String[] CSV_SUFFIX = new String[]{"csv"};
    public static final String[] ZPO_SUFFIX = new String[]{"zpo"};
    public static final String[] HTM_SUFFIX = new String[]{"htm"};
    public static final String HTML_REGEX = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
    public static final String DATE_FORMAT = "HH:mm:ss (MM/dd/yyyy)";
    protected MinimalTiffReader tiff;
    protected String[] files;
    private boolean isTiff = true;
    private Vector<String> allFiles;
    private String details;
    private String sliceSpace;
    private double pixelSizeX = 1.0;
    private double pixelSizeY = 1.0;
    private String finishTime = null;
    private String startTime = null;
    private double originX = 0.0;
    private double originY = 0.0;
    private double originZ = 0.0;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"ano", "cfg", "csv", "htm", "rec", "tim", "zpo"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        boolean binFile;
        String ext;
        block13: {
            if (!open) {
                return false;
            }
            if (PerkinElmerReader.checkSuffix(name, "cfg")) {
                try {
                    String check = DataTools.readFile((String)name);
                    if (check.indexOf("Ultraview") == -1) {
                        return false;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((ext = name).indexOf(".") != -1) {
                ext = ext.substring(ext.lastIndexOf(".") + 1);
            }
            binFile = true;
            try {
                Integer.parseInt(ext, 16);
            }
            catch (NumberFormatException e) {
                ext = ext.toLowerCase();
                if (ext.equals("tif") || ext.equals("tiff")) break block13;
                binFile = false;
            }
        }
        Location baseFile = new Location(name).getAbsoluteFile();
        String prefix = baseFile.getParent() + File.separator;
        String namePrefix = baseFile.getName();
        if (namePrefix.indexOf(".") != -1) {
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf("."));
        }
        if (namePrefix.indexOf("_") != -1 && binFile) {
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf("_"));
        }
        prefix = prefix + namePrefix;
        Location htmlFile = new Location(prefix + ".htm");
        if (ext.toLowerCase().equals("htm")) {
            htmlFile = new Location(name).getAbsoluteFile();
        }
        if (!htmlFile.exists()) {
            htmlFile = new Location(prefix + ".HTM");
            while (!htmlFile.exists() && prefix.indexOf("_") != -1) {
                htmlFile = new Location((prefix = prefix.substring(0, prefix.indexOf("_"))) + ".htm");
                if (htmlFile.exists()) continue;
                htmlFile = new Location(prefix + ".HTM");
            }
        }
        return htmlFile.exists() && (binFile || super.isThisType(name, false));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.isTiff && this.tiff != null) {
            return this.tiff.get8BitLookupTable();
        }
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.isTiff && this.tiff != null) {
            return this.tiff.get16BitLookupTable();
        }
        return null;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.isTiff) {
            this.tiff.setId(this.files[no / this.getSizeC()]);
            return this.tiff.openBytes(0, buf, x, y, w, h);
        }
        RandomAccessInputStream ras = new RandomAccessInputStream(this.files[no]);
        ras.seek(6L);
        this.readPlane(ras, x, y, w, h, buf);
        ras.close();
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            Vector<String> files = new Vector<String>();
            if (this.isTiff) {
                for (String f : this.allFiles) {
                    if (PerkinElmerReader.checkSuffix(f, new String[]{"tif", "tiff"})) continue;
                    files.add(f);
                }
            } else {
                for (String f : this.allFiles) {
                    String ext = f.substring(f.lastIndexOf(".") + 1);
                    try {
                        Integer.parseInt(ext, 16);
                    }
                    catch (NumberFormatException e) {
                        files.add(f);
                    }
                }
            }
            return files.toArray(new String[files.size()]);
        }
        return this.allFiles.toArray(new String[this.allFiles.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiff = null;
            this.allFiles = null;
            this.files = null;
            this.sliceSpace = null;
            this.details = null;
            this.isTiff = true;
            this.pixelSizeY = 1.0;
            this.pixelSizeX = 1.0;
            this.startTime = null;
            this.finishTime = null;
            this.originZ = 0.0;
            this.originY = 0.0;
            this.originX = 0.0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] tokens;
        String ext;
        String workingDirPath;
        if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
            return;
        }
        LOGGER.info("Finding HTML companion file");
        if (!PerkinElmerReader.checkSuffix(id, HTM_SUFFIX)) {
            String[] ls;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            for (String file : ls = parent.list()) {
                if (!PerkinElmerReader.checkSuffix(file, HTM_SUFFIX) || file.startsWith(".")) continue;
                id = new Location(parent.getAbsolutePath(), file).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.allFiles = new Vector();
        Location tmpFile = new Location(id).getAbsoluteFile();
        Location workingDir = tmpFile.getParentFile();
        if (workingDir == null) {
            workingDir = new Location(".");
        }
        if (!(workingDirPath = workingDir.getPath()).equals("")) {
            workingDirPath = workingDirPath + File.separator;
        }
        String[] ls = workingDir.list(true);
        if (!new Location(id).exists()) {
            ls = Location.getIdMap().keySet().toArray(new String[0]);
            workingDirPath = "";
        }
        LOGGER.info("Searching for all metadata companion files");
        String cfgFile = null;
        String anoFile = null;
        String recFile = null;
        String timFile = null;
        String csvFile = null;
        String zpoFile = null;
        String htmFile = null;
        int filesPt = 0;
        this.files = new String[ls.length];
        int dot = id.lastIndexOf(".");
        String check = dot < 0 ? id : id.substring(0, dot);
        check = check.substring(check.lastIndexOf(File.separator) + 1);
        String prefix = null;
        for (int i = 0; i < ls.length; ++i) {
            String s;
            int d = ls[i].lastIndexOf(".");
            while (d == -1 && i < ls.length - 1) {
                d = ls[++i].lastIndexOf(".");
            }
            String string = s = d < 0 ? ls[i] : ls[i].substring(0, d);
            if (!s.startsWith(check) && !check.startsWith(s) && (prefix == null || !s.startsWith(prefix))) continue;
            prefix = ls[i].substring(0, d);
            if (cfgFile == null && PerkinElmerReader.checkSuffix(ls[i], CFG_SUFFIX)) {
                cfgFile = ls[i];
            }
            if (anoFile == null && PerkinElmerReader.checkSuffix(ls[i], ANO_SUFFIX)) {
                anoFile = ls[i];
            }
            if (recFile == null && PerkinElmerReader.checkSuffix(ls[i], REC_SUFFIX)) {
                recFile = ls[i];
            }
            if (timFile == null && PerkinElmerReader.checkSuffix(ls[i], TIM_SUFFIX)) {
                timFile = ls[i];
            }
            if (csvFile == null && PerkinElmerReader.checkSuffix(ls[i], CSV_SUFFIX)) {
                csvFile = ls[i];
            }
            if (zpoFile == null && PerkinElmerReader.checkSuffix(ls[i], ZPO_SUFFIX)) {
                zpoFile = ls[i];
            }
            if (htmFile == null && PerkinElmerReader.checkSuffix(ls[i], HTM_SUFFIX)) {
                htmFile = ls[i];
            }
            if (PerkinElmerReader.checkSuffix(ls[i], TiffReader.TIFF_SUFFIXES)) {
                this.files[filesPt++] = workingDirPath + ls[i];
            }
            try {
                ext = ls[i].substring(ls[i].lastIndexOf(".") + 1);
                Integer.parseInt(ext, 16);
                this.isTiff = false;
                this.files[filesPt++] = workingDirPath + ls[i];
                continue;
            }
            catch (NumberFormatException exc) {
                LOGGER.debug("Failed to parse file extension", (Throwable)exc);
            }
        }
        String[] tempFiles = this.files;
        this.files = new String[filesPt];
        LOGGER.info("Finding image files");
        Vector<String> foundExts = new Vector<String>();
        for (int i = 0; i < filesPt; ++i) {
            ext = tempFiles[i].substring(tempFiles[i].lastIndexOf(".") + 1);
            if (foundExts.contains(ext)) continue;
            foundExts.add(ext);
        }
        int extCount = foundExts.size();
        foundExts = null;
        Vector<String> extSet = new Vector<String>();
        for (int i = 0; i < filesPt; i += extCount) {
            for (int j = 0; j < extCount; ++j) {
                String file = tempFiles[i + j];
                if (extSet.size() == 0) {
                    extSet.add(file);
                    continue;
                }
                if (file == null) continue;
                String ext2 = file.substring(file.lastIndexOf(".") + 1);
                int extNum = Integer.parseInt(ext2, 16);
                int insert = -1;
                for (int pos = 0; insert == -1 && pos < extSet.size(); ++pos) {
                    String posString = (String)extSet.get(pos);
                    int posNum = Integer.parseInt(posString = posString.substring(posString.lastIndexOf(".") + 1), 16);
                    if (extNum >= posNum) continue;
                    insert = pos;
                }
                if (insert == -1) {
                    extSet.add(tempFiles[i + j]);
                    continue;
                }
                extSet.add(insert, tempFiles[i + j]);
            }
            int length = Math.min(extCount, extSet.size());
            for (int j = 0; j < length; ++j) {
                this.files[i + j] = (String)extSet.get(j);
            }
            extSet.clear();
        }
        this.allFiles.addAll(Arrays.asList(this.files));
        this.sortFiles();
        this.core[0].imageCount = this.files.length;
        this.tiff = new MinimalTiffReader();
        LOGGER.info("Parsing metadata values");
        this.addUsedFile(workingDirPath, cfgFile);
        this.addUsedFile(workingDirPath, anoFile);
        this.addUsedFile(workingDirPath, recFile);
        this.addUsedFile(workingDirPath, timFile);
        if (timFile != null) {
            timFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, csvFile);
        if (csvFile != null) {
            csvFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, zpoFile);
        if (zpoFile != null) {
            zpoFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, htmFile);
        if (htmFile != null) {
            htmFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        if (timFile != null) {
            this.parseTimFile(timFile);
        }
        if (csvFile != null) {
            this.parseCSVFile(csvFile);
        }
        if (zpoFile != null && csvFile == null) {
            this.parseZpoFile(zpoFile);
        }
        Vector<Double> exposureTimes = new Vector<Double>();
        Vector<Double> zPositions = new Vector<Double>();
        Vector<Integer> emWaves = new Vector<Integer>();
        Vector<Integer> exWaves = new Vector<Integer>();
        if (htmFile != null) {
            int j;
            tokens = DataTools.readFile((String)htmFile).split(HTML_REGEX);
            for (j = 0; j < tokens.length; ++j) {
                if (tokens[j].indexOf("<") == -1) continue;
                tokens[j] = "";
            }
            for (j = 0; j < tokens.length - 1; j += 2) {
                if (tokens[j].indexOf("Exposure") != -1) {
                    this.addGlobalMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                    int ndx = tokens[j].indexOf("Exposure") + 9;
                    String exposure = tokens[j].substring(ndx, tokens[j].indexOf(" ", ndx)).trim();
                    if (exposure.endsWith(",")) {
                        exposure = exposure.substring(0, exposure.length() - 1);
                    }
                    exposureTimes.add(new Double(Double.parseDouble(exposure) / 1000.0));
                    if (tokens[j].indexOf("nm") != -1) {
                        int nmIndex = tokens[j].indexOf("nm");
                        int paren = tokens[j].lastIndexOf("(", nmIndex);
                        int slash = tokens[j].lastIndexOf("/", nmIndex);
                        if (slash == -1) {
                            slash = nmIndex;
                        }
                        emWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        if (tokens[j].indexOf("nm", nmIndex + 3) != -1) {
                            nmIndex = tokens[j].indexOf("nm", nmIndex + 3);
                            paren = tokens[j].lastIndexOf(" ", nmIndex);
                            slash = tokens[j].lastIndexOf("/", nmIndex);
                            if (slash == -1) {
                                slash = nmIndex + 2;
                            }
                            exWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        }
                    }
                    --j;
                    continue;
                }
                if (tokens[j + 1].trim().equals("Slice Z positions")) {
                    for (int q = j + 2; q < tokens.length; ++q) {
                        if (tokens[q].trim().equals("")) continue;
                        try {
                            zPositions.add(new Double(tokens[q].trim()));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (tokens[j].trim().equals("")) continue;
                tokens[j] = tokens[j].trim();
                tokens[j + 1] = tokens[j + 1].trim();
                this.parseKeyValue(tokens[j], tokens[j + 1]);
            }
        } else {
            throw new FormatException("Valid header files not found.");
        }
        if (this.details != null) {
            tokens = this.details.split("\\s");
            int n = 0;
            for (String token : tokens) {
                if (token.equals("Wavelengths")) {
                    this.core[0].sizeC = n;
                } else if (token.equals("Frames")) {
                    this.core[0].sizeT = n;
                } else if (token.equals("Slices")) {
                    this.core[0].sizeZ = n;
                }
                try {
                    n = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    n = 0;
                }
            }
        }
        LOGGER.info("Populating metadata");
        if (this.files.length == 0) {
            throw new FormatException("TIFF files not found.");
        }
        if (this.isTiff) {
            this.tiff.setId(this.files[0]);
            this.core[0].pixelType = this.tiff.getPixelType();
        } else {
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.files[0]);
            int bpp = (int)(tmp.length() - 6L) / (this.getSizeX() * this.getSizeY());
            tmp.close();
            if (bpp % 3 == 0) {
                bpp /= 3;
            }
            this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        }
        if (this.getSizeZ() <= 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() <= 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() <= 0) {
            this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
        } else {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            if (this.getImageCount() > this.files.length) {
                this.core[0].imageCount = this.files.length;
                this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            }
        }
        this.removeExtraFiles();
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].rgb = this.isTiff ? this.tiff.isRGB() : false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.isTiff ? this.tiff.isLittleEndian() : true;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = this.isTiff ? this.tiff.isIndexed() : false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.finishTime != null) {
            this.finishTime = DateTools.formatDate((String)this.finishTime, (String)DATE_FORMAT);
            store.setImageAcquiredDate(this.finishTime, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(this.pixelSizeX, 0);
            store.setPixelsPhysicalSizeY(this.pixelSizeY, 0);
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                if (i < emWaves.size()) {
                    store.setChannelEmissionWavelength(new PositiveInteger((Integer)emWaves.get(i)), 0, i);
                }
                if (i >= exWaves.size()) continue;
                store.setChannelExcitationWavelength(new PositiveInteger((Integer)exWaves.get(i)), 0, i);
            }
            long start = 0L;
            long end = 0L;
            if (this.startTime != null) {
                start = DateTools.getTime((String)this.startTime, (String)DATE_FORMAT);
            }
            if (this.finishTime != null) {
                end = DateTools.getTime((String)this.finishTime, (String)"yyyy-MM-dd'T'HH:mm:ss");
            }
            double secondsPerPlane = (double)(end - start) / (double)this.getImageCount() / 1000.0;
            for (int i = 0; i < this.getImageCount(); ++i) {
                int[] zct = this.getZCTCoords(i);
                store.setPlaneDeltaT((double)i * secondsPerPlane, 0, i);
                if (zct[1] < exposureTimes.size()) {
                    store.setPlaneExposureTime((Double)exposureTimes.get(zct[1]), 0, i);
                }
                if (zct[0] >= zPositions.size()) continue;
                store.setPlanePositionX(0.0, 0, i);
                store.setPlanePositionY(0.0, 0, i);
                store.setPlanePositionZ((Double)zPositions.get(zct[0]), 0, i);
            }
        }
    }

    private void parseKeyValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addGlobalMeta(key, value);
        try {
            if (key.equals("Image Width")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (key.equals("Image Length")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (key.equals("Number of slices")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            } else if (key.equals("Experiment details:")) {
                this.details = value;
            } else if (key.equals("Z slice space")) {
                this.sliceSpace = value;
            } else if (key.equals("Pixel Size X")) {
                this.pixelSizeX = Double.parseDouble(value);
            } else if (key.equals("Pixel Size Y")) {
                this.pixelSizeY = Double.parseDouble(value);
            } else if (key.equals("Finish Time:")) {
                this.finishTime = value;
            } else if (key.equals("Start Time:")) {
                this.startTime = value;
            } else if (key.equals("Origin X")) {
                this.originX = Double.parseDouble(value);
            } else if (key.equals("Origin Y")) {
                this.originY = Double.parseDouble(value);
            } else if (key.equals("Origin Z")) {
                this.originZ = Double.parseDouble(value);
            } else if (key.equals("SubfileType X")) {
                this.core[0].bitsPerPixel = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException exc) {
            LOGGER.debug("", (Throwable)exc);
        }
    }

    private void addUsedFile(String workingDirPath, String file) {
        if (file == null) {
            return;
        }
        Location f = new Location(workingDirPath, file);
        if (!workingDirPath.equals("")) {
            this.allFiles.add(f.getAbsolutePath());
        } else {
            this.allFiles.add(file);
        }
    }

    private void sortFiles() {
        if (this.isTiff) {
            Arrays.sort(this.files);
        } else {
            Comparator<String> c = new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int cmp;
                    String prefix1 = s1;
                    String prefix2 = s2;
                    String suffix1 = s1;
                    String suffix2 = s2;
                    if (s1.indexOf(".") != -1) {
                        prefix1 = s1.substring(0, s1.lastIndexOf("."));
                        suffix1 = s1.substring(s1.lastIndexOf(".") + 1);
                    }
                    if (s2.indexOf(".") != -1) {
                        prefix2 = s2.substring(0, s2.lastIndexOf("."));
                        suffix2 = s2.substring(s2.lastIndexOf(".") + 1);
                    }
                    if ((cmp = prefix1.compareTo(prefix2)) != 0) {
                        return cmp;
                    }
                    return Integer.parseInt(suffix1, 16) - Integer.parseInt(suffix2, 16);
                }
            };
            Arrays.sort(this.files, c);
        }
    }

    private void removeExtraFiles() {
        int calcCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        if (this.files.length > this.getImageCount() || this.getImageCount() != calcCount) {
            LOGGER.info("Removing extraneous files");
            String[] tmpFiles = this.files;
            int imageCount = Math.min(this.getImageCount(), calcCount);
            this.files = new String[imageCount];
            Hashtable<String, Integer> zSections = new Hashtable<String, Integer>();
            for (int i = 0; i < tmpFiles.length; ++i) {
                int dotIndex;
                int underscore = tmpFiles[i].lastIndexOf("_");
                String z = tmpFiles[i].substring(underscore + 1, dotIndex = tmpFiles[i].lastIndexOf("."));
                if (zSections.get(z) == null) {
                    zSections.put(z, new Integer(1));
                    continue;
                }
                int count = (Integer)zSections.get(z) + 1;
                zSections.put(z, new Integer(count));
            }
            int nextFile = 0;
            int oldFile = 0;
            Arrays.sort(tmpFiles, new PEComparator());
            Object[] keys = zSections.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                int oldCount = (Integer)zSections.get(key);
                int sizeC = this.isTiff ? this.tiff.getEffectiveSizeC() : this.getSizeC();
                int nPlanes = sizeC * this.getSizeT();
                int count = Math.min(oldCount, nPlanes);
                System.arraycopy(tmpFiles, oldFile, this.files, nextFile, count);
                nextFile += count;
                oldFile += count;
                if (count >= oldCount) continue;
                oldFile += oldCount - count;
            }
            this.core[0].imageCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        }
    }

    private void parseTimFile(String timFile) throws IOException {
        String[] tokens = DataTools.readFile((String)timFile).split("\\s");
        int tNum = 0;
        String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
        for (String token : tokens) {
            if (token.trim().length() == 0) continue;
            if (tNum >= hashKeys.length) break;
            if (token.equals("um")) {
                tNum = 5;
            }
            while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                ++tNum;
            }
            if (tNum == 4) {
                try {
                    Integer.parseInt(token);
                }
                catch (NumberFormatException e) {}
            }
            int n = ++tNum;
            ++tNum;
            this.parseKeyValue(hashKeys[n], token);
        }
    }

    private void parseCSVFile(String csvFile) throws IOException {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String[] tokens = DataTools.readFile((String)csvFile).split("\\s");
        Vector<String> tmp = new Vector<String>();
        for (String token : tokens) {
            if (token.trim().length() <= 0) continue;
            tmp.add(token.trim());
        }
        tokens = tmp.toArray(new String[0]);
        int tNum = 0;
        String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
        int pt = 0;
        int j = 0;
        while (j < tokens.length) {
            String key = null;
            String value = null;
            if (tNum < 7) {
                ++j;
            } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                ++j;
            } else if (pt < hashKeys.length) {
                key = hashKeys[pt++];
                value = tokens[j++];
            } else {
                key = tokens[j++] + tokens[j++];
                value = tokens[j++];
            }
            this.parseKeyValue(key, value);
            ++tNum;
        }
    }

    private void parseZpoFile(String zpoFile) throws IOException {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String[] tokens = DataTools.readFile((String)zpoFile).split("\\s");
        for (int t = 0; t < tokens.length; ++t) {
            this.addGlobalMeta("Z slice #" + t + " position", tokens[t]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PEComparator
    implements Comparator<String> {
        PEComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            String prefix2;
            if (s1.equals(s2)) {
                return 0;
            }
            int underscore1 = Math.max(s1.lastIndexOf("_"), 0);
            int underscore2 = Math.max(s2.lastIndexOf("_"), 0);
            int dot1 = Math.max(s1.lastIndexOf("."), 0);
            int dot2 = Math.max(s2.lastIndexOf("."), 0);
            String prefix1 = s1.substring(0, underscore1);
            if (!prefix1.equals(prefix2 = s2.substring(0, underscore2))) {
                return prefix1.compareTo(prefix2);
            }
            try {
                int z1 = Integer.parseInt(s1.substring(underscore1 + 1, dot1));
                int z2 = Integer.parseInt(s2.substring(underscore2 + 1, dot2));
                if (z1 < z2) {
                    return -1;
                }
                if (z2 < z1) {
                    return 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int ext1 = Integer.parseInt(s1.substring(dot1 + 1), 16);
                int ext2 = Integer.parseInt(s2.substring(dot2 + 1), 16);
                if (ext1 < ext2) {
                    return -1;
                }
                if (ext1 > ext2) {
                    return 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return 0;
        }
    }
}

