/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class SBIGReader
extends FormatReader {
    private static final long HEADER_SIZE = 2048L;
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    private boolean compressed;

    public SBIGReader() {
        super("SBIG", "");
        this.domains = new String[]{"Astronomy"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2048;
        int checkLen = 32;
        if (!FormatTools.validStream(stream, 2048, false)) {
            return false;
        }
        return stream.readString(32).indexOf("Image") > 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(2048L);
        int width = this.getSizeX() * 2;
        if (this.compressed) {
            for (int row = 0; row < h; ++row) {
                short rowLen = this.in.readShort();
                if (rowLen == width) {
                    this.in.read(buf, row * width, (int)rowLen);
                    continue;
                }
                int bufferPointer = row * width;
                this.in.read(buf, bufferPointer, 2);
                while (bufferPointer - row * width < width - 2) {
                    short prevPixel = DataTools.bytesToShort((byte[])buf, (int)bufferPointer, (boolean)this.isLittleEndian());
                    bufferPointer += 2;
                    byte check = this.in.readByte();
                    if (check == -128) {
                        this.in.read(buf, bufferPointer, 2);
                        continue;
                    }
                    prevPixel = (short)(prevPixel + check);
                    DataTools.unpackBytes((long)prevPixel, (byte[])buf, (int)bufferPointer, (int)2, (boolean)this.isLittleEndian());
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compressed = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        Object temperature = null;
        Double sizeX = null;
        Double sizeY = null;
        String date = null;
        String description = null;
        for (String line : lines = DataTools.readFile((String)this.currentId).split("\n")) {
            int eq = (line = line.trim()).indexOf("=");
            if (eq != -1) {
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("Width")) {
                    this.core[0].sizeX = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Height")) {
                    this.core[0].sizeY = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Note")) {
                    description = value;
                    continue;
                }
                if (key.equals("X_pixel_size")) {
                    sizeX = new Double(value) * 1000.0;
                    continue;
                }
                if (key.equals("Y_pixel_size")) {
                    sizeY = new Double(value) * 1000.0;
                    continue;
                }
                if (key.equals("Date")) {
                    date = value;
                    continue;
                }
                if (!key.equals("Time")) continue;
                date = date + " " + value;
                continue;
            }
            if (line.indexOf("Compressed") != -1) {
                this.compressed = true;
                continue;
            }
            if (line.equals("End")) break;
        }
        this.core[0].pixelType = 3;
        this.core[0].littleEndian = true;
        this.core[0].rgb = false;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null) {
            store.setImageAcquiredDate(DateTools.formatDate((String)date, (String)DATE_FORMAT), 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
            store.setPixelsPhysicalSizeY(sizeY, 0);
            store.setImageDescription(description, 0);
        }
    }
}

