/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class TopometrixReader
extends FormatReader {
    private long pixelOffset;

    public TopometrixReader() {
        super("TopoMetrix", new String[]{"tfr", "ffr", "zfr", "zfp", "2fl"});
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 6;
        if (!FormatTools.validStream(stream, 6, false)) {
            return false;
        }
        String check = stream.readString(6);
        if (!check.startsWith("#R")) {
            return false;
        }
        try {
            Double.parseDouble(check.substring(2, 5));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(2);
        int version = (int)Double.parseDouble(this.in.readString(4));
        this.in.skipBytes(2);
        this.pixelOffset = Long.parseLong(this.in.readString(4));
        this.in.skipBytes(2);
        long fp = this.in.getFilePointer();
        String date = this.in.readLine().trim();
        int commentLength = (int)(240L - this.in.getFilePointer() + fp);
        String comment = this.in.readString(commentLength).trim();
        if (version == 5) {
            this.in.seek(452L);
        }
        this.in.skipBytes(152);
        this.core[0].sizeX = this.in.readShort();
        this.in.skipBytes(2);
        this.core[0].sizeY = this.in.readShort();
        double xSize = 0.0;
        double ySize = 0.0;
        double adc = 0.0;
        double dacToWorldZero = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(10);
            if (version == 5) {
                this.in.skipBytes(4);
                xSize = this.in.readDouble();
                this.in.skipBytes(8);
                ySize = this.in.readDouble();
                adc = this.in.readDouble();
                dacToWorldZero = this.in.readDouble();
                this.in.skipBytes(1176);
                double sampleVolts = this.in.readDouble();
                double tunnelCurrent = this.in.readDouble();
                this.in.skipBytes(16);
                double timePerPixel = this.in.readDouble();
                this.in.skipBytes(40);
                double scanAngle = this.in.readDouble();
                this.addGlobalMeta("Sample volts", sampleVolts);
                this.addGlobalMeta("Tunnel current", tunnelCurrent);
                this.addGlobalMeta("Scan rate", timePerPixel);
                this.addGlobalMeta("Scan angle", scanAngle);
            } else {
                xSize = this.in.readFloat();
                this.in.skipBytes(4);
                ySize = this.in.readFloat();
                adc = this.in.readFloat();
                this.in.skipBytes(764);
                dacToWorldZero = this.in.readFloat();
            }
            this.addGlobalMeta("Version", version);
            this.addGlobalMeta("X size (in um)", xSize);
            this.addGlobalMeta("Y size (in um)", ySize);
            this.addGlobalMeta("ADC", adc);
            this.addGlobalMeta("DAC to world zero", dacToWorldZero);
            this.addGlobalMeta("Comment", comment);
            this.addGlobalMeta("Acquisition date", date);
        }
        this.core[0].pixelType = 3;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageAcquiredDate(DateTools.formatDate((String)date, (String[])new String[]{"MM/dd/yy HH:mm:ss", "MM/dd/yyyy HH:mm:ss"}), 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(xSize / (double)this.getSizeX(), 0);
            store.setPixelsPhysicalSizeY(ySize / (double)this.getSizeY(), 0);
            store.setImageDescription(comment, 0);
        }
    }
}

