/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.ZipHandle;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.ImageReader;

public class ZipReader
extends FormatReader {
    private ImageReader reader;

    public ZipReader() {
        super("Zip", "zip");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.reader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.reader.get16BitLookupTable();
    }

    public void setGroupFiles(boolean groupFiles) {
        super.setGroupFiles(groupFiles);
        if (this.reader != null) {
            this.reader.setGroupFiles(groupFiles);
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.reader = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.reader = new ImageReader();
        this.reader.setMetadataOptions(this.getMetadataOptions());
        this.reader.setMetadataFiltered(this.isMetadataFiltered());
        this.reader.setOriginalMetadataPopulated(this.isOriginalMetadataPopulated());
        this.reader.setNormalized(this.isNormalized());
        this.reader.setMetadataStore(this.getMetadataStore());
        ZipFile zip = new ZipFile(id);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            ZipHandle handle = new ZipHandle(id, ze);
            Location.mapFile((String)ze.getName(), (IRandomAccess)handle);
        }
        ZipHandle base = new ZipHandle(id);
        this.reader.setId(base.getEntryName());
        this.metadataStore = this.reader.getMetadataStore();
        this.core = this.reader.getCoreMetadata();
        this.metadata = this.reader.getGlobalMetadata();
    }
}

