/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.meta.MetadataRetrieve;

public class APNGWriter
extends FormatWriter {
    private static final byte[] PNG_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private int numFrames = 0;
    private long numFramesPointer = 0L;
    private int nextSequenceNumber;
    private boolean littleEndian;

    public APNGWriter() {
        super("Animated PNG", "png");
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("APNGWriter does not yet support saving image tiles.");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        int width = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int height = (Integer)meta.getPixelsSizeY(this.series).getValue();
        if (!this.initialized[this.series][no]) {
            this.writeFCTL(width, height);
            if (no == 0) {
                this.writePLTE();
            }
            this.initialized[this.series][no] = true;
        }
        this.writePixels(this.numFrames == 0 ? "IDAT" : "fdAT", buf, x, y, w, h);
        ++this.numFrames;
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3};
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (this.out.length() == 0L) {
            MetadataRetrieve r = this.getMetadataRetrieve();
            int width = (Integer)r.getPixelsSizeX(this.series).getValue();
            int height = (Integer)r.getPixelsSizeY(this.series).getValue();
            int bytesPerPixel = FormatTools.getBytesPerPixel(r.getPixelsType(this.series).toString());
            int nChannels = this.getSamplesPerPixel();
            boolean indexed = this.getColorModel() != null && this.getColorModel() instanceof IndexColorModel;
            this.littleEndian = r.getPixelsBinDataBigEndian(this.series, 0) == false;
            this.out.write(PNG_SIG);
            this.out.writeInt(13);
            byte[] b = new byte[17];
            b[0] = 73;
            b[1] = 72;
            b[2] = 68;
            b[3] = 82;
            DataTools.unpackBytes((long)width, (byte[])b, (int)4, (int)4, (boolean)false);
            DataTools.unpackBytes((long)height, (byte[])b, (int)8, (int)4, (boolean)false);
            b[12] = (byte)(bytesPerPixel * 8);
            if (indexed) {
                b[13] = 3;
            } else if (nChannels == 1) {
                b[13] = 0;
            } else if (nChannels == 2) {
                b[13] = 4;
            } else if (nChannels == 3) {
                b[13] = 2;
            } else if (nChannels == 4) {
                b[13] = 6;
            }
            b[14] = 0;
            b[15] = 0;
            b[16] = 0;
            this.out.write(b);
            this.out.writeInt(this.crc(b));
            this.out.writeInt(8);
            this.out.writeBytes("acTL");
            this.numFramesPointer = this.out.getFilePointer();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.writeFooter();
        }
        super.close();
        this.numFrames = 0;
        this.numFramesPointer = 0L;
        this.nextSequenceNumber = 0;
        this.littleEndian = false;
    }

    private int crc(byte[] buf) {
        return this.crc(buf, 0, buf.length);
    }

    private int crc(byte[] buf, int off, int len) {
        CRC32 crc = new CRC32();
        crc.update(buf, off, len);
        return (int)crc.getValue();
    }

    private void writeFCTL(int width, int height) throws IOException {
        this.out.writeInt(26);
        byte[] b = new byte[30];
        b[0] = 102;
        b[1] = 99;
        b[2] = 84;
        b[3] = 76;
        DataTools.unpackBytes((long)this.nextSequenceNumber++, (byte[])b, (int)4, (int)4, (boolean)false);
        DataTools.unpackBytes((long)width, (byte[])b, (int)8, (int)4, (boolean)false);
        DataTools.unpackBytes((long)height, (byte[])b, (int)12, (int)4, (boolean)false);
        DataTools.unpackBytes((long)0L, (byte[])b, (int)16, (int)4, (boolean)false);
        DataTools.unpackBytes((long)0L, (byte[])b, (int)20, (int)4, (boolean)false);
        DataTools.unpackBytes((long)1L, (byte[])b, (int)24, (int)2, (boolean)false);
        DataTools.unpackBytes((long)this.fps, (byte[])b, (int)26, (int)2, (boolean)false);
        b[28] = 1;
        b[29] = 0;
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writePLTE() throws IOException {
        if (!(this.getColorModel() instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel model = (IndexColorModel)this.getColorModel();
        byte[][] lut = new byte[3][256];
        model.getReds(lut[0]);
        model.getGreens(lut[1]);
        model.getBlues(lut[2]);
        this.out.writeInt(768);
        byte[] b = new byte[772];
        b[0] = 80;
        b[1] = 76;
        b[2] = 84;
        b[3] = 69;
        for (int i = 0; i < lut[0].length; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                b[i * lut.length + j + 4] = lut[j][i];
            }
        }
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writePixels(String chunk, byte[] stream, int x, int y, int width, int height) throws FormatException, IOException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int sizeC = this.getSamplesPerPixel();
        String type = r.getPixelsType(this.series).toString();
        int pixelType = FormatTools.pixelTypeFromString(type);
        boolean signed = FormatTools.isSigned(pixelType);
        if (!this.isFullPlane(x, y, width, height)) {
            throw new FormatException("APNGWriter does not support writing tiles.");
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        s.write(chunk.getBytes());
        if (chunk.equals("fdAT")) {
            s.write(DataTools.intToBytes((int)this.nextSequenceNumber++, (boolean)false));
        }
        DeflaterOutputStream deflater = new DeflaterOutputStream(s);
        int planeSize = stream.length / sizeC;
        int rowLen = stream.length / height;
        int bytesPerPixel = stream.length / (width * height * sizeC);
        byte[] rowBuf = new byte[rowLen];
        for (int i = 0; i < height; ++i) {
            deflater.write(0);
            if (this.interleaved) {
                if (this.littleEndian) {
                    for (int col = 0; col < width * sizeC; ++col) {
                        int offset = (i * sizeC * width + col) * bytesPerPixel;
                        int pixel = DataTools.bytesToInt((byte[])stream, (int)offset, (int)bytesPerPixel, (boolean)this.littleEndian);
                        DataTools.unpackBytes((long)pixel, (byte[])rowBuf, (int)(col * bytesPerPixel), (int)bytesPerPixel, (boolean)false);
                    }
                } else {
                    System.arraycopy(stream, i * rowLen, rowBuf, 0, rowLen);
                }
            } else {
                int max = (int)Math.pow(2.0, bytesPerPixel * 8 - 1);
                for (int col = 0; col < width; ++col) {
                    for (int c = 0; c < sizeC; ++c) {
                        int offset = c * planeSize + (i * width + col) * bytesPerPixel;
                        int pixel = DataTools.bytesToInt((byte[])stream, (int)offset, (int)bytesPerPixel, (boolean)this.littleEndian);
                        if (signed) {
                            pixel = pixel < max ? (pixel += max) : (pixel -= max);
                        }
                        int output = (col * sizeC + c) * bytesPerPixel;
                        DataTools.unpackBytes((long)pixel, (byte[])rowBuf, (int)output, (int)bytesPerPixel, (boolean)false);
                    }
                }
            }
            deflater.write(rowBuf);
        }
        deflater.finish();
        byte[] b = s.toByteArray();
        this.out.writeInt(b.length - 4);
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writeFooter() throws IOException {
        this.out.writeInt(0);
        this.out.writeBytes("IEND");
        this.out.writeInt(this.crc("IEND".getBytes()));
        this.out.seek(this.numFramesPointer);
        this.out.writeInt(this.numFrames);
        this.out.skipBytes(4);
        byte[] b = new byte[12];
        b[0] = 97;
        b[1] = 99;
        b[2] = 84;
        b[3] = 76;
        DataTools.unpackBytes((long)this.numFrames, (byte[])b, (int)4, (int)4, (boolean)false);
        DataTools.unpackBytes((long)0L, (byte[])b, (int)8, (int)4, (boolean)false);
        this.out.writeInt(this.crc(b));
    }
}

