/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.meta.MetadataRetrieve;

public class JPEG2000Writer
extends FormatWriter {
    private static final String LOSSY = "Lossy";
    private static final String LOSSLESS = "Lossless";

    public JPEG2000Writer() {
        super("JPEG-2000", "jp2");
        this.compressionTypes = new String[]{LOSSY, LOSSLESS};
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("JPEG2000Writer does not yet support saving image tiles.");
        }
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        boolean littleEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0) == false;
        int width = (Integer)retrieve.getPixelsSizeX(this.series).getValue();
        int height = (Integer)retrieve.getPixelsSizeY(this.series).getValue();
        int bytesPerPixel = FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString()));
        int nChannels = this.getSamplesPerPixel();
        CodecOptions options = new CodecOptions();
        options.width = width;
        options.height = height;
        options.channels = nChannels;
        options.bitsPerSample = bytesPerPixel * 8;
        options.littleEndian = littleEndian;
        options.interleaved = this.interleaved;
        options.lossless = this.compression == null || this.compression.equals(LOSSLESS);
        this.out.write(new JPEG2000Codec().compress(buf, options));
    }

    public boolean canDoStacks() {
        return false;
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3};
    }
}

