/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.CodecOptions;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.IFDType;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffSaver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TiffSaver.class);
    protected RandomAccessOutputStream out;
    protected RandomAccessInputStream in;
    private boolean bigTiff = false;
    private boolean sequentialWrite = false;

    public TiffSaver(RandomAccessOutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream expected to be not-null");
        }
        this.out = out;
    }

    public TiffSaver(String filename) throws IOException {
        this(new RandomAccessOutputStream(filename));
    }

    public void setWritingSequentially(boolean sequential) {
        this.sequentialWrite = sequential;
    }

    public void setInputStream(RandomAccessInputStream in) {
        this.in = in;
    }

    public RandomAccessOutputStream getStream() {
        return this.out;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.out.order(littleEndian);
    }

    public void setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
    }

    public boolean isLittleEndian() {
        return this.out.isLittleEndian();
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public void writeHeader() throws IOException {
        if (this.isLittleEndian()) {
            this.out.writeByte(73);
            this.out.writeByte(73);
        } else {
            this.out.writeByte(77);
            this.out.writeByte(77);
        }
        if (this.bigTiff) {
            this.out.writeShort(43);
        } else {
            this.out.writeShort(42);
        }
        this.out.writeInt(8);
        if (this.bigTiff) {
            this.out.writeLong(16L);
        }
    }

    public void writeImage(byte[][] buf, IFDList ifds, int pixelType) throws FormatException, IOException {
        for (int i = 0; i < ifds.size(); ++i) {
            if (i >= buf.length) continue;
            this.writeImage(buf[i], (IFD)ifds.get(i), i, pixelType, i == ifds.size() - 1);
        }
    }

    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, boolean last) throws FormatException, IOException {
        int w = (int)ifd.getImageWidth();
        int h = (int)ifd.getImageLength();
        this.writeImage(buf, ifd, no, pixelType, 0, 0, w, h, last);
    }

    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, int x, int y, int w, int h, boolean last) throws FormatException, IOException {
        long[] newStripOffsets;
        long[] newStripByteCounts;
        TiffParser parser;
        long[] ifdOffsets;
        int strip;
        if (buf == null) {
            throw new FormatException("Image data cannot be null");
        }
        if (this.in == null) {
            throw new FormatException("RandomAccessInputStream is null. Call setInputStream(RandomAccessInputStream) first.");
        }
        if (ifd == null) {
            throw new FormatException("IFD cannot be null");
        }
        int width = (int)ifd.getImageWidth();
        if (w != width) {
            throw new FormatException("Tile must be as wide as the full image.");
        }
        int height = (int)ifd.getImageLength();
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int plane = width * height * bytesPerPixel;
        int nChannels = buf.length / (w * h * bytesPerPixel);
        boolean interleaved = ifd.getPlanarConfiguration() == 1;
        this.makeValidIFD(ifd, pixelType, nChannels);
        TiffCompression compression = ifd.getCompression();
        int pixels = width;
        int rowsPerStrip = (int)ifd.getRowsPerStrip()[0];
        int stripSize = rowsPerStrip * width * bytesPerPixel;
        int nStrips = (height + rowsPerStrip - 1) / rowsPerStrip;
        if (interleaved) {
            stripSize *= nChannels;
        } else {
            nStrips *= nChannels;
        }
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[nStrips];
        DataOutputStream[] stripOut = new DataOutputStream[nStrips];
        for (int strip2 = 0; strip2 < nStrips; ++strip2) {
            stripBuf[strip2] = new ByteArrayOutputStream(stripSize);
            stripOut[strip2] = new DataOutputStream(stripBuf[strip2]);
        }
        int[] bps = ifd.getBitsPerSample();
        for (int row = y; row < h + y; ++row) {
            strip = row / rowsPerStrip;
            for (int col = 0; col < width; ++col) {
                int ndx = (row - y) * width * bytesPerPixel + col * bytesPerPixel;
                for (int c = 0; c < nChannels; ++c) {
                    for (int n = 0; n < bps[c] / 8; ++n) {
                        int off;
                        if (interleaved) {
                            off = ndx * nChannels + c * bytesPerPixel + n;
                            stripOut[strip].writeByte(buf[off]);
                            continue;
                        }
                        off = c * plane + ndx + n;
                        stripOut[c * (nStrips / nChannels) + strip].writeByte(buf[off]);
                    }
                }
            }
        }
        byte[][] strips = new byte[nStrips][];
        for (strip = 0; strip < nStrips; ++strip) {
            strips[strip] = stripBuf[strip].toByteArray();
            TiffCompression.difference(strips[strip], ifd);
            CodecOptions options = compression.getCompressionCodecOptions(ifd);
            options.height = rowsPerStrip;
            strips[strip] = compression.compress(strips[strip], options);
        }
        if (!this.sequentialWrite && no < (ifdOffsets = (parser = new TiffParser(this.in)).getIFDOffsets()).length) {
            this.out.seek(ifdOffsets[no]);
            ifd = parser.getIFD(ifdOffsets[no]);
        }
        long[] stripByteCounts = new long[nStrips];
        long[] stripOffsets = new long[nStrips];
        if (ifd.containsKey(279) && (newStripByteCounts = ifd.getStripByteCounts()).length == nStrips) {
            stripByteCounts = newStripByteCounts;
        }
        if (ifd.containsKey(273) && (newStripOffsets = ifd.getStripOffsets()).length == nStrips) {
            stripOffsets = newStripOffsets;
        }
        for (int i = 0; i < stripByteCounts.length; ++i) {
            if (stripByteCounts[i] != 0L) continue;
            stripByteCounts[i] = strips[i].length;
        }
        ifd.putIFDValue(279, stripByteCounts);
        ifd.putIFDValue(273, stripOffsets);
        long fp = this.out.getFilePointer();
        this.writeIFD(ifd, 0L);
        for (int i = 0; i < strips.length; ++i) {
            if (stripOffsets[i] > 0L && strips[i].length == 0) {
                this.out.seek(stripOffsets[i] + stripByteCounts[i]);
                continue;
            }
            stripOffsets[i] = this.out.getFilePointer();
            this.out.write(strips[i]);
        }
        ifd.putIFDValue(279, stripByteCounts);
        ifd.putIFDValue(273, stripOffsets);
        long endFP = this.out.getFilePointer();
        this.out.seek(fp);
        this.writeIFD(ifd, last ? 0L : endFP);
    }

    public void writeIFD(IFD ifd, long nextOffset) throws FormatException, IOException {
        TreeSet keys = new TreeSet(ifd.keySet());
        int keyCount = keys.size();
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        long fp = this.out.getFilePointer();
        int bytesPerEntry = this.bigTiff ? 20 : 12;
        int ifdBytes = (this.bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        if (this.bigTiff) {
            this.out.writeLong((long)keyCount);
        } else {
            this.out.writeShort(keyCount);
        }
        ByteArrayHandle extra = new ByteArrayHandle();
        RandomAccessOutputStream extraStream = new RandomAccessOutputStream((IRandomAccess)extra);
        for (Integer key : keys) {
            if (key.equals(0) || key.equals(1)) continue;
            Object value = ifd.get(key);
            this.writeIFDValue(extraStream, (long)ifdBytes + fp, key, value);
        }
        if (this.bigTiff) {
            this.out.seek(this.out.getFilePointer() - 8L);
        }
        this.writeIntValue(this.out, nextOffset);
        this.out.write(extra.getBytes(), 0, (int)extra.length());
    }

    public void writeIFDValue(RandomAccessOutputStream extraOut, long offset, int tag, Object value) throws FormatException, IOException {
        extraOut.order(this.isLittleEndian());
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = this.bigTiff ? 8 : 4;
        this.out.writeShort(tag);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            this.out.writeShort(IFDType.BYTE.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte((int)q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte((int)q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            this.out.writeShort(IFDType.ASCII.getCode());
            this.writeIntValue(this.out, q.length + 1);
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte((int)q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte((int)q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            this.out.writeShort(IFDType.SHORT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeShort(q[i]);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    this.out.writeShort(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeShort(q[i]);
                }
            }
        } else if (value instanceof long[]) {
            long[] q = (long[])value;
            int type = this.bigTiff ? IFDType.LONG8.getCode() : IFDType.LONG.getCode();
            this.out.writeShort(type);
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.writeIntValue(this.out, q[0]);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    this.writeIntValue(this.out, 0L);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    this.writeIntValue(extraOut, q[i]);
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            this.out.writeShort(IFDType.RATIONAL.getCode());
            this.writeIntValue(this.out, q.length);
            if (this.bigTiff && q.length == 1) {
                this.out.writeInt((int)((TiffRational)q[0]).getNumerator());
                this.out.writeInt((int)((TiffRational)q[0]).getDenominator());
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeInt((int)((TiffRational)q[i]).getNumerator());
                    extraOut.writeInt((int)((TiffRational)q[i]).getDenominator());
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            this.out.writeShort(IFDType.FLOAT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeFloat(q[0]);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    this.out.writeInt(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeFloat(q[i]);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            this.out.writeShort(IFDType.DOUBLE.getCode());
            this.writeIntValue(this.out, q.length);
            this.writeIntValue(this.out, offset + extraOut.length());
            for (int i = 0; i < q.length; ++i) {
                extraOut.writeDouble(q[i]);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public void overwriteLastIFDOffset(RandomAccessInputStream raf) throws FormatException, IOException {
        TiffParser parser = new TiffParser(raf);
        long[] offsets = parser.getIFDOffsets();
        this.out.seek(raf.getFilePointer() - (long)(this.bigTiff ? 8 : 4));
        this.writeIntValue(this.out, 0L);
    }

    public void overwriteIFDValue(RandomAccessInputStream raf, int ifd, int tag, Object value) throws FormatException, IOException {
        LOGGER.debug("overwriteIFDValue (ifd={}; tag={}; value={})", new Object[]{ifd, tag, value});
        raf.seek(0L);
        TiffParser parser = new TiffParser(raf);
        Boolean valid = parser.checkHeader();
        if (valid == null) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = valid;
        boolean bigTiff = parser.isBigTiff();
        this.setLittleEndian(little);
        this.setBigTiff(bigTiff);
        long offset = bigTiff ? 8L : 4L;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        long[] offsets = parser.getIFDOffsets();
        if (ifd >= offsets.length) {
            throw new FormatException("No such IFD (" + ifd + " of " + offsets.length + ")");
        }
        raf.seek(offsets[ifd]);
        long num = bigTiff ? raf.readLong() : (long)raf.readUnsignedShort();
        int i = 0;
        while ((long)i < num) {
            raf.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i));
            TiffIFDEntry entry = parser.readTiffIFDEntry();
            if (entry.getTag() == tag) {
                long newOffset;
                int newCount;
                ByteArrayHandle ifdBuf = new ByteArrayHandle(bytesPerEntry);
                RandomAccessOutputStream ifdOut = new RandomAccessOutputStream((IRandomAccess)ifdBuf);
                ByteArrayHandle extraBuf = new ByteArrayHandle();
                RandomAccessOutputStream extraOut = new RandomAccessOutputStream((IRandomAccess)extraBuf);
                extraOut.order(little);
                TiffSaver saver = new TiffSaver(ifdOut);
                saver.setLittleEndian(this.isLittleEndian());
                saver.writeIFDValue(extraOut, entry.getValueOffset(), tag, value);
                ifdBuf.seek(0L);
                extraBuf.seek(0L);
                short newTag = ifdBuf.readShort();
                short newType = ifdBuf.readShort();
                if (bigTiff) {
                    newCount = ifdBuf.readInt() & 0xFFFFFFFF;
                    newOffset = ifdBuf.readLong();
                } else {
                    newCount = ifdBuf.readInt();
                    newOffset = ifdBuf.readInt();
                }
                LOGGER.debug("overwriteIFDValue:");
                LOGGER.debug("\told ({});", (Object)entry);
                LOGGER.debug("\tnew: (tag={}; type={}; count={}; offset={})", new Object[]{(int)newTag, (int)newType, newCount, newOffset});
                if (extraBuf.length() == 0L) {
                    LOGGER.debug("overwriteIFDValue: new entry is inline");
                } else if (entry.getValueOffset() + (long)(entry.getValueCount() * entry.getType().getBytesPerElement()) == raf.length()) {
                    newOffset = entry.getValueOffset();
                    LOGGER.debug("overwriteIFDValue: old entry is at EOF");
                } else if (newCount <= entry.getValueCount()) {
                    newOffset = entry.getValueOffset();
                    LOGGER.debug("overwriteIFDValue: new entry is <= old entry");
                } else {
                    newOffset = raf.length();
                    LOGGER.debug("overwriteIFDValue: old entry will be orphaned");
                }
                this.out.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i) + 2L);
                this.out.writeShort((int)newType);
                this.writeIntValue(this.out, newCount);
                this.writeIntValue(this.out, newOffset);
                if (extraBuf.length() > 0L) {
                    this.out.seek(newOffset);
                    this.out.write(extraBuf.getByteBuffer(), 0, newCount);
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + IFD.getIFDTagName(tag) + ")");
    }

    public void overwriteComment(RandomAccessInputStream in, Object value) throws FormatException, IOException {
        this.overwriteIFDValue(in, 0, 270, value);
    }

    private void writeIntValue(RandomAccessOutputStream out, long offset) throws IOException {
        if (this.bigTiff) {
            out.writeLong(offset);
        } else {
            out.writeInt((int)offset);
        }
    }

    private void makeValidIFD(IFD ifd, int pixelType, int nChannels) {
        boolean indexed;
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int bps = 8 * bytesPerPixel;
        int[] bpsArray = new int[nChannels];
        Arrays.fill(bpsArray, bps);
        ifd.putIFDValue(258, bpsArray);
        if (FormatTools.isFloatingPoint(pixelType)) {
            ifd.putIFDValue(339, 3);
        }
        if (ifd.getIFDValue(259) == null) {
            ifd.putIFDValue(259, TiffCompression.UNCOMPRESSED.getCode());
        }
        boolean bl = indexed = nChannels == 1 && ifd.getIFDValue(320) != null;
        PhotoInterp pi = indexed ? PhotoInterp.RGB_PALETTE : (nChannels == 1 ? PhotoInterp.BLACK_IS_ZERO : PhotoInterp.RGB);
        ifd.putIFDValue(262, pi.getCode());
        ifd.putIFDValue(277, nChannels);
        if (ifd.get(282) == null) {
            ifd.putIFDValue(282, new TiffRational(1L, 1L));
        }
        if (ifd.get(283) == null) {
            ifd.putIFDValue(283, new TiffRational(1L, 1L));
        }
        if (ifd.get(305) == null) {
            ifd.putIFDValue(305, "LOCI Bio-Formats");
        }
        if (ifd.get(278) == null) {
            ifd.putIFDValue(278, new long[]{1L});
        }
        if (ifd.get(270) == null) {
            ifd.putIFDValue(270, "");
        }
    }
}

