/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Image;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.MicrobeamManipulationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrobeamManipulation
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrobeamManipulation.class);
    private MicrobeamManipulationType type;
    private String id;
    private List<ROI> roiList = new ArrayList<ROI>();
    private Experimenter experimenter;
    private List<LightSourceSettings> lightSourceSettingsList = new ArrayList<LightSourceSettings>();
    private List<Image> image_BackReferenceList = new ArrayList<Image>();

    public MicrobeamManipulation() {
    }

    public MicrobeamManipulation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"MicrobeamManipulation".equals(tagName)) {
            LOGGER.debug("Expecting node name of MicrobeamManipulation got {}", (Object)tagName);
        }
        if (element.hasAttribute("Type")) {
            this.setType(MicrobeamManipulationType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("MicrobeamManipulation missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> ROIRef_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "ROIRef");
        for (Element ROIRef_element : ROIRef_nodeList) {
            ROIRef roiList_reference = new ROIRef();
            roiList_reference.setID(ROIRef_element.getAttribute("ID"));
            model.addReference(this, roiList_reference);
        }
        List<Element> ExperimenterRef_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> LightSourceSettings_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "LightSourceSettings");
        for (Element LightSourceSettings_element : LightSourceSettings_nodeList) {
            this.addLightSourceSettings(new LightSourceSettings(LightSourceSettings_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ROIRef) {
            ROI o_casted = (ROI)o;
            o_casted.linkMicrobeamManipulation(this);
            this.roiList.add(o_casted);
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkMicrobeamManipulation(this);
            this.experimenter = o_casted;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public MicrobeamManipulationType getType() {
        return this.type;
    }

    public void setType(MicrobeamManipulationType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedROIList() {
        return this.roiList.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiList);
    }

    public ROI getLinkedROI(int index) {
        return this.roiList.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiList.set(index, o);
    }

    public boolean linkROI(ROI o) {
        o.linkMicrobeamManipulation(this);
        return this.roiList.add(o);
    }

    public boolean unlinkROI(ROI o) {
        o.unlinkMicrobeamManipulation(this);
        return this.roiList.remove(o);
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public int sizeOfLightSourceSettingsList() {
        return this.lightSourceSettingsList.size();
    }

    public List<LightSourceSettings> copyLightSourceSettingsList() {
        return new ArrayList<LightSourceSettings>(this.lightSourceSettingsList);
    }

    public LightSourceSettings getLightSourceSettings(int index) {
        return this.lightSourceSettingsList.get(index);
    }

    public LightSourceSettings setLightSourceSettings(int index, LightSourceSettings lightSourceSettings) {
        return this.lightSourceSettingsList.set(index, lightSourceSettings);
    }

    public void addLightSourceSettings(LightSourceSettings lightSourceSettings) {
        this.lightSourceSettingsList.add(lightSourceSettings);
    }

    public void removeLightSourceSettings(LightSourceSettings lightSourceSettings) {
        this.lightSourceSettingsList.remove(lightSourceSettings);
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element MicrobeamManipulation_element) {
        if (MicrobeamManipulation_element == null) {
            MicrobeamManipulation_element = document.createElementNS(NAMESPACE, "MicrobeamManipulation");
        }
        if (this.type != null) {
            MicrobeamManipulation_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            MicrobeamManipulation_element.setAttribute("ID", this.id.toString());
        }
        if (this.roiList != null) {
            for (ROI roiList_value : this.roiList) {
                ROIRef o = new ROIRef();
                o.setID(roiList_value.getID());
                MicrobeamManipulation_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.experimenter != null) {
            ExperimenterRef o = new ExperimenterRef();
            o.setID(this.experimenter.getID());
            MicrobeamManipulation_element.appendChild(o.asXMLElement(document));
        }
        if (this.lightSourceSettingsList != null) {
            for (LightSourceSettings lightSourceSettingsList_value : this.lightSourceSettingsList) {
                MicrobeamManipulation_element.appendChild(lightSourceSettingsList_value.asXMLElement(document));
            }
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, MicrobeamManipulation_element);
    }
}

