/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RootDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import pojos.ImageData;

class BrowserControl
implements MouseListener,
ImageDisplayVisitor,
PropertyChangeListener {
    private BrowserModel model;
    private RootDisplay view;
    private CellDisplay selectedCell;

    private void handleSelection(ImageDisplay d, boolean multiSelection, Point p) {
        ImageDisplay previousDisplay = this.model.getLastSelectedDisplay();
        if (multiSelection) {
            ImageDisplay previous = this.model.getLastSelectedDisplay();
            if (previous == null) {
                this.model.setSelectedDisplay(d, true, true);
                return;
            }
            Object object = previous.getHierarchyObject();
            Class<?> ref = object.getClass();
            if (!ref.equals(d.getHierarchyObject().getClass())) {
                return;
            }
            Collection nodes = this.model.getSelectedDisplays();
            Iterator i = nodes.iterator();
            boolean remove = false;
            while (i.hasNext()) {
                ImageDisplay node = (ImageDisplay)i.next();
                if (!node.equals(d)) continue;
                remove = true;
                break;
            }
            if (remove) {
                this.model.removeSelectedDisplay(d);
            } else {
                this.model.setSelectedDisplay(d, true, true);
            }
        } else if (this.isSelectionValid(d)) {
            if (d instanceof CellDisplay && !d.equals(previousDisplay)) {
                this.setSelectedCell(p, (CellDisplay)d);
            } else {
                boolean b = this.model.isMultiSelection();
                if (b || !d.equals(previousDisplay)) {
                    this.model.setSelectedDisplay(d, false, true);
                }
            }
        }
    }

    private void setSelectedCell(Point p, CellDisplay node) {
        this.selectedCell = node;
        SwingUtilities.convertPointToScreen(p, node);
        ColourPicker picker = new ColourPicker(DataBrowserAgent.getRegistry().getTaskBar().getFrame(), node.getHighlight(), true);
        picker.setColorDescription(node.getDescription());
        picker.addPropertyChangeListener(this);
        picker.setLocation(p);
        picker.setVisible(true);
    }

    private ImageDisplay findParentDisplay(Object x) {
        while (true) {
            if (x instanceof ImageDisplay) {
                return (ImageDisplay)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    private void attachListeners(ImageNode node) {
        if (node == null) {
            return;
        }
        node.addMouseListenerToComponents(this);
        node.addPropertyChangeListener(this);
    }

    BrowserControl(BrowserModel model, RootDisplay view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        model.addPropertyChangeListener("selectedDataBrowserNodeDisplay", this);
        model.addPropertyChangeListener("rollOver", this);
        this.model = model;
        this.view = view;
    }

    void initialize() {
        this.model.accept(this);
    }

    boolean isSelectionValid(ImageDisplay node) {
        if (!(node instanceof ImageNode)) {
            return true;
        }
        Object ho = node.getHierarchyObject();
        if (!(ho instanceof ImageData)) {
            return true;
        }
        ImageData img = (ImageData)ho;
        try {
            img.getDefaultPixels();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void visit(ImageNode node) {
        this.attachListeners(node);
        if (node instanceof WellSampleNode) {
            WellSampleNode sample = (WellSampleNode)node;
            WellImageSet well = sample.getParentWell();
            List<WellSampleNode> samples = well.getWellSamples();
            for (WellSampleNode wsn : samples) {
                if (wsn == node) continue;
                this.attachListeners(wsn);
            }
        }
    }

    public void visit(ImageSet node) {
        node.getTitleBar().addMouseListener(this);
        node.getInternalDesktop().addMouseListener(this);
        node.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("classifyNode".equals(name)) {
            this.model.setNodeForProperty("classifiedNode", evt.getNewValue());
        } else if ("annotateNode".equals(name)) {
            this.model.setNodeForProperty("annotatedNode", evt.getNewValue());
        } else if ("rollOver".equals(name)) {
            RollOverNode n = (RollOverNode)evt.getNewValue();
            ImageNode img = null;
            if (n != null) {
                img = n.getNode();
            }
            this.view.setTitle(this.model.currentPathString(img));
        } else if ("pinThumbnail".equals(name)) {
            ImageNode node = (ImageNode)evt.getNewValue();
            this.model.setThumbSelected(true, node);
        } else if (!"endMoving".equals(name)) {
            if ("descriptor".equals(name)) {
                CellDisplay node = (CellDisplay)evt.getNewValue();
                this.setSelectedCell(node.getLocation(), node);
            } else if ("colour".equals(name)) {
                ColourObject co = (ColourObject)evt.getNewValue();
                if (this.selectedCell == null) {
                    return;
                }
                this.selectedCell.setHighlight(co.getColor());
                this.selectedCell.setDescription(co.getDescription());
                this.model.setSelectedCell(this.selectedCell);
            }
        }
    }

    public void mousePressed(MouseEvent me) {
        ImageDisplay d = this.findParentDisplay(me.getSource());
        d.moveToFront();
        ImageDisplay previousDisplay = this.model.getLastSelectedDisplay();
        boolean macOS = UIUtilities.isMacOS();
        Point p = me.getPoint();
        boolean b = macOS ? me.isShiftDown() || me.isMetaDown() : me.isShiftDown() || me.isControlDown();
        me.consume();
        if (me.isControlDown() && SwingUtilities.isLeftMouseButton(me) && macOS) {
            if (!d.equals(previousDisplay) && this.isSelectionValid(d)) {
                if (d instanceof CellDisplay) {
                    this.setSelectedCell(me.getPoint(), (CellDisplay)d);
                } else {
                    this.model.setSelectedDisplay(d, false, true);
                }
            }
            this.model.setPopupPoint(p, true);
            return;
        }
        if (me.isPopupTrigger() && b) {
            this.model.setPopupPoint(p, true);
            return;
        }
        if (macOS) {
            this.handleSelection(d, b, me.getPoint());
        }
    }

    public void mouseReleased(MouseEvent me) {
        int count = me.getClickCount();
        if (!(count != 2 || me.isShiftDown() || me.isControlDown() || me.isMetaDown())) {
            if (UIUtilities.isMacOS()) {
                Object src;
                ImageDisplay d;
                if (!me.isControlDown() && (d = this.findParentDisplay(src = me.getSource())) instanceof ImageNode && d.getTitleBar() != src && this.isSelectionValid(d)) {
                    this.model.viewDisplay(d);
                }
            } else {
                Object src = me.getSource();
                ImageDisplay d = this.findParentDisplay(src);
                if (d instanceof ImageNode && d.getTitleBar() != src && this.isSelectionValid(d)) {
                    this.model.viewDisplay(d);
                }
            }
        } else if (count == 1) {
            boolean b;
            boolean macOS = UIUtilities.isMacOS();
            if (macOS) {
                return;
            }
            boolean bl = b = me.isShiftDown() || me.isControlDown();
            if (SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger() && b) {
                this.model.setPopupPoint(me.getPoint(), true);
                return;
            }
            ImageDisplay d = this.findParentDisplay(me.getSource());
            d.moveToFront();
            this.handleSelection(d, b, me.getPoint());
        }
    }

    public void mouseEntered(MouseEvent me) {
        boolean mo = this.model.isMouseOver();
        boolean ro = this.model.isRollOver();
        if (!mo && !ro) {
            return;
        }
        Object src = me.getSource();
        ImageDisplay d = this.findParentDisplay(src);
        if (mo) {
            if (d instanceof RootDisplay) {
                ImageDisplay lastSelected = this.model.getLastSelectedDisplay();
                if (lastSelected != null) {
                    this.view.setTitle(this.model.currentPathString(lastSelected));
                } else {
                    lastSelected = null;
                }
                this.model.setNodeForProperty("mouseOver", lastSelected);
                return;
            }
            if (!(d instanceof RootDisplay)) {
                this.view.setTitle(this.model.currentPathString(d));
            }
            this.model.setNodeForProperty("mouseOver", d);
        }
        if (!ro) {
            return;
        }
        if (d instanceof ImageNode && d.getTitleBar() != src) {
            ImageNode img = (ImageNode)d;
            RollOverNode n = new RollOverNode(img, img.getLocationOnScreen());
            this.model.setRollOverNode(n);
        } else {
            this.model.setRollOverNode(null);
        }
    }

    public void mouseExited(MouseEvent me) {
        this.model.setRollOverNode(null);
    }

    public void mouseClicked(MouseEvent me) {
    }
}

