/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.AnnotatedFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.CommentsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataObjectCreator;
import org.openmicroscopy.shoola.agents.dataBrowser.DataObjectSaver;
import org.openmicroscopy.shoola.agents.dataBrowser.DatasetsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.RateFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.ReportLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.TabularDataLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailsManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetThumbnailVisitor;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.TableResult;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataBrowserModel {
    static final int DATASETS = 0;
    static final int IMAGES = 1;
    static final int PROJECTS = 2;
    static final int SEARCH = 3;
    static final int TAGSETS = 4;
    static final int WELLS = 5;
    static final int TAGS = 6;
    static final int PLATES = 7;
    static final int GROUP = 8;
    static final int FS_FOLDER = 9;
    private int state = 1;
    private ThumbnailsManager thumbsManager;
    private ThumbnailsManager fullSizeThumbsManager;
    protected ViewerSorter sorter = new ViewerSorter();
    private DataBrowserLoader fieldsLoader;
    private DataBrowserLoader loader;
    private Collection existingTags;
    private Collection existingDatasets;
    private List<ApplicationData> applications;
    private ExperimenterData experimenter;
    protected boolean thumbnailLoaded;
    protected DataBrowser component;
    protected Browser browser;
    protected ImageTableView tableView;
    protected int numberOfImages;
    protected int imagesLoaded;
    protected Object parent;
    protected Object grandParent;

    DataBrowserModel() {
    }

    Object getParent() {
        return this.parent;
    }

    Object getExperimenter() {
        return this.experimenter;
    }

    int getNumberOfImages() {
        return this.numberOfImages;
    }

    ViewerSorter getSorter() {
        return this.sorter;
    }

    void layoutBrowser() {
        this.layoutBrowser(1);
    }

    void layoutBrowser(int type) {
        if (this.browser == null) {
            return;
        }
        if (this.browser.getSelectedLayout() == null) {
            Layout layout = LayoutFactory.createLayout(type, this.sorter, 10);
            this.browser.setSelectedLayout(layout);
        }
        this.browser.accept(this.browser.getSelectedLayout());
    }

    ImageTableView createImageTableView() {
        if (this.tableView != null) {
            return this.tableView;
        }
        this.tableView = new ImageTableView(this, (ImageDisplay)this.browser.getUI());
        return this.tableView;
    }

    int getState() {
        return this.state;
    }

    void loadData(boolean refresh, Collection ids) {
        if (refresh) {
            this.browser.accept(new ResetThumbnailVisitor(ids), 0);
        }
        this.loader = this.createDataLoader(refresh, ids);
        if (this.loader == null) {
            this.state = 3;
            return;
        }
        this.state = 2;
        this.loader.load();
    }

    boolean loadFields(int row, int column) {
        if (!(this instanceof WellsModel)) {
            return false;
        }
        this.fieldsLoader = ((WellsModel)this).createFieldsLoader(row, column);
        if (this.fieldsLoader == null) {
            return false;
        }
        this.fieldsLoader.load();
        return true;
    }

    void cancelFieldsLoading() {
        if (this.fieldsLoader != null) {
            this.fieldsLoader.cancel();
        }
    }

    void setGrandParent(Object grandParent) {
        this.grandParent = grandParent;
    }

    Object getGrandParent() {
        return this.grandParent;
    }

    Browser getBrowser() {
        return this.browser;
    }

    ImageTableView getTableView() {
        return this.tableView;
    }

    void initialize(DataBrowser component) {
        this.component = component;
    }

    void setThumbnail(Object ref, BufferedImage thumb, boolean valid, int maxEntries) {
        if (this.thumbsManager == null) {
            this.thumbsManager = this.getType() == 5 ? new ThumbnailsManager(this.getNodes(), maxEntries) : new ThumbnailsManager(this.browser.getVisibleImageNodes(), maxEntries);
        }
        this.thumbsManager.setThumbnail(ref, thumb, valid);
        if (this.thumbsManager.isDone()) {
            this.state = 3;
            this.thumbsManager = null;
        }
    }

    boolean setSlideViewImage(long imageID, BufferedImage thumb) {
        if (this.fullSizeThumbsManager != null) {
            this.fullSizeThumbsManager.setFullSizeImage(imageID, thumb);
            if (this.fullSizeThumbsManager.isDone()) {
                this.state = 3;
                this.fullSizeThumbsManager = null;
                return true;
            }
        }
        return false;
    }

    void discard() {
    }

    void cancelFiltering() {
    }

    void cancelSlideShow() {
    }

    void setState(int state) {
        this.state = state;
    }

    void fireFilteringByRate(int rate, Set nodes) {
        this.state = 4;
        RateFilter loader = new RateFilter(this.component, rate, nodes);
        loader.load();
    }

    void fireFilteringByTags(List<String> tags, Set<DataObject> nodes) {
        this.state = 4;
        TagsFilter loader = new TagsFilter(this.component, tags, nodes);
        loader.load();
    }

    void fireFilteringByComments(List<String> comments, Set<DataObject> nodes) {
        this.state = 4;
        CommentsFilter loader = new CommentsFilter(this.component, comments, nodes);
        loader.load();
    }

    void fireFilteringByContext(FilterContext context, Set<DataObject> nodes) {
        this.state = 4;
        DataFilter loader = new DataFilter(this.component, context, nodes);
        loader.load();
    }

    void fireFilteringByAnnotated(Class annotationType, boolean annotated, Set<DataObject> nodes) {
        this.state = 4;
        AnnotatedFilter loader = new AnnotatedFilter(this.component, annotationType, annotated, nodes);
        loader.load();
    }

    void fireTagsLoading() {
        this.state = 2;
        TagsLoader loader = new TagsLoader(this.component);
        loader.load();
    }

    void fireExisitingDatasetsLoading() {
        DatasetsLoader loader = new DatasetsLoader(this.component);
        loader.load();
    }

    void fireFullSizeLoading(Collection<ImageNode> images) {
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        HashSet<ImageNode> toKeep = new HashSet<ImageNode>();
        for (ImageNode node : images) {
            if (node.getThumbnail().getFullSizeImage() != null) continue;
            nodes.add((DataObject)node.getHierarchyObject());
            toKeep.add(node);
        }
        if (nodes.size() > 0) {
            this.fullSizeThumbsManager = new ThumbnailsManager(toKeep, toKeep.size());
            ThumbnailLoader loader = new ThumbnailLoader(this.component, nodes, false, 0);
            loader.load();
            this.state = 6;
        }
    }

    void fireDataSaving(DataObject data, Collection images) {
        TagAnnotationData tag;
        DataObject p = null;
        if (this.parent instanceof DataObject) {
            p = (DataObject)this.parent;
        }
        if (this.grandParent != null && this.grandParent instanceof DataObject) {
            p = (DataObject)this.grandParent;
        }
        if (data instanceof DatasetData) {
            if (!(p instanceof ProjectData)) {
                p = null;
            }
        } else if (data instanceof TagAnnotationData && p instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)p).getNameSpace())) {
            p = null;
        }
        DataObjectCreator loader = new DataObjectCreator(this.component, p, data, images);
        loader.load();
    }

    void fireDataSaving(Collection datasets, Collection images) {
        DataObjectSaver loader = new DataObjectSaver(this.component, datasets, images);
        loader.load();
    }

    void fireReportLoading(Collection images, List<Class> types, String name) {
        ReportLoader loader = new ReportLoader(this.component, types, this.sorter.sort(images), name);
        loader.load();
    }

    void setTags(Collection tags) {
        if (tags == null) {
            return;
        }
        Iterator i = tags.iterator();
        ArrayList<TagAnnotationData> l = new ArrayList<TagAnnotationData>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) continue;
            l.add(tag);
        }
        this.existingTags = this.sorter.sort(l);
    }

    void setExistingDatasets(Collection datasets) {
        this.existingDatasets = datasets;
    }

    Collection getExistingDatasets() {
        return this.existingDatasets;
    }

    boolean isImagesModel() {
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    boolean isRollOver() {
        return this.browser.isRollOver();
    }

    boolean isParentWritable() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        if (this.parent == null) {
            if (this.experimenter == null) {
                return false;
            }
            return this.experimenter.getId() == userID;
        }
        if (!(this.parent instanceof DataObject)) {
            if (this.experimenter == null) {
                return false;
            }
            return this.experimenter.getId() == userID;
        }
        boolean b = EditorUtil.isUserOwner(this.parent, userID);
        if (b) {
            return b;
        }
        int level = MetadataViewerAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    List sortCollection(Collection collection) {
        return this.sorter.sort(collection);
    }

    void setApplicationData(List<ApplicationData> applications) {
        this.applications = applications;
    }

    void setExperimenter(ExperimenterData experimenter) {
        this.experimenter = experimenter;
    }

    List<ApplicationData> getApplications() {
        return this.applications;
    }

    void fireTabularDataLoading(List<FileAnnotationData> data) {
        TabularDataLoader loader = null;
        if (data == null) {
            if (this instanceof WellsModel) {
                if (this.grandParent instanceof ScreenData) {
                    loader = new TabularDataLoader(this.component, (DataObject)this.grandParent);
                } else if (this.parent instanceof PlateData) {
                    loader = new TabularDataLoader(this.component, (DataObject)this.parent);
                }
            }
        } else if (data.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (FileAnnotationData fa : data) {
                ids.add(fa.getFileID());
            }
            loader = new TabularDataLoader(this.component, ids);
        }
        if (loader != null) {
            loader.load();
        }
    }

    void setTabularData(List<TableResult> data) {
        if (this instanceof WellsModel) {
            ((WellsModel)this).setTabularData(data);
        }
    }

    protected abstract DataBrowserLoader createDataLoader(boolean var1, Collection var2);

    protected abstract int getType();

    protected abstract List<ImageDisplay> getNodes();
}

